/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.FirestoreQuery;
import coldfusion.cloud.gcp.firestore.FirestoreTransaction;
import coldfusion.cloud.gcp.firestore.codecs.FirestoreSerializer;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.FirestoreQueryImpl;
import coldfusion.cloud.gcp.firestore.impl.ReferenceGetter;
import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.cloud.gcp.firestore.pmt.util.PMTUtilForGCPFirestore;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Array;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.MethodUnsupportedParameterException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.Transaction;
import java.util.Map;
import java.util.Objects;

public class FirestoreTransactionImpl
implements FirestoreTransaction {
    private final Transaction transaction;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.FIRESTORE.name());

    public FirestoreTransactionImpl(Transaction transaction) {
        this.transaction = transaction;
    }

    private void validateArguments(FirestoreDocumentReference documentReference, Map<?, ?> data, String funcName) {
        if (Objects.isNull(documentReference)) {
            throw new ValidationException(RB.getString(FirestoreTransactionImpl.class, (String)"DOCUMENT_REFERENCE_NULL"));
        }
        if (Objects.isNull(data)) {
            throw new ValidationException(RB.getString(FirestoreTransactionImpl.class, (String)"ATOMIC_DATA_NULL", (Object)"transaction", (Object)funcName));
        }
    }

    @Override
    public Future getDocument(FirestoreDocumentReference documentReference) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.get, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(documentReference)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreTransactionImpl.class, (String)"DOCUMENT_REFERENCE_NULL"));
            }
            Future future = new Future((java.util.concurrent.Future)this.transaction.get(ReferenceGetter.getDocumentReference((FirestoreDocumentReferenceImpl)documentReference)), FirestoreUtils.getDocumentSnapshotStruct());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.get, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Future runQuery(FirestoreQuery query) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.get, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(query)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreTransactionImpl.class, (String)"QUERY_NULL"));
            }
            Future future = new Future((java.util.concurrent.Future)this.transaction.get(ReferenceGetter.getQuery((FirestoreQueryImpl)query)), FirestoreUtils.getQuerySnapshotStruct());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.get, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    private DocumentReference[] getReferencesArray(Array documentReferences) {
        if (Objects.nonNull(documentReferences)) {
            DocumentReference[] referencesArray = new DocumentReference[documentReferences.size()];
            for (int i = 0; i < documentReferences.size(); ++i) {
                if (!(documentReferences.get(i) instanceof FirestoreDocumentReferenceImpl)) {
                    throw new MethodUnsupportedParameterException("first", "getAll of transaction", "document references but found something else at index " + i);
                }
                referencesArray[i] = ((FirestoreDocumentReferenceImpl)documentReferences.get(i)).getReference();
            }
            return referencesArray;
        }
        throw new ValidationException(RB.getString(FirestoreTransactionImpl.class, (String)"DOCUMENT_REFERENCES_NULL"));
    }

    @Override
    public Future getAll(Array documentReferences) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getAll, this.tagAttributeList);
        String status = "Success";
        try {
            Future future = new Future((java.util.concurrent.Future)this.transaction.getAll(this.getReferencesArray(documentReferences)), FirestoreUtils.documentSnapshotList());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getAll, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public Future getAll(Array documentReferences, Array mask) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getAll, this.tagAttributeList);
        String status = "Success";
        try {
            Future future = new Future((java.util.concurrent.Future)this.transaction.getAll(this.getReferencesArray(documentReferences), FirestoreUtils.getFieldMask(mask)), FirestoreUtils.documentSnapshotList());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getAll, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public boolean hasTransactionId() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.hasTransactionId, this.tagAttributeList);
        String status = "Success";
        try {
            boolean bl = this.transaction.hasTransactionId();
            return bl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.hasTransactionId, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreTransaction create(FirestoreDocumentReference documentReference, Map<?, ?> data) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.create, this.tagAttributeList);
        String status = "Success";
        try {
            this.validateArguments(documentReference, data, "create");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            FirestoreTransactionImpl firestoreTransactionImpl = new FirestoreTransactionImpl((Transaction)this.transaction.create(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))));
            return firestoreTransactionImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreTransactionImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"create"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.create, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreTransaction set(FirestoreDocumentReference documentReference, Map<?, ?> data) {
        return this.set(documentReference, data, false);
    }

    @Override
    public FirestoreTransaction set(FirestoreDocumentReference documentReference, Map<?, ?> data, boolean merge) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.set, this.tagAttributeList);
        String status = "Success";
        try {
            this.validateArguments(documentReference, data, "set");
            if (data instanceof TemplateProxy) {
                data = JSONUtils.getCFCDataAsMap((TemplateProxy)((TemplateProxy)data));
            }
            if (merge) {
                FirestoreTransactionImpl firestoreTransactionImpl = new FirestoreTransactionImpl((Transaction)this.transaction.set(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data)), SetOptions.merge()));
                return firestoreTransactionImpl;
            }
            FirestoreTransactionImpl firestoreTransactionImpl = new FirestoreTransactionImpl((Transaction)this.transaction.set(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty((Object)data))));
            return firestoreTransactionImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreTransactionImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"set"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.set, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreTransaction update(FirestoreDocumentReference documentReference, Map<?, ?> data) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.update, this.tagAttributeList);
        String status = "Success";
        try {
            this.validateArguments(documentReference, data, "update");
            FirestoreTransactionImpl firestoreTransactionImpl = new FirestoreTransactionImpl((Transaction)this.transaction.update(((FirestoreDocumentReferenceImpl)documentReference).getReference(), FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(data)));
            return firestoreTransactionImpl;
        }
        catch (IllegalArgumentException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(RB.getString(FirestoreTransactionImpl.class, (String)"PROVIDED_INCORRECT_INPUT", (Object)"update"), e);
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getParent, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreTransaction delete(FirestoreDocumentReference documentReference) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.delete, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(documentReference)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreTransactionImpl.class, (String)"DOCUMENT_REFERENCE_NULL"));
            }
            FirestoreTransactionImpl firestoreTransactionImpl = new FirestoreTransactionImpl((Transaction)this.transaction.delete(((FirestoreDocumentReferenceImpl)documentReference).getReference()));
            return firestoreTransactionImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.delete, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public int getMutationSize() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.getMutationSize, this.tagAttributeList);
        String status = "Success";
        try {
            int n = this.transaction.getMutationsSize();
            return n;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.getMutationSize, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }
}

