/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.gcp.firestore.codecs.FirestoreDeserializer;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.OleDateTime;
import com.google.cloud.firestore.DocumentSnapshot;
import java.util.Objects;
import java.util.TreeMap;

public class FirestoreDocumentSnapshot {
    private final DocumentSnapshot documentSnapshot;
    private final CaseSensitiveStruct data;
    private final String id;
    private final String path;
    private final OleDateTime readTime;
    private final OleDateTime createTime;
    private final OleDateTime updateTime;
    private final CFBoolean exists;

    public FirestoreDocumentSnapshot(DocumentSnapshot documentSnapshot) {
        this.documentSnapshot = documentSnapshot;
        this.id = documentSnapshot.getId();
        this.path = documentSnapshot.getReference().getPath();
        this.data = Objects.nonNull(this.getDocumentSnapshot().getData()) ? FirestoreDeserializer.deSerializeMap(new TreeMap<String, Object>(this.getDocumentSnapshot().getData())) : null;
        this.readTime = Objects.nonNull(documentSnapshot.getReadTime()) ? FirestoreUtils.getPrecisedDate(documentSnapshot.getReadTime()) : null;
        this.createTime = Objects.nonNull(documentSnapshot.getCreateTime()) ? FirestoreUtils.getPrecisedDate(documentSnapshot.getCreateTime()) : null;
        this.updateTime = Objects.nonNull(documentSnapshot.getUpdateTime()) ? FirestoreUtils.getPrecisedDate(documentSnapshot.getUpdateTime()) : null;
        boolean value = this.getDocumentSnapshot().exists();
        this.exists = new CFBoolean(Boolean.valueOf(value).toString(), value);
    }

    DocumentSnapshot getDocumentSnapshot() {
        return this.documentSnapshot;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public OleDateTime getReadTime() {
        return this.readTime;
    }

    public OleDateTime getCreateTime() {
        return this.createTime;
    }

    public OleDateTime getUpdateTime() {
        return this.updateTime;
    }

    public CFBoolean exists() {
        return this.exists;
    }

    public CaseSensitiveStruct getData() {
        return this.data;
    }
}

