/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.codecs;

import coldfusion.cloud.gcp.firestore.FirestoreCollectionReference;
import coldfusion.cloud.gcp.firestore.FirestoreDocumentReference;
import coldfusion.cloud.gcp.firestore.exception.GCPFirestoreException;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentReferenceImpl;
import coldfusion.cloud.gcp.firestore.impl.ReferenceGetter;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CFBigInteger;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.util.RB;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FirestoreSerializer {
    public static Map<String, Object> serializeMap(Map<String, Object> fields) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        fields.forEach((key, value) -> itemMap.put((String)key, FirestoreSerializer.serializeCFTypes(value)));
        return itemMap;
    }

    public static List<Object> serializeList(List<Object> objectList) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        objectList.forEach(value -> itemList.add(FirestoreSerializer.serializeCFTypes(value)));
        return itemList;
    }

    public static Object serializeCFTypes(Object value) {
        if (value instanceof CFBigDecimal) {
            return Cast._cast((Object)value, BigDecimal.class);
        }
        if (value instanceof CFBigInteger) {
            return Cast._cast((Object)value, BigInteger.class);
        }
        if (value instanceof CFInteger) {
            return Cast._cast((Object)value, Integer.class);
        }
        if (value instanceof CFLong) {
            return Cast._cast((Object)value, Long.class);
        }
        if (value instanceof CFDouble) {
            return Cast._cast((Object)value, Double.class);
        }
        if (value instanceof CFBoolean) {
            return Cast._cast((Object)value, Boolean.class);
        }
        if (value instanceof OleDateTime) {
            return Timestamp.ofTimeSecondsAndNanos((long)(((OleDateTime)value).getTime() / 1000L), (int)((OleDateTime)value).getNanos());
        }
        if (value instanceof FirestoreDocumentReference) {
            return ReferenceGetter.getDocumentReference((FirestoreDocumentReferenceImpl)value);
        }
        if (value instanceof FirestoreCollectionReference) {
            throw new GCPFirestoreException(RB.getString(FirestoreSerializer.class, (String)"COLLECTION_REFERENCE_NOT_SUPPORTED"));
        }
        if (value instanceof Map) {
            return FirestoreSerializer.serializeMap(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(value));
        }
        if (value instanceof byte[]) {
            return Blob.fromBytes((byte[])((byte[])value));
        }
        if (value instanceof List) {
            return FirestoreSerializer.serializeList((List)value);
        }
        return value;
    }
}

