/*
 * Decompiled with CFR 0.152.
 */
package ice.net.proxy;

import ice.net.Authentication;
import ice.net.Indirect;
import java.io.Serializable;

public class Proxy
extends Indirect
implements Serializable {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final boolean DEFAULT_TUNNELING = false;
    private Authentication authentication;
    private String protocol;
    private boolean tunneling;

    public Proxy(String host) throws IllegalArgumentException {
        this(DEFAULT_PROTOCOL, host, 80, false);
    }

    public Proxy(String host, int port) throws IllegalArgumentException {
        this(DEFAULT_PROTOCOL, host, port, false);
    }

    public Proxy(String protocol, String host, int port) throws IllegalArgumentException {
        this(protocol, host, port, false);
    }

    public Proxy(String protocol, String host, int port, boolean tunneling) throws IllegalArgumentException {
        super(host, port);
        this.checkProtocol(protocol);
        this.protocol = protocol.trim().toLowerCase();
        this.tunneling = tunneling;
    }

    public Proxy(String host, int port, String protocol) {
        this(protocol, host, port);
    }

    public Proxy(String host, int port, String protocol, boolean tunneling) {
        this(protocol, host, port, tunneling);
    }

    public boolean equals(Object object) {
        if (object instanceof Proxy) {
            return super.equals(object) && this.protocol.equals(((Proxy)object).getProtocol()) && this.tunneling == ((Proxy)object).isTunneling() && this.authentication != null ? this.authentication.equals(((Proxy)object).getAuthentication()) : ((Proxy)object).getAuthentication() == null;
        }
        return false;
    }

    public final Authentication getAuthentication() {
        return this.authentication;
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public Authentication getProxyAuthentication() {
        return this.getAuthentication();
    }

    public final boolean isTunneling() {
        return this.tunneling;
    }

    public final void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setProxyAuthentication(Authentication authentication) {
        this.setAuthentication(authentication);
    }

    public String toString() {
        return "Proxy [host: " + this.getHost() + ", " + "port: " + this.getPort() + "]";
    }

    protected final void checkProtocol(String protocol) throws IllegalArgumentException {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        if (protocol.trim().length() == 0) {
            throw new IllegalArgumentException("protocol is empty");
        }
    }
}

