/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Cache;
import ice.net.CacheManager;
import ice.net.CachedObject;
import ice.util.Defs;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class MemoryCache
implements Cache {
    private static final String CACHE_NAME = "Memory Cache";
    private long maxBytes = 1000000L;
    private long currentBytes;
    private Hashtable theData;
    private CacheManager theManager;
    private boolean verboseDebug = Defs.sysPropertyBoolean((String)"ice.net.debug.memorycache", (boolean)false);

    public MemoryCache() {
        this.theData = new Hashtable();
    }

    public void setManager(CacheManager cmIn) {
        this.theManager = cmIn;
    }

    public void setExpires(String url, Date date) {
        if (date == null) {
            return;
        }
        CachedObject _cachedObject = (CachedObject)this.theData.get(url);
        if (_cachedObject != null) {
            _cachedObject.setExpires(date.getTime());
        }
    }

    public void submit(CachedObject cachedObject) {
        if (cachedObject != null && (long)cachedObject.size() < this.maxBytes) {
            String _url = cachedObject.getURL();
            if (this.has(_url)) {
                if (this.isExpired(this.get(_url))) {
                    this.removeEntry(_url);
                    this.addEntry(cachedObject);
                    if (this.verboseDebug) {
                        Debug.trace((String)(cachedObject.getURL() + " was expired and has been replaced."));
                    }
                } else if (this.suppliedIsNewer(cachedObject)) {
                    this.removeEntry(_url);
                    this.addEntry(cachedObject);
                    if (this.verboseDebug) {
                        Debug.trace((String)(cachedObject.getURL() + " was refreshed."));
                    }
                }
            } else {
                this.addEntry(cachedObject);
            }
        }
    }

    public void delete(String url, boolean propFlag) {
        if (this.has(url)) {
            CachedObject c = this.get(url);
            this.removeEntry(url);
            if (this.theManager != null && propFlag) {
                this.theManager.wasDeleted(c, this);
            }
        }
    }

    private boolean suppliedIsNewer(CachedObject suppliedCachedObject) {
        CachedObject _cachedObject = (CachedObject)this.theData.get(suppliedCachedObject.getURL());
        long _lastModified = _cachedObject.getLastModified();
        long _suppliedLastModified = suppliedCachedObject.getLastModified();
        if (_lastModified == -1L || _suppliedLastModified == -1L) {
            return false;
        }
        return _lastModified < _suppliedLastModified;
    }

    public boolean has(String url) {
        return this.theData.containsKey(url);
    }

    private void removeEntry(String url) {
        CachedObject _cachedObject = (CachedObject)this.theData.get(url);
        if (_cachedObject != null) {
            this.theData.remove(url);
            this.currentBytes -= (long)_cachedObject.size();
            if (this.verboseDebug) {
                Debug.trace((String)("Removed " + url + " from the memory cache. Currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes(" + this.getUsedPercentage() + "%)"));
            }
        }
    }

    private void addEntry(CachedObject cachedObject) {
        cachedObject.setLastAccessed(System.currentTimeMillis());
        this.currentBytes += (long)cachedObject.size();
        if (this.currentBytes > this.maxBytes) {
            this.cull();
        }
        this.theData.put(cachedObject.getURL(), cachedObject);
        if (this.verboseDebug) {
            Debug.trace((String)(cachedObject.getURL() + " added to the memory cache. Currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes(" + this.getUsedPercentage() + "%)"));
        }
    }

    private String getUsedPercentage() {
        double c = this.currentBytes;
        double m = this.maxBytes;
        String perc = String.valueOf(c / m * 100.0);
        int loc = perc.indexOf(46);
        if (loc != -1) {
            perc = perc.substring(0, loc);
        }
        return perc;
    }

    public long getCurrentSize() {
        return this.currentBytes;
    }

    public void clear() {
        this.theData.clear();
        this.currentBytes = 0L;
    }

    private void cull() {
        while (this.currentBytes > this.maxBytes) {
            String theOldest = this.getOldest();
            CachedObject o = (CachedObject)this.theData.get(theOldest);
            if (this.verboseDebug) {
                Debug.trace((String)("Cache full - culling entry: " + theOldest));
            }
            this.removeEntry(theOldest);
            if (this.theManager == null) continue;
            this.theManager.wasDeleted(o, this);
        }
    }

    public void setMaxSize(long sizeInBytes) {
        this.maxBytes = sizeInBytes;
        if (this.currentBytes > this.maxBytes) {
            this.cull();
        }
    }

    public long getMaxSize() {
        return this.maxBytes;
    }

    public void clearExpired() {
        Enumeration e = this.theData.elements();
        while (e.hasMoreElements()) {
            CachedObject _cachedObject = (CachedObject)e.nextElement();
            if (!this.isExpired(_cachedObject)) continue;
            this.removeEntry(_cachedObject.getURL());
        }
    }

    public CachedObject get(String url) {
        CachedObject retVal = (CachedObject)this.theData.get(url);
        if (this.verboseDebug && retVal != null) {
            Debug.trace((String)("Retrieved " + url + " from memory cache."));
        }
        retVal.setLastAccessed(System.currentTimeMillis());
        return retVal;
    }

    public String getName() {
        return CACHE_NAME;
    }

    boolean isExpired(CachedObject o) {
        return this.theManager.isExpired(o);
    }

    String getOldest() {
        Enumeration e = this.theData.elements();
        String oldestName = null;
        long oldesttime = Long.MAX_VALUE;
        while (e.hasMoreElements()) {
            CachedObject _cachedObject = (CachedObject)e.nextElement();
            if (_cachedObject.getLastAccessed() >= oldesttime) continue;
            oldesttime = _cachedObject.getLastAccessed();
            oldestName = _cachedObject.getURL();
        }
        return oldestName;
    }
}

