/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.HttpMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLConnection;

public class HttpRequest
extends HttpMessage
implements Cloneable,
Serializable {
    public static final String CONNECT = "CONNECT";
    public static final String DELETE = "DELETE";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String TRACE = "TRACE";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String AUTHORIZATION = "Authorization";
    public static final String EXPECT = "Expect";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String TE = "TE";
    public static final String USER_AGENT = "User-Agent";
    public static final String COOKIE = "Cookie";
    public static final String COOKIE2 = "Cookie2";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String MAX_AGE = "max-age";
    public static final String MAX_STALE = "max-stale";
    public static final String MIN_FRESH = "min-fresh";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String ONLY_IF_CACHED = "only-if-cached";
    private String method;
    private String requestUri;
    private long requestTime;

    public HttpRequest(String method, String requestUri, String httpVersion) throws IllegalArgumentException {
        super(httpVersion);
        this.setMethod(method);
        this.setRequestUri(requestUri);
    }

    public Object clone() {
        HttpRequest _httpRequest = (HttpRequest)super.clone();
        return _httpRequest;
    }

    public boolean equals(Object object) {
        return object instanceof HttpRequest && ((HttpRequest)object).method.equalsIgnoreCase(this.method) && ((HttpRequest)object).requestUri.equalsIgnoreCase(this.requestUri) && super.equals(object);
    }

    public String getMessage(boolean showBody) {
        StringBuffer _stringBuffer = new StringBuffer();
        _stringBuffer.append(this.getRequestLine() + "\r\n");
        int _size = this.headerMap.getSize();
        for (int i = 0; i < _size; ++i) {
            _stringBuffer.append(this.headerMap.getFieldName(i) + ":" + " " + this.headerMap.getFieldValue(i) + "\r\n");
        }
        _stringBuffer.append("\r\n");
        if (showBody && this.entityBody != null) {
            _stringBuffer.append(this.entityBody.toString());
        }
        return _stringBuffer.toString();
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestLine() {
        return this.method + " " + this.requestUri + " " + this.httpVersion;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getStartLine() {
        return this.getRequestLine();
    }

    public void putHeader(String fieldName, String fieldValue) {
        int _atIndex;
        int _endIndex;
        int _beginIndex;
        String _fieldValue = fieldValue;
        if (REFERER.equalsIgnoreCase(fieldName) && _fieldValue != null && (_beginIndex = _fieldValue.indexOf("://")) != -1 && (_endIndex = _fieldValue.indexOf("/", _beginIndex += 3)) != -1 && (_atIndex = _fieldValue.indexOf("@", _beginIndex)) != -1 && _atIndex < _endIndex) {
            _fieldValue = _fieldValue.substring(0, _beginIndex) + _fieldValue.substring(_atIndex + 1);
        }
        super.putHeader(fieldName, _fieldValue);
    }

    public void setEntityBody(HttpMessage.EntityBody entityBody) {
        super.setEntityBody(entityBody);
        if (this.entityBody.bytes != null) {
            this.putHeader("Content-Length", Integer.toString(this.entityBody.bytes.length));
        }
        if (!this.containsHeader("Content-Type")) {
            try {
                String _contentType = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(this.entityBody.bytes));
                if (_contentType != null) {
                    this.putHeader("Content-Type", _contentType);
                }
            }
            catch (IOException exception) {
                Debug.ex((Throwable)exception);
            }
        }
    }

    public void setMethod(String method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        if (method.trim().length() == 0) {
            throw new IllegalArgumentException("method is empty");
        }
        this.method = method;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setRequestUri(String requestUri) throws IllegalArgumentException {
        if (requestUri == null) {
            throw new IllegalArgumentException("requestUri is null");
        }
        if (requestUri.trim().length() == 0) {
            throw new IllegalArgumentException("requestUri is empty");
        }
        this.requestUri = requestUri;
    }

    public String toString() {
        return "HttpRequest [" + this.getRequestLine() + "]";
    }
}

