/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Cache;
import ice.net.CacheFileFilter;
import ice.net.CacheManager;
import ice.net.CachedObject;
import ice.net.FileInfo;
import ice.util.Defs;
import ice.util.ICEException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileCache
implements Cache {
    private static final String INTERVAL_SYSPROP = "ice.net.filecache.dictionarySaveInterval";
    private static final int DEF_INTERVAL = 20;
    private static final String CACHE_NAME = "File Cache";
    private long maxBytes;
    private long currentBytes;
    private Hashtable theData;
    private Hashtable fileInfos;
    private CacheManager theManager;
    private String path = "";
    private int counter;
    private int interval;
    private boolean verboseDebug;
    private CacheFileFilter cacheFileFilter = new CacheFileFilter();
    private final int INITIAL_CACHE_SIZE = 5000000;

    public FileCache(String pathIn) throws ICEException {
        this.verboseDebug = Defs.sysPropertyBoolean((String)"ice.net.debug.filecache", (boolean)false);
        if (this.verboseDebug) {
            Debug.trace((String)"Initializing file Cache");
        }
        String intString = Defs.sysProperty((String)INTERVAL_SYSPROP, (String)String.valueOf(20));
        try {
            this.interval = Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            this.interval = 20;
            Debug.trace((String)("ice.net.filecache.dictionarySaveInterval value \"" + intString + "\" is not an integer! - using default value of " + 20));
        }
        if (Debug.trace) {
            Debug.trace((String)("File cache saving dictionary (ice.net.filecache.dictionarySaveInterval) every " + this.interval + " accesses"));
        }
        this.setDirectory(pathIn);
        this.maxBytes = 5000000L;
    }

    private void init() {
        this.theData = new Hashtable();
        this.fileInfos = new Hashtable();
        if (!this.readDictionary() || !this.validateDictionary()) {
            this.rebuild();
            this.writeDictionary();
        } else if (this.verboseDebug) {
            Debug.trace((String)"Dictionary file loaded and evaluated");
        }
    }

    private void testDirectory() throws IOException {
        String fileName = "testfile";
        File test = new File(this.path + File.separatorChar + fileName);
        if (this.verboseDebug) {
            Debug.trace((String)("Trying to write testfile: " + this.path + File.separatorChar + fileName));
        }
        FileWriter fw = new FileWriter(test);
        String data = "testtesttest";
        fw.write(data, 0, data.length());
        fw.close();
        boolean result = test.delete();
        if (this.verboseDebug) {
            if (result) {
                Debug.trace((String)"Test file written and deleted successfully.");
            } else {
                Debug.trace((String)"Attempt to delete Test file failed!");
            }
        }
    }

    public void setManager(CacheManager cmIn) {
        this.theManager = cmIn;
        this.init();
    }

    public void submit(CachedObject cachedObject) {
        if (this.has(cachedObject.getURL())) {
            if (this.isExpired(this.getInfo(cachedObject.getURL()))) {
                if (this.verboseDebug) {
                    Debug.trace((String)(cachedObject.getURL() + " is expired and is being replaced."));
                }
                this.removeEntry(cachedObject.getURL());
                this.addEntry(cachedObject);
            } else if (this.suppliedIsNewer(cachedObject)) {
                if (this.verboseDebug) {
                    Debug.trace((String)(cachedObject.getURL() + " is being refreshed."));
                }
                this.removeEntry(cachedObject.getURL());
                this.addEntry(cachedObject);
            } else if (this.verboseDebug) {
                Debug.trace((String)(cachedObject.getURL() + " is not expired and has no newer version. Neither added nor replaced."));
            }
        } else {
            this.addEntry(cachedObject);
        }
        if (this.currentBytes > this.maxBytes) {
            this.cull();
        }
    }

    public boolean has(String url) {
        return this.fileInfos.containsKey(url);
    }

    public void delete(String url, boolean propFlag) {
        if (this.has(url)) {
            CachedObject c = null;
            if (propFlag) {
                c = this.get(url);
            }
            this.removeEntry(url);
            if (this.theManager != null && propFlag) {
                this.theManager.wasDeleted(c, this);
            }
        }
    }

    private String getFileName(String url) {
        String retVal = null;
        retVal = url.hashCode() < 0 ? '0' + String.valueOf(url.hashCode()).substring(1) + ".ice" : String.valueOf(url.hashCode()) + ".ice";
        return retVal;
    }

    private boolean suppliedIsNewer(CachedObject cachedObject) {
        FileInfo _fileInfo = (FileInfo)this.fileInfos.get(cachedObject.getURL());
        Date oneInCache = new Date(_fileInfo.lastModifiedValue);
        Date newOne = new Date(cachedObject.getLastModified());
        if (oneInCache == null || newOne == null) {
            return false;
        }
        return oneInCache.before(newOne);
    }

    private void addEntry(CachedObject cachedObject) {
        long start = System.currentTimeMillis();
        cachedObject.setLastAccessed(start);
        FileInfo _fileInfo = this.toInfo(cachedObject);
        if (this.isExpired(_fileInfo)) {
            if (this.verboseDebug) {
                Debug.trace((String)("Not adding entry for URL: " + _fileInfo.url + ", URL already expired"));
            }
            return;
        }
        int coSize = cachedObject.size();
        if ((long)coSize + this.currentBytes > this.maxBytes) {
            this.cull(coSize);
        }
        try {
            String fileName = this.getFileName(cachedObject.getURL());
            FileOutputStream out = new FileOutputStream(this.path + File.separatorChar + fileName);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(cachedObject);
            s.flush();
            s.close();
            out.close();
            this.theData.put(cachedObject.getURL(), fileName);
            File ff = new File(this.path + File.separatorChar + fileName);
            this.currentBytes += ff.length();
            this.fileInfos.put(cachedObject.getURL(), _fileInfo);
            if (this.verboseDebug) {
                Debug.trace((String)("Added " + cachedObject.getURL() + " to the file cache in " + (System.currentTimeMillis() - start) + " ms.  Currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes(" + this.getUsedPercentage() + "%)"));
            }
        }
        catch (IOException e) {
            Debug.ex((Throwable)e);
        }
        ++this.counter;
        if (this.counter > this.interval) {
            this.writeDictionary();
        }
    }

    public void setDirectory(String pathIn) throws ICEException {
        Debug.trace((String)("File Cache directory set to: " + pathIn));
        try {
            if (pathIn == null) {
                throw new IOException("dummy");
            }
            if (pathIn.equals("")) {
                throw new IOException("dummy");
            }
            this.path = pathIn;
            this.testDirectory();
        }
        catch (IOException e) {
            throw new ICEException(2, 1, 18);
        }
    }

    public String getDirectory() {
        return this.path;
    }

    private void removeEntry(String url) {
        String o = (String)this.theData.get(url);
        if (o != null) {
            long start = System.currentTimeMillis();
            this.theData.remove(url);
            this.fileInfos.remove(url);
            if (!o.endsWith(".ice")) {
                return;
            }
            File f = new File(this.path + File.separatorChar + o);
            if (!f.exists()) {
                return;
            }
            this.currentBytes -= f.length();
            boolean status = f.delete();
            if (!status && Debug.trace) {
                Debug.trace((String)("Attempt to delete cache file: " + f.getName() + " failed. File not deleted."));
            }
            o = null;
            if (this.verboseDebug) {
                Debug.trace((String)("Removed " + url + " from the file cache in " + (System.currentTimeMillis() - start) + " ms. Currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes(" + this.getUsedPercentage() + "%)"));
            }
        }
    }

    public long getCurrentSize() {
        return this.currentBytes;
    }

    public void clear() {
        Enumeration e = this.theData.elements();
        while (e.hasMoreElements()) {
            boolean status;
            File f;
            String aFile = (String)e.nextElement();
            if (!aFile.endsWith(".ice") || !(f = new File(this.path + File.separatorChar + aFile)).exists() || (status = f.delete()) || !Debug.trace) continue;
            Debug.trace((String)("Attempt to delete cache file: " + f.getName() + " failed. File not deleted."));
        }
        this.fileInfos.clear();
        this.currentBytes = 0L;
    }

    private void cull() {
        this.cull(0);
    }

    private void cull(int bytesNeeded) {
        while (this.currentBytes + (long)bytesNeeded > this.maxBytes) {
            String theOldest = this.getOldest();
            String o = (String)this.theData.get(theOldest);
            if (this.theManager != null) {
                CachedObject p = this.get(o);
                this.theManager.wasDeleted(p, this);
            }
            if (this.verboseDebug) {
                Debug.trace((String)("Cache full - culling entry: " + theOldest));
            }
            this.removeEntry(theOldest);
        }
        this.writeDictionary();
    }

    public void setMaxSize(long sizeInBytes) {
        this.maxBytes = sizeInBytes;
        if (this.currentBytes > this.maxBytes) {
            this.cull();
        }
    }

    public long getMaxSize() {
        return this.maxBytes;
    }

    public void setExpires(String url, Date date) {
        FileInfo _fileInfo;
        if (date != null && (_fileInfo = (FileInfo)this.fileInfos.get(url)) != null) {
            _fileInfo.expiresValue = date.getTime();
        }
    }

    public void clearExpired() {
        Enumeration e = this.theData.elements();
        while (e.hasMoreElements()) {
            FileInfo tmp = (FileInfo)e.nextElement();
            if (!this.isExpired(tmp)) continue;
            this.removeEntry(tmp.url);
        }
    }

    private FileInfo getInfo(String url) {
        return (FileInfo)this.fileInfos.get(url);
    }

    public CachedObject get(String url) {
        if (!this.has(url)) {
            return null;
        }
        FileInfo f = (FileInfo)this.fileInfos.get(url);
        if (this.isExpired(f)) {
            this.removeEntry(url);
            return null;
        }
        CachedObject rtn = null;
        String fileName = null;
        try {
            long start = System.currentTimeMillis();
            fileName = (String)this.theData.get(url);
            FileInputStream iStream = new FileInputStream(this.path + File.separatorChar + fileName);
            ObjectInputStream p = new ObjectInputStream(iStream);
            rtn = (CachedObject)p.readObject();
            iStream.close();
            if (this.verboseDebug) {
                Debug.trace((String)("Retrieved " + url + " from file cache in " + (System.currentTimeMillis() - start) + " ms"));
            }
            f.lastAccessed = start;
        }
        catch (IOException e) {
            Debug.ex((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Debug.ex((Throwable)e);
        }
        ++this.counter;
        if (this.counter > this.interval) {
            this.writeDictionary();
        }
        return rtn;
    }

    public String getName() {
        return CACHE_NAME;
    }

    boolean isExpired(FileInfo fileInfo) {
        return !CachedObject.isFresh(fileInfo.ageValue, fileInfo.dateValue, fileInfo.requestTime, fileInfo.responseTime, fileInfo.maxAgeValue, fileInfo.expiresValue, fileInfo.lastModifiedValue, this.theManager.getCacheExpirationBuffer() * 1000);
    }

    void writeDictionary() {
        block5: {
            try {
                long start = System.currentTimeMillis();
                FileOutputStream fOut = new FileOutputStream(this.path + File.separatorChar + "dictionary.tmp");
                DataOutputStream dOut = new DataOutputStream(fOut);
                Enumeration e = this.fileInfos.elements();
                dOut.writeInt(this.fileInfos.size());
                while (e.hasMoreElements()) {
                    FileInfo _fileInfo = (FileInfo)e.nextElement();
                    dOut.writeInt(_fileInfo.url.length());
                    dOut.writeChars(_fileInfo.url);
                    dOut.writeLong(_fileInfo.ageValue);
                    dOut.writeLong(_fileInfo.dateValue);
                    dOut.writeLong(_fileInfo.requestTime);
                    dOut.writeLong(_fileInfo.responseTime);
                    dOut.writeLong(_fileInfo.maxAgeValue);
                    dOut.writeLong(_fileInfo.expiresValue);
                    dOut.writeLong(_fileInfo.lastModifiedValue);
                    dOut.writeLong(_fileInfo.lastAccessed);
                }
                dOut.close();
                fOut.close();
                File f = new File(this.path + File.separatorChar + "dictionary.tmp");
                File target = new File(this.path + File.separatorChar + "dictionary.ice");
                if (target.exists()) {
                    this.currentBytes -= target.length();
                    target.delete();
                }
                f.renameTo(target);
                this.currentBytes += target.length();
                if (this.verboseDebug) {
                    Debug.trace((String)("Dictionary file saved in " + (System.currentTimeMillis() - start) + " ms. Currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes(" + this.getUsedPercentage() + "%), with " + this.fileInfos.size() + " files cached"));
                }
            }
            catch (IOException e) {
                if (!Debug.trace) break block5;
                Debug.trace((String)("IOException renaming dictionary file: " + e));
            }
        }
        this.counter = 0;
    }

    boolean readDictionary() {
        long start = System.currentTimeMillis();
        Hashtable<String, FileInfo> temp = new Hashtable<String, FileInfo>();
        Hashtable<String, String> temp2 = new Hashtable<String, String>();
        try {
            String theFile = this.path + File.separatorChar + "dictionary.ice";
            FileInputStream fIn = new FileInputStream(theFile);
            DataInputStream dIn = new DataInputStream(fIn);
            int length = dIn.readInt();
            for (int i = 0; i < length; ++i) {
                FileInfo _fileInfo = new FileInfo();
                StringBuffer url = new StringBuffer();
                int urllength = dIn.readInt();
                for (int j = 0; j < urllength; ++j) {
                    url.append(dIn.readChar());
                }
                _fileInfo.url = url.toString();
                _fileInfo.ageValue = dIn.readLong();
                _fileInfo.dateValue = dIn.readLong();
                _fileInfo.requestTime = dIn.readLong();
                _fileInfo.responseTime = dIn.readLong();
                _fileInfo.maxAgeValue = dIn.readLong();
                _fileInfo.expiresValue = dIn.readLong();
                _fileInfo.lastModifiedValue = dIn.readLong();
                _fileInfo.lastAccessed = dIn.readLong();
                if (this.isExpired(_fileInfo)) continue;
                temp.put(_fileInfo.url, _fileInfo);
                temp2.put(_fileInfo.url, this.getFileName(_fileInfo.url));
            }
            if (this.fileInfos != null) {
                this.fileInfos.clear();
                this.theData.clear();
            }
            this.fileInfos = temp;
            this.theData = temp2;
            this.currentBytes += (long)theFile.length();
            if (this.verboseDebug) {
                Debug.trace((String)("Read " + length + " entries from dictionary in " + (System.currentTimeMillis() - start) + " ms."));
            }
            return true;
        }
        catch (IOException e) {
            File f;
            if (this.verboseDebug) {
                Debug.trace((String)("Reading dictionary failed with Exception: " + e + " rebuilding..."));
            }
            if ((f = new File(this.path + File.separatorChar + "dictionary.ice")).exists()) {
                f.delete();
            }
            return false;
        }
    }

    private String getUsedPercentage() {
        double c = this.currentBytes;
        double m = this.maxBytes;
        String perc = String.valueOf(c / m * 100.0);
        int loc = perc.indexOf(46);
        if (loc != -1) {
            perc = perc.substring(0, loc);
        }
        return perc;
    }

    private boolean validateDictionary() {
        long start = System.currentTimeMillis();
        Enumeration keys = this.fileInfos.keys();
        File directory = new File(this.path);
        File[] cacheFiles = directory.listFiles(this.cacheFileFilter);
        int keyCount = 0;
        int missingFiles = 0;
        block0: while (keys.hasMoreElements()) {
            String URL2 = (String)keys.nextElement();
            String fileName = this.getFileName(URL2);
            File cacheFile = new File(this.path + File.separatorChar + fileName);
            if (!cacheFile.exists()) {
                if (this.verboseDebug) {
                    Debug.trace((String)("Cached .ice file for: " + URL2 + " doesn't exist, removing cache entry"));
                }
                this.fileInfos.remove(URL2);
                ++missingFiles;
                continue;
            }
            ++keyCount;
            for (int idx = 0; idx < cacheFiles.length; ++idx) {
                if (cacheFiles[idx] == null || !cacheFiles[idx].getName().equals(fileName)) continue;
                this.currentBytes += cacheFiles[idx].length();
                cacheFiles[idx] = null;
                continue block0;
            }
        }
        int lostFiles = 0;
        for (int fdx = 0; fdx < cacheFiles.length; ++fdx) {
            if (cacheFiles[fdx] == null || !this.addFileToCache(this.fileInfos, this.theData, cacheFiles[fdx])) continue;
            ++lostFiles;
        }
        if (lostFiles > 0 || missingFiles > 0) {
            this.writeDictionary();
        }
        if (this.currentBytes > this.maxBytes) {
            this.cull();
        }
        if (Debug.trace) {
            Debug.trace((String)("Validated cache in " + (System.currentTimeMillis() - start) + " ms with " + keyCount + " valid keys, " + lostFiles + " files missing keys, and " + missingFiles + " keys missing files, currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes(" + this.getUsedPercentage() + "%), with " + this.fileInfos.size() + " files in cache"));
        }
        return true;
    }

    void rebuild() {
        long start = System.currentTimeMillis();
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        File theDirectory = new File(this.path);
        int fileCount = 0;
        if (theDirectory.isDirectory()) {
            if (Debug.trace) {
                Debug.trace((String)("Rebuilding file cache, using directory " + theDirectory + " for file cache"));
            }
            File[] theFiles = theDirectory.listFiles(this.cacheFileFilter);
            for (int i = 0; i < theFiles.length; ++i) {
                if (!this.addFileToCache(temp, temp2, theFiles[i])) continue;
                ++fileCount;
            }
            this.fileInfos = temp;
            this.theData = temp2;
        } else if (Debug.trace) {
            Debug.trace((String)("Rebuild of file cache failed: " + theDirectory + " is not a directory."));
        }
        if (this.currentBytes > this.maxBytes) {
            this.cull();
        }
        if (Debug.trace) {
            Debug.trace((String)("Rebuilt file cache in " + (System.currentTimeMillis() - start) + " ms with " + fileCount + " files found. Currently using " + this.currentBytes + " out of " + this.maxBytes + " bytes"));
        }
    }

    private boolean addFileToCache(Hashtable fileCache, Hashtable dataCache, File foundFile) {
        if (foundFile.getName().indexOf("dictionary") > -1) {
            return false;
        }
        try {
            FileInputStream iStream = new FileInputStream(foundFile);
            ObjectInputStream p = new ObjectInputStream(iStream);
            CachedObject _cachedObject = (CachedObject)p.readObject();
            iStream.close();
            FileInfo _fileInfo = this.toInfo(_cachedObject);
            if (this.isExpired(_fileInfo)) {
                foundFile.delete();
                return false;
            }
            if (this.verboseDebug) {
                Debug.trace((String)("URL: " + _fileInfo.url + " was found on disk. Adding to FileCache"));
            }
            this.currentBytes += foundFile.length();
            fileCache.put(_fileInfo.url, _fileInfo);
            dataCache.put(_fileInfo.url, foundFile.getName());
            return true;
        }
        catch (IOException e) {
            Debug.ex((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Debug.ex((Throwable)e);
        }
        return false;
    }

    String getOldest() {
        Enumeration e = this.fileInfos.elements();
        String oldestName = null;
        long oldesttime = Long.MAX_VALUE;
        while (e.hasMoreElements()) {
            FileInfo tmp = (FileInfo)e.nextElement();
            if (tmp.lastAccessed >= oldesttime) continue;
            oldesttime = tmp.lastAccessed;
            oldestName = tmp.url;
        }
        return oldestName;
    }

    private FileInfo toInfo(CachedObject cachedObject) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.url = cachedObject.getURL();
        fileInfo.ageValue = cachedObject.getAge();
        fileInfo.dateValue = cachedObject.getDate();
        fileInfo.requestTime = cachedObject.getRequestTime();
        fileInfo.responseTime = cachedObject.getResponse().getResponseTime();
        fileInfo.maxAgeValue = cachedObject.getMaxAge();
        fileInfo.expiresValue = cachedObject.getExpires();
        fileInfo.lastModifiedValue = cachedObject.getLastModified();
        fileInfo.lastAccessed = cachedObject.getLastAccessed();
        return fileInfo;
    }
}

