/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.ConnectionManager;
import ice.util.Defs;
import ice.util.Settings;
import java.io.Serializable;

public class ConnectionManagerSettings
implements Serializable,
Settings {
    private static final int MAX_PERSISTENT_CONNECTIONS_DEFAULT = 4;
    private static final String MAX_PERSISTENT_CONNECTIONS_KEY = "ice.net.maxPersistentConnections";
    private static final boolean NAGLE_ENABLED_DEFAULT = true;
    private static final String NAGLE_ENABLED_KEY = "ice.net.nagleEnabled";
    private static final int PERSISTENT_CONNECTION_TIMEOUT_DEFAULT = 15;
    private static final String PERSISTENT_CONNECTION_TIMEOUT_KEY = "ice.net.persistentConnectionTimeout";
    private static final boolean PERSISTENT_CONNECTIONS_ENABLED_DEFAULT = true;
    private static final String PERSISTENT_CONNECTIONS_ENABLED_KEY = "ice.net.persistentConnectionsEnabled";
    private static final int READ_BUFFER_SIZE_DEFAULT = 4096;
    private static final String READ_BUFFER_SIZE_KEY = "ice.net.readBufferSize";
    private static final int SO_TIMEOUT_DEFAULT = 0;
    private static final String SO_TIMEOUT_KEY = "ice.net.soTimeout";
    private int maxPersistentConnections;
    private boolean nagleEnabled;
    private boolean persistentConnectionsEnabled;
    private int persistentConnectionTimeout;
    private int readBufferSize;
    private int soTimeout;
    Object instancesLock = new Object();
    int instancesInUse = 0;

    public ConnectionManagerSettings() {
        this.initialize();
    }

    public static boolean areDefaultPersistentConnectionsEnabled() {
        return Defs.sysPropertyBoolean((String)PERSISTENT_CONNECTIONS_ENABLED_KEY, (boolean)true);
    }

    public boolean arePersistentConnectionsEnabled() {
        return this.persistentConnectionsEnabled;
    }

    public boolean equals(Object object) {
        return object instanceof ConnectionManagerSettings && ((ConnectionManagerSettings)object).maxPersistentConnections == this.maxPersistentConnections && ((ConnectionManagerSettings)object).nagleEnabled == this.nagleEnabled && ((ConnectionManagerSettings)object).persistentConnectionsEnabled == this.persistentConnectionsEnabled && ((ConnectionManagerSettings)object).persistentConnectionTimeout == this.persistentConnectionTimeout && ((ConnectionManagerSettings)object).readBufferSize == this.readBufferSize && ((ConnectionManagerSettings)object).soTimeout == this.soTimeout;
    }

    public static int getDefaultMaxPersistentConnections() {
        return Defs.sysPropertyInt((String)MAX_PERSISTENT_CONNECTIONS_KEY, (int)4);
    }

    public static int getDefaultPersistentConnectionTimeout() {
        return Defs.sysPropertyInt((String)PERSISTENT_CONNECTION_TIMEOUT_KEY, (int)15);
    }

    public static int getDefaultReadBufferSize() {
        return Defs.sysPropertyInt((String)READ_BUFFER_SIZE_KEY, (int)4096);
    }

    public static int getDefaultSoTimeout() {
        return Defs.sysPropertyInt((String)SO_TIMEOUT_KEY, (int)0);
    }

    public int getMaxPersistentConnections() {
        return this.maxPersistentConnections;
    }

    public int getPersistentConnectionTimeout() {
        return this.persistentConnectionTimeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public static boolean isDefaultNagleEnabled() {
        return Defs.sysPropertyBoolean((String)NAGLE_ENABLED_KEY, (boolean)true);
    }

    public boolean isNagleEnabled() {
        return this.nagleEnabled;
    }

    public void resetToDefault() {
        this.initialize();
    }

    public static void setDefaultMaxPersistentConnections(int maxPersistentConnections) throws IllegalArgumentException {
        ConnectionManager.checkMaxPersistentConnections(maxPersistentConnections);
        Defs.setSystemProperty((String)MAX_PERSISTENT_CONNECTIONS_KEY, (String)Integer.toString(maxPersistentConnections));
    }

    public static void setDefaultNagleEnabled(boolean nagleEnabled) {
        Defs.setSystemProperty((String)NAGLE_ENABLED_KEY, (String)new Boolean(nagleEnabled).toString());
    }

    public static void setDefaultPersistentConnectionsEnabled(boolean persistentConnectionsEnabled) {
        Defs.setSystemProperty((String)PERSISTENT_CONNECTIONS_ENABLED_KEY, (String)new Boolean(persistentConnectionsEnabled).toString());
    }

    public static void setDefaultPersistentConnectionTimeout(int persistentConnectionTimeout) throws IllegalArgumentException {
        ConnectionManager.checkPersistentConnectionTimeout(persistentConnectionTimeout);
        Defs.setSystemProperty((String)PERSISTENT_CONNECTION_TIMEOUT_KEY, (String)Integer.toString(persistentConnectionTimeout));
    }

    public static void setDefaultReadBufferSize(int readBufferSize) throws IllegalArgumentException {
        ConnectionManager.checkReadBufferSize(readBufferSize);
        Defs.setSystemProperty((String)READ_BUFFER_SIZE_KEY, (String)Integer.toString(readBufferSize));
    }

    public static void setDefaultSoTimeout(int soTimeout) throws IllegalArgumentException {
        ConnectionManager.checkSoTimeout(soTimeout);
        Defs.setSystemProperty((String)SO_TIMEOUT_KEY, (String)Integer.toString(0));
    }

    public void setMaxPersistentConnections(int maxPersistentConnections) throws IllegalArgumentException {
        ConnectionManager.checkMaxPersistentConnections(maxPersistentConnections);
        this.maxPersistentConnections = maxPersistentConnections;
    }

    public void setNagleEnabled(boolean nagleEnabled) {
        this.nagleEnabled = nagleEnabled;
    }

    public void setPersistentConnectionsEnabled(boolean persistentConnectionsEnabled) {
        this.persistentConnectionsEnabled = persistentConnectionsEnabled;
    }

    public void setPersistentConnectionTimeout(int persistentConnectionTimeout) throws IllegalArgumentException {
        ConnectionManager.checkPersistentConnectionTimeout(persistentConnectionTimeout);
        this.persistentConnectionTimeout = persistentConnectionTimeout;
    }

    public void setReadBufferSize(int readBufferSize) throws IllegalArgumentException {
        ConnectionManager.checkReadBufferSize(readBufferSize);
        this.readBufferSize = readBufferSize;
    }

    public void setSoTimeout(int soTimeout) throws IllegalArgumentException {
        ConnectionManager.checkSoTimeout(soTimeout);
        this.soTimeout = soTimeout;
    }

    public String toString() {
        return "ConnectionManagerSettings [maxPersistentConnections: " + this.maxPersistentConnections + ", " + "nagleEnabled: " + this.nagleEnabled + ", " + "persistentConnectionsEnabled: " + this.persistentConnectionsEnabled + ", " + "persistentConnectionTimeout: " + this.persistentConnectionTimeout + ", " + "readBufferSize: " + this.readBufferSize + ", " + "soTimeout: " + this.soTimeout + "]";
    }

    private void initialize() {
        this.maxPersistentConnections = ConnectionManagerSettings.getDefaultMaxPersistentConnections();
        this.nagleEnabled = ConnectionManagerSettings.isDefaultNagleEnabled();
        this.persistentConnectionsEnabled = ConnectionManagerSettings.areDefaultPersistentConnectionsEnabled();
        this.persistentConnectionTimeout = ConnectionManagerSettings.getDefaultPersistentConnectionTimeout();
        this.readBufferSize = ConnectionManagerSettings.getDefaultReadBufferSize();
        this.soTimeout = ConnectionManagerSettings.getDefaultSoTimeout();
    }
}

