/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.BasicConnection;
import ice.net.CacheManager;
import ice.net.CachedInputStream;
import ice.net.Connection;
import ice.net.ConnectionManagerSettings;
import ice.net.ConnectionRoute;
import ice.net.HttpRequest;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import ice.net.HttpURLConnectionEvent;
import ice.net.HttpURLConnectionListener;
import ice.net.PersistentConnection;
import ice.net.proxy.Proxy;
import ice.net.proxy.ProxyResolver;
import ice.util.Defs;
import ice.util.UnsupportedOperationException;
import ice.util.alg.Listeners;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConnectionManager {
    private static final int CLEAN_INTERVAL = 10000;
    private static final ConnectionManagerSettings FALLBACK_CONNECTION_MANAGER_SETTINGS = new ConnectionManagerSettings();
    private long cleanedTimestamp;
    private Hashtable connectionTable = new Hashtable();
    private int maxPersistentConnections;
    private boolean persistentConnectionsEnabled;
    private int persistentConnectionTimeout;
    private boolean nagleEnabled;
    private int soTimeout;
    private int readBufferSize;
    private Object httpUrlConnectionListenerSet;
    private HttpSession httpSession;

    public ConnectionManager() {
        this(new ConnectionManagerSettings());
    }

    public ConnectionManager(ConnectionManagerSettings connectionManagerSettings) {
        this.setMaxPersistentConnections(connectionManagerSettings.getMaxPersistentConnections());
        this.setNagleEnabled(connectionManagerSettings.isNagleEnabled());
        this.setPersistentConnectionsEnabled(connectionManagerSettings.arePersistentConnectionsEnabled());
        this.setPersistentConnectionTimeout(connectionManagerSettings.getPersistentConnectionTimeout());
        this.setReadBufferSize(connectionManagerSettings.getReadBufferSize());
        this.setSoTimeout(connectionManagerSettings.getSoTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpURLConnectionListener(HttpURLConnectionListener httpUrlConnectionListener) {
        if (httpUrlConnectionListener != null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.httpUrlConnectionListenerSet = Listeners.add((Object)this.httpUrlConnectionListenerSet, (Object)httpUrlConnectionListener);
            }
        }
    }

    public boolean arePersistentConnectionsEnabled() {
        if (this.httpSession == null) {
            return this.persistentConnectionsEnabled;
        }
        return this.httpSession.isPersistent;
    }

    public CachedInputStream createInputStream(HttpURLConnection httpUrlConnection, CacheManager cacheManager, Connection connection, byte[] buffer, int offset, int length) {
        int _contentLength;
        if (httpUrlConnection != null) {
            HttpResponse _httpResponse = httpUrlConnection.getResponse();
            if (_httpResponse != null && _httpResponse.containsHeader("Content-Length")) {
                try {
                    _contentLength = Integer.parseInt(_httpResponse.getFieldValues("Content-Length")[0]);
                }
                catch (NumberFormatException exception) {
                    _contentLength = -1;
                }
            } else {
                _contentLength = -1;
            }
        } else {
            _contentLength = -1;
        }
        return new CachedInputStream(httpUrlConnection, cacheManager, connection, buffer, offset, length, _contentLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getConnection(HttpURLConnection httpUrlConnection, URL url, InetAddress inetAddress, int port) throws IOException {
        int _port;
        HttpURLConnection _httpUrlConnection;
        block62: {
            PersistentConnection _persistentConnection;
            block57: {
                String _key;
                block63: {
                    String _key2;
                    Enumeration _keys;
                    Object _protocol;
                    block58: {
                        block61: {
                            ConnectionRoute _connectionRoute;
                            ProxyResolver _proxyResolver;
                            String _className;
                            block59: {
                                block60: {
                                    _httpUrlConnection = httpUrlConnection;
                                    _port = port;
                                    if (!(_httpUrlConnection instanceof HttpURLConnection)) break block58;
                                    _protocol = url.getProtocol();
                                    _className = _httpUrlConnection.getClass().getName();
                                    if (!((String)_protocol).equals("https") || _className.equals("ice.https.HttpsURLConnection")) break block59;
                                    _httpUrlConnection = this.openConnection(url);
                                    _proxyResolver = _httpUrlConnection.getInstanceProxyResolver();
                                    if (_proxyResolver == null) break block60;
                                    _connectionRoute = null;
                                    try {
                                        _connectionRoute = _proxyResolver.findProxyForUrl(_httpUrlConnection.getURL());
                                    }
                                    catch (Exception exception) {
                                        Debug.ex((Throwable)exception);
                                    }
                                    if (_connectionRoute != null && _connectionRoute instanceof Proxy) {
                                        _port = ((Proxy)_connectionRoute).getPort();
                                        break block58;
                                    } else if (_port == 80) {
                                        _port = 443;
                                    }
                                    break block58;
                                }
                                if (_port == 80) {
                                    _port = 443;
                                }
                                break block58;
                            }
                            if (!((String)_protocol).equals("http") || _className.equals("ice.net.HttpURLConnection")) break block58;
                            _httpUrlConnection = this.openConnection(url);
                            _proxyResolver = _httpUrlConnection.getInstanceProxyResolver();
                            if (_proxyResolver == null) break block61;
                            _connectionRoute = null;
                            try {
                                _connectionRoute = _proxyResolver.findProxyForUrl(_httpUrlConnection.getURL());
                            }
                            catch (Exception exception) {
                                Debug.ex((Throwable)exception);
                            }
                            if (_connectionRoute != null && _connectionRoute instanceof Proxy) {
                                _port = ((Proxy)_connectionRoute).getPort();
                                break block58;
                            } else if (_port == 443) {
                                _port = 80;
                            }
                            break block58;
                        }
                        if (_port == 443) {
                            _port = 80;
                        }
                    }
                    if (!(this.httpSession == null ? this.persistentConnectionsEnabled : this.httpSession.isPersistent)) break block62;
                    if (this.httpSession == null) {
                        if (System.currentTimeMillis() - this.cleanedTimestamp > 10000L) {
                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                Debug.trace((String)"Cleaning up persistent connections...");
                            }
                            _protocol = this.connectionTable;
                            synchronized (_protocol) {
                                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                    Debug.trace((String)"[Lock: required]");
                                }
                                this.cleanedTimestamp = System.currentTimeMillis();
                                _keys = this.connectionTable.keys();
                                int _size = this.connectionTable.size();
                                for (int i = 0; i < _size; ++i) {
                                    _key2 = (String)_keys.nextElement();
                                    Vector _persistentConnectionList = (Vector)this.connectionTable.get(_key2);
                                    this.checkTimeout(_persistentConnectionList);
                                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                        Debug.trace((String)("PersistentConnectionList [" + _key2 + "]: " + "size = " + _persistentConnectionList.size()));
                                    }
                                    if (_persistentConnectionList.size() != 0) continue;
                                    this.connectionTable.remove(_key2);
                                    if (!Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) continue;
                                    Debug.trace((String)("PersistentConnectionList [" + _key2 + "]: " + "removed!"));
                                }
                                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                    Debug.trace((String)"[Lock: released]");
                                }
                            }
                        }
                    } else if (System.currentTimeMillis() - this.httpSession.lastCleanedAt > (long)this.httpSession.CLEAN_INTERVAL) {
                        _protocol = this.httpSession.cleanLock;
                        synchronized (_protocol) {
                            this.httpSession.lastCleanedAt = System.currentTimeMillis();
                            _keys = this.httpSession.theConnections.keys();
                            int _size = this.httpSession.theConnections.size();
                            for (int i = 0; i < _size; ++i) {
                                _key2 = (String)_keys.nextElement();
                                Vector _persistentConnectionList = (Vector)this.httpSession.theConnections.get(_key2);
                                this.checkTimeout(_persistentConnectionList);
                                if (_persistentConnectionList.size() != 0) continue;
                                this.httpSession.theConnections.remove(_key2);
                            }
                        }
                    }
                    _persistentConnection = null;
                    _key = inetAddress.getHostAddress() + ":" + _port;
                    if (this.httpSession != null) break block63;
                    Hashtable hashtable = this.connectionTable;
                    synchronized (hashtable) {
                        block56: {
                            block64: {
                                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                    Debug.trace((String)"[Lock: required]");
                                }
                                if (!this.connectionTable.containsKey(_key)) break block64;
                                Vector _persistentConnectionList = (Vector)this.connectionTable.get(_key);
                                this.checkTimeout(_persistentConnectionList);
                                if (_persistentConnectionList.size() < this.maxPersistentConnections) {
                                    _persistentConnection = this.waitFor(_persistentConnectionList, false);
                                    if (_persistentConnection != null) {
                                        if (!_persistentConnection.reuseable || _persistentConnection.hasTimedOut()) {
                                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                                Debug.trace((String)("Timed out or not reusable persistent connection:\r\n" + _persistentConnection));
                                            }
                                            _persistentConnectionList.removeElement(_persistentConnection);
                                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                                Debug.trace((String)("Persistent connection removed:\r\n" + _persistentConnection));
                                            }
                                            _persistentConnection = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                            _persistentConnectionList.addElement(_persistentConnection);
                                            break block56;
                                        } else {
                                            _persistentConnection.reInit();
                                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                                Debug.trace((String)"[Lock: released]");
                                            }
                                            return _persistentConnection;
                                        }
                                    }
                                    _persistentConnection = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                    _persistentConnectionList.addElement(_persistentConnection);
                                    break block56;
                                } else {
                                    _persistentConnection = this.waitFor(_persistentConnectionList, true);
                                    if (_persistentConnection != null) {
                                        if (!_persistentConnection.reuseable || _persistentConnection.hasTimedOut()) {
                                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                                Debug.trace((String)("Timed out or not reusable persistent connection:\r\n" + _persistentConnection));
                                            }
                                            _persistentConnectionList.removeElement(_persistentConnection);
                                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                                Debug.trace((String)("Persistent connection removed:\r\n" + _persistentConnection));
                                            }
                                            _persistentConnection = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                            _persistentConnectionList.addElement(_persistentConnection);
                                            break block56;
                                        } else {
                                            _persistentConnection.reInit();
                                            if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                                                Debug.trace((String)"[Lock: released]");
                                            }
                                            return _persistentConnection;
                                        }
                                    }
                                    _persistentConnection = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                    _persistentConnectionList.addElement(_persistentConnection);
                                }
                                break block56;
                            }
                            Vector<PersistentConnection> _persistentConnectionList = new Vector<PersistentConnection>();
                            _persistentConnection = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                            _persistentConnectionList.addElement(_persistentConnection);
                            this.connectionTable.put(_key, _persistentConnectionList);
                        }
                        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                            Debug.trace((String)"[Lock: released]");
                        }
                        break block57;
                    }
                }
                Hashtable hashtable = this.httpSession.theConnections;
                synchronized (hashtable) {
                    block65: {
                        if (!this.httpSession.theConnections.containsKey(_key)) break block65;
                        Vector _persistentConnectionList = (Vector)this.httpSession.theConnections.get(_key);
                        this.checkTimeout(_persistentConnectionList);
                        if (_persistentConnectionList.size() < this.httpSession.maxInstances) {
                            _persistentConnection = this.waitFor(_persistentConnectionList, false);
                            if (_persistentConnection != null) {
                                if (_persistentConnection.reuseable && !_persistentConnection.hasTimedOut()) {
                                    _persistentConnection.reInit();
                                    return _persistentConnection;
                                }
                                _persistentConnectionList.removeElement(_persistentConnection);
                                _persistentConnection = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.httpSession);
                                _persistentConnectionList.addElement(_persistentConnection);
                                break block57;
                            } else {
                                _persistentConnection = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.httpSession);
                                _persistentConnectionList.addElement(_persistentConnection);
                            }
                            break block57;
                        } else {
                            _persistentConnection = this.waitFor(_persistentConnectionList, true);
                            if (_persistentConnection != null) {
                                if (_persistentConnection.reuseable && !_persistentConnection.hasTimedOut()) {
                                    _persistentConnection.reInit();
                                    return _persistentConnection;
                                }
                                _persistentConnectionList.removeElement(_persistentConnection);
                                _persistentConnection = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.httpSession);
                                _persistentConnectionList.addElement(_persistentConnection);
                                break block57;
                            } else {
                                _persistentConnection = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.httpSession);
                                _persistentConnectionList.addElement(_persistentConnection);
                            }
                        }
                        break block57;
                    }
                    Vector<PersistentConnection> _persistentConnectionList = new Vector<PersistentConnection>();
                    _persistentConnection = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.httpSession);
                    _persistentConnectionList.addElement(_persistentConnection);
                    this.httpSession.theConnections.put(_key, _persistentConnectionList);
                }
            }
            if (_persistentConnection.awaitingSocketCreation()) {
                _persistentConnection.setSocket(_httpUrlConnection.createSimpleSocket(inetAddress, _port));
                return _persistentConnection;
            }
            return null;
        }
        if (this.httpSession == null) {
            return new BasicConnection(_httpUrlConnection.createSimpleSocket(inetAddress, _port), HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
        }
        return new BasicConnection(HttpURLConnection.getGlobalCacheManager(), _httpUrlConnection.createSimpleSocket(inetAddress, _port), this.httpSession);
    }

    public int getMaxPersistentConnections() {
        if (this.httpSession == null) {
            return this.maxPersistentConnections;
        }
        return this.httpSession.maxInstances;
    }

    public int getPersistentConnectionTimeout() {
        if (this.httpSession == null) {
            return this.persistentConnectionTimeout;
        }
        return this.httpSession.TIMEOUTVALUE;
    }

    public int getReadBufferSize() {
        if (this.httpSession == null) {
            return this.readBufferSize;
        }
        return this.httpSession.READBUFFERSIZE;
    }

    public int getSoTimeout() {
        if (this.httpSession == null) {
            return this.soTimeout;
        }
        return this.httpSession.so_Timeout;
    }

    public boolean isNagleEnabled() {
        if (this.httpSession == null) {
            return this.nagleEnabled;
        }
        return this.httpSession.enableNagle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpURLConnectionListener(HttpURLConnectionListener httpUrlConnectionListener) {
        if (httpUrlConnectionListener != null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.httpUrlConnectionListenerSet = Listeners.remove((Object)this.httpUrlConnectionListenerSet, (Object)httpUrlConnectionListener);
            }
        }
    }

    public void setMaxPersistentConnections(int maxPersistentConnections) throws IllegalArgumentException {
        ConnectionManager.checkMaxPersistentConnections(maxPersistentConnections);
        if (this.httpSession == null) {
            this.maxPersistentConnections = maxPersistentConnections;
        } else {
            this.httpSession.maxInstances = maxPersistentConnections;
        }
    }

    public void setNagleEnabled(boolean nagleEnabled) {
        if (this.httpSession == null) {
            this.nagleEnabled = nagleEnabled;
        } else {
            this.httpSession.enableNagle = nagleEnabled;
        }
    }

    public void setPersistentConnectionsEnabled(boolean persistentConnectionsEnabled) {
        if (this.httpSession == null) {
            this.persistentConnectionsEnabled = persistentConnectionsEnabled;
        } else {
            this.httpSession.isPersistent = persistentConnectionsEnabled;
        }
    }

    public void setPersistentConnectionTimeout(int persistentConnectionTimeout) throws IllegalArgumentException {
        ConnectionManager.checkPersistentConnectionTimeout(persistentConnectionTimeout);
        if (this.httpSession == null) {
            this.persistentConnectionTimeout = persistentConnectionTimeout;
        } else {
            this.httpSession.TIMEOUTVALUE = persistentConnectionTimeout;
        }
    }

    public void setReadBufferSize(int readBufferSize) throws IllegalArgumentException {
        ConnectionManager.checkReadBufferSize(readBufferSize);
        if (this.httpSession == null) {
            this.readBufferSize = readBufferSize;
        } else {
            this.httpSession.READBUFFERSIZE = readBufferSize;
        }
    }

    public void setSoTimeout(int soTimeout) throws IllegalArgumentException {
        ConnectionManager.checkSoTimeout(soTimeout);
        if (this.httpSession == null) {
            this.soTimeout = soTimeout;
        } else {
            this.httpSession.so_Timeout = soTimeout;
        }
    }

    protected Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        Socket _socket = new Socket(inetAddress, port);
        if (this.httpSession == null) {
            _socket.setSoTimeout(this.soTimeout);
            _socket.setTcpNoDelay(this.nagleEnabled);
        } else {
            _socket.setSoTimeout(this.httpSession.so_Timeout);
            _socket.setTcpNoDelay(this.httpSession.enableNagle);
        }
        return _socket;
    }

    protected void fireHttpURLConnectionEvent(HttpURLConnection httpUrlConnection, int eventType, HttpRequest httpRequest) throws IllegalArgumentException {
        this.fireHttpURLConnectionEvent(httpUrlConnection, eventType, httpRequest, null);
    }

    protected void fireHttpURLConnectionEvent(HttpURLConnection httpUrlConnection, int eventType, HttpRequest httpRequest, HttpResponse httpResponse) throws IllegalArgumentException {
        if (this.httpUrlConnectionListenerSet != null) {
            HttpURLConnectionEvent _event = new HttpURLConnectionEvent(httpUrlConnection, eventType, httpRequest, httpResponse);
            if (!(this.httpUrlConnectionListenerSet instanceof Object[])) {
                ((HttpURLConnectionListener)this.httpUrlConnectionListenerSet).onHttpURLConnectionEvent(_event);
            } else {
                for (int i = 0; i < ((Object[])this.httpUrlConnectionListenerSet).length; ++i) {
                    ((HttpURLConnectionListener)((Object[])this.httpUrlConnectionListenerSet)[i]).onHttpURLConnectionEvent(_event);
                }
            }
            if (_event.isConsumed()) {
                if (eventType == 1) {
                    httpUrlConnection.requestCancelled = true;
                } else if (eventType == 3) {
                    httpUrlConnection.responseCancelled = true;
                }
            }
        }
    }

    protected InetAddress getByName(String host) throws SecurityException, UnknownHostException {
        return this.getByName(host, true);
    }

    protected InetAddress getByName(String host, boolean useIp) throws SecurityException, UnknownHostException {
        if (useIp) {
            return InetAddress.getByName(host);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException exception) {
            Debug.trace((String)"no ip for localhost found. try loopback interface.");
            return InetAddress.getByName(null);
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    static void checkMaxPersistentConnections(int maxPersistentConnections) throws IllegalArgumentException {
        if (maxPersistentConnections < -1) {
            throw new IllegalArgumentException("maxPersistentConnections < -1");
        }
    }

    static void checkPersistentConnectionTimeout(int persistentConnectionTimeout) throws IllegalArgumentException {
        if (persistentConnectionTimeout < 0) {
            throw new IllegalArgumentException("persistentConnectionTimeout < 0");
        }
    }

    static void checkReadBufferSize(int readBufferSize) throws IllegalArgumentException {
        if (readBufferSize < 1) {
            throw new IllegalArgumentException("readBufferSize < 1");
        }
    }

    static void checkSoTimeout(int soTimeout) throws IllegalArgumentException {
        if (soTimeout < 0) {
            throw new IllegalArgumentException("soTimeout < 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkTimeout(Vector persistentConnectionList) {
        int _persistentConnectionsKilled = 0;
        Vector vector = persistentConnectionList;
        synchronized (vector) {
            for (int i = 0; i < persistentConnectionList.size(); ++i) {
                PersistentConnection _persistentConnection = (PersistentConnection)persistentConnectionList.elementAt(i);
                if (!_persistentConnection.hasTimedOut()) continue;
                persistentConnectionList.removeElementAt(i);
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                    Debug.trace((String)("Persistent connection removed:\r\n" + _persistentConnection));
                }
                ++_persistentConnectionsKilled;
                --i;
            }
        }
        return _persistentConnectionsKilled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentConnection waitFor(Vector persistentConnectionList, boolean blocking) {
        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
            Debug.trace((String)("Waiting for persistent connection [blocked: " + blocking + "]..."));
        }
        while (true) {
            Vector vector = persistentConnectionList;
            synchronized (vector) {
                int _size = persistentConnectionList.size();
                if (_size == 0) {
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)"No persistent connections.");
                    }
                    return null;
                }
                for (int i = 0; i < _size; ++i) {
                    PersistentConnection _persistentConnection = (PersistentConnection)persistentConnectionList.elementAt(i);
                    if (!_persistentConnection.isActive()) {
                        if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                            Debug.trace((String)("Inactive persistent connection:\r\n" + _persistentConnection));
                        }
                        return _persistentConnection;
                    }
                    if (!_persistentConnection.hasTimedOut()) continue;
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Timed out persistent connection:\r\n" + _persistentConnection));
                    }
                    persistentConnectionList.removeElement(_persistentConnection);
                    if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                        Debug.trace((String)("Persistent connection removed:\r\n" + _persistentConnection));
                    }
                    return null;
                }
            }
            if (!blocking) {
                return null;
            }
            try {
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.connections", (boolean)false)) {
                    Debug.trace((String)"Sleeping for 200 ms....");
                }
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public ConnectionManager(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public CachedInputStream createInputStream(java.net.HttpURLConnection httpUrlConnection, CacheManager cacheManager, Connection connection, byte[] buffer, int offset, int length) {
        return new CachedInputStream(httpUrlConnection, cacheManager, connection, buffer, offset, length);
    }

    public boolean getPersistent() {
        return this.arePersistentConnectionsEnabled();
    }

    public static void setLimits(boolean limits) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setPersistent(boolean persistent) {
        this.setPersistentConnectionsEnabled(persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allocateInstance() {
        int _maxPersistentConnections = FALLBACK_CONNECTION_MANAGER_SETTINGS.getMaxPersistentConnections();
        if (_maxPersistentConnections >= 0) {
            Object object = ConnectionManager.FALLBACK_CONNECTION_MANAGER_SETTINGS.instancesLock;
            synchronized (object) {
                ++ConnectionManager.FALLBACK_CONNECTION_MANAGER_SETTINGS.instancesInUse;
                while (ConnectionManager.FALLBACK_CONNECTION_MANAGER_SETTINGS.instancesInUse > _maxPersistentConnections) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static void freeInstance() {
        if (FALLBACK_CONNECTION_MANAGER_SETTINGS.getMaxPersistentConnections() >= 0) {
            --ConnectionManager.FALLBACK_CONNECTION_MANAGER_SETTINGS.instancesInUse;
        }
    }
}

