/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.zip;

import coldfusion.util.ExtensionFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import net.lingala.zip4j.model.FileHeader;

public class ZipFilter
implements FileFilter {
    private List filterList;
    private String pathFilter;
    private boolean recurse;

    public ZipFilter(Object filter, String path, boolean recurse) {
        if (filter != null) {
            this.filterList = new ArrayList();
            if (filter instanceof String) {
                String[] filters = ((String)filter).trim().split(",");
                for (int i = 0; i < filters.length; ++i) {
                    this.filterList.add(new ExtensionFilter(filters[i].trim()));
                }
            } else if (filter instanceof List) {
                for (int i = 0; i < ((List)filter).size(); ++i) {
                    this.filterList.add(new ExtensionFilter(((String)((List)filter).get(i)).trim()));
                }
            }
        }
        if (path != null) {
            this.pathFilter = path.replace('\\', '/').toLowerCase();
        }
        this.recurse = recurse;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return this.recurse;
        }
        if (this.filterList == null) {
            return true;
        }
        for (int i = 0; i < this.filterList.size(); ++i) {
            ExtensionFilter extFilter = (ExtensionFilter)this.filterList.get(i);
            if (!extFilter.accept(pathname)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPathFilter(FileHeader zipEntry) {
        if (this.pathFilter == null || this.pathFilter.length() == 0) {
            return true;
        }
        if (zipEntry.getFileName().equalsIgnoreCase(this.pathFilter)) {
            return true;
        }
        String entryName = zipEntry.getFileName().toLowerCase();
        if (entryName.startsWith(this.pathFilter + "/")) {
            String remainingName = entryName.substring(this.pathFilter.length() + 1);
            if (remainingName.indexOf(47) != -1) {
                return this.recurse;
            }
            return true;
        }
        return false;
    }

    public boolean accept(FileHeader zipEntry) {
        if (!this.matchesPathFilter(zipEntry)) {
            return false;
        }
        if (this.pathFilter == null || this.pathFilter.length() == 0) {
            int index = zipEntry.getFileName().indexOf(47);
            if (!this.recurse && index != -1 && index != zipEntry.getFileName().length() - 1) {
                return false;
            }
        }
        if (this.filterList == null) {
            return true;
        }
        String name = this.getFileName(zipEntry);
        for (int i = 0; i < this.filterList.size(); ++i) {
            ExtensionFilter extFilter = (ExtensionFilter)this.filterList.get(i);
            if (!extFilter.accept(name)) continue;
            return true;
        }
        return false;
    }

    private String getFileName(FileHeader zipEntry) {
        String name = zipEntry.getFileName();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private boolean matchesPathFilter(ZipEntry zipEntry) {
        if (this.pathFilter == null || this.pathFilter.length() == 0) {
            return true;
        }
        if (zipEntry.getName().equalsIgnoreCase(this.pathFilter)) {
            return true;
        }
        String entryName = zipEntry.getName().toLowerCase();
        if (entryName.startsWith(this.pathFilter + "/")) {
            String remainingName = entryName.substring(this.pathFilter.length() + 1);
            if (remainingName.indexOf(47) != -1) {
                return this.recurse;
            }
            return true;
        }
        return false;
    }

    public boolean accept(ZipEntry zipEntry) {
        if (!this.matchesPathFilter(zipEntry)) {
            return false;
        }
        if (this.pathFilter == null || this.pathFilter.length() == 0) {
            int index = zipEntry.getName().indexOf(47);
            if (!this.recurse && index != -1 && index != zipEntry.getName().length() - 1) {
                return false;
            }
        }
        if (this.filterList == null) {
            return true;
        }
        String name = this.getFileName(zipEntry);
        for (int i = 0; i < this.filterList.size(); ++i) {
            ExtensionFilter extFilter = (ExtensionFilter)this.filterList.get(i);
            if (!extFilter.accept(name)) continue;
            return true;
        }
        return false;
    }

    private String getFileName(ZipEntry zipEntry) {
        String name = zipEntry.getName();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }
}

