/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class UtilTransliteratorWithFixup
extends UtilTransliterator {
    private String encoding;
    private CharToByteConverter c2b;
    private ByteToCharConverter b2c;
    private int maxBytesPerChar;
    private int maxCharsPerByte;
    private char[][] fixupMapPut;
    private char[][] fixupMapGet;
    private static final char[][] MS932_eucJP_Map = new char[][]{{'\u2225', '\u2016'}, {'\uff5e', '\u301c'}, {'\uff0d', '\u2212'}, {'\u2015', '\u2014'}};
    private static final char[][] eucJP_MS932_Map = new char[][]{{'\u00ac', '\uffe2'}, {'\u2016', '\u2225'}, {'\u301c', '\uff5e'}, {'\u2212', '\uff0d'}, {'\u00a2', '\uffe0'}, {'\u00a3', '\uffe1'}, {'\u2014', '\u2015'}};
    private Reader _rdr;

    private void fixup(char[] cArray, int n2, char[][] cArray2) {
        int n3 = cArray2.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                if (c2 != cArray2[i3][0]) continue;
                cArray[i2] = cArray2[i3][1];
                continue block0;
            }
        }
    }

    public UtilTransliteratorWithFixup(String string, int n2, int n3) throws UtilException {
        try {
            this.encoding = string;
            this.c2b = CharToByteConverter.getConverter((String)string);
            this.b2c = ByteToCharConverter.getConverter((String)string);
            this.maxBytesPerChar = this.c2b.getMaxBytesPerChar();
            this.maxCharsPerByte = this.b2c.getMaxCharsPerByte();
            this.setDefaultCacheSize();
            block1 : switch (n3) {
                case 1: {
                    switch (n2) {
                        case 2: {
                            this.fixupMapPut = eucJP_MS932_Map;
                            this.fixupMapGet = MS932_eucJP_Map;
                            break block1;
                        }
                    }
                    this.fixupMapGet = new char[0][0];
                    this.fixupMapPut = this.fixupMapGet;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 1: {
                            this.fixupMapPut = MS932_eucJP_Map;
                            this.fixupMapGet = eucJP_MS932_Map;
                            break block1;
                        }
                    }
                    this.fixupMapGet = new char[0][0];
                    this.fixupMapPut = this.fixupMapGet;
                    break;
                }
                default: {
                    this.fixupMapGet = new char[0][0];
                    this.fixupMapPut = this.fixupMapGet;
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
    }

    public boolean isFixedBytesPerChar() {
        return this.c2b.getMaxBytesPerChar() == 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public int getMaxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public byte[] encode(String string) throws UtilException {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        this.fixup(cArray, n2, this.fixupMapPut);
        try {
            return this.c2b.convertAll(cArray);
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        int n3 = n2 * this.maxBytesPerChar;
        this.setCacheSize(n2);
        try {
            this.c2b.reset();
            this.c2b.setSubstitutionMode(true);
            string.getChars(0, n2, this.charsCache, 0);
            this.fixup(this.charsCache, n2, this.fixupMapPut);
            int n4 = this.c2b.convert(this.charsCache, 0, n2, this.bytesCache, 0, n3);
            nArray[0] = n4 += this.c2b.flush(this.bytesCache, this.c2b.nextByteIndex(), n3);
            return this.bytesCache;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.charsCache[i2] = (char)(this.bytesCache[i2] & 0xFF);
                }
                this.fixup(this.charsCache, n4, this.fixupMapPut);
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                this.fixup(this.charsCache, n4, this.fixupMapPut);
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        int n4 = n3 * this.maxCharsPerByte;
        this.setCacheSize(n4);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n5 = this.b2c.convert(byArray, n2, n2 + n3, this.charsCache, 0, n4);
            n5 += this.b2c.flush(this.charsCache, n5, n4);
            this.fixup(this.charsCache, n5, this.fixupMapGet);
            return new String(this.charsCache, 0, n5);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n4 = this.b2c.convert(byArray, n2, n2 + n3, cArray, 0, cArray.length);
            n4 += this.b2c.flush(cArray, n4, cArray.length);
            this.fixup(this.charsCache, n4, this.fixupMapGet);
            return n4;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        int n5 = n3 * this.maxCharsPerByte;
        int n6 = Math.max(n5, n4);
        this.setCacheSize(n6);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n7 = this.b2c.convert(byArray, n2, n2 + n3, this.charsCache, 0, n5);
            n7 += this.b2c.flush(this.charsCache, n7, n5);
            this.fixup(this.charsCache, n7, this.fixupMapGet);
            for (int i2 = n7; i2 < n4; ++i2) {
                this.charsCache[i2] = 32;
            }
            return new String(this.charsCache, 0, n4);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            this._rdr = new InputStreamReader(inputStream, this.encoding);
            return new Reader(){
                private Reader rdr;
                private int length;
                private char[] cache;
                {
                    this.rdr = UtilTransliteratorWithFixup.this._rdr;
                }

                public int read() throws IOException {
                    int n2 = this.rdr.read();
                    if (n2 == -1) {
                        return -1;
                    }
                    if (this.cache == null || this.cache.length < 1) {
                        this.cache = new char[1];
                    }
                    this.cache[0] = (char)n2;
                    UtilTransliteratorWithFixup.this.fixup(this.cache, 1, UtilTransliteratorWithFixup.this.fixupMapGet);
                    return this.cache[0];
                }

                public int read(char[] cArray, int n2, int n3) throws IOException {
                    int n4;
                    if (this.cache == null || this.cache.length < n3) {
                        this.cache = new char[n3];
                    }
                    if ((n4 = this.rdr.read(this.cache, 0, n3)) <= 0) {
                        return n4;
                    }
                    UtilTransliteratorWithFixup.this.fixup(this.cache, n4, UtilTransliteratorWithFixup.this.fixupMapGet);
                    System.arraycopy(this.cache, 0, cArray, n2, n4);
                    return n4;
                }

                public void close() throws IOException {
                    this.rdr.close();
                }
            };
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

