/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.tools;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LogInputOutputStream
extends InputStream
implements DataOutput,
DataInput {
    DataOutputStream log;
    DataOutputStream dos;
    DataInputStream dis;
    boolean writing = false;
    int logPos = 0;
    String[] H = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public LogInputOutputStream(String string, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        this.dis = dataInputStream;
        this.dos = dataOutputStream;
        try {
            this.log = new DataOutputStream(new FileOutputStream(string));
            this.log.writeBytes("SLX Client Log");
            this.writeNewLine();
            this.writeNewLine();
            this.log.flush();
        }
        catch (IOException iOException) {
            System.out.println("Error opening log file");
        }
    }

    public int available() throws IOException {
        return this.dis.available();
    }

    public void close() throws IOException {
        this.dos.close();
        this.dis.close();
    }

    public void mark(int n2) {
        throw new Error("Log does not implement this method");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int read(byte[] byArray) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void reset() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public long skip(long l2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkWriting();
        this.logBuffer(byArray, n2, n3);
        this.dos.write(byArray, n2, n3);
    }

    public byte readByte() throws IOException {
        this.checkReading();
        byte by2 = this.dis.readByte();
        byte[] byArray = new byte[]{by2};
        this.logBuffer(byArray, 0, 1);
        return by2;
    }

    public int readInt() throws IOException {
        this.checkReading();
        int n2 = this.dis.readInt();
        byte[] byArray = new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        this.logBuffer(byArray, 0, 4);
        return n2;
    }

    public long readLong() throws IOException {
        this.checkReading();
        long l2 = this.dis.readLong();
        byte[] byArray = new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48 & 0xFFL), (byte)(l2 >>> 40 & 0xFFL), (byte)(l2 >>> 32 & 0xFFL), (byte)(l2 >>> 24 & 0xFFL), (byte)(l2 >>> 16 & 0xFFL), (byte)(l2 >>> 8 & 0xFFL), (byte)(l2 & 0xFFL)};
        this.logBuffer(byArray, 0, 8);
        return l2;
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.checkReading();
        this.dis.readFully(byArray, n2, n3);
        this.logBuffer(byArray, n2, n3);
    }

    private void checkWriting() {
        if (!this.writing) {
            this.writing = true;
            this.logPos = 0;
            if (this.log == null) {
                return;
            }
            try {
                this.writeNewLine();
                this.writeNewLine();
                this.log.writeBytes("*** Write ***");
                this.writeNewLine();
                this.log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkReading() {
        if (this.writing) {
            this.writing = false;
            this.logPos = 0;
            if (this.log == null) {
                return;
            }
            try {
                this.writeNewLine();
                this.writeNewLine();
                this.log.writeBytes("*** Read ***");
                this.writeNewLine();
                this.log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void logBuffer(byte[] byArray, int n2, int n3) {
        try {
            this.writeBuffer(byArray, n2, n3);
            this.log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNewLine() throws IOException {
        this.log.writeBytes(System.getProperty("line.separator"));
        this.log.flush();
    }

    private void writeBuffer(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            this.writeByte(byArray[n2 + n4]);
            ++n4;
            ++this.logPos;
            if (this.logPos % 4 == 0) {
                this.log.writeBytes(" ");
            }
            if (this.logPos % 16 != 0) continue;
            this.writeNewLine();
        }
    }

    private void writeByte(byte by2) throws IOException {
        this.writeTuple(by2 >>> 4);
        this.writeTuple(by2);
    }

    private void writeTuple(int n2) throws IOException {
        int n3 = n2 & 0xF;
        this.log.writeBytes(this.H[n3]);
    }

    public void write(int n2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void write(byte[] byArray) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeBoolean(boolean bl2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeByte(int n2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeShort(int n2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeChar(int n2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeInt(int n2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeLong(long l2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeFloat(float f2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeDouble(double d2) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeBytes(String string) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeChars(String string) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void writeUTF(String string) throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public void readFully(byte[] byArray) throws IOException {
        this.checkReading();
        this.dis.readFully(byArray);
        this.logBuffer(byArray, 0, byArray.length);
    }

    public int skipBytes(int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.readByte();
        }
        this.writeNewLine();
        this.log.writeBytes("*** last " + n2 + " bytes skipped ***");
        this.writeNewLine();
        return n2;
    }

    public boolean readBoolean() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int readUnsignedByte() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public short readShort() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public int readUnsignedShort() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public char readChar() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public float readFloat() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public double readDouble() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public String readLine() throws IOException {
        throw new IOException("Log does not implement this method");
    }

    public String readUTF() throws IOException {
        throw new IOException("Log does not implement this method");
    }
}

