/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicePurpose;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.constraints.ConstraintUtils;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DHParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ElGamalParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ElGamalKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

