/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerExceptions;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFDebuggerUtils;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.LineLocationComparator;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BreakPointManager {
    CFJVMDebugManager debugManager = null;
    private HashMap breakpoints = new HashMap();
    public static final String DUMMY_DEBUG_HANDLER = "coldfusion.debug.DummyDeubgRequestHandler";
    private HashMap currCFClasses = new HashMap();
    private BreakpointRequest dummyBPRequest = null;
    private static final int DUMMY_BP_LINE_NUMBER = 30;
    private static LineLocationComparator locationComparator = new LineLocationComparator();
    private ExceptionRequest exceptionBPRequest = null;

    public BreakPointManager(CFJVMDebugManager mgr) {
        this.debugManager = mgr;
        try {
            if (this.debugManager.isBreakOnException()) {
                this.setBreakpointOnException();
            }
        }
        catch (Throwable t) {
            CFDebuggerLogger.log(t);
        }
    }

    public int setBreakPoint(String sessionId, String cfmlPath, int lineNum) throws Throwable {
        ClientDebugSession session = this.debugManager.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        if (session.isRemoteSession()) {
            cfmlPath = this.getCanonicalPathOfTemplate(cfmlPath);
        }
        if (session.isBreakpointSet(cfmlPath, lineNum)) {
            return 1;
        }
        String bpOwningSession = this.getClientSessionForBreakpoint(cfmlPath, lineNum, session.getSessionId());
        if (bpOwningSession != null) {
            CFDebuggerExceptions.throwBreakpointSetByAnotherSessionException(cfmlPath, lineNum);
        }
        int ret = 0;
        try {
            ret = this.setBreakPoint(cfmlPath, lineNum, true);
        }
        catch (Throwable e) {
            CFDebuggerExceptions.UnresolvedBreakpointLocationException bpe = CFDebuggerExceptions.createUnresolvedBreakpointLocationException(cfmlPath, lineNum, -1);
            session.createExceptionEvent(bpe);
            session.addPendingBreakpoint(cfmlPath, lineNum);
            String className = CFDebuggerUtils.getClassName(new File(cfmlPath));
            this.saveBreakpointInfo(className, cfmlPath, lineNum);
            ret = 0;
        }
        if (ret == 1) {
            session.addBreakpoint(cfmlPath, lineNum);
            session.sendBreakpointSetEvent(cfmlPath, lineNum, -1);
        } else if (ret == -1) {
            session.addPendingBreakpoint(cfmlPath, lineNum);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBreakpointInfo(String classFileName, String cfmlPath, int lineNum) {
        Object info = this.breakpoints.get(classFileName);
        if (info == null) {
            Object[] infoArray = new Object[]{cfmlPath, new ArrayList()};
            info = infoArray;
            this.breakpoints.put(classFileName, info);
        }
        Object[] bpInfo = (Object[])info;
        ArrayList lineNums = (ArrayList)bpInfo[1];
        Integer lineNumObj = new Integer(lineNum);
        ArrayList arrayList = lineNums;
        synchronized (arrayList) {
            if (lineNums.indexOf(lineNumObj) == -1) {
                lineNums.add(lineNumObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreakpointsOnClassPrepare(String className, ClassType cfmClass) {
        Object[] bpInfo;
        int index = -1;
        String mainClassName = className;
        boolean isSubClass = false;
        index = className.indexOf(36);
        if (index != -1) {
            mainClassName = className.substring(0, index);
            isSubClass = true;
        }
        if ((bpInfo = this.getBreakpointsInfo(mainClassName)) == null) {
            return;
        }
        this.currCFClasses.put(className, cfmClass);
        String cfmlPath = null;
        int lineNum = -1;
        ClientDebugSession session = null;
        cfmlPath = bpInfo[0].toString();
        ArrayList lineNums = (ArrayList)bpInfo[1];
        ArrayList<Integer> bpsToBeRemoved = new ArrayList<Integer>();
        Object object = bpInfo[1];
        synchronized (object) {
            Iterator it = lineNums.iterator();
            while (it.hasNext()) {
                try {
                    Integer intLineNum = (Integer)it.next();
                    lineNum = intLineNum;
                    session = this.debugManager.getClientSession(cfmlPath, lineNum, null, true);
                    if (session == null) {
                        bpsToBeRemoved.add(intLineNum);
                        continue;
                    }
                    int ret = this.setJavaBreakPoint(mainClassName, cfmlPath, lineNum, true, isSubClass);
                    CFDebuggerLogger.log("Set BP at - " + cfmlPath + ":" + lineNum + ", returnValue = " + ret);
                    if (ret != 1) continue;
                    session.addBreakpoint(cfmlPath, lineNum);
                    session.onBPSuccessfullySet(cfmlPath, lineNum);
                    session.sendBreakpointSetEvent(cfmlPath, lineNum, -1);
                }
                catch (Throwable e1) {
                    if (session == null) continue;
                    session.markFailedBP(cfmlPath, lineNum);
                    CFDebuggerLogger.log("Set BP Failed at - " + cfmlPath + ":" + lineNum + ", Reason = " + e1.getMessage());
                }
            }
            it = bpsToBeRemoved.iterator();
            while (it.hasNext()) {
                lineNums.remove(it.next());
            }
            bpsToBeRemoved.removeAll(bpsToBeRemoved);
        }
    }

    private Object[] getBreakpointsInfo(String className) {
        Object info = this.breakpoints.get(className);
        if (info == null) {
            return null;
        }
        return (Object[])info;
    }

    private String getClientSessionForBreakpoint(String cfmlPath, int lineNum, String excludeSession) {
        ClientDebugSession session = this.debugManager.getClientSession(cfmlPath, lineNum, excludeSession, true);
        return session == null ? null : session.getSessionId();
    }

    private int setBreakPoint(String cfmlPath, int lineNum, boolean addToPendingList) throws Throwable {
        int ret;
        String className = CFDebuggerUtils.getClassName(new File(cfmlPath));
        if (className == null) {
            CFDebuggerExceptions.throwCFMLTemplateNotFound(cfmlPath);
        }
        if ((ret = this.setJavaBreakPoint(className, cfmlPath, lineNum, addToPendingList, true)) == -1) {
            return ret;
        }
        return ret;
    }

    public boolean setDummpyRequestEndBP() throws Throwable {
        if (this.dummyBPRequest != null) {
            return true;
        }
        try {
            List<ReferenceType> classes = this.debugManager.getVm().classesByName(DUMMY_DEBUG_HANDLER);
            if (classes == null || classes.size() == 0) {
                return false;
            }
            ClassType theClass = null;
            theClass = (ClassType)classes.get(0);
            List<Location> lineLocations = null;
            try {
                lineLocations = theClass.allLineLocations();
            }
            catch (AbsentInformationException e) {
                CFDebuggerExceptions.throwBreakPointSetFailedException(DUMMY_DEBUG_HANDLER, 1);
            }
            for (Location loc : lineLocations) {
                if (loc.lineNumber() < 30) continue;
                this.dummyBPRequest = this.debugManager.getVm().eventRequestManager().createBreakpointRequest(loc);
                this.dummyBPRequest.setSuspendPolicy(0);
                if (this.dummyBPRequest == null) {
                    CFDebuggerExceptions.throwBreakPointSetFailedException(DUMMY_DEBUG_HANDLER, 1);
                }
                this.dummyBPRequest.enable();
                break;
            }
        }
        catch (Throwable e) {
            CFDebuggerExceptions.throwBreakPointSetFailedException(DUMMY_DEBUG_HANDLER, 1);
        }
        return true;
    }

    int setJavaBreakPoint(String className, String cfmlPath, int lineNum, boolean addToPendingList, boolean checkBPExists) throws Throwable {
        List<ReferenceType> classes = this.debugManager.getVm().classesByName(className);
        if (classes == null || classes.size() == 0) {
            this.saveBreakpointInfo(className, cfmlPath, lineNum);
            return -1;
        }
        ClassType theClass = null;
        if (classes.size() == 1) {
            theClass = (ClassType)classes.get(0);
            this.currCFClasses.put(className, theClass);
        } else {
            Object obj = this.currCFClasses.get(className);
            if (obj != null) {
                theClass = (ClassType)obj;
            }
        }
        if (theClass != null) {
            this.setJavaBreakPoint(theClass, cfmlPath, lineNum, addToPendingList, checkBPExists);
        } else {
            Throwable bpSetException = null;
            ArrayList<ReferenceType> classesArrayList = new ArrayList<ReferenceType>(classes);
            for (int i = classesArrayList.size() - 1; i >= 0; --i) {
                ClassType currClass = (ClassType)classesArrayList.get(i);
                try {
                    this.setJavaBreakPoint(currClass, cfmlPath, lineNum, addToPendingList, checkBPExists);
                    continue;
                }
                catch (Throwable th) {
                    if (bpSetException != null) continue;
                    bpSetException = th;
                }
            }
            if (bpSetException != null) {
                throw bpSetException;
            }
        }
        this.saveBreakpointInfo(className, cfmlPath, lineNum);
        return 1;
    }

    private boolean isJavaBreakpointSet(String cfmlPath, ClassType classType, int lineNum) {
        try {
            List<BreakpointRequest> bps = this.debugManager.getVm().eventRequestManager().breakpointRequests();
            Iterator<BreakpointRequest> it = bps.iterator();
            while (it.hasNext()) {
                Location loc = it.next().location();
                if (!loc.sourcePath().equals(cfmlPath) || loc.lineNumber() != lineNum) continue;
                if (classType != null) {
                    ClassType declaringType = (ClassType)loc.declaringType();
                    if (!declaringType.equals(classType)) continue;
                    return true;
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean isCFInterface(ClassType classType) throws Throwable {
        ClassType parentType = classType.superclass();
        if (parentType == null) {
            return false;
        }
        if (parentType.name().equals("coldfusion.runtime.CFInterface")) {
            return true;
        }
        return this.isCFInterface(parentType);
    }

    private void printLineLocations(String cfmlPath, List lineLocations) throws Throwable {
        CFDebuggerLogger.log("Printing line locations of " + cfmlPath + " ....");
        for (Location loc : lineLocations) {
            CFDebuggerLogger.log(loc.sourceName() + ":" + loc.lineNumber());
        }
    }

    private boolean setJavaBreakPoint(ClassType classType, String cfmlPath, int lineNum, boolean addToPendingList, boolean checkBPExists) throws Throwable {
        if (checkBPExists && this.isJavaBreakpointSet(cfmlPath, classType, lineNum)) {
            return true;
        }
        if (this.isCFInterface(classType)) {
            CFDebuggerExceptions.throwBreakpointInInterfaceException(cfmlPath, lineNum);
        }
        List<Location> lineLocations = null;
        try {
            lineLocations = classType.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        ArrayList<BreakpointRequest> bprs = new ArrayList<BreakpointRequest>();
        if (lineLocations != null) {
            Object[] locs = lineLocations.toArray();
            Arrays.sort(locs, locationComparator);
            for (int i = 0; i < locs.length; ++i) {
                Location loc = (Location)locs[i];
                if (loc.lineNumber() != lineNum) continue;
                BreakpointRequest bpr = this.debugManager.getVm().eventRequestManager().createBreakpointRequest(loc);
                bpr.setSuspendPolicy(1);
                if (bpr == null) {
                    CFDebuggerExceptions.throwBreakPointSetFailedException(cfmlPath, lineNum);
                }
                bpr.enable();
                bprs.add(bpr);
                break;
            }
        }
        if (bprs.size() > 0) {
            return true;
        }
        List<ReferenceType> nestedTypes = classType.nestedTypes();
        boolean bpSet = false;
        Iterator<ReferenceType> it1 = nestedTypes.iterator();
        while (it1.hasNext()) {
            String nestedClassName = it1.next().name();
            int ret = 0;
            try {
                ret = this.setJavaBreakPoint(nestedClassName, cfmlPath, lineNum, false, checkBPExists);
            }
            catch (CFDebuggerExceptions.InvalidBreakpointLocationException e) {
                ret = 0;
            }
            if (ret != true) continue;
            bpSet = true;
            break;
        }
        if (!bpSet) {
            CFDebuggerExceptions.throwInvalidBreakpointLocationException(cfmlPath, lineNum, -1);
        }
        return bpSet;
    }

    public void removeBreakpoint(String sessionId, String cfmlPath, int lineNum) throws Throwable {
        ClientDebugSession session = this.debugManager.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        if (session.isRemoteSession()) {
            cfmlPath = this.getCanonicalPathOfTemplate(cfmlPath);
        }
        session.removeBreakpoint(cfmlPath, lineNum, this.debugManager.getVm());
    }

    public void removeallBreakpoints(String sessionId) throws Throwable {
        ClientDebugSession session = this.debugManager.getDebugSession(sessionId);
        if (session == null) {
            CFDebuggerExceptions.throwDebugSessionNotFound(sessionId);
        }
        session.removeAllBreakpoints(this.debugManager.getVm());
    }

    private String getCanonicalPathOfTemplate(String path) {
        try {
            path = path.replace('\\', '/');
            File cfmlFile = new File(path);
            return cfmlFile.getCanonicalPath();
        }
        catch (Throwable t) {
            return path;
        }
    }

    public void setBreakpointOnException() throws Throwable {
        List<ReferenceType> classList = this.debugManager.getVm().classesByName("coldfusion.debug.DebuggerExceptionWrapper");
        if (classList.size() == 0) {
            return;
        }
        if (this.exceptionBPRequest == null) {
            this.exceptionBPRequest = this.debugManager.getVm().eventRequestManager().createExceptionRequest(classList.get(0), true, false);
            this.exceptionBPRequest.setSuspendPolicy(1);
        }
        this.exceptionBPRequest.setEnabled(true);
    }

    public void removeBreakpointOnException() throws Throwable {
        if (this.exceptionBPRequest != null) {
            this.exceptionBPRequest.setEnabled(false);
        }
    }
}

