/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml.idp;

import coldfusion.log.CFLogs;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.SAMLServiceImpl;
import coldfusion.saml.idp.AbstractMetadataProvider;
import coldfusion.saml.idp.MetadataProvider;
import coldfusion.util.RB;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpMetadataProvider
extends AbstractMetadataProvider
implements MetadataProvider {
    public HttpMetadataProvider(IdpConfiguration idpConfiguration) {
        super(idpConfiguration);
    }

    @Override
    public Saml2Settings provide() {
        double currentTime = System.currentTimeMillis();
        if (!this.isValid(this.idpConfiguration.getRefreshInterval())) {
            try {
                this.samlSettings = new SettingsBuilder().fromValues(IdPMetadataParser.parseRemoteXML((URL)new URL(this.idpConfiguration.getMetadataUrl()))).build();
                super.setLastUpdated(currentTime);
            }
            catch (MalformedURLException e) {
                if (this.samlSettings != null) {
                    CFLogs.APPLICATION_LOG.warn((Object)RB.getString(SAMLServiceImpl.class, (String)"URLMetadataFetchError", (Object)this.idpConfiguration.getMetadataUrl()));
                }
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"MetadataMalformedURL", (Object)this.idpConfiguration.getMetadataUrl()));
            }
            catch (Exception e) {
                if (this.samlSettings != null) {
                    CFLogs.APPLICATION_LOG.warn((Object)RB.getString(SAMLServiceImpl.class, (String)"URLMetadataFetchError", (Object)this.idpConfiguration.getMetadataUrl()));
                }
                throw new SAMLServiceImpl.IdpMetadataException(RB.getString(SAMLServiceImpl.class, (String)"MetadataURLFetchException", (Object)this.idpConfiguration.getMetadataUrl()));
            }
        }
        super.setLastFetched(currentTime);
        return this.samlSettings;
    }
}

