/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.saml;

import coldfusion.log.CFLogs;
import coldfusion.osgi.services.SamlService;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Struct;
import coldfusion.saml.IdpConfiguration;
import coldfusion.saml.SamlCacheHelper;
import coldfusion.saml.SamlHelper;
import coldfusion.saml.SamlRequestBuilder;
import coldfusion.saml.SamlResponseHandler;
import coldfusion.saml.SpConfiguration;
import coldfusion.saml.util.Utils;
import coldfusion.server.ConfigMap;
import coldfusion.server.SecurityService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class SAMLServiceImpl
extends ServiceBase
implements SamlService,
Observer {
    private File samlServiceFile;
    private String seed;
    protected Map<String, IdpConfiguration> idpConfig;
    protected Map<String, SpConfiguration> spConfig;
    private ConfigMap samlSettings;
    private String rootDir;
    private String samlFolderPrefix;
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private static final String IDP_LIST = "IdentityProvidersMap";
    private static final String SP_LIST = "ServiceProvidersMap";
    private static final String staticpassword = "***************";
    private static final String METADATA_FILE_SUFFIX = "_metadata.xml";

    public SAMLServiceImpl(File serviceFile, String rootDir) {
        this.samlServiceFile = serviceFile;
        this.rootDir = rootDir;
        this.idpConfig = new HashMap<String, IdpConfiguration>();
        this.spConfig = new HashMap<String, SpConfiguration>();
        this.samlFolderPrefix = rootDir + File.separator + "lib" + File.separator + "saml" + File.separator;
        File directory = new File(this.samlFolderPrefix);
        if (!directory.exists()) {
            directory.mkdir();
        }
        SamlCacheHelper.initSamlAuthCache(rootDir);
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void addIdpMetadata(String alias, Object config1) {
        List<String> errors;
        IdpConfiguration config = (IdpConfiguration)config1;
        if (Utils.isEmpty(alias)) {
            throw new IdpMetadataException(RB.getString((Object)this, (String)"AliasEmptyIDP"));
        }
        if (alias.length() > 50) {
            throw new IdpMetadataException(RB.getString((Object)this, (String)"AliasTooLong"));
        }
        if (config.getRefreshInterval() < 0.0) {
            throw new IdpMetadataException(RB.getString((Object)this, (String)"RefreshIntervalNegative"));
        }
        if (config.getMetadataRaw() != null) {
            config.setMetadataRaw(StringEscapeUtils.unescapeHtml4((String)config.getMetadataRaw()));
        }
        if ((errors = SamlHelper.validateIdpSettings(config)).isEmpty()) {
            if (this.idpConfig.containsKey(alias)) {
                throw new IdpNameAlreadyExistsException(alias);
            }
        } else {
            throw new IdpException(errors);
        }
        this.idpConfig.put(alias, config);
        this.samlSettings.put((Object)IDP_LIST, this.idpConfig);
        this.store(alias, config, null);
    }

    public void modifyIdpMetadata(String oldAlias, String newAlias, Object config1) {
        List<String> errors;
        IdpConfiguration config = (IdpConfiguration)config1;
        if (Utils.isEmpty(oldAlias) || Utils.isEmpty(newAlias)) {
            throw new IdpMetadataException(RB.getString((Object)this, (String)"AliasEmptyIDP"));
        }
        if (config.getRefreshInterval() < 0.0) {
            throw new IdpMetadataException(RB.getString((Object)this, (String)"RefreshIntervalNegative"));
        }
        if (config.getMetadataRaw() != null) {
            config.setMetadataRaw(StringEscapeUtils.unescapeHtml4((String)config.getMetadataRaw()));
        }
        if ((errors = SamlHelper.validateIdpSettings(config)).isEmpty()) {
            if (!this.idpConfig.containsKey(oldAlias)) {
                throw new IdpNotFoundException(oldAlias);
            }
        } else {
            throw new IdpException(errors);
        }
        IdpConfiguration oldValue = this.idpConfig.get(oldAlias);
        this.idpConfig.remove(oldAlias);
        this.idpConfig.put(newAlias, config);
        this.samlSettings.put((Object)IDP_LIST, this.idpConfig);
        this.store(newAlias, config, oldValue);
    }

    public void deleteIdpMetadata(String alias) {
        if (!this.idpConfig.containsKey(alias)) {
            throw new IdpNotFoundException(alias);
        }
        IdpConfiguration oldValue = this.idpConfig.get(alias);
        this.idpConfig.remove(alias);
        this.samlSettings.put((Object)IDP_LIST, this.idpConfig);
        this.store(alias, null, oldValue);
    }

    public Map getAllIdpConfig() {
        LinkedHashMap sortedMap = new LinkedHashMap();
        this.idpConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> sortedMap.put(x.getKey(), x.getValue()));
        return sortedMap;
    }

    public Map getAllSpConfig() {
        LinkedHashMap sortedMap = new LinkedHashMap();
        this.spConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> sortedMap.put(x.getKey(), x.getValue()));
        return sortedMap;
    }

    public Struct getIdpMetadataData(String alias) {
        return SamlHelper.toIdpStruct(this.getIdpMetadata(alias));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reEncryptPasswordForMigration(String password, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (!PasswordUtils.isAESS((int)majorVersion, (int)minorVersion)) {
            oldSeed = OLDSEEDVAL;
        }
        if (password != null) {
            ConfigMap configMap = this.samlSettings;
            synchronized (configMap) {
                try {
                    String newPassword = PasswordUtils.reEncryptWithNewSeed((String)password, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                    return newPassword;
                }
                catch (Exception e) {
                    CFLogs.SERVER_LOG.error((Throwable)e);
                }
            }
        }
        return null;
    }

    public IdpConfiguration getIdpMetadata(String alias) {
        if (this.idpConfig.containsKey(alias)) {
            return this.idpConfig.get(alias);
        }
        return null;
    }

    public Struct getSpMetadataData(String alias) {
        return SamlHelper.toSpStruct(this.getSpMetadataForAdmin(alias));
    }

    public SpConfiguration getSpMetadataForAdmin(String alias) {
        SpConfiguration spConfig = this.getSpMetadata(alias);
        this.removeSignKeystorePassword(spConfig);
        return spConfig;
    }

    public SpConfiguration getSpMetadata(String alias) {
        if (alias != null && this.spConfig.containsKey(alias)) {
            try {
                SpConfiguration clone = this.spConfig.get(alias).clone();
                clone.setSignKeystorePassword(this.decryptPassword(clone.getSignKeystorePassword()));
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return this.spConfig.get(alias);
            }
        }
        return null;
    }

    private void removeSignKeystorePassword(SpConfiguration spConfig) {
        if (spConfig.getSignKeystorePassword() != null) {
            spConfig.setSignKeystorePassword(staticpassword);
        }
    }

    public void addSpMetadata(String alias, Object config1) {
        List<String> errors;
        SpConfiguration config = (SpConfiguration)config1;
        if (Utils.isEmpty(alias)) {
            throw new SpMetadataException(RB.getString((Object)this, (String)"AliasEmptySP"));
        }
        if (alias.length() > 50) {
            throw new SpMetadataException(RB.getString((Object)this, (String)"AliasTooLong"));
        }
        if (this.entityIdExists(config.getEntityId())) {
            throw new SpMetadataException(RB.getString((Object)this, (String)"DuplicateEntityId"));
        }
        List<String> list = errors = config.isGenerated() ? null : SamlHelper.validateSpSettings(config);
        if (errors == null || errors.isEmpty()) {
            if (config.getSignKeystorePassword() != null) {
                config.setSignKeystorePassword(this.encryptPassword(config.getSignKeystorePassword()));
            }
            if (this.spConfig.containsKey(alias)) {
                throw new SpNameAlreadyExistsException(alias);
            }
        } else {
            throw new SpException(errors);
        }
        this.spConfig.put(alias, config);
        this.samlSettings.put((Object)SP_LIST, this.spConfig);
        this.store(alias, config, null);
    }

    private boolean entityIdExists(String entityId) {
        boolean exists = false;
        for (SpConfiguration config : this.spConfig.values()) {
            if (!config.getEntityId().equals(entityId)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public void modifySpMetadata(String oldAlias, String newAlias, Object newConfig1) throws CloneNotSupportedException {
        this.modifySpMetadata(oldAlias, newAlias, newConfig1, false);
    }

    public void modifySpMetadata(String oldAlias, String newAlias, Object newConfig1, boolean adminApi) throws CloneNotSupportedException {
        List<String> errors;
        SpConfiguration newConfig = (SpConfiguration)newConfig1;
        if (Utils.isEmpty(oldAlias) || Utils.isEmpty(newAlias)) {
            throw new SpMetadataException(RB.getString((Object)this, (String)"AliasEmptySP"));
        }
        if (adminApi) {
            SpConfiguration oldConf = this.getSpMetadata(oldAlias);
            SamlHelper.mergeSp(oldConf, newConfig);
        }
        if ((errors = SamlHelper.validateSpSettings(newConfig)).isEmpty()) {
            if (!this.spConfig.containsKey(oldAlias)) {
                throw new SpNotFoundException(oldAlias);
            }
            SpConfiguration oldConfig = this.spConfig.get(oldAlias).clone();
            String oldSignKeystorePassword = null;
            String newSignKeystorePassword = null;
            oldSignKeystorePassword = PasswordUtils.decryptPassword((String)oldConfig.getSignKeystorePassword(), (String)this.seed);
            newSignKeystorePassword = newConfig.getSignKeystorePassword();
            if (oldSignKeystorePassword != null && newSignKeystorePassword != null && newSignKeystorePassword.equals(staticpassword)) {
                newConfig.setSignKeystorePassword(oldConfig.getSignKeystorePassword());
            } else if (!StringUtils.equals((CharSequence)oldSignKeystorePassword, (CharSequence)newConfig.getSignKeystorePassword())) {
                newConfig.setSignKeystorePassword(PasswordUtils.encryptPassword((String)newConfig.getSignKeystorePassword(), (String)this.seed));
            } else {
                newConfig.setSignKeystorePassword(oldConfig.getSignKeystorePassword());
            }
        } else {
            throw new SpException(errors);
        }
        SpConfiguration oldValue = this.spConfig.remove(oldAlias);
        this.spConfig.put(newAlias, newConfig);
        this.samlSettings.put((Object)SP_LIST, this.spConfig);
        this.store(newAlias, newConfig, oldValue);
    }

    public void deleteSpMetadata(String alias) {
        if (!this.spConfig.containsKey(alias)) {
            throw new SpNotFoundException(alias);
        }
        SpConfiguration config = this.spConfig.get(alias);
        if (config.isGenerated()) {
            File file = new File(config.getSignKeystorePath());
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SpConfiguration oldValue = this.spConfig.remove(alias);
        this.samlSettings.put((Object)SP_LIST, this.spConfig);
        this.store(alias, null, oldValue);
    }

    public void start() throws ServiceException {
        super.start();
        if (this.isFirstLoad()) {
            PasswordUtils.getInstance().addObserver((Observer)this);
        }
    }

    public void addPasswordObserver() {
        try {
            this.start();
        }
        catch (ServiceException e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
    }

    public void load() throws ServiceException {
        try {
            this.samlServiceFile = coldfusion.util.Utils.getCanonicalFile((File)this.samlServiceFile);
            this.samlSettings = (ConfigMap)this.deserialize(this.samlServiceFile);
            if (this.samlSettings == null) {
                this.samlSettings = new ConfigMap((Service)this, "saml");
                this.idpConfig = new HashMap<String, IdpConfiguration>();
                this.spConfig = new HashMap<String, SpConfiguration>();
                this.samlSettings.put((Object)IDP_LIST, this.idpConfig);
                this.samlSettings.put((Object)SP_LIST, this.spConfig);
            } else {
                Object idplist = this.samlSettings.get((Object)IDP_LIST);
                if (idplist != null) {
                    this.idpConfig = (Map)idplist;
                } else {
                    this.samlSettings.put((Object)IDP_LIST, this.idpConfig);
                }
                Object splist = this.samlSettings.get((Object)SP_LIST);
                if (splist != null) {
                    this.spConfig = (Map)splist;
                } else {
                    this.samlSettings.put((Object)SP_LIST, this.spConfig);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void store() {
        this.serialize(this.samlSettings, this.samlServiceFile);
    }

    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    public void store(Object key, Object value, Object oldValue) {
        this.store(key, value, oldValue, true);
    }

    public void store(Object key, Object value, Object oldValue, boolean broadcast) {
        this.serialize(this.samlSettings, this.samlServiceFile, broadcast, key, this.convertToStruct(value), this.convertToStruct(oldValue));
    }

    private Map convertToStruct(Object val) {
        Object value;
        if (null == val) {
            return null;
        }
        HashMap<String, Object> st = new HashMap<String, Object>();
        if (val instanceof IdpConfiguration) {
            value = (IdpConfiguration)val;
            st.put("description", ((IdpConfiguration)value).getDescription());
            st.put("entityid", ((IdpConfiguration)value).getEntityId());
            st.put("logoutResponseURL", ((IdpConfiguration)value).getLogoutResponseUrl());
            st.put("metadataFilePath", ((IdpConfiguration)value).getMetadataFilePath());
            st.put("metadataRaw", ((IdpConfiguration)value).getMetadataRaw());
            st.put("metadataURL", ((IdpConfiguration)value).getMetadataUrl());
            st.put("refreshInterval", ((IdpConfiguration)value).getRefreshInterval());
            st.put("signCertificate", ((IdpConfiguration)value).getSignCertificate());
            st.put("sloBinding", ((IdpConfiguration)value).getSloBinding());
            st.put("ssoURL", ((IdpConfiguration)value).getSsoUrl());
            st.put("ssoBinding", ((IdpConfiguration)value).getSsoBinding());
            st.put("sloURL", ((IdpConfiguration)value).getSloUrl());
        }
        if (val instanceof SpConfiguration) {
            value = (SpConfiguration)val;
            st.put("description", ((SpConfiguration)value).getDescription());
            st.put("entityid", ((SpConfiguration)value).getEntityId());
            st.put("sloBinding", ((SpConfiguration)value).getSloBinding());
            st.put("sloURL", ((SpConfiguration)value).getSloUrl());
            st.put("acsBinding", ((SpConfiguration)value).getAcsBinding());
            st.put("acsURL", ((SpConfiguration)value).getAcsUrl());
            st.put("signKeystoreAlias", ((SpConfiguration)value).getSignKeystoreAlias());
            st.put("stateStore", ((SpConfiguration)value).getStateStore());
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            String string = seedVal;
            synchronized (string) {
                this.reEncryptPasswords(oldSeed);
            }
        }
    }

    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("saml.keys", "IdentityProvidersMap,ServiceProvidersMap");
            this.rb.put("saml.types", "java.util.Map, java.util.Map");
            this.rb.put("saml.formats", "coldfusion.server.MapFormatter, coldfusion.server.MapFormatter");
            this.rb.put("saml.value", "");
        }
        return this.rb;
    }

    private void reEncryptPasswords(String oldSeed) {
        this.spConfig.forEach((k, v) -> {
            String password = PasswordUtils.decryptPassword((String)v.getSignKeystorePassword(), (String)oldSeed);
            v.setSignKeystorePassword(PasswordUtils.encryptPassword((String)password, (String)this.seed));
        });
        this.store();
    }

    public String exportSpMetadata(String alias) throws CloneNotSupportedException, IOException {
        String filepath = this.samlFolderPrefix + alias + METADATA_FILE_SUFFIX;
        SpConfiguration config = this.spConfig.get(alias).clone();
        config.setSignKeystorePassword(PasswordUtils.decryptPassword((String)config.getSignKeystorePassword(), (String)this.seed));
        SamlHelper.exportSpMetadata(config, filepath);
        return new File(filepath).getCanonicalPath();
    }

    public String generateDefaultSpMetadata() {
        Map m = SamlHelper.generateDefaultSpMetadata(true, null);
        return (String)m.get("name");
    }

    public String encryptPassword(String plainText) {
        return PasswordUtils.encryptPassword((String)plainText, (String)this.seed);
    }

    public String decryptPassword(String password) {
        return PasswordUtils.decryptPassword((String)password, (String)this.seed);
    }

    public boolean isInstaceOfSamlService(Object o) {
        return o instanceof SAMLServiceImpl;
    }

    public Map GenerateSAMLSPMetadata(Map struct) {
        return SamlHelper.generateSpStruct(struct);
    }

    public String GetSAMLAuthRequest(Map struct) {
        return new SamlRequestBuilder().buildAuthnRequest(struct);
    }

    public String GetSAMLLogoutRequest(Map struct) {
        return new SamlRequestBuilder().buildLogoutRequest(struct);
    }

    public void InitSAMLAuthRequest(Map struct) {
        new SamlRequestBuilder().initAuthRequest(struct);
    }

    public void InitSAMLLogoutRequest(Map struct) {
        new SamlRequestBuilder().initLogoutRequest(struct);
    }

    public Map ProcessSAMLResponse(String idpName, String spName) {
        return new SamlResponseHandler(false, idpName, spName).handleResponse();
    }

    public Map ProcessSAMLLogoutRequest(String idpName, String spName) {
        return new SamlResponseHandler(true, idpName, spName).handleLogoutRequest();
    }

    public void SendSAMLLogoutResponse(String sessionIndex, String idpName, String spName) {
        new SamlResponseHandler(true, idpName, spName).sendLogoutResponse(sessionIndex);
    }

    public boolean IsSAMLLogoutRequest() {
        return SamlHelper.isSamlLogoutRequest();
    }

    public boolean IsSAMLLogoutResponse() {
        return SamlHelper.isSamlLogoutResponse();
    }

    public static class SpException
    extends ApplicationException {
        public String fieldsMissing = "";

        public SpException(List<String> errors) {
            ArrayList<String> fields = new ArrayList<String>();
            Iterator<String> iterator = errors.iterator();
            while (iterator.hasNext()) {
                String error;
                switch (error = iterator.next()) {
                    case "entity_id": {
                        fields.add("Entity Id");
                        break;
                    }
                    case "acs_url": {
                        fields.add("Assertion Consumer Service URL");
                    }
                }
            }
            this.fieldsMissing = String.join((CharSequence)",", fields);
        }
    }

    public static class SpMetadataException
    extends ApplicationException {
        public String exceptionMessage = "";

        public SpMetadataException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }

    public class SpNotFoundException
    extends ApplicationException {
        public String alias;

        public SpNotFoundException(String alias) {
            this.alias = alias;
        }
    }

    public class SpNameAlreadyExistsException
    extends ApplicationException {
        public String name = "";

        public SpNameAlreadyExistsException(String name) {
            this.name = name;
        }
    }

    public class IdpNotFoundException
    extends ApplicationException {
        public String alias;

        public IdpNotFoundException(String alias) {
            this.alias = alias;
        }
    }

    public static class IdpMetadataException
    extends ApplicationException {
        public String exceptionMessage = "";

        public IdpMetadataException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }

    public static class IdpException
    extends ApplicationException {
        public String fieldsMissing = "";

        public IdpException(List<String> errors) {
            ArrayList<String> fields = new ArrayList<String>();
            Iterator<String> iterator = errors.iterator();
            while (iterator.hasNext()) {
                String error;
                switch (error = iterator.next()) {
                    case "idp_entityId_not_found": {
                        fields.add("Entity Id");
                        break;
                    }
                    case "idp_sso_url_invalid": {
                        fields.add("Single Sign On URL");
                        break;
                    }
                    case "idp_cert_or_fingerprint_not_found_and_required": {
                        fields.add("IDP Encryption Certificate");
                    }
                }
            }
            this.fieldsMissing = String.join((CharSequence)",", fields);
        }
    }

    public class IdpNameAlreadyExistsException
    extends ApplicationException {
        public String alias = "";

        public IdpNameAlreadyExistsException(String alias) {
            this.alias = alias;
        }
    }
}

