/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRRtfSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_RTF = ".rtf";
    public static final JRRtfSaveContributor INSTANCE = new JRRtfSaveContributor();

    public static JRRtfSaveContributor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_RTF);
    }

    @Override
    public String getDescription() {
        return "RTF (*.rtf)";
    }

    @Override
    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_RTF)) {
            file = new File(file.getAbsolutePath() + EXTENSION_RTF);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.exportReport();
        }
    }
}

