/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.impl;

import coldfusion.cloud.gcp.pubsub.PubSubClient;
import coldfusion.cloud.gcp.pubsub.PubSubSubscription;
import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriberMessageHandlerRequestConsumer;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.SubscriberMessageHandlerRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubClientManager;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.pubsub.v1.Subscription;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PubSubSubscriptionImpl
implements PubSubSubscription {
    private final Logger logger = CFLogs.SERVER_LOG;
    private final PubSubClient pubsubClient;
    private final PubSubClientManager clientManager;
    private Subscription subscription;
    private String subscriptionName;
    private String subscriptionId;
    private String topicId;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public PubSubSubscriptionImpl(PubSubClient pubsubClient, PubSubClientManager clientManager, Subscription subscription) {
        this.pubsubClient = pubsubClient;
        this.clientManager = clientManager;
        this.subscription = subscription;
        if (this.subscription != null) {
            this.subscriptionName = subscription.getName();
            this.subscriptionId = PubSubServiceUtils.getResourceIdFromResourceName(this.subscriptionName);
            this.topicId = PubSubServiceUtils.getResourceIdFromResourceName(subscription.getTopic());
        }
    }

    @Override
    public String getId() {
        return this.subscriptionId;
    }

    @Override
    public String getName() {
        return this.subscriptionName;
    }

    @Override
    public String getTopicId() {
        return this.topicId;
    }

    @Override
    public String getTopicName() {
        return this.subscription.getTopic();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.subscription.getLabelsMap();
    }

    @Override
    public int getAckDeadlineSeconds() {
        return this.subscription.getAckDeadlineSeconds();
    }

    @Override
    public boolean isEnableExactlyOnceDelivery() {
        return this.subscription.getEnableExactlyOnceDelivery();
    }

    @Override
    public boolean isEnableMessageOrdering() {
        return this.subscription.getEnableMessageOrdering();
    }

    @Override
    public boolean isRetainAckedMessages() {
        return this.subscription.getRetainAckedMessages();
    }

    @Override
    public boolean isDetached() {
        return this.subscription.getDetached();
    }

    @Override
    public String getFilter() {
        return this.subscription.getFilter();
    }

    @Override
    public String getMessageRetentionDuration() {
        return FieldTypecastUtil.toDurationString((long)this.subscription.getMessageRetentionDuration().getSeconds());
    }

    @Override
    public Struct getExpirationPolicy() {
        return PubSubServiceUtils.deserialize(this.subscription.getExpirationPolicy());
    }

    @Override
    public Struct getRetryPolicy() {
        return PubSubServiceUtils.deserialize(this.subscription.getRetryPolicy());
    }

    @Override
    public Struct getDeadLetterPolicy() {
        return PubSubServiceUtils.deserialize(this.subscription.getDeadLetterPolicy());
    }

    @Override
    public Struct getPushConfig() {
        return PubSubServiceUtils.deserialize(this.subscription.getPushConfig());
    }

    @Override
    public Struct getBigQueryConfig() {
        return PubSubServiceUtils.deserialize(this.subscription.getBigqueryConfig());
    }

    @Override
    public void setLabels(Map<String, String> labels) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("labels", labels);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void addLabels(Map<String, String> newLabels) {
        if (newLabels == null || newLabels.isEmpty()) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"LABEL_NULL_OR_EMPTY_ERROR"));
        }
        Map<String, String> existingLabels = this.getLabels();
        Map<String, String> updatedLabels = PubSubServiceUtils.getUpdatedLabels(existingLabels, newLabels);
        this.setLabels(updatedLabels);
    }

    @Override
    public boolean containsLabels(String key) {
        if (PubSubServiceUtils.isNullOrEmpty(key)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"LABEL_KEY_NULL_EMPTY"));
        }
        return this.subscription.containsLabels(key);
    }

    @Override
    public void setAckDeadlineSeconds(long seconds) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("ackDeadlineSeconds", seconds);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void setMessageRetentionDuration(String duration) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("messageRetentionDuration", duration);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void setEnableExactlyOnceDelivery(boolean enableExactlyOnceDelivery) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("enableExactlyOnceDelivery", enableExactlyOnceDelivery);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void setRetainAckedMessages(boolean retainAckedMessages) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("retainAckedMessages", retainAckedMessages);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public Struct setDetached(boolean detached) {
        return this.pubsubClient.detachSubscription(this.getId());
    }

    @Override
    public void setExpirationPolicy(Map expirationPolicy) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("expirationPolicy", expirationPolicy);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void setRetryPolicy(Map retryPolicy) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("retryPolicy", retryPolicy);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void setDeadLetterPolicy(Map deadLetterPolicy) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("deadLetterPolicy", deadLetterPolicy);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void setDeliveryConfig(Map deliveryConfig) {
        Struct subscriptionUpdateOptions = new Struct();
        subscriptionUpdateOptions.put("subscriptionName", this.getId());
        subscriptionUpdateOptions.put("deliveryConfig", deliveryConfig);
        this.updateSubscription((Map)subscriptionUpdateOptions);
    }

    @Override
    public void registerMessageHandler(Map messageHandlerMetadata) {
        block6: {
            Subscriber subscriber = null;
            if (messageHandlerMetadata != null) {
                SubscriberMessageHandlerRequest request = new SubscriberMessageHandlerRequest();
                this.filler.fillObject((Object)request, messageHandlerMetadata, SubscriberMessageHandlerRequestConsumer.INSTANCE.getConsumerMap());
                try {
                    subscriber = this.clientManager.getSubscriber(this.getId(), request);
                    if (!subscriber.isRunning()) {
                        subscriber.startAsync().awaitRunning();
                    }
                }
                catch (Exception timeoutException) {
                    if (subscriber == null) break block6;
                    try {
                        subscriber.stopAsync().awaitTerminated(1L, TimeUnit.MINUTES);
                    }
                    catch (TimeoutException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public Struct delete() {
        return this.pubsubClient.deleteSubscription(this.getId());
    }

    @Override
    public Struct getIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.SUBSCRIPTION);
        }
        return this.pubsubClient.getIAMPolicy(policyMap);
    }

    @Override
    public Struct addIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.SUBSCRIPTION);
        }
        return this.pubsubClient.addIAMPolicy(policyMap);
    }

    @Override
    public Struct testIAMPermissions(Map permissionsMap) {
        if (Objects.nonNull(permissionsMap)) {
            permissionsMap.put("resourceName", this.getId());
            permissionsMap.put("resourceType", ResourceType.SUBSCRIPTION);
        }
        return this.pubsubClient.testIAMPermissions(permissionsMap);
    }

    @Override
    public Struct setIAMPolicy(Map policyMap) {
        if (Objects.nonNull(policyMap)) {
            policyMap.put("resourceName", this.getId());
            policyMap.put("resourceType", ResourceType.SUBSCRIPTION);
        }
        return this.pubsubClient.setIAMPolicy(policyMap);
    }

    @Override
    public Struct pullMessages(Map pullMessageMetadata) {
        if (Objects.nonNull(pullMessageMetadata)) {
            pullMessageMetadata.putIfAbsent("subscriptionName", this.getId());
        }
        return this.pubsubClient.pullMessages(pullMessageMetadata);
    }

    @Override
    public Struct acknowledgeMessages(Map acknowledgeMessageMetadata) {
        if (Objects.nonNull(acknowledgeMessageMetadata)) {
            acknowledgeMessageMetadata.putIfAbsent("subscriptionName", this.getId());
        }
        return this.pubsubClient.acknowledgeMessages(acknowledgeMessageMetadata);
    }

    @Override
    public Struct modifyAckDeadline(Map ackDeadlineMetadata) {
        if (Objects.nonNull(ackDeadlineMetadata)) {
            ackDeadlineMetadata.putIfAbsent("subscriptionName", this.getId());
        }
        return this.pubsubClient.modifyAckDeadline(ackDeadlineMetadata);
    }

    @Override
    public Struct seekMessages(Map seekMessageMetadata) {
        if (Objects.nonNull(seekMessageMetadata)) {
            seekMessageMetadata.putIfAbsent("subscriptionName", this.getId());
        }
        return this.pubsubClient.seekMessages(seekMessageMetadata);
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    private void updateSubscription(Map subscriptionUpdateOptions) {
        PubSubSubscription pubsubSubscription = this.pubsubClient.updateSubscription(subscriptionUpdateOptions);
        this.subscription = pubsubSubscription.getSubscription();
    }
}

