/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.config.AbstractGCPServiceConfig;
import coldfusion.cloud.gcp.pubsub.DeliveryType;
import coldfusion.cloud.gcp.pubsub.PubSubClient;
import coldfusion.cloud.gcp.pubsub.PubSubSchema;
import coldfusion.cloud.gcp.pubsub.PubSubSnapshot;
import coldfusion.cloud.gcp.pubsub.PubSubSubscription;
import coldfusion.cloud.gcp.pubsub.PubSubTopic;
import coldfusion.cloud.gcp.pubsub.ResourceType;
import coldfusion.cloud.gcp.pubsub.auth.PubSubCredentialValidator;
import coldfusion.cloud.gcp.pubsub.config.PubSubClientServiceConfig;
import coldfusion.cloud.gcp.pubsub.consumer.IAMPermissionTestRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.IAMPolicyAddRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.MessageAcknowledgeRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.MessagePublishRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.MessagePullRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.MessageSeekRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.MessageValidateRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.ModifyMessageAckDeadlineRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.PaginatedMetadataRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SchemaMetadataRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriptionMetadataRequestConsumer;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubSchemaImpl;
import coldfusion.cloud.gcp.pubsub.impl.PubSubSnapshotImpl;
import coldfusion.cloud.gcp.pubsub.impl.PubSubSubscriptionImpl;
import coldfusion.cloud.gcp.pubsub.impl.PubSubTopicImpl;
import coldfusion.cloud.gcp.pubsub.model.ReceivedPubSubMessage;
import coldfusion.cloud.gcp.pubsub.pmt.utils.PMTUtilsForGCPPubSub;
import coldfusion.cloud.gcp.pubsub.pmt.utils.PubSubApis;
import coldfusion.cloud.gcp.pubsub.request.IAMPermissionTestRequest;
import coldfusion.cloud.gcp.pubsub.request.IAMPolicyAddRequest;
import coldfusion.cloud.gcp.pubsub.request.MessageAcknowledgeRequest;
import coldfusion.cloud.gcp.pubsub.request.MessagePublishRequest;
import coldfusion.cloud.gcp.pubsub.request.MessagePullRequest;
import coldfusion.cloud.gcp.pubsub.request.MessageSeekRequest;
import coldfusion.cloud.gcp.pubsub.request.MessageValidateRequest;
import coldfusion.cloud.gcp.pubsub.request.ModifyMessageAckDeadlineRequest;
import coldfusion.cloud.gcp.pubsub.request.PaginatedMetadataRequest;
import coldfusion.cloud.gcp.pubsub.request.PubSubMessageRequest;
import coldfusion.cloud.gcp.pubsub.request.PublisherSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.SchemaMetadataRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataBigQueryConfigRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataDeadLetterPolicyRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataDeliveryConfigRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataExpirationPolicyRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataOidcTokenRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataPushConfigRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataRetryPolicyRequest;
import coldfusion.cloud.gcp.pubsub.request.TopicMetadataRequest;
import coldfusion.cloud.gcp.pubsub.request.TopicMetadataSchemaSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubClientManager;
import coldfusion.cloud.gcp.pubsub.utils.PubSubMessageSerializer;
import coldfusion.cloud.gcp.pubsub.utils.PubSubResourceNameTransformer;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ObjectHandledInvokable;
import coldfusion.runtime.Struct;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.api.client.util.Lists;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.SchemaServiceClient;
import com.google.cloud.pubsub.v1.SchemaServiceSettings;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.iam.v1.Binding;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.FieldMask;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.BigQueryConfig;
import com.google.pubsub.v1.DeadLetterPolicy;
import com.google.pubsub.v1.DeleteSchemaRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.Encoding;
import com.google.pubsub.v1.ExpirationPolicy;
import com.google.pubsub.v1.ListSchemasRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.ReceivedMessage;
import com.google.pubsub.v1.RetryPolicy;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.SchemaSettings;
import com.google.pubsub.v1.SchemaView;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateSchemaRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.jsp.PageContext;

public class PubSubClientImpl
implements PubSubClient,
ObjectHandledInvokable {
    private final PubSubClientServiceConfig pubsubConfig;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private final PubSubResourceNameTransformer nameTransformer;
    private final PubSubClientManager clientManager;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.PUBSUB.name());

    public PubSubClientImpl(GCPCredential credential, AbstractGCPServiceConfig pubsubConfig, String pubsubClientId) {
        PubSubCredentialValidator credentialValidator = new PubSubCredentialValidator(credential);
        this.nameTransformer = new PubSubResourceNameTransformer(credentialValidator.getProjectId());
        this.pubsubConfig = (PubSubClientServiceConfig)pubsubConfig;
        this.clientManager = new PubSubClientManager(credential, this.pubsubConfig, pubsubClientId);
    }

    @Override
    public PubSubTopic createTopic(String topicName) {
        return this.createTopic(topicName, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubTopic createTopic(String topicId, Map topicCreateOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubTopic getTopic(String topicId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubTopic updateTopic(String topicId, Map topicUpdateOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Struct listTopics() {
        return this.listTopics(null);
    }

    @Override
    public Struct listTopics(Map listMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.listTopics, this.tagAttributeList);
        Struct response = new Struct();
        TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
            ListTopicsRequest.Builder listTopicRequestBuilder = ListTopicsRequest.newBuilder().setProject(this.nameTransformer.getProjectName());
            if (Objects.nonNull(listMetadata)) {
                PaginatedMetadataRequest request = new PaginatedMetadataRequest();
                this.filler.fillObject((Object)request, listMetadata, PaginatedMetadataRequestConsumer.INSTANCE.getConsumerMap());
                if (request.getPageSize() != null) {
                    listTopicRequestBuilder = listTopicRequestBuilder.setPageSize(request.getPageSize().intValue());
                }
                if (request.getNextPageToken() != null) {
                    listTopicRequestBuilder = listTopicRequestBuilder.setPageToken(request.getNextPageToken());
                }
            }
            ListTopicsRequest listTopicsRequest = listTopicRequestBuilder.build();
            TopicAdminClient.ListTopicsPagedResponse listTopicsPagedResponse = topicAdminClient.listTopics(listTopicsRequest);
            TopicAdminClient.ListTopicsPage page = (TopicAdminClient.ListTopicsPage)listTopicsPagedResponse.getPage();
            ArrayList topics = Lists.newArrayList((Iterable)page.getValues());
            ArrayList<PubSubTopicImpl> pubsubTopics = new ArrayList<PubSubTopicImpl>();
            for (Topic topic : topics) {
                PubSubTopicImpl pubsubTopic = new PubSubTopicImpl(this, topic);
                pubsubTopics.add(pubsubTopic);
            }
            response.put((Object)"STATUS", (Object)"Success");
            response.put((Object)"topics", pubsubTopics);
            if (!PubSubServiceUtils.isNullOrEmpty(listTopicsPagedResponse.getNextPageToken())) {
                response.put((Object)"nextPageToken", (Object)listTopicsPagedResponse.getNextPageToken());
            }
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.listTopics, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS")));
        }
        return response;
    }

    @Override
    public Struct deleteTopic(String topicId) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.deleteTopic, this.tagAttributeList);
        String topicName = this.nameTransformer.getTopicName(topicId);
        Struct response = new Struct();
        TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
            DeleteTopicRequest deleteTopicRequest = DeleteTopicRequest.newBuilder().setTopic(topicName).build();
            topicAdminClient.deleteTopic(deleteTopicRequest);
            this.clientManager.deletePublisher(topicId);
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (NotFoundException nfe) {
            this.validateIfProjectIDExists(nfe);
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_NOT_FOUND", (Object)topicId), nfe);
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("delete", (String)response.get((Object)"STATUS"));
                rmdMap.put("topic", topicId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.deleteTopic, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Struct getIAMPolicy(Map getIamPolicy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Struct setIAMPolicy(Map setIamPolicy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Struct addIAMPolicy(Map addIamPolicy) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.addIAMPolicy, this.tagAttributeList);
        String status = "Success";
        if (addIamPolicy != null) {
            IAMPolicyAddRequest pubsubAddIamPolicyRequest = new IAMPolicyAddRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)pubsubAddIamPolicyRequest, addIamPolicy, IAMPolicyAddRequestConsumer.INSTANCE.getConsumerMap());
            Struct iamPolicy = new Struct();
            String resourceId = pubsubAddIamPolicyRequest.getResourceName();
            ResourceType resourceType = pubsubAddIamPolicyRequest.getResourceType();
            String resourceName = this.inspectPolicyResourceType(resourceId, resourceType);
            List<Binding> newBindings = PubSubServiceUtils.getPolicyBindings(pubsubAddIamPolicyRequest.getBindings());
            TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
            try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
                GetIamPolicyRequest getIamPolicyRequest = GetIamPolicyRequest.newBuilder().setResource(resourceName).build();
                Policy oldPolicy = topicAdminClient.getIamPolicy(getIamPolicyRequest);
                List oldBindings = oldPolicy.getBindingsList();
                if (newBindings != null) {
                    ArrayList<Binding> bindings = new ArrayList<Binding>();
                    bindings.addAll(oldBindings);
                    bindings.addAll(newBindings);
                    Policy updatedPolicy = Policy.newBuilder((Policy)oldPolicy).addAllBindings(bindings).build();
                    SetIamPolicyRequest setIamPolicyRequest = SetIamPolicyRequest.newBuilder().setResource(resourceName).setPolicy(updatedPolicy).build();
                    Policy updatedIamPolicy = topicAdminClient.setIamPolicy(setIamPolicyRequest);
                    iamPolicy = PubSubServiceUtils.deserialize(updatedIamPolicy);
                }
            }
            catch (NotFoundException nfe) {
                status = "Failure";
                this.validateIfProjectIDExists(nfe);
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"RESOURCE_NOT_FOUND", (Object)((Object)pubsubAddIamPolicyRequest.getResourceType()), (Object)pubsubAddIamPolicyRequest.getResourceName()), nfe);
            }
            catch (IOException e) {
                status = "Failure";
                throw new PubSubException(e.getMessage(), e);
            }
            catch (Exception e) {
                status = "Failure";
                throw new PubSubException(e.getMessage(), e);
            }
            finally {
                if (tempAttributeList != null) {
                    Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("post", status);
                    rmdMap.put(resourceType.toString().toLowerCase(), resourceId);
                    PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.addIAMPolicy, tempAttributeList, rmdMap);
                }
            }
            return iamPolicy;
        }
        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.addIAMPolicy, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("post", "Failure"));
        throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"IAM_POLICY_MAP_NOT_PROVIDED"));
    }

    @Override
    public Struct testIAMPermissions(Map permissionsMap) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.testIAMPermissions, this.tagAttributeList);
        String status = "Success";
        if (permissionsMap != null) {
            IAMPermissionTestRequest pubsubTestIamPermissionRequest = new IAMPermissionTestRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)pubsubTestIamPermissionRequest, permissionsMap, IAMPermissionTestRequestConsumer.INSTANCE.getConsumerMap());
            Struct subsetPermissions = new Struct();
            TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
            try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
                String resourceName = this.inspectPolicyResourceType(pubsubTestIamPermissionRequest.getResourceName(), pubsubTestIamPermissionRequest.getResourceType());
                List<String> permissions = pubsubTestIamPermissionRequest.getPermissions();
                TestIamPermissionsRequest testIamPermissionRequest = TestIamPermissionsRequest.newBuilder().setResource(resourceName).addAllPermissions(permissions).build();
                TestIamPermissionsResponse testIamPermissionsResponse = topicAdminClient.testIamPermissions(testIamPermissionRequest);
                ProtocolStringList permissionsList = testIamPermissionsResponse.getPermissionsList();
                ArrayList subsetPermissionsList = Lists.newArrayList((Iterator)permissionsList.iterator());
                subsetPermissions.put((Object)"permissions", (Object)subsetPermissionsList);
            }
            catch (NotFoundException nfe) {
                status = "Failure";
                this.validateIfProjectIDExists(nfe);
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"RESOURCE_NOT_FOUND", (Object)((Object)pubsubTestIamPermissionRequest.getResourceType()), (Object)pubsubTestIamPermissionRequest.getResourceName()), nfe);
            }
            catch (IOException e) {
                status = "Failure";
                throw new PubSubException(e.getMessage(), e);
            }
            catch (Exception e) {
                status = "Failure";
                throw new PubSubException(e.getMessage(), e);
            }
            finally {
                if (tempAttributeList != null) {
                    Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", status);
                    rmdMap.put(pubsubTestIamPermissionRequest.getResourceType().toString().toLowerCase(), pubsubTestIamPermissionRequest.getResourceName());
                    PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.testIAMPermissions, tempAttributeList, rmdMap);
                }
            }
            return subsetPermissions;
        }
        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.testIAMPermissions, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Failure"));
        throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"IAM_POLICY_MAP_NOT_PROVIDED"));
    }

    @Override
    public Future publish(Map messageMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.publish, this.tagAttributeList);
        PublisherSettingsRequest publisherSettings = null;
        Publisher publisher = null;
        if (messageMetadata != null) {
            MessagePublishRequest request = new MessagePublishRequest();
            this.filler.fillObject((Object)request, messageMetadata, MessagePublishRequestConsumer.INSTANCE.getConsumerMap());
            if (Objects.nonNull((Object)this.pubsubConfig)) {
                publisherSettings = this.pubsubConfig.getPublisherSettings();
            }
            String topicId = request.getTopicId();
            publisher = this.clientManager.getPublisher(topicId, publisherSettings);
            PubsubMessage message = this.processMessage(request);
            if (publisher != null) {
                if (tempAttributeList != null) {
                    Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Success");
                    rmdMap.put("topic", topicId);
                    PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.publish, tempAttributeList, rmdMap);
                }
                return new Future((java.util.concurrent.Future)publisher.publish(message));
            }
        }
        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.publish, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Success"));
        return null;
    }

    @Override
    public Struct publishAllOutstanding(String topicId) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.publishAllOutstanding, this.tagAttributeList);
        Struct response = new Struct();
        try {
            PublisherSettingsRequest publisherSettings;
            Publisher publisher;
            if (Objects.nonNull((Object)this.pubsubConfig) && (publisher = this.clientManager.getPublisher(topicId, publisherSettings = this.pubsubConfig.getPublisherSettings())) != null) {
                publisher.publishAllOutstanding();
            }
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                rmdMap.put("topic", topicId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.publishAllOutstanding, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    @Override
    public Struct resumePublish(String topicId, String orderingKey) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.resumePublish, this.tagAttributeList);
        Struct response = new Struct();
        if (PubSubServiceUtils.isNullOrEmpty(orderingKey)) {
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.resumePublish, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Failure"));
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"MESSAGE_ORDERING_KEY_NULL_EMPTY"));
        }
        try {
            PublisherSettingsRequest publisherSettings;
            Publisher publisher;
            if (Objects.nonNull((Object)this.pubsubConfig) && (publisher = this.clientManager.getPublisher(topicId, publisherSettings = this.pubsubConfig.getPublisherSettings())) != null) {
                publisher.resumePublish(orderingKey);
            }
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("post", (String)response.get((Object)"STATUS"));
                rmdMap.put("topic", topicId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.resumePublish, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSubscription subscribe(Map subscriptionMetadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PubSubSubscription updateSubscription(Map subscriptionMetadata) {
        PubSubSubscriptionImpl pubSubSubscription;
        block21: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.updateSubscription, this.tagAttributeList);
            String status = "Success";
            pubSubSubscription = null;
            if (Objects.nonNull(subscriptionMetadata)) {
                SubscriptionMetadataRequest request = new SubscriptionMetadataRequest();
                this.filler.fillObject((Object)request, subscriptionMetadata, SubscriptionMetadataRequestConsumer.INSTANCE.getConsumerMap());
                String subscriptionId = request.getSubscriptionId();
                SubscriptionAdminSettings subscriptionAdminSettings = this.clientManager.getSubscriptionAdminSettings();
                try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
                    UpdateSubscriptionRequest updateSubscriptionRequest = this.updateSubscription(subscriptionId, request);
                    Subscription subscription = subscriptionAdminClient.updateSubscription(updateSubscriptionRequest);
                    pubSubSubscription = new PubSubSubscriptionImpl(this, this.clientManager, subscription);
                    break block21;
                }
                catch (NotFoundException nfe) {
                    this.validateIfProjectIDExists(nfe);
                    status = "Failure";
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_NOT_FOUND", (Object)subscriptionId), nfe);
                }
                catch (IOException e) {
                    status = "Failure";
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    status = "Failure";
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    if (tempAttributeList != null) {
                        Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("put", status);
                        rmdMap.put("subscription", subscriptionId);
                        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.updateSubscription, tempAttributeList, rmdMap);
                    }
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.updateSubscription, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("put", "Success"));
        }
        return pubSubSubscription;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSubscription getSubscription(String subscriptionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Struct listProjectSubscriptions() {
        return this.listProjectSubscriptions(null);
    }

    @Override
    public Struct listProjectSubscriptions(Map listMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.listProjectSubscriptions, this.tagAttributeList);
        Struct response = new Struct();
        SubscriptionAdminSettings subscriptionAdminSettings = this.clientManager.getSubscriptionAdminSettings();
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
            ListSubscriptionsRequest.Builder listSubscriptionsRequestBuilder = ListSubscriptionsRequest.newBuilder().setProject(this.nameTransformer.getProjectName());
            if (Objects.nonNull(listMetadata)) {
                PaginatedMetadataRequest request = new PaginatedMetadataRequest();
                this.filler.fillObject((Object)request, listMetadata, PaginatedMetadataRequestConsumer.INSTANCE.getConsumerMap());
                if (request.getPageSize() != null) {
                    listSubscriptionsRequestBuilder = listSubscriptionsRequestBuilder.setPageSize(request.getPageSize().intValue());
                }
                if (Objects.nonNull(request.getNextPageToken())) {
                    listSubscriptionsRequestBuilder = listSubscriptionsRequestBuilder.setPageToken(request.getNextPageToken());
                }
            }
            ListSubscriptionsRequest listSubscriptionsRequest = listSubscriptionsRequestBuilder.build();
            SubscriptionAdminClient.ListSubscriptionsPagedResponse listSubscriptionsPagedResponse = subscriptionAdminClient.listSubscriptions(listSubscriptionsRequest);
            SubscriptionAdminClient.ListSubscriptionsPage page = (SubscriptionAdminClient.ListSubscriptionsPage)listSubscriptionsPagedResponse.getPage();
            ArrayList subscriptions = Lists.newArrayList((Iterable)page.getValues());
            ArrayList<PubSubSubscriptionImpl> pubsubSubscriptions = new ArrayList<PubSubSubscriptionImpl>();
            for (Subscription subscription : subscriptions) {
                PubSubSubscriptionImpl pubsubSubscription = new PubSubSubscriptionImpl(this, this.clientManager, subscription);
                pubsubSubscriptions.add(pubsubSubscription);
            }
            response.put((Object)"STATUS", (Object)"Success");
            response.put((Object)"subscriptions", pubsubSubscriptions);
            if (!PubSubServiceUtils.isNullOrEmpty(listSubscriptionsPagedResponse.getNextPageToken())) {
                response.put((Object)"nextPageToken", (Object)listSubscriptionsPagedResponse.getNextPageToken());
            }
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.listProjectSubscriptions, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS")));
        }
        return response;
    }

    @Override
    public Struct listTopicSubscriptions(String topicId) {
        return this.listTopicSubscriptions(topicId, null);
    }

    @Override
    public Struct listTopicSubscriptions(String topicId, Map listMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.listTopicSubscriptions, this.tagAttributeList);
        String topicName = this.nameTransformer.getTopicName(topicId);
        Struct response = new Struct();
        TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
            ListTopicSubscriptionsRequest.Builder listTopicSubscriptionsRequestBuilder = ListTopicSubscriptionsRequest.newBuilder().setTopic(topicName);
            if (Objects.nonNull(listMetadata)) {
                PaginatedMetadataRequest request = new PaginatedMetadataRequest();
                this.filler.fillObject((Object)request, listMetadata, PaginatedMetadataRequestConsumer.INSTANCE.getConsumerMap());
                if (request.getPageSize() != null) {
                    listTopicSubscriptionsRequestBuilder = listTopicSubscriptionsRequestBuilder.setPageSize(request.getPageSize().intValue());
                }
                if (Objects.nonNull(request.getNextPageToken())) {
                    listTopicSubscriptionsRequestBuilder = listTopicSubscriptionsRequestBuilder.setPageToken(request.getNextPageToken());
                }
            }
            ListTopicSubscriptionsRequest listTopicSubscriptionsRequest = listTopicSubscriptionsRequestBuilder.build();
            TopicAdminClient.ListTopicSubscriptionsPagedResponse listTopicSubscriptionsPagedResponse = topicAdminClient.listTopicSubscriptions(listTopicSubscriptionsRequest);
            TopicAdminClient.ListTopicSubscriptionsPage page = (TopicAdminClient.ListTopicSubscriptionsPage)listTopicSubscriptionsPagedResponse.getPage();
            List<String> subscriptions = PubSubServiceUtils.getResourceIdList(page.getValues());
            response.put((Object)"STATUS", (Object)"Success");
            response.put((Object)"subscriptions", subscriptions);
            if (!PubSubServiceUtils.isNullOrEmpty(listTopicSubscriptionsPagedResponse.getNextPageToken())) {
                response.put((Object)"nextPageToken", (Object)listTopicSubscriptionsPagedResponse.getNextPageToken());
            }
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                rmdMap.put("topic", topicId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.listTopicSubscriptions, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    @Override
    public Struct detachSubscription(String subscriptionId) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.detachSubscription, this.tagAttributeList);
        String subscriptionName = this.nameTransformer.getSubscriptionName(subscriptionId);
        Struct response = new Struct();
        TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
            DetachSubscriptionRequest detachSubscriptionRequest = DetachSubscriptionRequest.newBuilder().setSubscription(subscriptionName).build();
            topicAdminClient.detachSubscription(detachSubscriptionRequest);
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (NotFoundException nfe) {
            this.validateIfProjectIDExists(nfe);
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_NOT_FOUND", (Object)subscriptionId), nfe);
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                rmdMap.put("subscription", subscriptionId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.detachSubscription, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    @Override
    public Struct deleteSubscription(String subscriptionId) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.deleteSubscription, this.tagAttributeList);
        String subscriptionName = this.nameTransformer.getSubscriptionName(subscriptionId);
        Struct response = new Struct();
        SubscriptionAdminSettings subscriptionAdminSettings = this.clientManager.getSubscriptionAdminSettings();
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
            DeleteSubscriptionRequest deleteSubscriptionRequest = DeleteSubscriptionRequest.newBuilder().setSubscription(subscriptionName).build();
            subscriptionAdminClient.deleteSubscription(deleteSubscriptionRequest);
            this.clientManager.deleteSubscriber(subscriptionId);
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (NotFoundException nfe) {
            this.validateIfProjectIDExists(nfe);
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_NOT_FOUND", (Object)subscriptionId), nfe);
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("delete", (String)response.get((Object)"STATUS"));
                rmdMap.put("subscription", subscriptionId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.deleteSubscription, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    @Override
    public Struct pullMessages(Map pullMessageMetadata) {
        Struct response;
        block28: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.pullMessages, this.tagAttributeList);
            response = new Struct();
            if (pullMessageMetadata != null) {
                MessagePullRequest request = new MessagePullRequest();
                this.filler.fillObject((Object)request, pullMessageMetadata, MessagePullRequestConsumer.INSTANCE.getConsumerMap());
                String subscriptionName = this.nameTransformer.getSubscriptionName(request.getSubscriptionId());
                PullRequest.Builder pullRequestBuilder = PullRequest.newBuilder().setSubscription(subscriptionName);
                if (request.isReturnImmediately() != null) {
                    boolean returnImmediately = request.isReturnImmediately();
                    pullRequestBuilder = pullRequestBuilder.setReturnImmediately(returnImmediately);
                }
                if (request.getMaxMessages() != null) {
                    int maxMessages = request.getMaxMessages();
                    pullRequestBuilder = pullRequestBuilder.setMaxMessages(maxMessages);
                }
                PullRequest pullRequest = pullRequestBuilder.build();
                try {
                    SubscriberStubSettings subscriberStubSettings = this.clientManager.getSubscriberStubSettings();
                    try (GrpcSubscriberStub subscriber = GrpcSubscriberStub.create((SubscriberStubSettings)subscriberStubSettings);){
                        ArrayList<Struct> receivedMessages = new ArrayList<Struct>();
                        PullResponse pullResponse = (PullResponse)subscriber.pullCallable().call((Object)pullRequest);
                        List receivedMessagesList = pullResponse.getReceivedMessagesList();
                        if (receivedMessagesList.isEmpty()) {
                            response.put((Object)"STATUS", (Object)"Success");
                            response.put((Object)"messages", receivedMessages);
                            Struct struct = response;
                            return struct;
                        }
                        for (ReceivedMessage message : receivedMessagesList) {
                            ReceivedPubSubMessage receivedMessage = new ReceivedPubSubMessage(message);
                            receivedMessages.add(PubSubServiceUtils.deserialize(receivedMessage));
                        }
                        response.put((Object)"STATUS", (Object)"Success");
                        response.put((Object)"messages", receivedMessages);
                        break block28;
                    }
                }
                catch (IOException e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    if (tempAttributeList != null) {
                        Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                        rmdMap.put("subscription", request.getSubscriptionId());
                        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.pullMessages, tempAttributeList, rmdMap);
                    }
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.pullMessages, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Success"));
        }
        return response;
    }

    @Override
    public Struct acknowledgeMessages(Map acknowledgeMetadata) {
        Struct response;
        block21: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.acknowledgeMessages, this.tagAttributeList);
            response = new Struct();
            if (acknowledgeMetadata != null) {
                MessageAcknowledgeRequest request = new MessageAcknowledgeRequest();
                this.filler.fillObject((Object)request, acknowledgeMetadata, MessageAcknowledgeRequestConsumer.INSTANCE.getConsumerMap());
                String subscriptionName = this.nameTransformer.getSubscriptionName(request.getSubscriptionId());
                AcknowledgeRequest.Builder acknowledgeRequestBuilder = AcknowledgeRequest.newBuilder().setSubscription(subscriptionName);
                if (request.getAckIds() != null) {
                    acknowledgeRequestBuilder = acknowledgeRequestBuilder.addAllAckIds(request.getAckIds());
                }
                AcknowledgeRequest acknowledgeRequest = acknowledgeRequestBuilder.build();
                try {
                    SubscriberStubSettings subscriberStubSettings = this.clientManager.getSubscriberStubSettings();
                    try (GrpcSubscriberStub subscriber = GrpcSubscriberStub.create((SubscriberStubSettings)subscriberStubSettings);){
                        subscriber.acknowledgeCallable().call((Object)acknowledgeRequest);
                        response.put((Object)"STATUS", (Object)"Success");
                        break block21;
                    }
                }
                catch (IOException e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    if (tempAttributeList != null) {
                        Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                        rmdMap.put("subscription", request.getSubscriptionId());
                        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.acknowledgeMessages, tempAttributeList, rmdMap);
                    }
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.acknowledgeMessages, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Success"));
        }
        return response;
    }

    @Override
    public Struct modifyAckDeadline(Map modifyAckDeadlineMetadata) {
        Struct response;
        block22: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.modifyAckDeadline, this.tagAttributeList);
            response = new Struct();
            if (modifyAckDeadlineMetadata != null) {
                ModifyMessageAckDeadlineRequest request = new ModifyMessageAckDeadlineRequest();
                this.filler.fillObject((Object)request, modifyAckDeadlineMetadata, ModifyMessageAckDeadlineRequestConsumer.INSTANCE.getConsumerMap());
                String subscriptionName = this.nameTransformer.getSubscriptionName(request.getSubscriptionId());
                ModifyAckDeadlineRequest.Builder modifyAckDeadlineRequestBuilder = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscriptionName);
                if (request.getAckIds() != null) {
                    modifyAckDeadlineRequestBuilder = modifyAckDeadlineRequestBuilder.addAllAckIds(request.getAckIds());
                }
                if (request.getAckDeadlineSeconds() != null) {
                    modifyAckDeadlineRequestBuilder = modifyAckDeadlineRequestBuilder.setAckDeadlineSeconds(request.getAckDeadlineSeconds().intValue());
                }
                ModifyAckDeadlineRequest modifyAckDeadlineRequest = modifyAckDeadlineRequestBuilder.build();
                try {
                    SubscriberStubSettings subscriberStubSettings = this.clientManager.getSubscriberStubSettings();
                    try (GrpcSubscriberStub subscriber = GrpcSubscriberStub.create((SubscriberStubSettings)subscriberStubSettings);){
                        subscriber.modifyAckDeadlineCallable().call((Object)modifyAckDeadlineRequest);
                        response.put((Object)"STATUS", (Object)"Success");
                        break block22;
                    }
                }
                catch (IOException e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    if (tempAttributeList != null) {
                        Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("put", (String)response.get((Object)"STATUS"));
                        rmdMap.put("subscription", request.getSubscriptionId());
                        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.modifyAckDeadline, tempAttributeList, rmdMap);
                    }
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.modifyAckDeadline, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("put", "Success"));
        }
        return response;
    }

    @Override
    public Struct seekMessages(Map seekMessageMetadata) {
        Struct response;
        block24: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.seekMessages, this.tagAttributeList);
            response = new Struct();
            if (seekMessageMetadata != null) {
                MessageSeekRequest request = new MessageSeekRequest();
                this.filler.fillObject((Object)request, seekMessageMetadata, MessageSeekRequestConsumer.INSTANCE.getConsumerMap());
                String subscriptionName = this.nameTransformer.getSubscriptionName(request.getSubscriptionId());
                SeekRequest.Builder seekRequestBuilder = SeekRequest.newBuilder().setSubscription(subscriptionName);
                if (request.getSnapshotId() == null && request.getTimestamp() == null) {
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SEEK_MESSAGE_SNAPSHOT_OR_TIMESTAMP_MISSING_VALIDATION_ERROR"));
                }
                if (request.getSnapshotId() != null && request.getTimestamp() != null) {
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SEEK_MESSAGE_SNAPSHOT_OR_TIMESTAMP_VALIDATION_ERROR"));
                }
                if (request.getSnapshotId() != null) {
                    String snapshotName = this.nameTransformer.getSnapshotName(request.getSnapshotId());
                    seekRequestBuilder = seekRequestBuilder.setSnapshot(snapshotName);
                }
                if (request.getTimestamp() != null) {
                    Timestamp timestamp = PubSubServiceUtils.getTimestampFromOleDateTime(request.getTimestamp());
                    seekRequestBuilder = seekRequestBuilder.setTime(timestamp);
                }
                SeekRequest seekRequest = seekRequestBuilder.build();
                try {
                    SubscriberStubSettings subscriberStubSettings = this.clientManager.getSubscriberStubSettings();
                    try (GrpcSubscriberStub subscriber = GrpcSubscriberStub.create((SubscriberStubSettings)subscriberStubSettings);){
                        subscriber.seekCallable().call((Object)seekRequest);
                        response.put((Object)"STATUS", (Object)"Success");
                        break block24;
                    }
                }
                catch (IOException e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    if (tempAttributeList != null) {
                        Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                        rmdMap.put("subscription", request.getSubscriptionId());
                        rmdMap.put("snapshot", request.getSnapshotId());
                        PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.seekMessages, tempAttributeList, rmdMap);
                    }
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.seekMessages, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Success"));
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSnapshot createSnapshot(Map snapshotMetadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSnapshot getSnapshot(String snapshotId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSnapshot updateSnapshot(Map snapshotMetadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Struct listProjectSnapshots() {
        return this.listProjectSnapshots(null);
    }

    @Override
    public Struct listProjectSnapshots(Map listMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.listProjectSnapshots, this.tagAttributeList);
        Struct response = new Struct();
        SubscriptionAdminSettings subscriptionAdminSettings = this.clientManager.getSubscriptionAdminSettings();
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
            ListSnapshotsRequest.Builder listSnapshotsRequestBuilder = ListSnapshotsRequest.newBuilder().setProject(this.nameTransformer.getProjectName());
            if (Objects.nonNull(listMetadata)) {
                PaginatedMetadataRequest request = new PaginatedMetadataRequest();
                this.filler.fillObject((Object)request, listMetadata, PaginatedMetadataRequestConsumer.INSTANCE.getConsumerMap());
                if (request.getPageSize() != null) {
                    listSnapshotsRequestBuilder = listSnapshotsRequestBuilder.setPageSize(request.getPageSize().intValue());
                }
                if (request.getNextPageToken() != null) {
                    listSnapshotsRequestBuilder = listSnapshotsRequestBuilder.setPageToken(request.getNextPageToken());
                }
            }
            ListSnapshotsRequest listSnapshotsRequest = listSnapshotsRequestBuilder.build();
            SubscriptionAdminClient.ListSnapshotsPagedResponse listSnapshotsPagedResponse = subscriptionAdminClient.listSnapshots(listSnapshotsRequest);
            SubscriptionAdminClient.ListSnapshotsPage page = (SubscriptionAdminClient.ListSnapshotsPage)listSnapshotsPagedResponse.getPage();
            ArrayList snapshots = Lists.newArrayList((Iterable)page.getValues());
            ArrayList<PubSubSnapshotImpl> pubsubSnapshots = new ArrayList<PubSubSnapshotImpl>();
            for (Snapshot snapshot : snapshots) {
                PubSubSnapshotImpl pubsubSnapshot = new PubSubSnapshotImpl(this, snapshot);
                pubsubSnapshots.add(pubsubSnapshot);
            }
            response.put((Object)"STATUS", (Object)"Success");
            response.put((Object)"snapshots", pubsubSnapshots);
            if (!PubSubServiceUtils.isNullOrEmpty(listSnapshotsPagedResponse.getNextPageToken())) {
                response.put((Object)"nextPageToken", (Object)listSnapshotsPagedResponse.getNextPageToken());
            }
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.listProjectSnapshots, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS")));
        }
        return response;
    }

    @Override
    public Struct listTopicSnapshots(String topicId) {
        return this.listTopicSnapshots(topicId, null);
    }

    @Override
    public Struct listTopicSnapshots(String topicId, Map listMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.listTopicSnapshots, this.tagAttributeList);
        String topicName = this.nameTransformer.getTopicName(topicId);
        Struct response = new Struct();
        TopicAdminSettings topicAdminSettings = this.clientManager.getTopicAdminSettings();
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
            ListTopicSnapshotsRequest.Builder listTopicSnapshotsRequestBuilder = ListTopicSnapshotsRequest.newBuilder().setTopic(topicName);
            if (Objects.nonNull(listMetadata)) {
                PaginatedMetadataRequest request = new PaginatedMetadataRequest();
                this.filler.fillObject((Object)request, listMetadata, PaginatedMetadataRequestConsumer.INSTANCE.getConsumerMap());
                if (request.getPageSize() != null) {
                    listTopicSnapshotsRequestBuilder = listTopicSnapshotsRequestBuilder.setPageSize(request.getPageSize().intValue());
                }
                if (request.getNextPageToken() != null) {
                    listTopicSnapshotsRequestBuilder = listTopicSnapshotsRequestBuilder.setPageToken(request.getNextPageToken());
                }
            }
            ListTopicSnapshotsRequest listTopicSnapshotsRequest = listTopicSnapshotsRequestBuilder.build();
            TopicAdminClient.ListTopicSnapshotsPagedResponse listTopicSnapshotsPagedResponse = topicAdminClient.listTopicSnapshots(listTopicSnapshotsRequest);
            TopicAdminClient.ListTopicSnapshotsPage page = (TopicAdminClient.ListTopicSnapshotsPage)listTopicSnapshotsPagedResponse.getPage();
            List<String> snapshots = PubSubServiceUtils.getResourceIdList(page.getValues());
            response.put((Object)"STATUS", (Object)"Success");
            response.put((Object)"snapshots", snapshots);
            if (!PubSubServiceUtils.isNullOrEmpty(listTopicSnapshotsPagedResponse.getNextPageToken())) {
                response.put((Object)"nextPageToken", (Object)listTopicSnapshotsPagedResponse.getNextPageToken());
            }
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS"));
                rmdMap.put("topic", topicId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.listTopicSnapshots, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    @Override
    public Struct deleteSnapshot(String snapshotId) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.deleteSnapshot, this.tagAttributeList);
        Struct response = new Struct();
        String snapshotName = this.nameTransformer.getSnapshotName(snapshotId);
        SubscriptionAdminSettings subscriptionAdminSettings = this.clientManager.getSubscriptionAdminSettings();
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
            DeleteSnapshotRequest deleteSnapshotRequest = DeleteSnapshotRequest.newBuilder().setSnapshot(snapshotName).build();
            subscriptionAdminClient.deleteSnapshot(deleteSnapshotRequest);
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (NotFoundException nfe) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_NOT_FOUND", (Object)snapshotId), nfe);
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            if (tempAttributeList != null) {
                Map<String, String> rmdMap = PMTUtilsForGCPPubSub.getMonitoringResponseMap("delete", (String)response.get((Object)"STATUS"));
                rmdMap.put("snapshot", snapshotId);
                PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.deleteSnapshot, tempAttributeList, rmdMap);
            }
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSchema createSchema(Map schemaMetadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PubSubSchema getSchema(String schemaId) {
        return this.getSchema(schemaId, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public PubSubSchema getSchema(String schemaId, String schemaView) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Struct listSchemas() {
        return this.listSchemas(null);
    }

    @Override
    public Struct listSchemas(Map listMetadata) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.listSchemas, this.tagAttributeList);
        Struct response = new Struct();
        SchemaServiceSettings schemaServiceSettings = this.clientManager.getSchemaServiceSettings();
        try (SchemaServiceClient schemaServiceClient = SchemaServiceClient.create((SchemaServiceSettings)schemaServiceSettings);){
            ListSchemasRequest.Builder listSchemasRequestBuilder = ListSchemasRequest.newBuilder().setParent(this.nameTransformer.getProjectName());
            if (Objects.nonNull(listMetadata)) {
                PaginatedMetadataRequest request = new PaginatedMetadataRequest();
                this.filler.fillObject((Object)request, listMetadata, PaginatedMetadataRequestConsumer.INSTANCE.getConsumerMap());
                if (request.getPageSize() != null) {
                    listSchemasRequestBuilder = listSchemasRequestBuilder.setPageSize(request.getPageSize().intValue());
                }
                if (request.getNextPageToken() != null) {
                    listSchemasRequestBuilder = listSchemasRequestBuilder.setPageToken(request.getNextPageToken());
                }
                if (request.getSchemaView() != null) {
                    SchemaView view = request.getSchemaView();
                    listSchemasRequestBuilder = listSchemasRequestBuilder.setView(view);
                }
            }
            ListSchemasRequest listSchemasRequest = listSchemasRequestBuilder.build();
            SchemaServiceClient.ListSchemasPagedResponse listSchemasPagedResponse = schemaServiceClient.listSchemas(listSchemasRequest);
            SchemaServiceClient.ListSchemasPage page = (SchemaServiceClient.ListSchemasPage)listSchemasPagedResponse.getPage();
            ArrayList schemas = Lists.newArrayList((Iterable)page.getValues());
            ArrayList<PubSubSchemaImpl> pubsubSchemas = new ArrayList<PubSubSchemaImpl>();
            for (Schema schema : schemas) {
                PubSubSchemaImpl pubsubSchema = new PubSubSchemaImpl(this, schema);
                pubsubSchemas.add(pubsubSchema);
            }
            response.put((Object)"STATUS", (Object)"Success");
            response.put((Object)"schemas", pubsubSchemas);
            if (!PubSubServiceUtils.isNullOrEmpty(listSchemasPagedResponse.getNextPageToken())) {
                response.put((Object)"nextPageToken", (Object)listSchemasPagedResponse.getNextPageToken());
            }
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.listSchemas, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS")));
        }
        return response;
    }

    @Override
    public Struct validateSchema(Map schemaMetadata) {
        Struct response;
        block20: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.validateSchema, this.tagAttributeList);
            response = new Struct();
            if (schemaMetadata != null) {
                SchemaMetadataRequest request = new SchemaMetadataRequest();
                this.filler.fillObject((Object)request, schemaMetadata, SchemaMetadataRequestConsumer.INSTANCE.getConsumerMap());
                String schemaId = request.getSchemaId();
                String schemaName = this.nameTransformer.getSchemaName(schemaId);
                Schema.Type schemaType = request.getSchemaType();
                String schemaDefinition = request.getSchemaDefinition();
                SchemaServiceSettings schemaServiceSettings = this.clientManager.getSchemaServiceSettings();
                try (SchemaServiceClient schemaServiceClient = SchemaServiceClient.create((SchemaServiceSettings)schemaServiceSettings);){
                    Schema validateSchema = Schema.newBuilder().setName(schemaName).setType(schemaType).setDefinition(schemaDefinition).build();
                    ValidateSchemaRequest.Builder validateSchemaRequestBuilder = ValidateSchemaRequest.newBuilder().setParent(this.nameTransformer.getProjectName()).setSchema(validateSchema);
                    schemaServiceClient.validateSchema(validateSchemaRequestBuilder.build());
                    response.put((Object)"STATUS", (Object)"Success");
                    break block20;
                }
                catch (NotFoundException nfe) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_NOT_FOUND", (Object)schemaId), nfe);
                }
                catch (IOException e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    this.handleInvalidSchemaDefinitionError(schemaDefinition, e);
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.validateSchema, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS")));
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.validateSchema, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Failure"));
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_METADATA_MAP_NOT_PROVIDED"));
        }
        return response;
    }

    @Override
    public Struct validateMessage(Map messageValidateMetadata) {
        Struct response;
        block20: {
            TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.validateMessage, this.tagAttributeList);
            response = new Struct();
            if (messageValidateMetadata != null) {
                MessageValidateRequest request = new MessageValidateRequest();
                this.filler.fillObject((Object)request, messageValidateMetadata, MessageValidateRequestConsumer.INSTANCE.getConsumerMap());
                String schemaId = request.getSchemaId();
                String schemaName = this.nameTransformer.getSchemaName(schemaId);
                Encoding schemaEncoding = request.getSchemaEncoding();
                Object data = request.getData();
                SchemaServiceSettings schemaServiceSettings = this.clientManager.getSchemaServiceSettings();
                try (SchemaServiceClient schemaServiceClient = SchemaServiceClient.create((SchemaServiceSettings)schemaServiceSettings);){
                    ByteString message = PubSubMessageSerializer.serialize(data);
                    ValidateMessageRequest.Builder validateMessageRequestBuilder = ValidateMessageRequest.newBuilder().setParent(this.nameTransformer.getProjectName()).setName(schemaName).setEncoding(schemaEncoding).setMessage(message);
                    schemaServiceClient.validateMessage(validateMessageRequestBuilder.build());
                    response.put((Object)"STATUS", (Object)"Success");
                    break block20;
                }
                catch (NotFoundException nfe) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_NOT_FOUND", (Object)schemaId), nfe);
                }
                catch (IOException e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                catch (Exception e) {
                    response.put((Object)"STATUS", (Object)"Failure");
                    throw new PubSubException(e.getMessage(), e);
                }
                finally {
                    PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.validateMessage, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", (String)response.get((Object)"STATUS")));
                }
            }
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.validateMessage, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("get", "Failure"));
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_METADATA_MAP_NOT_PROVIDED"));
        }
        return response;
    }

    @Override
    public Struct deleteSchema(String schemaId) {
        TagAttributeList tempAttributeList = PMTUtilsForGCPPubSub.startGCPPubSubMonitoring(PubSubApis.deleteSchema, this.tagAttributeList);
        Struct response = new Struct();
        String schemaName = this.nameTransformer.getSchemaName(schemaId);
        SchemaServiceSettings schemaServiceSettings = this.clientManager.getSchemaServiceSettings();
        try (SchemaServiceClient schemaServiceClient = SchemaServiceClient.create((SchemaServiceSettings)schemaServiceSettings);){
            DeleteSchemaRequest deleteSchemaRequest = DeleteSchemaRequest.newBuilder().setName(schemaName).build();
            schemaServiceClient.deleteSchema(deleteSchemaRequest);
            response.put((Object)"STATUS", (Object)"Success");
        }
        catch (NotFoundException nfe) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_NOT_FOUND", (Object)schemaId), nfe);
        }
        catch (IOException e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        catch (Exception e) {
            response.put((Object)"STATUS", (Object)"Failure");
            throw new PubSubException(e.getMessage(), e);
        }
        finally {
            PMTUtilsForGCPPubSub.endGCPPubSubMonitoring(PubSubApis.deleteSchema, tempAttributeList, PMTUtilsForGCPPubSub.getMonitoringResponseMap("delete", (String)response.get((Object)"STATUS")));
        }
        return response;
    }

    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        if (methodName != null) {
            switch (methodName.toLowerCase()) {
                case "createtopic": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.createTopic(Cast._String((Object)args[0]));
                    }
                    if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof Map) {
                        return this.createTopic(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_CREATE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "gettopic": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.getTopic(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_GET_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "updatetopic": {
                    if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof Map) {
                        return this.updateTopic(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_UPDATE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "listtopics": {
                    if (args != null && args.length == 0) {
                        return this.listTopics();
                    }
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.listTopics(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_LIST_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "deletetopic": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.deleteTopic(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_DELETE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "getiampolicy": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.getIAMPolicy(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"POLICY_IAM_GET_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "setiampolicy": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.setIAMPolicy(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"POLICY_IAM_SET_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "addiampolicy": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.addIAMPolicy(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"POLICY_IAM_ADD_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "testiampermissions": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.testIAMPermissions(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"POLICY_IAM_TEST_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "publish": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.publish(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"PUBLISH_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "publishalloutstanding": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.publishAllOutstanding(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"PUBLISH_ALL_OUTSTANDING_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "resumepublish": {
                    if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof String) {
                        return this.resumePublish(Cast._String((Object)args[0]), Cast._String((Object)args[1]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"PUBLISH_RESUME_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "subscribe": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.subscribe(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIBER_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "getsubscription": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.getSubscription(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_GET_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "updatesubscription": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.updateSubscription(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_UPDATE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "listprojectsubscriptions": {
                    if (args != null && args.length == 0) {
                        return this.listProjectSubscriptions();
                    }
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.listProjectSubscriptions(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_LIST_PROJECT_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "listtopicsubscriptions": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.listTopicSubscriptions(Cast._String((Object)args[0]));
                    }
                    if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof Map) {
                        return this.listTopicSubscriptions(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_LIST_TOPIC_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "detachsubscription": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.detachSubscription(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_DETACH_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "deletesubscription": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.deleteSubscription(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_DELETE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "pullmessages": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.pullMessages(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_PULL_MESSAGES_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "acknowledgemessages": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.acknowledgeMessages(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_ACKNOWLEDGE_MESSAGES_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "modifyackdeadline": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.modifyAckDeadline(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_MODIFY_ACK_DEADLINE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "seekmessages": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.seekMessages(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_SEEK_MESSAGES_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "createsnapshot": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.createSnapshot(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_CREATE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "getsnapshot": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.getSnapshot(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_GET_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "updatesnapshot": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.updateSnapshot(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_UPDATE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "listprojectsnapshots": {
                    if (args != null && args.length == 0) {
                        return this.listProjectSnapshots();
                    }
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.listProjectSnapshots(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_LIST_PROJECT_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "listtopicsnapshots": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.listTopicSnapshots(Cast._String((Object)args[0]));
                    }
                    if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof Map) {
                        return this.listTopicSnapshots(Cast._String((Object)args[0]), Cast._Map((Object)args[1]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_LIST_TOPIC_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "deletesnapshot": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.deleteSnapshot(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_DELETE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "createschema": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.createSchema(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_CREATE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "getschema": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.getSchema(Cast._String((Object)args[0]));
                    }
                    if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof String) {
                        return this.getSchema(Cast._String((Object)args[0]), Cast._String((Object)args[1]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_GET_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "listschemas": {
                    if (args != null && args.length == 0) {
                        return this.listSchemas();
                    }
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.listSchemas(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_LIST_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "validateschema": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.validateSchema(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_VALIDATE_SCHEMA_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "validatemessage": {
                    if (args != null && args.length == 1 && args[0] instanceof Map) {
                        return this.validateMessage(Cast._Map((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_VALIDATE_MESSAGE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
                case "deleteschema": {
                    if (args != null && args.length == 1 && args[0] instanceof String) {
                        return this.deleteSchema(Cast._String((Object)args[0]));
                    }
                    throw new IllegalArgumentException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_DELETE_METHOD_NOT_FOUND_ERROR", (Object)methodName));
                }
            }
            Object val = super.invoke(methodName, args, pageContext);
            if (val != ObjectHandledInvokable.OBJECT_METHOD_NOT_FOUND) {
                return val;
            }
        }
        throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"METHOD_NOT_FOUND_ERROR", (Object)methodName));
    }

    private String inspectPolicyResourceType(String resourceName, ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: {
                return this.nameTransformer.getTopicName(resourceName);
            }
            case SUBSCRIPTION: {
                return this.nameTransformer.getSubscriptionName(resourceName);
            }
            case SNAPSHOT: {
                return this.nameTransformer.getSnapshotName(resourceName);
            }
        }
        throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"INVALID_RESOURCE_TYPE", (Object)((Object)resourceType)));
    }

    private SchemaView getSchemaView(String schemaView) {
        GenericEnumValidator enumValidator = new GenericEnumValidator(SchemaView.class, "schemaView");
        enumValidator.validate((Object)schemaView);
        return SchemaView.valueOf((String)schemaView.toUpperCase());
    }

    private SchemaSettings getSchemaSettings(TopicMetadataRequest request) {
        TopicMetadataSchemaSettingsRequest schemaSettingsRequest = request.getSchemaSettings();
        SchemaSettings.Builder schemaSettingsBuilder = SchemaSettings.newBuilder();
        if (schemaSettingsRequest.getSchemaName() != null) {
            String schemaId = schemaSettingsRequest.getSchemaName();
            String schemaName = this.nameTransformer.getSchemaName(schemaId);
            schemaSettingsBuilder = schemaSettingsBuilder.setSchema(schemaName);
        }
        if (schemaSettingsRequest.getSchemaEncoding() != null) {
            Encoding schemaEncoding = schemaSettingsRequest.getSchemaEncoding();
            schemaSettingsBuilder = schemaSettingsBuilder.setEncoding(schemaEncoding);
        }
        return schemaSettingsBuilder.build();
    }

    private PubsubMessage processMessage(MessagePublishRequest request) {
        PubsubMessage pubsubMessage = null;
        if (request.getMessage() != null) {
            PubSubMessageRequest pubsubMessageRequest = request.getMessage();
            PubsubMessage.Builder messageBuilder = PubsubMessage.newBuilder();
            if (pubsubMessageRequest.getData() != null) {
                ByteString message = PubSubMessageSerializer.serialize(pubsubMessageRequest.getData(), pubsubMessageRequest.getSerializeCFC());
                messageBuilder = messageBuilder.setData(message);
            }
            if (pubsubMessageRequest.getOrderingKey() != null) {
                messageBuilder = messageBuilder.setOrderingKey(pubsubMessageRequest.getOrderingKey());
            }
            if (pubsubMessageRequest.getAttributes() != null) {
                messageBuilder = messageBuilder.putAllAttributes(pubsubMessageRequest.getAttributes());
            }
            pubsubMessage = messageBuilder.build();
        }
        return pubsubMessage;
    }

    private Subscription createSubscription(String subscriptionName, String topicName, SubscriptionMetadataRequest request) {
        Subscription subscription = null;
        Subscription.Builder subscriptionBuilder = Subscription.newBuilder();
        subscriptionBuilder = subscriptionBuilder.setName(subscriptionName);
        subscriptionBuilder = subscriptionBuilder.setTopic(topicName);
        subscriptionBuilder = this.getDeliveryConfig(request, subscriptionBuilder);
        if (request.getDeadLetterPolicy() != null) {
            DeadLetterPolicy deadLetterPolicy = this.getDeadLetterPolicy(request.getDeadLetterPolicy());
            subscriptionBuilder = subscriptionBuilder.setDeadLetterPolicy(deadLetterPolicy);
        }
        if (request.getExpirationPolicy() != null) {
            ExpirationPolicy expirationPolicy = this.getExpirationPolicy(request.getExpirationPolicy());
            subscriptionBuilder = subscriptionBuilder.setExpirationPolicy(expirationPolicy);
        }
        if (request.getRetryPolicy() != null) {
            RetryPolicy retryPolicy = this.getRetryPolicy(request.getRetryPolicy());
            subscriptionBuilder = subscriptionBuilder.setRetryPolicy(retryPolicy);
        }
        if (request.getMessageRetentionDuration() != null) {
            subscriptionBuilder = subscriptionBuilder.setMessageRetentionDuration(request.getMessageRetentionDuration());
        }
        if (request.getLabels() != null) {
            subscriptionBuilder = subscriptionBuilder.putAllLabels(request.getLabels());
        }
        if (request.getFilter() != null) {
            subscriptionBuilder = subscriptionBuilder.setFilter(request.getFilter());
        }
        if (request.getAckDeadlineSeconds() != null) {
            subscriptionBuilder = subscriptionBuilder.setAckDeadlineSeconds(request.getAckDeadlineSeconds().intValue());
        }
        if (request.getEnableExactlyOnceDelivery() != null) {
            SubscriptionMetadataDeliveryConfigRequest deliveryConfigRequest = request.getDeliveryConfig();
            if (deliveryConfigRequest != null && deliveryConfigRequest.getType() != DeliveryType.PULL) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"CREATE_SUBSCRIPTION_ENABLE_EXACTLY_ONCE_DELIVERY"));
            }
            subscriptionBuilder = subscriptionBuilder.setEnableExactlyOnceDelivery(request.getEnableExactlyOnceDelivery().booleanValue());
            subscriptionBuilder = subscriptionBuilder.setEnableExactlyOnceDelivery(request.getEnableExactlyOnceDelivery().booleanValue());
        }
        if (request.getEnableMessageOrdering() != null) {
            subscriptionBuilder = subscriptionBuilder.setEnableMessageOrdering(request.getEnableMessageOrdering().booleanValue());
        }
        if (request.getRetainAckedMessages() != null) {
            subscriptionBuilder = subscriptionBuilder.setRetainAckedMessages(request.getRetainAckedMessages().booleanValue());
        }
        subscription = subscriptionBuilder.build();
        return subscription;
    }

    private UpdateSubscriptionRequest updateSubscription(String subscriptionId, SubscriptionMetadataRequest request) {
        UpdateSubscriptionRequest updateSubscriptionRequest = null;
        Subscription.Builder subscriptionBuilder = Subscription.newBuilder();
        ArrayList<String> fieldMasks = new ArrayList<String>();
        if (Objects.nonNull(request)) {
            String subscriptionName = this.nameTransformer.getSubscriptionName(subscriptionId);
            subscriptionBuilder = subscriptionBuilder.setName(subscriptionName);
            if (request.getTopicId() != null) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"UPDATE_SUBSCRIPTION_TOPIC"));
            }
            if (request.getDeliveryConfig() != null) {
                SubscriptionMetadataDeliveryConfigRequest deliveryConfig = request.getDeliveryConfig();
                DeliveryType deliveryType = deliveryConfig.getType();
                switch (deliveryType) {
                    case PULL: {
                        subscriptionBuilder = subscriptionBuilder.setPushConfig(PushConfig.getDefaultInstance());
                        fieldMasks.add("push_config");
                        break;
                    }
                    case PUSH: {
                        if (deliveryConfig.getPushConfig() != null) {
                            PushConfig pushConfig = this.getPushConfig(deliveryConfig.getPushConfig());
                            subscriptionBuilder = subscriptionBuilder.setPushConfig(pushConfig);
                            fieldMasks.add("push_config");
                            break;
                        }
                    }
                    case BIGQUERY: {
                        if (deliveryConfig.getBigQueryConfig() != null) {
                            BigQueryConfig bigQueryConfig = this.getBigQueryConfig(deliveryConfig.getBigQueryConfig());
                            subscriptionBuilder = subscriptionBuilder.setBigqueryConfig(bigQueryConfig);
                            fieldMasks.add("bigquery_config");
                            break;
                        }
                    }
                    default: {
                        throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_DELIVERY_TYPE_VALIDATION", (Object)deliveryType.toString()));
                    }
                }
            }
            if (request.getDeadLetterPolicy() != null) {
                SubscriptionMetadataDeadLetterPolicyRequest deadLetterPolicyRequest = request.getDeadLetterPolicy();
                if (deadLetterPolicyRequest.isEnabled().booleanValue()) {
                    DeadLetterPolicy deadLetterPolicy = this.getDeadLetterPolicy(deadLetterPolicyRequest);
                    subscriptionBuilder = subscriptionBuilder.setDeadLetterPolicy(deadLetterPolicy);
                }
                fieldMasks.add("dead_letter_policy");
            }
            if (request.getExpirationPolicy() != null) {
                SubscriptionMetadataExpirationPolicyRequest expirationPolicyRequest = request.getExpirationPolicy();
                if (expirationPolicyRequest.isEnabled() != null) {
                    ExpirationPolicy expirationPolicy = this.getExpirationPolicy(expirationPolicyRequest);
                    subscriptionBuilder = subscriptionBuilder.setExpirationPolicy(expirationPolicy);
                }
                fieldMasks.add("expiration_policy");
            }
            if (request.getRetryPolicy() != null) {
                SubscriptionMetadataRetryPolicyRequest retryPolicyRequest = request.getRetryPolicy();
                if (retryPolicyRequest.isEnabled().booleanValue()) {
                    RetryPolicy retryPolicy = this.getRetryPolicy(retryPolicyRequest);
                    subscriptionBuilder = subscriptionBuilder.setRetryPolicy(retryPolicy);
                }
                fieldMasks.add("retry_policy");
            }
            if (request.getMessageRetentionDuration() != null) {
                subscriptionBuilder = subscriptionBuilder.setMessageRetentionDuration(request.getMessageRetentionDuration());
                fieldMasks.add("message_retention_duration");
            }
            if (request.getLabels() != null) {
                subscriptionBuilder = subscriptionBuilder.putAllLabels(request.getLabels());
                fieldMasks.add("labels");
            }
            if (request.getFilter() != null) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"UPDATE_SUBSCRIPTION_FILTER"));
            }
            if (request.getAckDeadlineSeconds() != null) {
                subscriptionBuilder = subscriptionBuilder.setAckDeadlineSeconds(request.getAckDeadlineSeconds().intValue());
                fieldMasks.add("ack_deadline_seconds");
            }
            if (request.getEnableExactlyOnceDelivery() != null) {
                SubscriptionMetadataDeliveryConfigRequest deliveryConfigRequest = request.getDeliveryConfig();
                if (deliveryConfigRequest == null || deliveryConfigRequest.getType() == DeliveryType.PULL) {
                    subscriptionBuilder = subscriptionBuilder.setEnableExactlyOnceDelivery(request.getEnableExactlyOnceDelivery().booleanValue());
                    fieldMasks.add("enable_exactly_once_delivery");
                } else {
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"UPDATE_SUBSCRIPTION_ENABLE_EXACTLY_ONCE_DELIVERY"));
                }
            }
            if (request.getEnableMessageOrdering() != null) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"UPDATE_SUBSCRIPTION_ENABLE_MESSAGE_ORDERING"));
            }
            if (request.getRetainAckedMessages() != null) {
                subscriptionBuilder = subscriptionBuilder.setRetainAckedMessages(request.getRetainAckedMessages().booleanValue());
                fieldMasks.add("retain_acked_messages");
            }
        }
        Subscription updateSubscription = subscriptionBuilder.build();
        updateSubscriptionRequest = UpdateSubscriptionRequest.newBuilder().setSubscription(updateSubscription).setUpdateMask(FieldMask.newBuilder().addAllPaths(fieldMasks)).build();
        return updateSubscriptionRequest;
    }

    private ExpirationPolicy getExpirationPolicy(SubscriptionMetadataExpirationPolicyRequest expirationPolicyRequest) {
        ExpirationPolicy.Builder expirationPolicyBuilder = ExpirationPolicy.newBuilder();
        expirationPolicyBuilder = expirationPolicyRequest.getClearTtl() != false ? expirationPolicyBuilder.clearTtl() : expirationPolicyBuilder.setTtl(expirationPolicyRequest.getTtl());
        return expirationPolicyBuilder.build();
    }

    private Subscription.Builder getDeliveryConfig(SubscriptionMetadataRequest request, Subscription.Builder subscriptionBuilder) {
        SubscriptionMetadataDeliveryConfigRequest deliveryConfig = request.getDeliveryConfig();
        if (request.getDeliveryConfig() == null) {
            subscriptionBuilder = subscriptionBuilder.setPushConfig(PushConfig.getDefaultInstance());
            return subscriptionBuilder;
        }
        DeliveryType deliveryType = deliveryConfig.getType();
        switch (deliveryType) {
            case PULL: {
                subscriptionBuilder = subscriptionBuilder.setPushConfig(PushConfig.getDefaultInstance());
                return subscriptionBuilder;
            }
            case PUSH: {
                if (deliveryConfig.getPushConfig() != null) {
                    PushConfig pushConfig = this.getPushConfig(deliveryConfig.getPushConfig());
                    subscriptionBuilder = subscriptionBuilder.setPushConfig(pushConfig);
                    return subscriptionBuilder;
                }
            }
            case BIGQUERY: {
                if (deliveryConfig.getBigQueryConfig() == null) break;
                BigQueryConfig bigQueryConfig = this.getBigQueryConfig(deliveryConfig.getBigQueryConfig());
                subscriptionBuilder = subscriptionBuilder.setBigqueryConfig(bigQueryConfig);
                return subscriptionBuilder;
            }
        }
        throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_DELIVERY_TYPE_VALIDATION", (Object)deliveryType.toString()));
    }

    private PushConfig getPushConfig(SubscriptionMetadataPushConfigRequest request) {
        PushConfig pushConfig = null;
        PushConfig.Builder pushConfigBuilder = PushConfig.newBuilder();
        String pushEndpoint = request.getPushEndpoint();
        Map<String, String> attributes = request.getAttributes();
        SubscriptionMetadataOidcTokenRequest oidcTokenRequest = request.getOidcToken();
        PushConfig.OidcToken oidcToken = null;
        if (oidcTokenRequest != null) {
            PushConfig.OidcToken.Builder oidcTokenBuilder = PushConfig.OidcToken.newBuilder();
            if (oidcTokenRequest.getServiceAccountEmail() != null) {
                oidcTokenBuilder = oidcTokenBuilder.setServiceAccountEmail(oidcTokenRequest.getServiceAccountEmail());
            }
            if (oidcTokenRequest.getAudience() != null) {
                oidcTokenBuilder = oidcTokenBuilder.setAudience(oidcTokenRequest.getAudience());
            }
            oidcToken = oidcTokenBuilder.build();
        }
        if (pushEndpoint != null) {
            pushConfigBuilder = pushConfigBuilder.setPushEndpoint(pushEndpoint);
        }
        if (attributes != null) {
            pushConfigBuilder = pushConfigBuilder.putAllAttributes(attributes);
        }
        if (oidcToken != null) {
            pushConfigBuilder = pushConfigBuilder.setOidcToken(oidcToken);
        }
        pushConfig = pushConfigBuilder.build();
        return pushConfig;
    }

    private BigQueryConfig getBigQueryConfig(SubscriptionMetadataBigQueryConfigRequest request) {
        BigQueryConfig bigQueryConfig = null;
        BigQueryConfig.Builder bigQueryConfigBuilder = BigQueryConfig.newBuilder();
        if (request.getTable() != null) {
            bigQueryConfigBuilder = bigQueryConfigBuilder.setTable(request.getTable());
        }
        if (request.isUseTableSchema() != null) {
            bigQueryConfigBuilder = bigQueryConfigBuilder.setUseTopicSchema(request.isUseTableSchema().booleanValue());
        }
        if (request.isWriteSchema() != null) {
            bigQueryConfigBuilder = bigQueryConfigBuilder.setWriteMetadata(request.isWriteSchema().booleanValue());
        }
        if (request.isDropUnknownFields() != null) {
            bigQueryConfigBuilder = bigQueryConfigBuilder.setDropUnknownFields(request.isDropUnknownFields().booleanValue());
        }
        bigQueryConfig = bigQueryConfigBuilder.build();
        return bigQueryConfig;
    }

    private DeadLetterPolicy getDeadLetterPolicy(SubscriptionMetadataDeadLetterPolicyRequest request) {
        DeadLetterPolicy deadLetterPolicy = null;
        DeadLetterPolicy.Builder deadLetterPolicyBuilder = DeadLetterPolicy.newBuilder();
        if (request.getDeadLetterTopic() != null) {
            String deadLetterTopicName = this.nameTransformer.getTopicName(request.getDeadLetterTopic());
            deadLetterPolicyBuilder = deadLetterPolicyBuilder.setDeadLetterTopic(deadLetterTopicName);
        }
        if (request.getMaxDeliveryAttempts() != null) {
            deadLetterPolicyBuilder = deadLetterPolicyBuilder.setMaxDeliveryAttempts(request.getMaxDeliveryAttempts().intValue());
        }
        deadLetterPolicy = deadLetterPolicyBuilder.build();
        return deadLetterPolicy;
    }

    private RetryPolicy getRetryPolicy(SubscriptionMetadataRetryPolicyRequest request) {
        RetryPolicy retryPolicy = null;
        RetryPolicy.Builder retryPolicyBuilder = RetryPolicy.newBuilder();
        if (request.getMinimumBackoff() != null) {
            retryPolicyBuilder = retryPolicyBuilder.setMinimumBackoff(request.getMinimumBackoff());
        }
        if (request.getMaximumBackoff() != null) {
            retryPolicyBuilder = retryPolicyBuilder.setMaximumBackoff(request.getMaximumBackoff());
        }
        retryPolicy = retryPolicyBuilder.build();
        return retryPolicy;
    }

    private void validateIfProjectIDExists(NotFoundException nfe) {
        if (nfe.getMessage() != null && nfe.getMessage().contains("Requested project not found or user does not have access to it")) {
            throw new PubSubException(nfe.getMessage(), nfe);
        }
    }

    private void handleInvalidSchemaDefinitionError(String schemaDefinition, Exception ex) {
        if (PubSubClientImpl.isSchemaDefinitionValid(ex)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"INVALID_SCHEMA_DEFINITION", (Object)schemaDefinition), ex);
        }
    }

    private static boolean isSchemaDefinitionValid(Exception ex) {
        return ex instanceof InvalidArgumentException && ex.getMessage() != null && (ex.getMessage().contains("Invalid schema definition: Could not parse schema.") || ex.getMessage().contains("Invalid schema message: Could not parse schema:"));
    }
}

