/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.mask.MaskUtils;
import org.jpedal.render.ClipUtils;
import org.jpedal.utils.Matrix;

public class FormFlattener {
    private float[][] ctm;
    private Area newClip;
    private static final FormExclusion exclusionOption;

    public void drawFlattenedForm(PdfStreamDecoder pdfStreamDecoder, PdfObject form, boolean isHTML, PdfObject AcroRes) throws PdfException {
        if (exclusionOption != FormExclusion.ExcludeNone && !FormFlattener.showForm(form)) {
            return;
        }
        ParserOptions parserOptions = pdfStreamDecoder.parserOptions;
        int pageNumber = parserOptions.getPageNumber();
        int type = form.getParameterConstant(1147962727);
        if (type == 1919840408) {
            AnnotationFactory.renderFlattenedAnnotation(form, pdfStreamDecoder.current, pageNumber, pdfStreamDecoder.pageData.getRotation(pageNumber));
            return;
        }
        GraphicsState oldGS = pdfStreamDecoder.gs;
        pdfStreamDecoder.gs = new GraphicsState();
        parserOptions.setFlattenedForm(true);
        boolean[] characteristic = ((FormObject)form).getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5] || form.getParameterConstant(1147962727) == 1061176672) {
            return;
        }
        PdfObject imgObj = FormFlattener.getImageObject(pdfStreamDecoder, form, AcroRes, pageNumber, type);
        if (imgObj == null) {
            return;
        }
        PdfObject resources = imgObj.getDictionary(2004251818);
        if (resources != null) {
            pdfStreamDecoder.readResources(resources, false);
        }
        float[] BBox = FormFlattener.getBBox(form, imgObj);
        float x = BBox[0];
        float y = BBox[1];
        if (this.init(pdfStreamDecoder, form, imgObj, BBox)) {
            pdfStreamDecoder.gs.CTM = this.getCTM();
            x = pdfStreamDecoder.gs.CTM[2][0];
            y = pdfStreamDecoder.gs.CTM[2][1];
        }
        Area newClip = ClipUtils.convertPDFClipToJavaClip(this.newClip);
        this.drawForm(imgObj, form, pdfStreamDecoder, newClip, isHTML, BBox, x, y, imgObj.getDecodedStream(), oldGS);
    }

    private boolean init(PdfStreamDecoder pdfStreamDecoder, PdfObject form, PdfObject imgObj, float[] BBox) {
        float[] matrix = imgObj.getFloatArray(1145198201);
        if (matrix != null) {
            ParserOptions parserOptions;
            int pageNumber;
            float[] imageBB = FormFlattener.checkOrderCorrect(imgObj.getFloatArray(303185736));
            if (matrix[1] > 0.0f && matrix[2] < 0.0f && BBox[1] > 0.0f && BBox[3] > 0.0f && imgObj.getParameterConstant(1147962727) == 373244477 && pdfStreamDecoder.pageData.getRotation(pageNumber = (parserOptions = pdfStreamDecoder.parserOptions).getPageNumber()) == 0) {
                matrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, -imageBB[0], -imageBB[1]};
            }
            this.setCTM(imageBB, BBox, matrix);
        }
        this.newClip = matrix != null ? new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)(BBox[2] - BBox[0] + 2.0f), (int)(BBox[3] - BBox[1] + 2.0f))) : FormFlattener.setClipAndCTM(pdfStreamDecoder, form, imgObj, BBox, BBox[0], BBox[1]);
        return matrix != null;
    }

    private float[][] getCTM() {
        return this.ctm;
    }

    private void setCTM(float[] imageBBox, float[] BBox, float[] matrix) {
        float[][] m = new float[][]{{matrix[0], matrix[1], 0.0f}, {matrix[2], matrix[3], 0.0f}, {matrix[4], matrix[5], 1.0f}};
        float w = Math.abs(BBox[2] - BBox[0]);
        float h = Math.abs(BBox[3] - BBox[1]);
        float w1 = Math.abs(imageBBox[2] - imageBBox[0]);
        float h1 = Math.abs(imageBBox[3] - imageBBox[1]);
        float[] scaling = new float[]{w / w1, h / h1};
        if (matrix[1] != 0.0f && matrix[2] != 0.0f) {
            scaling = new float[]{w / h1, h / w1};
        }
        if ((double)Math.abs(1.0f - scaling[0]) < 0.01) {
            scaling[0] = 1.0f;
        }
        if ((double)Math.abs(1.0f - scaling[1]) < 0.01) {
            scaling[1] = 1.0f;
        }
        boolean debug = false;
        float[] co_ords = new float[]{BBox[0] - imageBBox[0] * scaling[0], BBox[1] - imageBBox[1] * scaling[1]};
        if (matrix[0] > 0.0f && matrix[3] > 0.0f) {
            co_ords = new float[]{BBox[0] - matrix[4] * scaling[0] - imageBBox[0] * scaling[0], BBox[1] - matrix[5] * scaling[1] - imageBBox[1] * scaling[1]};
        } else if (matrix[0] < 0.0f && matrix[3] < 0.0f) {
            co_ords = new float[]{BBox[0] - imageBBox[0] * scaling[0], BBox[1] - imageBBox[1] * scaling[1]};
        } else if (matrix[1] > 0.0f && matrix[2] < 0.0f) {
            co_ords = new float[]{BBox[2] - matrix[4] * scaling[0] + imageBBox[1] * scaling[0], BBox[1] - matrix[5] * scaling[1] - imageBBox[0] * scaling[1]};
        } else if (matrix[1] < 0.0f && matrix[2] > 0.0f) {
            co_ords = new float[]{BBox[0], BBox[1]};
        }
        this.ctm = new float[][]{{scaling[0], 0.0f, 0.0f}, {0.0f, scaling[1], 0.0f}, {co_ords[0], co_ords[1], 1.0f}};
        this.ctm = Matrix.multiply(m, this.ctm);
    }

    private static float[] getBBox(PdfObject form, PdfObject imgObj) {
        Rectangle rect;
        float[] BBox = form.getFloatArray(573911876);
        if (imgObj != null && imgObj.getObjectType() == 129 && (rect = ((FormObject)form).getBoundingRectangle()) != null) {
            BBox = new float[]{rect.x, rect.y, rect.width, rect.height};
        }
        if (BBox == null) {
            BBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        }
        return FormFlattener.checkOrderCorrect(BBox);
    }

    private static float[] checkOrderCorrect(float[] BBox) {
        float t1;
        if (BBox[1] > BBox[3]) {
            t1 = BBox[1];
            BBox[1] = BBox[3];
            BBox[3] = t1;
        }
        if (BBox[0] > BBox[2]) {
            t1 = BBox[0];
            BBox[0] = BBox[2];
            BBox[2] = t1;
        }
        return BBox;
    }

    private static PdfObject getImageObject(PdfStreamDecoder pdfStreamDecoder, PdfObject form, PdfObject AcroRes, int pageNumber, int type) {
        String str;
        byte[] formData;
        PdfObjectReader currentPdfFile = pdfStreamDecoder.currentPdfFile;
        PdfObject imgObj = null;
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        if (APobjN != null || form.getDictionary(7451).getDictionary(25) != null) {
            String defaultState = form.getName(4387);
            Object[] values = FormStream.getNormalKeyValues(form, currentPdfFile.getObjectReader());
            if (defaultState != null && defaultState.equals(((FormObject)form).getNormalOnState())) {
                ((FormObject)form).setNormalOnState((String)values[0]);
                imgObj = (PdfObject)values[1];
            } else {
                imgObj = (PdfObject)values[2];
            }
        }
        if (imgObj != null && (formData = imgObj.getDecodedStream()) != null && ((str = new String(formData)).isEmpty() || str.contains("BMC") && !str.contains("BT"))) {
            imgObj = null;
        }
        if (imgObj == null) {
            if (type == 980909433) {
                AnnotationUtils.createAPObjectForFormObject((FormObject)form, currentPdfFile);
                imgObj = form.getDictionary(4384).getDictionary(30);
            } else {
                String V = form.getTextStreamValue(38);
                byte[] DA = form.getTextStreamValueAsByte(5137);
                if (DA != null || V != null && !V.isEmpty()) {
                    ReadOnlyTextIcon textIcon = new ReadOnlyTextIcon(form, 0, currentPdfFile, AcroRes);
                    textIcon.decipherAppObject((FormObject)form);
                    if (V != null) {
                        textIcon.setText(V);
                        imgObj = textIcon.getFakeObject();
                    } else {
                        imgObj = textIcon.getFakeObject();
                        imgObj.setDecodedStream(DA);
                    }
                }
                if (imgObj == null && DA == null && type == 607471684) {
                    AnnotationFactory.renderFlattenedAnnotation(form, pdfStreamDecoder.current, pageNumber, pdfStreamDecoder.pageData.getRotation(pageNumber));
                }
            }
        }
        if (imgObj != null) {
            currentPdfFile.checkResolved(imgObj);
        }
        return imgObj;
    }

    private static Area setClipAndCTM(PdfStreamDecoder pdfStreamDecoder, PdfObject form, PdfObject imgObj, float[] BBox, float x, float y) {
        if (imgObj != null) {
            float[] values2;
            float[] BoundingBox = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            PdfObject temp = form.getDictionary(4384);
            if (temp != null && (temp = temp.getDictionary(30)) != null) {
                String defaultState = form.getName(4387);
                Object[] values = FormStream.getNormalKeyValues(form, pdfStreamDecoder.currentPdfFile.getObjectReader());
                if (defaultState != null && defaultState.equals(((FormObject)form).getNormalOnState())) {
                    ((FormObject)form).setNormalOnState((String)values[0]);
                    temp = (PdfObject)values[1];
                } else {
                    temp = (PdfObject)values[2];
                }
                if (temp != null && (BoundingBox = temp.getFloatArray(303185736)) == null) {
                    BoundingBox = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                }
            }
            if ((values2 = imgObj.getFloatArray(303185736)) != null) {
                float yScale;
                float xScale = (BBox[2] - BBox[0]) / (values2[2] - values2[0]);
                if (xScale < 0.0f) {
                    xScale = -xScale;
                }
                if ((yScale = (BBox[3] - BBox[1]) / (values2[3] - values2[1])) < 0.0f) {
                    yScale = -yScale;
                }
                pdfStreamDecoder.gs.CTM = new float[][]{{xScale, 0.0f, 0.0f}, {0.0f, yScale, 0.0f}, {x - BoundingBox[0], y - BoundingBox[1], 1.0f}};
            } else {
                pdfStreamDecoder.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x, y, 1.0f}};
            }
        } else {
            pdfStreamDecoder.gs.CTM = form.getParameterConstant(1147962727) == 1654331 ? (Object)new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x - BBox[0], y - BBox[1], 1.0f}} : (float[][])new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x, y, 1.0f}};
        }
        Area newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)BBox[2], (int)BBox[3]));
        return newClip;
    }

    void drawForm(PdfObject imgObj, PdfObject form, PdfStreamDecoder pdfStreamDecoder, Area newClip, boolean isHTML, float[] BBox, float x, float y, byte[] formData, GraphicsState oldGS) throws PdfException {
        if (newClip != null) {
            pdfStreamDecoder.gs.updateClip(new Area(newClip));
        }
        pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, null, false);
        TextState oldState = pdfStreamDecoder.gs.getTextState();
        pdfStreamDecoder.gs.setTextState(new TextState());
        if (isHTML) {
            int w = (int)(BBox[2] - BBox[0]);
            int h = (int)(BBox[3] - BBox[1]);
            if (w > 0 && h > 0) {
                BufferedImage image = MaskUtils.createTransparentForm(imgObj, 0, w, h, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer);
                pdfStreamDecoder.gs.CTM = new float[][]{{image.getWidth() / 4, 0.0f, 0.0f}, {0.0f, image.getHeight() / 4, 0.0f}, {0.0f, 0.0f, 1.0f}};
                pdfStreamDecoder.gs.x = x;
                pdfStreamDecoder.gs.y = y;
                pdfStreamDecoder.gs.CTM[2][0] = x;
                pdfStreamDecoder.gs.CTM[2][1] = y;
                int previousUse = ((FormObject)form).isAddedToHTML() ? -3 : -2;
                pdfStreamDecoder.current.drawImage(pdfStreamDecoder.parserOptions.getPageNumber(), image, pdfStreamDecoder.gs, false, form.getObjectRefAsString(), previousUse);
            }
        } else if (formData != null) {
            pdfStreamDecoder.decodeStreamIntoObjects(formData, false);
        }
        pdfStreamDecoder.gs.updateClip(null);
        pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, null, true);
        pdfStreamDecoder.gs = oldGS;
        pdfStreamDecoder.gs.setTextState(oldState);
    }

    private static boolean showForm(PdfObject form) {
        switch (exclusionOption) {
            case ExcludeFormsAndAnnotations: {
                return false;
            }
            case ExcludeAnnotations: {
                if (form.getParameterConstant(608780341) != 1044266837 || form.getNameAsConstant(5668) != -1) break;
                return false;
            }
            case ExcludeForms: {
                if (form.getNameAsConstant(5668) == -1) break;
                return false;
            }
        }
        return true;
    }

    static {
        String value = System.getProperty("org.jpedal.removeForms");
        exclusionOption = value != null && !value.isEmpty() ? FormExclusion.valueOf(value) : FormExclusion.ExcludeNone;
    }

    private static enum FormExclusion {
        ExcludeNone,
        ExcludeForms,
        ExcludeAnnotations,
        ExcludeFormsAndAnnotations;

    }
}

