/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import org.jpedal.color.CalGrayColorSpace;
import org.jpedal.color.CalRGBColorSpace;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.ICCColorSpace;
import org.jpedal.color.LabColorSpace;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.color.YCCKColorSpace;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.KeyArray;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public final class ColorspaceFactory {
    public static GenericColorSpace getColorSpaceInstance(PdfObjectReader currentPdfFile, PdfArrayIterator colorSpace) {
        int ID2 = colorSpace.getNextValueAsKey();
        if (ID2 == 320678171) {
            ID2 = 1498837125;
        }
        if (ID2 == 895578984 || ID2 == 25) {
            GenericColorSpace currentColorData = ColorspaceFactory.getColorSpace(colorSpace, currentPdfFile);
            int size = colorSpace.getNextValueAsInteger(true);
            byte[] lookup = ColorspaceFactory.getTransformTable(currentPdfFile, colorSpace.getNextValueAsByte(true));
            if (currentColorData.getRawColorSpacePDFType() == 1247168582 && lookup.length < 3) {
                currentColorData = new DeviceGrayColorSpace();
            }
            currentColorData.setIndex(lookup, size);
            return currentColorData;
        }
        return ColorspaceFactory.getColorspace(ID2, colorSpace, currentPdfFile);
    }

    private static GenericColorSpace getColorSpace(PdfArrayIterator colorSpace, PdfObjectReader currentPdfFile) {
        byte[] colValue = colorSpace.getNextValueAsByte(false);
        if (StreamReaderUtils.isRef(colValue, 0) || StreamReaderUtils.isArray(colValue, 0)) {
            PdfArrayIterator it = ColorspaceFactory.convertColValueToMixedArray(currentPdfFile, colorSpace.getNextValueAsByte(true));
            return ColorspaceFactory.getColorSpaceInstance(currentPdfFile, it);
        }
        return ColorspaceFactory.getColorspace(colorSpace.getNextValueAsKey(), colorSpace, currentPdfFile);
    }

    public static FunctionObject getFunctionObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        FunctionObject colObj = new FunctionObject(new String(data));
        if (data[0] == 60) {
            colObj.setStatus(2);
        } else {
            colObj.setStatus(1);
        }
        colObj.setUnresolvedData(data, 1518239089);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(colObj);
        return colObj;
    }

    private static byte[] getTransformTable(PdfObjectReader currentPdfFile, byte[] data) {
        if (StreamReaderUtils.isRef(data, 0)) {
            ColorSpaceObject colObj2 = new ColorSpaceObject(new String(data));
            currentPdfFile.readObject(colObj2);
            return colObj2.getDecodedStream();
        }
        return data;
    }

    private static ColorSpaceObject getColObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        ColorSpaceObject colObj = new ColorSpaceObject(new String(data));
        if (data[0] == 60) {
            colObj.setStatus(2);
        } else {
            colObj.setStatus(1);
        }
        colObj.setUnresolvedData(data, 2087749783);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(colObj);
        return colObj;
    }

    private static GenericColorSpace getColorspace(int ID2, PdfArrayIterator colorSpace, PdfObjectReader currentPdfFile) {
        GenericColorSpace currentColorData;
        switch (ID2) {
            case -2073385820: 
            case 960981604: {
                currentColorData = ColorspaceFactory.getDeviceNColorSpace(currentPdfFile, colorSpace, ID2);
                break;
            }
            case 1568372915: {
                currentColorData = new DeviceGrayColorSpace();
                break;
            }
            case 1498837125: {
                currentColorData = new DeviceCMYKColorSpace();
                currentColorData.setRawColorSpace(1498837125);
                break;
            }
            case 391471749: {
                currentColorData = ColorspaceFactory.getCalGrayColorspace(ColorspaceFactory.getColObjectFromRefOrDirect(currentPdfFile, colorSpace.getNextValueAsByte(true)));
                break;
            }
            case 1008872003: {
                currentColorData = ColorspaceFactory.getCalRGBColorspace(ColorspaceFactory.getColObjectFromRefOrDirect(currentPdfFile, colorSpace.getNextValueAsByte(true)));
                break;
            }
            case 1847602: {
                currentColorData = ColorspaceFactory.getLabColorspace(ColorspaceFactory.getColObjectFromRefOrDirect(currentPdfFile, colorSpace.getNextValueAsByte(true)));
                break;
            }
            case 1247168582: {
                currentColorData = ColorspaceFactory.getICCColorspace(ColorspaceFactory.getColObjectFromRefOrDirect(currentPdfFile, colorSpace.getNextValueAsByte(true)), currentPdfFile);
                break;
            }
            case 1146450818: {
                currentColorData = ColorspaceFactory.getPatternColorspace(colorSpace, currentPdfFile);
                break;
            }
            case 689115931: {
                currentColorData = new YCCKColorSpace();
                currentColorData.setRawColorSpace(1498837125);
                break;
            }
            default: {
                currentColorData = new DeviceRGBColorSpace();
            }
        }
        return currentColorData;
    }

    private static GenericColorSpace getPatternColorspace(PdfArrayIterator colorSpace, PdfObjectReader currentPdfFile) {
        PatternColorSpace currentColorData;
        if (colorSpace.hasMoreTokens()) {
            GenericColorSpace patternColorSpace = ColorspaceFactory.getColorSpace(colorSpace, currentPdfFile);
            currentColorData = new PatternColorSpace(currentPdfFile, patternColorSpace);
        } else {
            currentColorData = new PatternColorSpace(currentPdfFile, new DeviceRGBColorSpace());
        }
        return currentColorData;
    }

    private static byte[][] convertColValueToKeyArray(PdfObjectReader currentPdfFile, byte[] alt) {
        int ptr = 0;
        if (alt[0] == 91) {
            ptr = 1;
        }
        KeyArray objDecoder = new KeyArray(currentPdfFile.getObjectReader(), ptr, alt);
        OCObject obj = new OCObject(new String(alt));
        objDecoder.readArray(obj, 910980737);
        return obj.getKeyArray(910980737);
    }

    public static PdfArrayIterator convertColValueToMixedArray(PdfObjectReader currentPdfFile, byte[] raw) {
        ColorSpaceObject obj = new ColorSpaceObject(new String(raw));
        PdfFileReader objectReader = currentPdfFile.getObjectReader();
        int startArray = 0;
        if (StreamReaderUtils.isRef(raw, 0)) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, 0);
            int ref = values[0];
            int generation = values[1];
            raw = objectReader.readObjectAsByteArray(obj, objectReader.isCompressed(ref, generation), ref, generation);
            obj = new ColorSpaceObject(new String(raw));
            while (raw[startArray] != 91 && raw[startArray] != 47) {
                ++startArray;
            }
        }
        Array objDecoder = new Array(objectReader, startArray, 18, raw);
        objDecoder.readArray(obj, 2087749783);
        return obj.getMixedArray(2087749783);
    }

    private ColorspaceFactory() {
    }

    private static GenericColorSpace getICCColorspace(PdfObject colorSpace, PdfObjectReader currentPdfFile) {
        GenericColorSpace currentColorData;
        int alt = colorSpace.getParameterConstant(2054519176);
        if (alt == 1498837125 || alt == 1785221209 || alt == 1568372915) {
            currentColorData = ColorspaceFactory.getColorspace(alt, null, currentPdfFile);
        } else {
            currentColorData = new ICCColorSpace(colorSpace.getDecodedStream());
            int type = currentColorData.getType();
            if (type == 9) {
                currentColorData = new DeviceCMYKColorSpace();
            } else if (type == 5) {
                currentColorData = new DeviceRGBColorSpace();
            } else if (type == 6) {
                currentColorData = new DeviceGrayColorSpace();
            }
        }
        currentColorData.setRawColorSpace(1247168582);
        return currentColorData;
    }

    private static GenericColorSpace getLabColorspace(PdfObject colorSpace) {
        float[] R = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] rangeArray = colorSpace.getFloatArray(826160983);
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (rangeArray != null) {
            R = rangeArray;
        }
        return new LabColorSpace(W, R);
    }

    private static GenericColorSpace getCalRGBColorspace(PdfObject colorSpace) {
        float[] W = new float[]{1.0f, 1.0f, 1.0f};
        float[] G2 = new float[]{1.0f, 1.0f, 1.0f};
        float[] Ma = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] gammaArray = colorSpace.getFloatArray(826096968);
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] matrixArray = colorSpace.getFloatArray(1145198201);
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (gammaArray != null) {
            G2 = gammaArray;
        }
        if (matrixArray != null) {
            Ma = matrixArray;
        }
        return new CalRGBColorSpace(W, Ma, G2);
    }

    private static GenericColorSpace getCalGrayColorspace(PdfObject colorSpace) {
        float[] W = new float[]{0.0f};
        float[] G2 = new float[]{1.0f};
        float[] gammaArray = null;
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] rawGamma = colorSpace.getFloatArray(826096968);
        if (rawGamma != null) {
            gammaArray = rawGamma;
        }
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (gammaArray != null) {
            G2 = gammaArray;
        }
        return new CalGrayColorSpace(W, G2);
    }

    private static GenericColorSpace getDeviceNColorSpace(PdfObjectReader currentPdfFile, PdfArrayIterator colorSpace, int ID2) {
        int componentCount = 1;
        byte[] name = colorSpace.getNextValueAsByte(true);
        GenericColorSpace altCS = ColorspaceFactory.getColorSpace(colorSpace, currentPdfFile);
        FunctionObject functionObj = ColorspaceFactory.getFunctionObjectFromRefOrDirect(currentPdfFile, colorSpace.getNextValueAsByte(true));
        if (ID2 != -2073385820) {
            byte[][] components = ColorspaceFactory.convertColValueToKeyArray(currentPdfFile, name);
            componentCount = components.length;
        }
        ColorMapping colorMapper = new ColorMapping(currentPdfFile, functionObj);
        float[] domain = ((PdfObject)functionObj).getFloatArray(1026641277);
        if (ID2 == -2073385820) {
            return new SeparationColorSpace(colorMapper, domain, altCS);
        }
        return new DeviceNColorSpace(componentCount, colorMapper, domain, altCS);
    }
}

