/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class CalRGBColorSpace
extends GenericColorSpace {
    private int r;
    private int g;
    private int b;
    private static final double cs00 = 3.240449;
    private static final double cs01 = -1.537136;
    private static final double cs02 = -0.498531;
    private static final double cs10 = -0.969265;
    private static final double cs11 = 1.876011;
    private static final double cs12 = 0.041556;
    private static final double cs20 = 0.055643;
    private static final double cs21 = -0.204026;
    private static final double cs22 = 1.057229;
    private final double kr;
    private final double kg;
    private final double kb;
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;
    private final float[] A = new float[]{1.0f, 1.0f, 1.0f};

    public CalRGBColorSpace(float[] whitepoint, float[] matrix, float[] gamma) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(whitepoint, null, matrix, gamma);
        this.setType(1008872003);
        this.kr = 1.0 / (3.240449 * (double)this.W[0] + -1.537136 * (double)this.W[1] + -0.498531 * (double)this.W[2]);
        this.kg = 1.0 / (-0.969265 * (double)this.W[0] + 1.876011 * (double)this.W[1] + 0.041556 * (double)this.W[2]);
        this.kb = 1.0 / (0.055643 * (double)this.W[0] + -0.204026 * (double)this.W[1] + 1.057229 * (double)this.W[2]);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h) {
        return data;
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(width, height, 1);
        WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    @Override
    public final void setColor(float[] number_values) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            number_values = this.flattenIndexedValue(number_values);
        }
        for (int i = 0; i < this.componentCount; ++i) {
            this.A[i] = number_values[i];
            if (!(this.A[i] > 1.0f)) continue;
            return;
        }
        this.convertToRGB(this.A[0], this.A[1], this.A[2]);
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    private void convertToRGB(float C, float I, float E) {
        if (this.lastC != C || this.lastI != I || this.lastE != E) {
            double ag = Math.pow(C, this.G[0]);
            double bg = Math.pow(I, this.G[1]);
            double cg = Math.pow(E, this.G[2]);
            double X = (double)this.Ma[0] * ag + (double)this.Ma[3] * bg + (double)this.Ma[6] * cg;
            double Y = (double)this.Ma[1] * ag + (double)this.Ma[4] * bg + (double)this.Ma[7] * cg;
            double Z = (double)this.Ma[2] * ag + (double)this.Ma[5] * bg + (double)this.Ma[8] * cg;
            double rawR = 3.240449 * X + -1.537136 * Y + -0.498531 * Z;
            double rawG = -0.969265 * X + 1.876011 * Y + 0.041556 * Z;
            double rawB = 0.055643 * X + -0.204026 * Y + 1.057229 * Z;
            this.r = (int)(255.0 * Math.sqrt(CalRGBColorSpace.clip(rawR * this.kr)));
            this.g = (int)(255.0 * Math.sqrt(CalRGBColorSpace.clip(rawG * this.kg)));
            this.b = (int)(255.0 * Math.sqrt(CalRGBColorSpace.clip(rawB * this.kb)));
            this.lastC = C;
            this.lastI = I;
            this.lastE = E;
        }
    }

    private static double clip(double v) {
        return v > 1.0 ? 1.0 : v;
    }
}

