/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.objects;

import com.idrsolutions.pdf.acroforms.xfa.XBox;
import com.idrsolutions.pdf.acroforms.xfa.XFAFormObject;
import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import com.idrsolutions.pdf.acroforms.xfa.XFAStyle;
import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XFontInfo;
import com.idrsolutions.pdf.acroforms.xfa.XFormCalc;
import com.idrsolutions.pdf.acroforms.xfa.XQuery;
import com.idrsolutions.pdf.acroforms.xfa.XRect;
import com.idrsolutions.pdf.acroforms.xfa.objects.XFADraw;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpedal.color.PdfColor;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.SwingShape;
import org.jpedal.objects.TextState;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.Tj;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFAField
extends XFAFormObject {
    private final Tj textDecoder;
    private Map<String, PdfFont> fontCache = new HashMap<String, PdfFont>();
    private double[] coordsXYWH = new double[4];
    private double[] fullBound = new double[4];
    private String name;
    private final Node node;
    public String radioValue;
    private XFontInfo capFontInfo = new XFontInfo();
    private int captionPlace = 3317767;
    private int captionHAlign = 3317767;
    private int captionVAlign = 115029;
    private String captionData;
    private boolean foundCaptionFont;
    private int formHAlign = 3317767;
    private final DynamicVectorRenderer dvr;
    private String inputPicture;
    private String outputPicture;
    private boolean isDateTimeField;
    double reserveValue;
    private boolean isCaptionHTML;
    private double clickBtnSize = 11.0;
    int subtype = -1;
    private boolean isVisible = true;
    private boolean hasBgColor;
    final PdfObjectReader currentPdfFile;
    final PdfFontFactory pdfFontFactory;
    public boolean readOnly;
    private final XBox box;
    private String captionBorderStrokeStr;
    private String captionBorderFillStr;
    private static final double formBorderThickness = 1.0;
    private String formBorderStrokeStr;
    private String formBorderFillStr;
    private int[] internalMattes = new int[]{0, 0, 0, 0};
    private final PdfStreamDecoder decoder;
    private String formData;
    private int checkButtonMarkType = 94935104;
    private int checkButtonShape = -894674659;
    private final Element fieldEle;

    public XFAField(Tj textDecoder, Node node, Node pageAreaNode, int pageNumber, DynamicVectorRenderer dvr, PdfObjectReader currentPdfFile, XFAPageContent xfaPageContent, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache) {
        Node borderNode;
        String ancType;
        this.textDecoder = textDecoder;
        this.node = node;
        this.dvr = dvr;
        this.decoder = decoder;
        this.fontCache = fontCache;
        this.fieldEle = (Element)node;
        if (decoder != null) {
            decoder.incrementTokenNumber();
        }
        this.setPageNumber(pageNumber);
        this.formData = XBox.getCustomData(node);
        this.box = new XBox(node);
        this.coordsXYWH = XFAFormStream.getDynamicCoordsBottom(node, pageAreaNode);
        XBox.XLayout layout = XBox.findLayout(node.getParentNode());
        if (layout == XBox.XLayout.POSITION && !(ancType = this.fieldEle.getAttribute("anchorType")).isEmpty()) {
            switch (ancType.hashCode()) {
                case 1781909088: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] - this.coordsXYWH[2] / 2.0;
                    this.coordsXYWH[1] = this.coordsXYWH[1] + this.coordsXYWH[3];
                    break;
                }
                case -1682792238: {
                    this.coordsXYWH[1] = this.coordsXYWH[1] + this.coordsXYWH[3];
                    break;
                }
                case -621290831: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] - this.coordsXYWH[2];
                    this.coordsXYWH[1] = this.coordsXYWH[1] + this.coordsXYWH[3];
                    break;
                }
                case -641184182: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] - this.coordsXYWH[2] / 2.0;
                    this.coordsXYWH[1] = this.coordsXYWH[1] + this.coordsXYWH[3] / 2.0;
                    break;
                }
                case -818275524: {
                    this.coordsXYWH[1] = this.coordsXYWH[1] + this.coordsXYWH[3] / 2.0;
                    break;
                }
                case 408923527: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] - this.coordsXYWH[2];
                    this.coordsXYWH[1] = this.coordsXYWH[1] + this.coordsXYWH[3] / 2.0;
                    break;
                }
                case -696883702: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] - this.coordsXYWH[2] / 2.0;
                    break;
                }
                case -1140120836: {
                    break;
                }
                case -978346553: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] + this.coordsXYWH[2];
                }
            }
        }
        this.fullBound = new double[]{this.coordsXYWH[0], this.coordsXYWH[1], this.coordsXYWH[2], this.coordsXYWH[3]};
        if (!this.box.isVisibleWidget(node)) {
            this.coordsXYWH = new double[]{0.0, 0.0, 0.0, 0.0};
            this.fullBound = new double[]{0.0, 0.0, 0.0, 0.0};
            this.isVisible = false;
        }
        if (node.getParentNode() != null && dvr != null && (borderNode = XFAFormStream.lookForChild(node.getParentNode(), -1383304148)) != null) {
            XFADraw.drawParentBorder(dvr, node.getParentNode(), this.fullBound);
        }
        this.setXYWH(this.coordsXYWH);
        this.currentPdfFile = currentPdfFile;
        this.pdfFontFactory = new PdfFontFactory(currentPdfFile);
        NamedNodeMap nnm = node.getAttributes();
        block32: for (int z = 0; z < nnm.getLength(); ++z) {
            String attrName = nnm.item(z).getNodeName();
            String attrValue = nnm.item(z).getNodeValue();
            switch (attrName.hashCode()) {
                case 3373707: {
                    this.name = attrValue;
                    continue block32;
                }
                case 3355: {
                    continue block32;
                }
                case -1276666629: {
                    switch (attrValue.hashCode()) {
                        case -1217487446: {
                            this.isVisible = false;
                            this.setCharactersitics(1, true);
                            break;
                        }
                        case -1901805651: {
                            this.isVisible = false;
                            this.setCharactersitics(1, true);
                        }
                    }
                    continue block32;
                }
                case -1423461020: {
                    if (attrValue.hashCode() != -867683742) continue block32;
                    this.readOnly = true;
                    this.setFieldFlags(1, true);
                }
            }
        }
        String sname = XBox.getCustomName(node);
        this.setRef(sname);
        this.setTextStreamValue(36, sname.getBytes());
        switch (this.box.getWidgetSubType()) {
            case -1004091177: {
                this.setXFARawDataType(XFARawDataType.TEXTEDIT);
                this.updateTextEdit();
                break;
            }
            case -878615035: {
                this.setXFARawDataType(XFARawDataType.IMAGEEDIT);
                this.updateImageEdit();
                break;
            }
            case 68595383: {
                this.setXFARawDataType(XFARawDataType.NUMERICEDIT);
                this.updateNumericEdit();
                break;
            }
            case 609537093: {
                this.setXFARawDataType(XFARawDataType.DATETIMEEDIT);
                this.updateDateTimeEdit();
                break;
            }
            case 566613829: {
                this.setXFARawDataType(XFARawDataType.PASSWORDEDIT);
                this.updatePasswordEdit();
                break;
            }
            case -1377687758: {
                this.setXFARawDataType(XFARawDataType.BUTTON);
                this.updateButton();
                break;
            }
            case 535284191: {
                this.setXFARawDataType(XFARawDataType.CHOICELIST);
                this.updateChoiceList();
                break;
            }
            case 1073584312: {
                this.setXFARawDataType(XFARawDataType.SIGNATURE);
                this.updateSignature();
                break;
            }
            case 282923610: {
                this.setXFARawDataType(XFARawDataType.CHECKBUTTON);
                this.updateCheckButton();
            }
        }
    }

    private void updateButton() {
        this.subtype = 7;
        this.updateFormBasics();
        if (this.captionBorderStrokeStr != null) {
            this.setBorderStroke(this.captionBorderStrokeStr);
        }
        if (this.captionBorderFillStr != null) {
            this.setBackgroundColor(this.captionBorderFillStr);
        }
        this.setType(1197118);
        this.setFlag(17, true);
        XFAFormStream.setupAppearances(this, false);
        if (this.captionData != null) {
            Font font = new Font(this.capFontInfo.getTypeFace(), this.capFontInfo.getWeight(), this.capFontInfo.getSize());
            this.setTextFont(font);
            this.setFontName(this.capFontInfo.getTypeFace());
            this.setTextSize(this.capFontInfo.getSize());
            this.setNormalCaption(this.captionData);
            PdfColor pColor = this.capFontInfo.getColor();
            int v = pColor.getRGB();
            int r = v >> 16 & 0xFF;
            int g = v >> 8 & 0xFF;
            int b = v & 0xFF;
            float[] colorArr = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
            this.setTextColor(colorArr);
            if (this.captionData != null) {
                this.capFontInfo.setTypeFace("Arial");
                this.setTextStreamValue(5137, this.createFakeDAforXFA(this.capFontInfo, this.captionData, this.captionHAlign));
            }
        }
    }

    private void updateCheckButton() {
        Node valueNode;
        Node nameAtr;
        Node btnNode;
        this.captionPlace = 3317767;
        this.updateFormBasics();
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
        this.setType(1197118);
        this.subtype = 9;
        Node uiNode = XFAFormStream.lookForChild(this.node, 3732);
        this.checkButtonMarkType = 94935104;
        if (uiNode != null && (btnNode = XFAFormStream.lookForChild(uiNode, 282923610)) != null) {
            block19: for (int z = 0; z < btnNode.getAttributes().getLength(); ++z) {
                Node attrNode = btnNode.getAttributes().item(z);
                switch (attrNode.getNodeName().hashCode()) {
                    case 109399969: {
                        switch (attrNode.getNodeValue().hashCode()) {
                            case 108704142: {
                                this.checkButtonShape = 108704142;
                            }
                        }
                        continue block19;
                    }
                    case 3530753: {
                        this.clickBtnSize = XFAUtils.convertToPoints(attrNode.getNodeValue());
                        continue block19;
                    }
                    case 3344077: {
                        this.checkButtonMarkType = attrNode.getNodeValue().hashCode();
                    }
                }
            }
        }
        double[] btnCoords = new double[]{this.coordsXYWH[0], this.coordsXYWH[1], this.coordsXYWH[2], this.coordsXYWH[3]};
        this.coordsXYWH[0] = this.coordsXYWH[0] + this.box.getMarginLeft();
        if (this.coordsXYWH[3] > this.clickBtnSize) {
            this.coordsXYWH[1] = this.coordsXYWH[1] + (this.fullBound[3] - this.clickBtnSize) / 2.0;
        }
        this.coordsXYWH[2] = this.clickBtnSize;
        this.coordsXYWH[3] = this.clickBtnSize;
        if (this.captionData != null) {
            if (this.fullBound[2] > 0.0 && this.reserveValue > this.fullBound[2]) {
                this.reserveValue = this.fullBound[2] - this.clickBtnSize;
            } else if (this.reserveValue <= 0.0) {
                switch (this.captionPlace) {
                    case 3317767: {
                        this.reserveValue = this.fullBound[2] - this.clickBtnSize;
                        break;
                    }
                    case 108511772: {
                        this.reserveValue = this.fullBound[2] - this.clickBtnSize;
                        break;
                    }
                    case 115029: {
                        this.reserveValue = this.fullBound[2];
                        break;
                    }
                    case -1383228885: {
                        this.reserveValue = this.fullBound[2];
                    }
                }
            }
            switch (this.captionPlace) {
                case 3317767: {
                    this.coordsXYWH[0] = this.coordsXYWH[0] + this.reserveValue;
                    btnCoords[2] = this.reserveValue;
                    break;
                }
                case 108511772: {
                    btnCoords[0] = btnCoords[0] + this.clickBtnSize + this.box.getMarginLeft();
                    btnCoords[2] = this.reserveValue;
                    break;
                }
                case 115029: {
                    break;
                }
            }
            if (this.dvr != null && this.captionData != null) {
                if (this.isCaptionHTML) {
                    this.parseHTML(btnCoords, this.capFontInfo, this.captionData, this.captionHAlign, this.captionVAlign);
                } else {
                    GraphicsState gs = new GraphicsState(0, 0);
                    gs.setFillType(1);
                    this.alignText(btnCoords, this.capFontInfo, this.captionHAlign, this.captionVAlign, this.captionData);
                }
            }
        }
        if (this.formBorderFillStr != null) {
            this.setBackgroundColor(this.formBorderFillStr);
        }
        if (this.formBorderStrokeStr != null) {
            this.setBorderStroke(this.formBorderStrokeStr);
        } else {
            this.setBorderStroke("solid");
        }
        this.setXYWH(this.coordsXYWH);
        Node parent = this.node.getParentNode();
        boolean nameInserted = false;
        String selectValue = "1";
        String nonSelectValue = "0";
        boolean isSelected = false;
        if (parent.getNodeName().hashCode() == 1644111747) {
            this.subtype = 8;
            this.setFieldFlags(16, true);
            if (parent.hasAttributes() && (nameAtr = parent.getAttributes().getNamedItem("name")) != null) {
                Node itemsNode;
                String hierName = XQuery.getDataBindName(parent);
                if (this.name != null) {
                    this.setRef(hierName + '.' + this.name);
                }
                if ((itemsNode = XFAFormStream.singleNodePicker(this.node, 100526016)) != null) {
                    selectValue = itemsNode.getTextContent().trim();
                }
                this.setTextStreamValue(36, hierName.getBytes());
                nameInserted = true;
            }
        } else {
            nameAtr = this.node.getAttributes().getNamedItem("name");
            if (nameAtr != null) {
                Element itemsEle;
                NodeList textList;
                Node itemsNode;
                String hierName = XQuery.getDataBindName(this.node);
                if (this.name != null) {
                    this.setRef(hierName + '.' + this.name);
                }
                if ((itemsNode = XFAFormStream.singleNodePicker(this.node, 100526016)) != null && (textList = (itemsEle = (Element)itemsNode).getElementsByTagName("text")).getLength() > 1) {
                    selectValue = textList.item(0).getTextContent().trim();
                    nonSelectValue = textList.item(0).getTextContent().trim();
                }
                this.setTextStreamValue(36, hierName.getBytes());
                nameInserted = true;
            }
        }
        if (!nameInserted) {
            String sname = XBox.getCustomName(this.node);
            this.setRef(sname);
            this.setTextStreamValue(36, sname.getBytes());
        }
        if (this.formData == null && (valueNode = XFAFormStream.lookForChild(this.node, 111972721)) != null) {
            this.formData = valueNode.getTextContent();
        }
        if (this.formData != null && this.formData.equals(selectValue)) {
            isSelected = true;
            this.setName(4387, "On".getBytes());
            this.setTextStreamValue(38, selectValue);
        } else {
            this.setTextStreamValue(38, nonSelectValue);
        }
        this.setSelected(isSelected);
        XFAFormStream.setupAppearances(this, isSelected);
    }

    private void updateChoiceList() {
        String defaultValue = null;
        ArrayList<Node> itemList = new ArrayList<Node>();
        block4: for (int z = 0; z < this.node.getChildNodes().getLength(); ++z) {
            Node child = this.node.getChildNodes().item(z);
            switch (child.getNodeName().hashCode()) {
                case 111972721: {
                    defaultValue = child.getTextContent();
                    continue block4;
                }
                case 100526016: {
                    itemList.add(child);
                }
            }
        }
        Node ui = XFAFormStream.lookForChild(this.node, 3732);
        boolean isMultiSelect = false;
        if (ui != null) {
            for (int z = 0; z < ui.getChildNodes().getLength(); ++z) {
                Node child = ui.getChildNodes().item(z);
                if (child.getNodeName().hashCode() != 535284191) continue;
                for (int a = 0; a < child.getAttributes().getLength(); ++a) {
                    Node attr = child.getAttributes().item(a);
                    if (attr.getNodeName().hashCode() != 3417674) continue;
                    isMultiSelect = true;
                }
            }
        }
        this.updateFormBasics();
        this.setType(4920);
        if (isMultiSelect) {
            this.setFlag(22, true);
            this.subtype = FormFactory.LIST;
        } else {
            this.setFlag(18, true);
            this.subtype = 2;
        }
        Node itemsNode = !itemList.isEmpty() ? (Node)itemList.get(0) : null;
        LinkedHashMap<String, Integer> selectionMap = new LinkedHashMap<String, Integer>();
        if (itemsNode != null) {
            int z;
            Object[] obj;
            Node keyNode;
            ArrayList<byte[]> optionList = new ArrayList<byte[]>();
            int count = 0;
            for (int z2 = 0; z2 < itemsNode.getChildNodes().getLength(); ++z2) {
                String string = itemsNode.getChildNodes().item(z2).getTextContent();
                if (string == null || string.isEmpty()) continue;
                optionList.add(string.getBytes());
                selectionMap.put(string, count);
                ++count;
            }
            Object[] options = optionList.toArray();
            Object[] objectArray = new Object[options.length];
            count = 0;
            Node node = keyNode = itemList.size() == 2 ? (Node)itemList.get(1) : null;
            if (keyNode != null && keyNode.getNodeName().hashCode() == 100526016) {
                selectionMap.clear();
                obj = new Object[options.length];
                for (z = 0; z < keyNode.getChildNodes().getLength(); ++z) {
                    Object[] temp;
                    String data = keyNode.getChildNodes().item(z).getTextContent();
                    if (data == null || data.isEmpty() || count >= objectArray.length) continue;
                    objectArray[count] = data.getBytes();
                    obj[count] = temp = new Object[]{objectArray[count], options[count]};
                    selectionMap.put(data, count);
                    ++count;
                }
                this.setObjectArray(2048068, obj);
            } else {
                obj = new Object[selectionMap.size()];
                for (z = 0; z < selectionMap.size(); ++z) {
                    Object[] temp;
                    obj[z] = temp = new Object[]{options[z], options[z]};
                }
                this.setObjectArray(2048068, obj);
            }
        }
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
        this.drawForm();
        this.drawFormCaption();
        this.completeFormBorder();
        Map<String, String> map = this.getValuesMap(true);
        XFontInfo xFontInfo = this.box.getFormFontInfo();
        if (this.formData == null) {
            if (defaultValue != null && map != null && map.get(defaultValue) != null) {
                this.setSelectedItem(defaultValue);
                this.setTextStreamValue(5137, this.createFakeDAforXFA(xFontInfo, map.get(defaultValue), this.formHAlign));
            }
        } else if (map != null) {
            this.setSelectedItem(this.formData);
            for (String string : selectionMap.keySet()) {
                if (!string.equalsIgnoreCase(this.formData)) continue;
                this.setSelectedIndex((Integer)selectionMap.get(string));
            }
            for (Object e : map.keySet()) {
                String ss = (String)e;
                if (!ss.equalsIgnoreCase(this.formData)) continue;
                String val = map.get(e);
                this.setTextStreamValue(5137, this.createFakeDAforXFA(xFontInfo, val, this.formHAlign));
            }
        } else {
            Object[] objectArray = new Object[]{this.formData.getBytes(), this.formData.getBytes()};
            Object[] obj = new Object[]{objectArray};
            this.setObjectArray(2048068, obj);
            this.setSelectedIndex(0);
            this.setTextStreamValue(5137, this.createFakeDAforXFA(xFontInfo, this.getSelectedItem(), this.formHAlign));
        }
        XFAFormStream.setupAppearances(this, false);
    }

    private void updateDateTimeEdit() {
        Node defaultDate;
        this.isDateTimeField = true;
        this.updateFormBasics();
        this.setType(9288);
        this.setFlag(13, false);
        this.setFlag(14, false);
        if (this.formData == null && (defaultDate = this.fieldEle.getElementsByTagName("date").item(0)) != null) {
            this.formData = defaultDate.getTextContent();
        }
        if (this.formData != null) {
            if (this.inputPicture != null && this.outputPicture != null) {
                this.formData = XFormCalc.getFormattedDateTime(this.inputPicture, this.outputPicture, this.formData);
            } else if (this.outputPicture != null) {
                this.formData = XFormCalc.getFormattedDateTime(this.outputPicture, this.formData);
            }
            this.setTextStreamValue(38, this.formData);
        }
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
        this.drawForm();
        this.drawFormCaption();
        this.completeFormBorder();
        if (this.formData != null) {
            XFontInfo xFontInfo = this.box.getFormFontInfo();
            this.setTextStreamValue(5137, this.createFakeDAforXFA(xFontInfo, this.formData, this.formHAlign));
        }
        this.subtype = 3;
        XFAFormStream.setupAppearances(this, false);
    }

    private void updateImageEdit() {
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
    }

    private void updateNumericEdit() {
        this.updateFormBasics();
        this.setType(9288);
        this.setFlag(13, false);
        this.setFlag(14, false);
        if (this.outputPicture != null) {
            this.formData = XFormCalc.getFormattedNumeric(this.outputPicture, this.formData);
        } else if (this.formData != null && this.formData.contains(".00")) {
            this.formData = this.formData.substring(0, this.formData.indexOf(46));
        }
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
        this.drawForm();
        this.drawFormCaption();
        this.completeFormBorder();
        this.subtype = 3;
        if (this.formData != null) {
            this.setTextStreamValue(38, this.formData);
            this.setTextStreamValue(5137, this.createFakeDAforXFA(this.box.getFormFontInfo(), this.formData, this.formHAlign));
        }
        XFAFormStream.setupAppearances(this, false);
    }

    private void updatePasswordEdit() {
        this.updateFormBasics();
        this.setType(9288);
        this.setFlag(13, false);
        this.setFlag(14, true);
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
        this.drawForm();
        this.drawFormCaption();
        this.completeFormBorder();
        this.subtype = 6;
        XFAFormStream.setupAppearances(this, false);
    }

    private void updateSignature() {
        this.updateFormBasics();
        this.setType(2308407);
        this.drawForm();
        this.drawFormCaption();
        this.completeFormBorder();
        this.subtype = 11;
        XFAFormStream.setupAppearances(this, false);
    }

    private void updateTextEdit() {
        this.updateFormBasics();
        this.setType(9288);
        this.setFlag(13, this.box.isContainMultiline());
        this.setFlag(14, false);
        if (this.dvr != null) {
            XFADraw.drawBorder(this.dvr, this.node, this.fullBound);
        }
        this.drawForm();
        this.drawFormCaption();
        this.completeFormBorder();
        if (this.outputPicture != null) {
            this.formData = XFormCalc.getFormattedText(this.outputPicture, this.formData);
        }
        if (this.formData != null) {
            this.setTextStreamValue(38, this.formData);
        } else {
            block7: for (int z = 0; z < this.node.getChildNodes().getLength(); ++z) {
                Node child = this.node.getChildNodes().item(z);
                switch (child.getNodeName().hashCode()) {
                    case 111972721: {
                        if (!child.hasChildNodes()) continue block7;
                        Node valueNode = null;
                        block8: for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                            Node temp = child.getChildNodes().item(i);
                            switch (temp.getNodeName().hashCode()) {
                                case 3556653: {
                                    valueNode = temp;
                                    continue block8;
                                }
                                case -1290477827: {
                                    valueNode = temp;
                                }
                            }
                        }
                        if (valueNode == null) continue block7;
                        this.formData = valueNode.getTextContent();
                        this.setTextStreamValue(38, this.formData);
                    }
                }
            }
        }
        this.subtype = 5;
        if (this.formData != null) {
            XFontInfo xFontInfo = this.box.getFormFontInfo();
            this.setTextStreamValue(5137, this.createFakeDAforXFA(xFontInfo, this.formData, this.formHAlign));
        }
        XFAFormStream.setupAppearances(this, false);
    }

    private void updateFormBasics() {
        Font font = new Font(this.box.getFormFontInfo().getTypeFace(), this.box.getFormFontInfo().getWeight(), this.box.getFormFontInfo().getSize());
        this.setTextFont(font);
        this.setFontName(font.getFontName());
        this.setTextSize(font.getSize());
        boolean captionFound = false;
        NodeList cList = this.node.getChildNodes();
        block58: for (int q = 0; q < cList.getLength(); ++q) {
            Node child = cList.item(q);
            String cName = child.getNodeName();
            switch (cName.hashCode()) {
                case 552573414: {
                    int z;
                    if (captionFound) continue block58;
                    captionFound = true;
                    if (child.hasAttributes()) {
                        NamedNodeMap nnm = child.getAttributes();
                        block59: for (z = 0; z < nnm.getLength(); ++z) {
                            switch (nnm.item(z).getNodeName().hashCode()) {
                                case 1097075900: {
                                    this.reserveValue = XFAUtils.convertToPoints(nnm.item(z).getNodeValue());
                                    continue block59;
                                }
                                case 1792938725: {
                                    this.captionPlace = nnm.item(z).getNodeValue().hashCode();
                                }
                            }
                        }
                    }
                    block60: for (int z2 = 0; z2 < child.getChildNodes().getLength(); ++z2) {
                        Node capChild = child.getChildNodes().item(z2);
                        switch (capChild.getNodeName().hashCode()) {
                            case 111972721: {
                                Node exNode = XFAFormStream.lookForChild(capChild, -1290477827);
                                if (exNode != null) {
                                    if (this.box.getWidgetSubType() == -1377687758) {
                                        this.captionData = exNode.getTextContent().trim();
                                        continue block60;
                                    }
                                    TransformerFactory transFactory = SecureTransformerFactory.newInstance();
                                    try {
                                        Transformer transformer = transFactory.newTransformer();
                                        StringWriter buffer = new StringWriter();
                                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                                        Node bodyNode = XFAFormStream.lookForChild(exNode, 3029410);
                                        transformer.transform(new DOMSource(bodyNode), new StreamResult(buffer));
                                        this.captionData = buffer.toString();
                                        this.isCaptionHTML = true;
                                    }
                                    catch (Exception e) {
                                        this.isCaptionHTML = false;
                                        this.captionData = exNode.getTextContent().trim();
                                        LogWriter.writeLog("Exception in XML parsing " + e);
                                    }
                                    continue block60;
                                }
                                Node textNode = XFAFormStream.lookForChild(capChild, 3556653);
                                if (textNode == null) continue block60;
                                this.captionData = textNode.getTextContent();
                                continue block60;
                            }
                            case 3148879: {
                                this.capFontInfo = XFontInfo.getFontInfoFromNode(capChild);
                                this.foundCaptionFont = true;
                                continue block60;
                            }
                            case 3433440: {
                                block61: for (int c = 0; c < capChild.getAttributes().getLength(); ++c) {
                                    String pName = capChild.getAttributes().item(c).getNodeName();
                                    String value = capChild.getAttributes().item(c).getNodeValue();
                                    switch (pName.hashCode()) {
                                        case -1254185091: {
                                            switch (value.hashCode()) {
                                                case 108511772: {
                                                    this.captionHAlign = 108511772;
                                                    break;
                                                }
                                                case 3317767: {
                                                    this.captionHAlign = 3317767;
                                                    break;
                                                }
                                                case -1364013995: {
                                                    this.captionHAlign = -1364013995;
                                                }
                                            }
                                            continue block61;
                                        }
                                        case -853376977: {
                                            switch (value.hashCode()) {
                                                case 115029: {
                                                    this.captionVAlign = 115029;
                                                    break;
                                                }
                                                case -1074341483: {
                                                    this.captionVAlign = -1074341483;
                                                    break;
                                                }
                                                case -1383228885: {
                                                    this.captionVAlign = -1383228885;
                                                }
                                            }
                                            continue block61;
                                        }
                                        case 1970934485: {
                                            continue block61;
                                        }
                                    }
                                }
                                continue block60;
                            }
                        }
                    }
                    continue block58;
                }
                case 3433440: {
                    int z;
                    if (!child.hasAttributes()) continue block58;
                    NamedNodeMap nnm = child.getAttributes();
                    for (z = 0; z < nnm.getLength(); ++z) {
                        String value = nnm.item(z).getNodeValue();
                        block32 : switch (nnm.item(z).getNodeName().hashCode()) {
                            case -1254185091: {
                                switch (value.hashCode()) {
                                    case 3317767: {
                                        this.formHAlign = 3317767;
                                        this.setIntNumber(33, 0);
                                        break block32;
                                    }
                                    case -1364013995: {
                                        this.formHAlign = -1364013995;
                                        this.setIntNumber(33, 1);
                                        break block32;
                                    }
                                    case 108511772: {
                                        this.formHAlign = 108511772;
                                        this.setIntNumber(33, 2);
                                    }
                                }
                            }
                        }
                    }
                    continue block58;
                }
                case 3732: {
                    this.scanUINodes(child);
                    for (int u = 0; u < child.getChildNodes().getLength(); ++u) {
                        Node uiChild = child.getChildNodes().item(u);
                        switch (uiChild.getNodeName().hashCode()) {
                            case -577741570: {
                                this.inputPicture = uiChild.getTextContent();
                            }
                        }
                    }
                    continue block58;
                }
                case -1268779017: {
                    for (int f = 0; f < child.getChildNodes().getLength(); ++f) {
                        Node formatChild = child.getChildNodes().item(f);
                        switch (formatChild.getNodeName().hashCode()) {
                            case -577741570: {
                                this.outputPicture = formatChild.getTextContent();
                            }
                        }
                    }
                    continue block58;
                }
                case -1383304148: {
                    block65: for (int c = 0; c < child.getChildNodes().getLength(); ++c) {
                        Node cNode = child.getChildNodes().item(c);
                        switch (cNode.getNodeName().hashCode()) {
                            case 3143043: {
                                Node color = XFAFormStream.lookForChild(cNode, 94842723);
                                if (color == null || !color.hasAttributes()) continue block65;
                                for (int col = 0; col < color.getAttributes().getLength(); ++col) {
                                    switch (color.getAttributes().item(col).getNodeName().hashCode()) {
                                        case 111972721: {
                                            this.captionBorderFillStr = color.getAttributes().item(col).getNodeValue();
                                        }
                                    }
                                }
                                continue block65;
                            }
                            case -1354665387: {
                                continue block65;
                            }
                            case 3108285: {
                                block67: for (int att = 0; att < cNode.getAttributes().getLength(); ++att) {
                                    Node attNode = cNode.getAttributes().item(att);
                                    switch (attNode.getNodeName().hashCode()) {
                                        case -891980232: {
                                            this.captionBorderStrokeStr = attNode.getNodeValue();
                                            continue block67;
                                        }
                                    }
                                }
                                continue block65;
                            }
                        }
                    }
                    continue block58;
                }
            }
        }
        if (!this.foundCaptionFont) {
            this.capFontInfo = this.box.getFormFontInfo();
        }
    }

    private void completeFormBorder() {
        if (this.BS == null) {
            this.BS = new FormObject();
        }
        this.BS.setIntNumber(39, 1);
        this.setLineWidth(1);
        if (this.formBorderFillStr != null) {
            this.setBackgroundColor(this.formBorderFillStr);
        }
        if (this.formBorderStrokeStr != null) {
            this.getDictionary(7451).setFloatArray(4627, new float[]{0.6f, 0.6f, 0.7f});
            this.setBorderStroke(this.formBorderStrokeStr);
        }
        boolean hasFormBorder = false;
        block4: for (int i = 0; i < this.node.getChildNodes().getLength(); ++i) {
            Node child = this.node.getChildNodes().item(i);
            switch (child.getNodeName().hashCode()) {
                case -1383304148: {
                    hasFormBorder = true;
                    continue block4;
                }
                case 3732: {
                    Element uiEle = (Element)child;
                    NodeList list = uiEle.getElementsByTagName("border");
                    if (list.getLength() <= 0) continue block4;
                    hasFormBorder = true;
                    Element borderEle = (Element)list.item(0);
                    if ("hidden".equals(borderEle.getAttribute("presence"))) continue block4;
                    NodeList edgeList = borderEle.getElementsByTagName("edge");
                    if (edgeList.getLength() == 0) {
                        this.internalMattes = new int[]{1, 1, 1, 1};
                        continue block4;
                    }
                    if (edgeList.getLength() == 1) {
                        Element edgeEle = (Element)edgeList.item(0);
                        String presence = edgeEle.getAttribute("presence");
                        if ("hidden".equals(presence)) {
                            this.internalMattes = new int[]{0, 0, 0, 0};
                            continue block4;
                        }
                        this.internalMattes = new int[]{1, 1, 1, 1};
                        continue block4;
                    }
                    if (edgeList.getLength() <= 1) continue block4;
                    for (int j = 0; j < Math.min(edgeList.getLength(), 4); ++j) {
                        Element edgeEle = (Element)edgeList.item(j);
                        String presence = edgeEle.getAttribute("presence");
                        if ("hidden".equals(presence)) continue;
                        this.internalMattes[j] = 1;
                    }
                    continue block4;
                }
            }
        }
        if (!hasFormBorder) {
            this.internalMattes = new int[]{1, 1, 1, 1};
        }
        this.setMatteBorderDetails(this.internalMattes);
    }

    public void drawFormCaption() {
        if (this.dvr == null) {
            return;
        }
        double[] arrs = new double[]{this.fullBound[0], this.fullBound[1], this.fullBound[2], this.fullBound[3]};
        if (this.captionData != null && this.isVisible) {
            switch (this.captionPlace) {
                case 3317767: {
                    arrs[2] = this.reserveValue;
                    arrs[0] = arrs[0] + this.box.getMarginLeft();
                    arrs[1] = arrs[1] + this.box.getMarginBottom();
                    arrs[3] = arrs[3] - this.box.getMarginTop() - this.box.getMarginBottom();
                    break;
                }
                case 115029: {
                    arrs[1] = arrs[1] + (arrs[3] - this.reserveValue);
                    arrs[3] = this.reserveValue;
                    arrs[0] = arrs[0] + this.box.getMarginLeft();
                    arrs[1] = arrs[1] - this.box.getMarginTop();
                    arrs[2] = arrs[2] - this.box.getMarginLeft() - this.box.getMarginRight();
                    break;
                }
                case -1383228885: {
                    arrs[3] = this.reserveValue;
                    arrs[0] = arrs[0] + this.box.getMarginLeft();
                    arrs[1] = arrs[1] + this.box.getMarginBottom();
                    arrs[2] = arrs[2] - this.box.getMarginLeft() - this.box.getMarginRight();
                    break;
                }
                case 108511772: {
                    arrs[0] = arrs[0] + (arrs[2] - this.reserveValue);
                    arrs[2] = this.reserveValue;
                    arrs[0] = arrs[0] - this.box.getMarginRight();
                    arrs[1] = arrs[1] + this.box.getMarginBottom();
                    arrs[2] = arrs[2] - this.box.getMarginRight();
                    arrs[3] = arrs[3] - this.box.getMarginTop() - this.box.getMarginBottom();
                }
            }
            if (this.captionHAlign == 108511772 && !this.isCaptionHTML) {
                this.captionData = this.captionData.trim();
            }
            if (this.isCaptionHTML) {
                this.parseHTML(arrs, this.capFontInfo, this.captionData, this.captionHAlign, this.captionVAlign);
            } else {
                GraphicsState gs = new GraphicsState(0, 0);
                gs.setFillType(1);
                this.alignText(arrs, this.capFontInfo, this.captionHAlign, this.captionVAlign, this.captionData);
            }
        }
    }

    public void drawForm() {
        double[] arr = new double[]{this.coordsXYWH[0], this.coordsXYWH[1], this.coordsXYWH[2], this.coordsXYWH[3]};
        if (this.reserveValue == 0.0 && this.captionData != null) {
            if (this.isCaptionHTML) {
                Dimension dim = this.findExdataDimension(this.coordsXYWH, this.box, this.capFontInfo, this.captionData, this.captionHAlign, this.captionVAlign);
                if (this.captionPlace == 3317767 || this.captionPlace == 108511772) {
                    this.reserveValue = dim.getWidth();
                } else if (this.captionPlace == 115029 || this.captionPlace == -1383228885) {
                    this.reserveValue = dim.getHeight();
                }
            } else if (this.captionPlace == 3317767 || this.captionPlace == 108511772) {
                this.reserveValue = XFAFormStream.getTempTotalWidth(this.capFontInfo, this.captionData, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
            } else if (this.captionPlace == 115029 || this.captionPlace == -1383228885) {
                this.reserveValue = this.capFontInfo.getSize();
            }
            if (this.reserveValue > this.coordsXYWH[2]) {
                this.reserveValue = this.coordsXYWH[2];
            }
        }
        switch (this.captionPlace) {
            case 3317767: {
                arr[0] = arr[0] + this.reserveValue;
                arr[2] = arr[2] - this.reserveValue;
                break;
            }
            case 115029: {
                arr[3] = arr[3] - this.reserveValue;
                break;
            }
            case -1383228885: {
                arr[1] = arr[1] + this.reserveValue;
                arr[3] = arr[3] - this.reserveValue;
                break;
            }
            case 108511772: {
                arr[2] = arr[2] - this.reserveValue;
                break;
            }
            default: {
                arr[0] = arr[0] + this.reserveValue;
                arr[2] = arr[2] - this.reserveValue;
            }
        }
        arr[0] = arr[0] + this.box.getMarginLeft();
        arr[1] = arr[1] + this.box.getMarginBottom();
        arr[2] = arr[2] - this.box.getMarginRight() - this.box.getMarginLeft();
        arr[3] = arr[3] - this.box.getMarginTop() - this.box.getMarginBottom();
        this.setXYWH(arr);
        System.arraycopy(arr, 0, this.coordsXYWH, 0, 4);
    }

    public String getName() {
        return this.name;
    }

    public byte[] createFakeDAforXFA(XFontInfo xFontInfo, String data, int HAlign) {
        int toDJSize;
        String dummyJJstring;
        int indent = 5;
        data = data.replace("(", "\\(");
        data = data.replace(")", "\\)");
        data = data.replace('\r', '\n');
        data = data.replace("\n\n", "\n \n");
        if (this.subtype == 4 || this.subtype == 6) {
            data = data.replaceAll("\\.", "*");
        }
        double componentWidth = this.getBoundingRectangle().width;
        if (data.contains("\n")) {
            StringTokenizer lines = new StringTokenizer(data, "\n");
            StringBuilder otherLines = new StringBuilder(data.length());
            double diff = 0.0;
            double lastDiff = 0.0;
            while (lines.hasMoreTokens()) {
                String nextLine = lines.nextToken();
                double textWidth = XFAFormStream.getPdfFontTotalWidth(xFontInfo, nextLine, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                switch (HAlign) {
                    case 108511772: {
                        diff = componentWidth - textWidth - 5.0;
                        break;
                    }
                    case -1364013995: {
                        diff = (componentWidth - textWidth) / 2.0 - 5.0;
                    }
                }
                if (diff < 0.0) {
                    diff = 0.0;
                }
                String toAdd = diff - lastDiff + " -" + xFontInfo.getSize() + " Td ";
                otherLines.append(toAdd);
                lastDiff = diff;
                otherLines.append(" [(").append(nextLine).append(")]TJ ");
            }
            dummyJJstring = otherLines.toString();
        } else {
            double textWidth = XFAFormStream.getPdfFontTotalWidth(this.capFontInfo, data, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
            double diff = 0.0;
            switch (HAlign) {
                case 108511772: {
                    diff = componentWidth - textWidth - 5.0;
                    break;
                }
                case -1364013995: {
                    diff = (componentWidth - textWidth) / 2.0 - 5.0;
                }
            }
            dummyJJstring = diff > 0.0 ? diff + " 0 Td " + '(' + data + ")Tj " : '(' + data + ")Tj ";
        }
        Color textColor = this.getTextColor();
        if (textColor == null) {
            textColor = Color.BLACK;
        }
        toDJSize = (toDJSize = xFontInfo.getSize()) == 0 ? 10 : toDJSize;
        dummyJJstring = "BT " + textColor.getRed() + ' ' + textColor.getGreen() + ' ' + textColor.getBlue() + " rg Arial" + ' ' + toDJSize + " Tf 1 TFS " + dummyJJstring;
        if (DecoderOptions.isRunningOnWindows) {
            return dummyJJstring.getBytes();
        }
        try {
            return dummyJJstring.getBytes("Cp1252");
        }
        catch (UnsupportedEncodingException ex) {
            LogWriter.writeLog(ex);
            LogWriter.writeLog("XFA XML Encoding error " + ex);
            return null;
        }
    }

    private void drawEmbeddedText(float[][] trm, int textX, int textY, GraphicsState gs, String data, XFontInfo xFontInfo) {
        this.decoder.incrementTokenNumber();
        PdfFont currentFont = XFAFormStream.resolveFont(xFontInfo, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
        this.textDecoder.setGS(gs);
        TextState currentTextState = new TextState();
        currentTextState.Tm = new float[][]{{xFontInfo.getSize(), 0.0f, 0.0f}, {0.0f, xFontInfo.getSize(), 0.0f}, {textX, textY, 1.0f}};
        currentTextState.setTMAtLineStart();
        if (data != null) {
            byte[] dummyJJstring = this.createFakeDAforXFA(xFontInfo, data, this.captionHAlign);
            this.setTextStreamValue(5137, dummyJJstring);
            this.textDecoder.TJ(currentTextState, currentFont, dummyJJstring, 0, dummyJJstring.length, false);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public void alignText(double[] formCoords, XFontInfo fontInfo, int hAlign, int vAlign, String cData) {
        GraphicsState gs = new GraphicsState();
        gs.setFillType(2);
        gs.nonstrokeColorSpace.setColor(fontInfo.getColor());
        double x = formCoords[0];
        double y = formCoords[1];
        double w = formCoords[2];
        double h = formCoords[3];
        float[][] trm = new float[3][3];
        trm[0][0] = fontInfo.getSize();
        trm[1][1] = fontInfo.getSize();
        Font font = new Font(fontInfo.getTypeFace(), fontInfo.getWeight(), fontInfo.getSize());
        AffineTransform af = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(af, false, false);
        LineMetrics fontMetrics = font.getLineMetrics("Ayfgqp", frc);
        float descent = fontMetrics.getDescent();
        double fontHeight = font.getSize();
        double totalWidth = XFAFormStream.getTempTotalWidth(fontInfo, cData, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
        HashMap<Integer, String> lineMap = XFAFormStream.getTotalLines(w, cData, fontInfo, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
        if (lineMap.size() == 1) {
            switch (hAlign) {
                case -1364013995: {
                    trm[2][0] = (float)((w - totalWidth) / 2.0 + x);
                    break;
                }
                case 108511772: {
                    trm[2][0] = w > 0.0 ? (float)(w - totalWidth + x) : (float)x;
                    break;
                }
                case 3317767: {
                    trm[2][0] = (float)x;
                    break;
                }
                default: {
                    trm[2][0] = (float)x;
                }
            }
            switch (vAlign) {
                case 115029: {
                    if (h > 0.0) {
                        trm[2][1] = (float)(y + h - fontHeight);
                        break;
                    }
                    trm[2][1] = (float)(y - fontHeight);
                    break;
                }
                case -1074341483: {
                    if (h > 0.0) {
                        trm[2][1] = h > fontHeight ? (float)(y + (double)descent + (h - fontHeight) / 2.0) : (float)y + descent;
                        break;
                    }
                    trm[2][1] = (float)(y + (double)descent);
                    break;
                }
                case -1383228885: {
                    trm[2][1] = (float)(y + (double)descent);
                }
            }
            this.drawEmbeddedText(trm, (int)trm[2][0], (int)trm[2][1], gs, cData, fontInfo);
        } else {
            int totalHeight = fontInfo.getSize() * lineMap.size();
            switch (vAlign) {
                case 115029: {
                    trm[2][1] = (float)h;
                    break;
                }
                case -1074341483: {
                    if (h <= (double)totalHeight) {
                        trm[2][1] = (float)h;
                        break;
                    }
                    trm[2][1] = (float)(h - (h - (double)totalHeight) / 2.0);
                    break;
                }
                case -1383228885: {
                    trm[2][1] = h < (double)totalHeight ? (float)h : (float)(h - (h - (double)totalHeight));
                }
            }
            float[] fArray = trm[2];
            fArray[1] = fArray[1] + (float)y;
            for (int z = 1; z <= lineMap.size(); ++z) {
                String text = lineMap.get(z);
                switch (hAlign) {
                    case 3317767: {
                        trm[2][0] = (float)x;
                        break;
                    }
                    case -1364013995: {
                        double tc = XFAFormStream.getTempTotalWidth(fontInfo, text, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                        trm[2][0] = (float)((w - tc) / 2.0 + x);
                        break;
                    }
                    case 108511772: {
                        double tr = XFAFormStream.getTempTotalWidth(fontInfo, text, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                        trm[2][0] = w > 0.0 ? (float)(w - tr + x) : (float)x;
                        break;
                    }
                    default: {
                        trm[2][0] = (float)x;
                    }
                }
                float[] fArray2 = trm[2];
                fArray2[1] = fArray2[1] - (float)fontHeight;
                this.drawEmbeddedText(trm, (int)trm[2][0], (int)trm[2][1], gs, text, fontInfo);
            }
        }
    }

    public static void drawRectangle(DynamicVectorRenderer render, double[] area, int fillType, PdfColor pdfColor) {
        GraphicsState gs = new GraphicsState();
        switch (fillType) {
            case 1: {
                if (pdfColor != null) {
                    gs.strokeColorSpace.setColor(pdfColor);
                }
                gs.setFillType(1);
                if (render == null) break;
                XFAField.drawColorLine(render, gs, area[0] + area[2], area[1] + area[3], area[0], area[1] + area[3]);
                XFAField.drawColorLine(render, gs, area[0] + area[2], area[1], area[0] + area[2], area[1] + area[3]);
                XFAField.drawColorLine(render, gs, area[0], area[1], area[0] + area[2], area[1]);
                XFAField.drawColorLine(render, gs, area[0], area[1] + area[3], area[0], area[1]);
                break;
            }
            case 2: {
                float[][] ctm = new float[3][3];
                ctm[0][0] = 1.0f;
                ctm[1][1] = 1.0f;
                ctm[2][2] = 1.0f;
                SwingShape pdfShape = new SwingShape();
                pdfShape.appendRectangle((float)area[0], (float)area[1], (float)area[2], (float)area[3]);
                Shape result = pdfShape.generateShapeFromPath(ctm, 3.0f, 0);
                if (pdfColor != null) {
                    gs.nonstrokeColorSpace.setColor(pdfColor);
                }
                gs.setFillType(2);
                if (render == null) break;
                render.drawShape(new SwingShape(result), gs, 83);
            }
        }
    }

    public String getCaptionData() {
        return this.captionData;
    }

    public boolean hasBgColor() {
        return this.hasBgColor;
    }

    public int getSubtype() {
        return this.subtype;
    }

    private void scanUINodes(Node child) {
        String strokeStr = null;
        Node borderNode = XFAFormStream.singleNodePicker(child, -1383304148);
        boolean isEdgeHidden = false;
        if (borderNode != null) {
            block11: for (int z = 0; z < borderNode.getChildNodes().getLength(); ++z) {
                Node bChild = borderNode.getChildNodes().item(z);
                switch (bChild.getNodeName().hashCode()) {
                    case 3108285: {
                        if (!bChild.hasAttributes()) continue block11;
                        block12: for (int a = 0; a < bChild.getAttributes().getLength(); ++a) {
                            Node bAttr = bChild.getAttributes().item(a);
                            switch (bAttr.getNodeName().hashCode()) {
                                case -1276666629: {
                                    if (bAttr.getNodeValue().hashCode() != -1217487446) continue block12;
                                    isEdgeHidden = true;
                                    continue block12;
                                }
                                case -891980232: {
                                    strokeStr = bAttr.getNodeValue();
                                }
                            }
                        }
                        continue block11;
                    }
                    case 3143043: {
                        Node color = XFAFormStream.lookForChild(bChild, 94842723);
                        if (color == null || !color.hasAttributes()) continue block11;
                        for (int col = 0; col < color.getAttributes().getLength(); ++col) {
                            switch (color.getAttributes().item(col).getNodeName().hashCode()) {
                                case 111972721: {
                                    this.formBorderFillStr = color.getAttributes().item(col).getNodeValue();
                                }
                            }
                        }
                        continue block11;
                    }
                }
            }
            if (!isEdgeHidden) {
                this.formBorderStrokeStr = strokeStr;
            }
        }
    }

    public static void drawLine(DynamicVectorRenderer dvr, double fromX, double fromY, double toX, double toY) {
        if (dvr != null) {
            GraphicsState gsl = new GraphicsState(0, 0);
            gsl.setFillType(1);
            SwingShape lineShape = new SwingShape();
            lineShape.moveTo((float)fromX, (float)fromY);
            lineShape.lineTo((float)toX, (float)toY);
            float[][] lineCtm = new float[3][3];
            lineCtm[0][0] = 1.0f;
            lineCtm[1][1] = 1.0f;
            lineCtm[2][2] = 1.0f;
            Shape lineResult = lineShape.generateShapeFromPath(lineCtm, 3.0f, 0);
            dvr.drawShape(new SwingShape(lineResult), gsl, 83);
        }
    }

    public static void drawColorLine(DynamicVectorRenderer dvr, GraphicsState gsl, double fromX, double fromY, double toX, double toY) {
        if (dvr != null) {
            SwingShape lineShape = new SwingShape();
            lineShape.moveTo((float)fromX, (float)fromY);
            lineShape.lineTo((float)toX, (float)toY);
            float[][] lineCtm = new float[3][3];
            lineCtm[0][0] = 1.0f;
            lineCtm[1][1] = 1.0f;
            lineCtm[2][2] = 1.0f;
            Shape lineResult = lineShape.generateShapeFromPath(lineCtm, 3.0f, 0);
            dvr.drawShape(new SwingShape(lineResult), gsl, 83);
        }
    }

    public String getInputPicture() {
        return this.inputPicture;
    }

    public String getOutputPicture() {
        return this.outputPicture;
    }

    public boolean isDateTimeField() {
        return this.isDateTimeField;
    }

    public Dimension findExdataDimension(double[] coords, XBox box, XFontInfo fontInfo, String htmlData, int hAlign, int vAlign) {
        HashMap<Integer, ArrayList> lineMap = new HashMap<Integer, ArrayList>();
        HashMap<Integer, XFAStyle> map = XFADraw.parseExDataToMap(fontInfo, htmlData, hAlign);
        double maxW = coords[2] - box.getMarginRight() - box.getMarginLeft();
        if (box.getW() == 0.0) {
            for (int z = 0; z < map.size(); ++z) {
                XFAStyle style = map.get(z);
                ArrayList<XFAStyle> list = new ArrayList<XFAStyle>();
                if ("<br/>".equals(style.getStyleData())) {
                    style.setStyleData("");
                    list.add(style);
                    lineMap.put(lineMap.size(), list);
                    continue;
                }
                if (lineMap.containsKey(lineMap.size() - 1)) {
                    ((ArrayList)lineMap.get(lineMap.size() - 1)).add(style);
                    continue;
                }
                list.add(style);
                lineMap.put(lineMap.size(), list);
            }
        } else {
            double lineLen = 0.0;
            for (int z = 0; z < map.size(); ++z) {
                XFAStyle style = map.get(z);
                String dataStr = style.getStyleData();
                ArrayList list = new ArrayList();
                if ("<br/>".equals(style.getStyleData())) {
                    style.setStyleData("");
                    list.add(style);
                    lineMap.put(lineMap.size(), list);
                    lineLen = 0.0;
                    continue;
                }
                double dataLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), dataStr, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                if (dataLen <= maxW - lineLen) {
                    if (lineMap.containsKey(lineMap.size() - 1)) {
                        ((ArrayList)lineMap.get(lineMap.size() - 1)).add(style);
                    } else {
                        list.add(style);
                        lineMap.put(lineMap.size(), list);
                    }
                    lineLen += dataLen;
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                StringBuilder spaceB = new StringBuilder();
                for (int c = 0; c < dataStr.length(); ++c) {
                    String cStr = String.valueOf(dataStr.charAt(c));
                    double spaceLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), spaceB.toString(), this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                    double charLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), cStr, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                    double availW = maxW - lineLen;
                    lineLen += charLen;
                    if (availW < charLen && !" ".equals(cStr)) {
                        XFAStyle temp = new XFAStyle(null, style.getFontInfo(), sb.toString(), hAlign);
                        if (lineMap.containsKey(lineMap.size() - 1)) {
                            list = (ArrayList)lineMap.get(lineMap.size() - 1);
                            list.add(temp);
                            lineMap.put(lineMap.size(), new ArrayList());
                        } else {
                            list.add(temp);
                            lineMap.put(lineMap.size(), list);
                            lineMap.put(lineMap.size(), new ArrayList());
                        }
                        sb = new StringBuilder();
                        spaceB.append(cStr);
                        lineLen = spaceLen + charLen;
                        continue;
                    }
                    if (" ".equals(cStr)) {
                        sb.append((CharSequence)spaceB).append(cStr);
                        spaceB = new StringBuilder();
                        continue;
                    }
                    spaceB.append(cStr);
                }
                if (sb.length() <= 0 && spaceB.length() <= 0) continue;
                sb.append((CharSequence)spaceB);
                XFAStyle temp = new XFAStyle(null, style.getFontInfo(), sb.toString(), hAlign);
                if (lineMap.containsKey(lineMap.size() - 1)) {
                    list = (ArrayList)lineMap.get(lineMap.size() - 1);
                    list.add(temp);
                } else {
                    list.add(temp);
                    lineMap.put(lineMap.size(), list);
                }
                sb.setLength(0);
                spaceB.setLength(0);
            }
        }
        HashMap<Integer, Integer> lineHeightMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> lineWidthMap = new HashMap<Integer, Double>();
        for (int z = 0; z < lineMap.size(); ++z) {
            int height = 0;
            double width = 0.0;
            for (XFAStyle style : (ArrayList)lineMap.get(z)) {
                XFontInfo xFontInfo = style.getFontInfo();
                height = xFontInfo.getSize() > height ? xFontInfo.getSize() : height;
                width += XFAFormStream.getTempTotalWidth(xFontInfo, style.getStyleData(), this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
            }
            lineHeightMap.put(z, height);
            lineWidthMap.put(z, width);
        }
        double totalHeight = 0.0;
        for (Integer hh : lineHeightMap.keySet()) {
            totalHeight += (double)((Integer)lineHeightMap.get(hh)).intValue();
        }
        double totalWidth = 0.0;
        for (Integer ww : lineWidthMap.keySet()) {
            totalWidth = totalWidth < (Double)lineWidthMap.get(ww) ? (Double)lineWidthMap.get(ww) : totalWidth;
        }
        return new Dimension((int)totalWidth, (int)totalHeight);
    }

    public void parseHTML(double[] coords, XFontInfo fontInfo, String htmlData, int hAlign, int vAlign) {
        HashMap<Integer, ArrayList> lineMap = new HashMap<Integer, ArrayList>();
        HashMap<Integer, XFAStyle> map = XFADraw.parseExDataToMap(fontInfo, htmlData, hAlign);
        double maxW = coords[2];
        if (this.box.getW() == 0.0) {
            for (int z = 0; z < map.size(); ++z) {
                XFAStyle style = map.get(z);
                ArrayList<XFAStyle> list = new ArrayList<XFAStyle>();
                if ("<br/>".equals(style.getStyleData())) {
                    style.setStyleData("");
                    list.add(style);
                    lineMap.put(lineMap.size(), list);
                    continue;
                }
                if (lineMap.containsKey(lineMap.size() - 1)) {
                    ((ArrayList)lineMap.get(lineMap.size() - 1)).add(style);
                    continue;
                }
                list.add(style);
                lineMap.put(lineMap.size(), list);
            }
        } else {
            double lineLen = 0.0;
            for (int z = 0; z < map.size(); ++z) {
                XFAStyle style = map.get(z);
                String dataStr = style.getStyleData();
                ArrayList list = new ArrayList();
                if ("<br/>".equals(style.getStyleData())) {
                    style.setStyleData("");
                    list.add(style);
                    lineMap.put(lineMap.size(), list);
                    lineLen = 0.0;
                    continue;
                }
                double dataLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), dataStr, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                if (dataLen < maxW - lineLen) {
                    if (lineMap.containsKey(lineMap.size() - 1)) {
                        ((ArrayList)lineMap.get(lineMap.size() - 1)).add(style);
                    } else {
                        list.add(style);
                        lineMap.put(lineMap.size(), list);
                    }
                    lineLen += dataLen;
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                StringBuilder spaceB = new StringBuilder();
                for (int c = 0; c < dataStr.length(); ++c) {
                    String cStr = String.valueOf(dataStr.charAt(c));
                    double spaceLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), spaceB.toString(), this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                    double charLen = XFAFormStream.getTempTotalWidth(style.getFontInfo(), cStr, this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
                    double availW = maxW - lineLen;
                    lineLen += charLen;
                    if (availW < charLen && !" ".equals(cStr)) {
                        XFAStyle temp = new XFAStyle(null, style.getFontInfo(), sb.toString(), hAlign);
                        if (lineMap.containsKey(lineMap.size() - 1)) {
                            list = (ArrayList)lineMap.get(lineMap.size() - 1);
                            list.add(temp);
                            lineMap.put(lineMap.size(), new ArrayList());
                        } else {
                            list.add(temp);
                            lineMap.put(lineMap.size(), list);
                            lineMap.put(lineMap.size(), new ArrayList());
                        }
                        sb = new StringBuilder();
                        spaceB.append(cStr);
                        lineLen = spaceLen + charLen;
                        continue;
                    }
                    if (" ".equals(cStr)) {
                        sb.append((CharSequence)spaceB).append(cStr);
                        spaceB = new StringBuilder();
                        continue;
                    }
                    spaceB.append(cStr);
                }
                if (sb.length() <= 0 && spaceB.length() <= 0) continue;
                sb.append((CharSequence)spaceB);
                XFAStyle temp = new XFAStyle(null, style.getFontInfo(), sb.toString(), hAlign);
                if (lineMap.containsKey(lineMap.size() - 1)) {
                    list = (ArrayList)lineMap.get(lineMap.size() - 1);
                    list.add(temp);
                } else {
                    list.add(temp);
                    lineMap.put(lineMap.size(), list);
                }
                sb.setLength(0);
                spaceB.setLength(0);
            }
        }
        HashMap<Integer, Integer> lineHeightMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> lineWidthMap = new HashMap<Integer, Double>();
        for (int z = 0; z < lineMap.size(); ++z) {
            int height = 0;
            double width = 0.0;
            for (XFAStyle style : (ArrayList)lineMap.get(z)) {
                XFontInfo xFontInfo = style.getFontInfo();
                height = xFontInfo.getSize() > height ? xFontInfo.getSize() : height;
                width += XFAFormStream.getTempTotalWidth(xFontInfo, style.getStyleData(), this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore());
            }
            lineHeightMap.put(z, height);
            lineWidthMap.put(z, width);
        }
        double totalHeight = 0.0;
        for (Integer hh : lineHeightMap.keySet()) {
            totalHeight += (double)((Integer)lineHeightMap.get(hh)).intValue();
        }
        GraphicsState gs = new GraphicsState(0, 0);
        gs.setFillType(2);
        double x = coords[0];
        double y = coords[1];
        double w = coords[2];
        double h = coords[3];
        XRect rect = new XRect(x, y, w, h);
        switch (vAlign) {
            case 115029: {
                rect.moveFromY(h);
                break;
            }
            case -1074341483: {
                if (h <= totalHeight) {
                    rect.moveFromY(h);
                    break;
                }
                rect.moveFromY(h - (h - totalHeight) / 2.0);
                break;
            }
            case -1383228885: {
                if (h < totalHeight) {
                    rect.moveFromY(h);
                    break;
                }
                rect.moveFromY(h - (h - totalHeight));
            }
        }
        for (int z = 0; z < lineMap.size(); ++z) {
            int lineH = (Integer)lineHeightMap.get(z);
            double lineW = (Double)lineWidthMap.get(z);
            switch (hAlign) {
                case 3317767: {
                    rect.setX(x);
                    break;
                }
                case 108511772: {
                    rect.moveFromX(maxW - lineW);
                    break;
                }
                case -1364013995: {
                    rect.moveFromX((maxW - lineW) / 2.0);
                }
            }
            rect.moveFromY(-lineH);
            if (((ArrayList)lineMap.get(z)).size() == 1) {
                XFAStyle oneStyle = (XFAStyle)((ArrayList)lineMap.get(z)).get(0);
                switch (oneStyle.getTextAlign()) {
                    case 3317767: {
                        break;
                    }
                    case 108511772: {
                        rect.setX(x);
                        rect.moveFromX(maxW - lineW);
                        break;
                    }
                    case -1364013995: {
                        rect.setX(x);
                        rect.moveFromX((maxW - lineW) / 2.0);
                    }
                }
            }
            for (XFAStyle style : (ArrayList)lineMap.get(z)) {
                XFontInfo xFontInfo = style.getFontInfo();
                float[][] trm = new float[3][3];
                float f = xFontInfo.getSize();
                trm[1][1] = f;
                trm[0][0] = f;
                gs.nonstrokeColorSpace.setColor(xFontInfo.getColor());
                this.drawEmbeddedText(trm, (int)rect.getX(), (int)rect.getY(), gs, style.getStyleData(), xFontInfo);
                rect.moveFromX(XFAFormStream.getTempTotalWidth(xFontInfo, style.getStyleData(), this.decoder, this.fontCache, this.pdfFontFactory, this.currentPdfFile.getObjectStore()));
            }
            rect.setX(x);
        }
    }

    public int getCheckButtonMarkType() {
        return this.checkButtonMarkType;
    }

    public int getCheckButtonShape() {
        return this.checkButtonShape;
    }

    public static enum XFARawDataType {
        TEXTEDIT,
        IMAGEEDIT,
        NUMERICEDIT,
        DATETIMEEDIT,
        PASSWORDEDIT,
        BUTTON,
        CHOICELIST,
        SIGNATURE,
        CHECKBUTTON;

    }
}

