/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import com.idrsolutions.image.webp.data.EVP8;
import com.idrsolutions.image.webp.options.WebpEncoderOptions;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WebpEncoder
extends JDeliImage
implements Encoder {
    private WebpEncoderOptions webpEncoderOptions = new WebpEncoderOptions();

    public WebpEncoder(EncoderOptions format) {
        if (format != null) {
            this.webpEncoderOptions = (WebpEncoderOptions)format;
        }
    }

    public WebpEncoder() {
    }

    public void write(BufferedImage image, File file) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        this.write(image, bos);
        bos.flush();
        bos.close();
    }

    @Override
    public void write(BufferedImage inputImage, OutputStream os) throws IOException {
        WebpEncoder.optimiseImage(inputImage);
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(inputImage);
        int qp = 100 - this.webpEncoderOptions.getQuality();
        EVP8.encode(imageToCompress, os, qp);
    }
}

