/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.ECabac;
import com.idrsolutions.image.heic.common.ProfileData;

class ProfileTierLevel {
    final ProfileData general = new ProfileData();
    private final ProfileData[] sub_layer = new ProfileData[8];

    ProfileTierLevel() {
    }

    void read(Bitstream reader, int max_sub_layers) {
        int i;
        this.general.profile_present_flag = 1;
        this.general.level_present_flag = 1;
        this.general.read(reader);
        for (i = 0; i < max_sub_layers - 1; ++i) {
            this.sub_layer[i] = new ProfileData();
            this.sub_layer[i].profile_present_flag = reader.readBit();
            this.sub_layer[i].level_present_flag = reader.readBit();
        }
        if (max_sub_layers > 1) {
            for (i = max_sub_layers - 1; i < 8; ++i) {
                reader.readBits(2);
            }
        }
        for (i = 0; i < max_sub_layers - 1; ++i) {
            this.sub_layer[i].read(reader);
        }
    }

    void write(ECabac out, int max_sub_layers) {
        int i;
        this.general.write(out);
        for (i = 0; i < max_sub_layers - 1; ++i) {
            out.write_bit(this.sub_layer[i].profile_present_flag);
            out.write_bit(this.sub_layer[i].level_present_flag);
        }
        if (max_sub_layers > 1) {
            for (i = max_sub_layers - 1; i < 8; ++i) {
                out.skip_bits(2);
            }
        }
        for (i = 0; i < max_sub_layers - 1; ++i) {
            this.sub_layer[i].write(out);
        }
    }
}

