/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import macromedia.jdbc.slbase.BaseBlob;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseClob;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseDoubleConversionConstants;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseImplBlob;
import macromedia.jdbc.slbase.BaseImplBlobEmulated;
import macromedia.jdbc.slbase.BaseImplClob;
import macromedia.jdbc.slbase.BaseImplClobEmulated;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseIntegerStringConstants;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.slutil.UtilASCIIInputStreamToCharacterReader;
import macromedia.slutil.UtilBinaryToASCIIInputStream;
import macromedia.slutil.UtilCharacterReaderToASCIIInputStream;
import macromedia.slutil.UtilCharacterReaderToUCS2InputStream;
import macromedia.slutil.UtilDataConversions;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilJDKVersionChecker;
import macromedia.slutil.UtilSmallDecimal;
import macromedia.slutil.UtilStringFunctions;
import macromedia.slutil.UtilTransliterator;
import macromedia.slutil.UtilUCS2InputStreamToCharacterReader;

public class BaseData {
    public static final int UNKNOWN_DATA_OBJECT = 0;
    public static final int BYTE = 1;
    public static final int BYTE_ARRAY = 2;
    public static final int SHORT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIGDECIMAL = 8;
    public static final int BOOLEAN = 9;
    public static final int STRING = 10;
    public static final int DATE = 11;
    public static final int TIME = 12;
    public static final int TIMESTAMP = 13;
    public static final int BINARYINPUTSTREAM = 14;
    public static final int ASCIIINPUTSTREAM = 15;
    public static final int UTF8INPUTSTREAM = 16;
    public static final int UCS2INPUTSTREAM = 17;
    public static final int CHARACTERSTREAMREADER = 18;
    public static final int BLOB = 19;
    public static final int CLOB = 20;
    public static final int SMALLDECIMAL = 21;
    public static final int NATIVE_TYPE_BYTE_BASE = 100;
    public static final int SQLSERVER_UNIQUEIDENTIFIER = 101;
    public static final int SQLSERVER_DATETIME = 102;
    public static final int SQLSERVER_SMALLDATETIME = 103;
    public static final int SYBASE_DATETIME = 104;
    public static final int SYBASE_SHORTDATE = 105;
    public static final int SYBASE_DATE = 106;
    public static final int SYBASE_TIME = 107;
    public static final int ORACLE_DATE = 108;
    public static final int ORACLE_TIMESTAMP = 109;
    public static final int ORACLE_TIMESTAMP_WITH_TIMEZONE = 110;
    public static final int ORACLE_TIMESTAMP_WITH_LOCAL_TIMEZONE = 111;
    public static final int NATIVE_TYPE_STRING_BASE = 200;
    public static final int DB2_DATE = 201;
    public static final int DB2_TIME = 202;
    public static final int DB2_TIMESTAMP = 203;
    public static final int MYSQL_DATE = 204;
    public static final int MYSQL_TIME = 205;
    public static final int MYSQL_TIMESTAMP = 206;
    private static final int DEFAULT_CHUNK_LEN = 10240;
    private static final int MAX_CHUNK_LEN = Integer.MAX_VALUE;
    public BaseConnection connection;
    public int type;
    public Object data;
    private int nativeDataLen;
    private int oracleLTZHours;
    private int oracleLTZMinutes;
    private int oracleTZScale;
    private boolean oracleFetchTSWTZasTimestamp;
    static final BigDecimal bdMaxInt = new BigDecimal(Integer.toString(Integer.MAX_VALUE));
    static final BigDecimal bdMinInt = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
    static final BigDecimal bdMaxLong = new BigDecimal(Long.toString(Long.MAX_VALUE));
    static final BigDecimal bdMinLong = new BigDecimal(Long.toString(Long.MIN_VALUE));
    static final BigDecimal bdMaxShort = new BigDecimal(Long.toString(32767L));
    static final BigDecimal bdMinShort = new BigDecimal(Long.toString(-32768L));
    static final BigDecimal bdMaxByte = new BigDecimal(Long.toString(127L));
    static final BigDecimal bdMinByte = new BigDecimal(Long.toString(-128L));
    public boolean booleanValue;
    public byte byteValue;
    public short shortValue;
    public int intValue;
    public long longValue;
    public float floatValue;
    public double doubleValue;
    public boolean isNull;
    private boolean needWrapper = true;
    public static final char[] NEGATIVE_INFINITY = new char[]{'-', 'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    public static final char[] POSITIVE_INFINITY = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    public static final char[] NaN = new char[]{'N', 'a', 'N'};
    static final long MaxValue = 0xCCCCCCCCCCCCCCCL;
    public static final char[] DigitHundreds = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    char[] buf = null;
    private Calendar s_calendar = null;
    static int[] scalingFactors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

    public BaseData(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.setNull(0);
    }

    public BaseData(int n2, Object object, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.setData(n2, object);
    }

    public BaseData(Object object, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.setData(object);
    }

    public int getType() {
        return this.type;
    }

    public void populate(BaseData baseData) {
        this.isNull = baseData.isNull;
        this.type = baseData.type;
        this.intValue = baseData.intValue;
        this.byteValue = baseData.byteValue;
        this.booleanValue = baseData.booleanValue;
        this.shortValue = baseData.shortValue;
        this.longValue = baseData.longValue;
        this.floatValue = baseData.floatValue;
        this.doubleValue = baseData.doubleValue;
        this.data = baseData.data;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public static boolean isVariableLengthType(int n2) {
        switch (n2) {
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 93: {
                return true;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: {
                return false;
            }
        }
        return false;
    }

    public static int[] getInfoForSQLType(int n2) {
        int[] nArray = new int[]{-1, -1, -1, -1};
        switch (n2) {
            case -5: {
                nArray[0] = 20;
                nArray[1] = 19;
                nArray[2] = 0;
                nArray[3] = 5;
                break;
            }
            case -7: 
            case 16: {
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = -1;
                nArray[3] = 9;
                break;
            }
            case 91: {
                nArray[0] = 10;
                nArray[1] = 10;
                nArray[2] = 0;
                nArray[3] = 11;
                break;
            }
            case 2: 
            case 3: {
                nArray[3] = 8;
                break;
            }
            case 6: 
            case 8: {
                nArray[0] = 22;
                nArray[1] = 15;
                nArray[2] = 0;
                nArray[3] = 7;
                break;
            }
            case 4: {
                nArray[0] = 11;
                nArray[1] = 10;
                nArray[2] = 0;
                nArray[3] = 4;
                break;
            }
            case 5: {
                nArray[0] = 6;
                nArray[1] = 5;
                nArray[2] = 0;
                nArray[3] = 3;
                break;
            }
            case -6: {
                nArray[0] = 4;
                nArray[1] = 3;
                nArray[2] = 0;
                nArray[3] = 1;
                break;
            }
            case 7: {
                nArray[0] = 13;
                nArray[1] = 7;
                nArray[2] = 0;
                nArray[3] = 6;
                break;
            }
            case 92: {
                nArray[0] = 18;
                nArray[1] = 18;
                nArray[2] = 9;
                nArray[3] = 12;
                break;
            }
            case 93: {
                nArray[0] = 29;
                nArray[1] = 29;
                nArray[2] = 9;
                nArray[3] = 13;
                break;
            }
            case -2: {
                nArray[3] = 2;
                break;
            }
            case -8: 
            case 1: {
                nArray[3] = 10;
                break;
            }
            case -4: {
                nArray[3] = 14;
                break;
            }
            case -1: {
                nArray[3] = 15;
                break;
            }
            case -3: {
                nArray[3] = 2;
                break;
            }
            case -9: 
            case 12: {
                nArray[3] = 10;
                break;
            }
            case 2004: {
                nArray[3] = 19;
                break;
            }
            case -10: 
            case 2005: {
                nArray[3] = 20;
                break;
            }
        }
        return nArray;
    }

    static String mapJDBCTypeToJavaObjectTypeName(int n2) {
        String string = null;
        switch (n2) {
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: 
            case 16: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "byte[]";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
                break;
            }
            case -10: 
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2003: {
                string = "java.sql.Array";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static int mapJDBCTypeToJavaObjectType(int n2) {
        int n3 = 0;
        switch (n2) {
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                n3 = 10;
                break;
            }
            case 2: 
            case 3: {
                n3 = 8;
                break;
            }
            case -7: 
            case 16: {
                n3 = 9;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                n3 = 4;
                break;
            }
            case -5: {
                n3 = 5;
                break;
            }
            case 7: {
                n3 = 6;
                break;
            }
            case 6: 
            case 8: {
                n3 = 7;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                n3 = 2;
                break;
            }
            case 91: {
                n3 = 11;
                break;
            }
            case 92: {
                n3 = 12;
                break;
            }
            case 93: {
                n3 = 13;
                break;
            }
            case 2004: {
                n3 = 19;
                break;
            }
            case -10: 
            case 2005: {
                n3 = 20;
                break;
            }
        }
        return n3;
    }

    public void setASCIIStream(InputStream inputStream) {
        this.type = 15;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.type = 8;
        if (bigDecimal == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = bigDecimal;
        }
    }

    public void setBinaryStream(InputStream inputStream) {
        this.type = 14;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setBlob(BaseImplBlob baseImplBlob) {
        this.type = 19;
        if (baseImplBlob == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseImplBlob;
        }
    }

    public void setBoolean(boolean bl2) {
        this.booleanValue = bl2;
        this.type = 9;
        this.isNull = false;
        this.data = null;
    }

    public void setByte(byte by2) {
        this.byteValue = by2;
        this.type = 1;
        this.isNull = false;
        this.data = null;
    }

    public void setBytes(byte[] byArray) {
        this.type = 2;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = byArray;
        }
    }

    public void setNativeBytes(byte[] byArray, int n2) {
        this.type = n2;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = byArray.length;
        }
    }

    public void setNativeBytes(byte[] byArray, int n2, int n3) {
        this.type = n3;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = n2;
        }
    }

    public void setNativeOracleTimestampWithLocalTimeZone(byte[] byArray, int n2, int n3, int n4) {
        this.type = 111;
        this.oracleLTZHours = n3;
        this.oracleLTZMinutes = n4;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = n2;
        }
    }

    public int getOracleTZHours() {
        return this.oracleLTZHours;
    }

    public void setOracleTZHours(int n2) {
        this.oracleLTZHours = n2;
    }

    public int getOracleTZMinutes() {
        return this.oracleLTZMinutes;
    }

    public void setOracleTZMinutes(int n2) {
        this.oracleLTZMinutes = n2;
    }

    public int getOracleTZScale() {
        return this.oracleTZScale;
    }

    public void setOracleTZScale(int n2) {
        this.oracleTZScale = n2;
    }

    public boolean getOracleFetchTSWTZasTimestamp() {
        return this.oracleFetchTSWTZasTimestamp;
    }

    public void setOracleFetchTSWTZasTimestamp(boolean bl2) {
        this.oracleFetchTSWTZasTimestamp = bl2;
    }

    public void setNativeOracleTimestampWithTimeZone(byte[] byArray, int n2, int n3, boolean bl2) {
        this.type = 110;
        this.oracleTZScale = n3;
        this.oracleFetchTSWTZasTimestamp = bl2;
        if (byArray == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = byArray;
            this.nativeDataLen = n2;
        }
    }

    public void setNativeString(String string, int n2) {
        this.type = n2;
        if (string == null) {
            this.isNull = true;
            this.data = null;
            this.nativeDataLen = 0;
        } else {
            this.isNull = false;
            this.data = string;
            this.nativeDataLen = string.length();
        }
    }

    public void setCharacterStreamReader(Reader reader) {
        this.type = 18;
        if (reader == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = reader;
        }
    }

    public void setClob(BaseImplClob baseImplClob) {
        this.type = 20;
        if (baseImplClob == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseImplClob;
        }
    }

    public void setData(int n2, Object object) {
        this.type = n2;
        if (object == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            switch (this.type) {
                case 4: {
                    this.intValue = (Integer)object;
                    this.data = null;
                    break;
                }
                case 1: {
                    this.byteValue = (Byte)object;
                    this.data = null;
                    break;
                }
                case 9: {
                    this.booleanValue = (Boolean)object;
                    this.data = null;
                    break;
                }
                case 3: {
                    this.shortValue = (Short)object;
                    this.data = null;
                    break;
                }
                case 5: {
                    this.longValue = (Long)object;
                    this.data = null;
                    break;
                }
                case 6: {
                    this.floatValue = ((Float)object).floatValue();
                    this.data = null;
                    break;
                }
                case 7: {
                    this.doubleValue = (Double)object;
                    this.data = null;
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    this.data = object;
                    this.nativeDataLen = ((byte[])object).length;
                    break;
                }
                default: {
                    this.data = object;
                }
            }
        }
    }

    public void setData(Object object) {
        this.setData(BaseData.getJavaObjectType(object, 0), object);
    }

    public void setDate(Date date) {
        this.type = 11;
        if (date == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = date;
        }
    }

    public void setDouble(double d2) {
        this.doubleValue = d2;
        this.type = 7;
        this.isNull = false;
        this.data = null;
    }

    public void setFloat(float f2) {
        this.floatValue = f2;
        this.type = 6;
        this.isNull = false;
        this.data = null;
    }

    public void setInteger(int n2) {
        this.intValue = n2;
        this.type = 4;
        this.isNull = false;
        this.data = null;
    }

    public void setLong(long l2) {
        this.longValue = l2;
        this.type = 5;
        this.isNull = false;
        this.data = null;
    }

    public void setNull(int n2) {
        this.isNull = true;
        this.type = n2;
        this.data = null;
    }

    public void setShort(short s2) {
        this.shortValue = s2;
        this.type = 3;
        this.isNull = false;
        this.data = null;
    }

    public void setSmallDecimal(UtilSmallDecimal utilSmallDecimal) {
        this.type = 21;
        if (utilSmallDecimal == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = utilSmallDecimal;
        }
    }

    public void setString(String string) {
        this.type = 10;
        if (string == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = string;
        }
    }

    public void setTime(Time time) {
        this.type = 12;
        if (time == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = time;
        }
    }

    public void setTimestamp(BaseTimestamp baseTimestamp) {
        this.type = 13;
        if (baseTimestamp == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = baseTimestamp;
        }
    }

    public void setUCS2InputStream(InputStream inputStream) {
        this.type = 17;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public void setUTF8InputStream(InputStream inputStream) {
        this.type = 16;
        if (inputStream == null) {
            this.isNull = true;
            this.data = null;
        } else {
            this.isNull = false;
            this.data = inputStream;
        }
    }

    public static int getJavaObjectType(Object object, int n2) {
        int n3 = 0;
        if (object == null) {
            n3 = n2 == 0 ? 10 : BaseData.mapJDBCTypeToJavaObjectType(n2);
        } else if (object instanceof Integer) {
            n3 = 4;
        } else if (object instanceof Byte) {
            n3 = 1;
        } else if (object instanceof Short) {
            n3 = 3;
        } else if (object instanceof Long) {
            n3 = 5;
        } else if (object instanceof Float) {
            n3 = 6;
        } else if (object instanceof Double) {
            n3 = 7;
        } else if (object instanceof BigDecimal) {
            n3 = 8;
        } else if (object instanceof UtilSmallDecimal) {
            n3 = 21;
        } else if (object instanceof Boolean) {
            n3 = 9;
        } else if (object instanceof String) {
            n3 = 10;
        } else if (object instanceof Date) {
            n3 = 11;
        } else if (object instanceof Time) {
            n3 = 12;
        } else if (object instanceof BaseTimestamp || object instanceof Timestamp) {
            n3 = 13;
        } else if (object instanceof Blob || object instanceof BaseImplBlob) {
            n3 = 19;
        } else if (object instanceof Clob || object instanceof BaseImplClob) {
            n3 = 20;
        } else if (object instanceof Reader) {
            n3 = 18;
        } else if (object instanceof InputStream) {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    n3 = 14;
                    break;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    n3 = 15;
                }
            }
        } else {
            String string = object.getClass().getName();
            if (string.equals("[B")) {
                n3 = 2;
            }
        }
        return n3;
    }

    static boolean isStreamed(int n2) {
        switch (n2) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static byte[] stringToBytes(String string, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        if (utilTransliterator != null) {
            try {
                byArray = utilTransliterator.encode(string);
            }
            catch (UtilException utilException) {
                throw baseExceptions.getException(6024);
            }
        } else {
            int n2 = string.length();
            if (n2 % 2 != 0) {
                throw baseExceptions.getException(6032, "22018");
            }
            byte[] byArray2 = new byte[n2 / 2];
            boolean bl2 = true;
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by2;
                char c2 = string.charAt(i2);
                if (c2 >= '0' && c2 <= '9') {
                    by2 = (byte)(c2 - 48);
                } else if (c2 >= 'a' && c2 <= 'f') {
                    by2 = (byte)(c2 - 97 + 10);
                } else if (c2 >= 'A' && c2 <= 'F') {
                    by2 = (byte)(c2 - 65 + 10);
                } else {
                    throw baseExceptions.getException(6032, "22018");
                }
                if (bl2) {
                    byArray2[i2 / 2] = (byte)(by2 << 4);
                    bl2 = false;
                    continue;
                }
                int n3 = i2 / 2;
                byArray2[n3] = (byte)(byArray2[n3] + by2);
                bl2 = true;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public static int compare(BaseData baseData, BaseData baseData2, int n2, boolean bl2, BaseExceptions baseExceptions) throws SQLException {
        int n3 = 0;
        switch (n2) {
            case 10: {
                String string = baseData.getString(-1, baseExceptions);
                String string2 = baseData2.getString(-1, baseExceptions);
                if (string == string2) {
                    return 0;
                }
                if (string == null) {
                    return 1;
                }
                if (string2 == null) {
                    return -1;
                }
                if (bl2) {
                    n3 = UtilStringFunctions.CompareStrings(string, string2);
                    break;
                }
                n3 = UtilStringFunctions.CompareStringsAlpha(string, string2);
                break;
            }
            case 4: {
                int n4 = baseData.getInteger(baseExceptions);
                int n5 = baseData2.getInteger(baseExceptions);
                if (n4 > n5) {
                    n3 = 1;
                    break;
                }
                if (n4 < n5) {
                    n3 = -1;
                    break;
                }
                n3 = 0;
                break;
            }
            case 3: {
                short s2 = baseData.getShort(baseExceptions);
                short s3 = baseData2.getShort(baseExceptions);
                if (s2 > s3) {
                    n3 = 1;
                    break;
                }
                if (s2 < s3) {
                    n3 = -1;
                    break;
                }
                n3 = 0;
                break;
            }
            case 9: {
                boolean bl3 = baseData.getBoolean(baseExceptions);
                boolean bl4 = baseData2.getBoolean(baseExceptions);
                n3 = bl3 && !bl4 ? 1 : (!bl3 && bl4 ? -1 : 0);
            }
        }
        return n3;
    }

    public Object getObject() {
        if (this.isNull) {
            return null;
        }
        switch (this.type) {
            case 4: {
                return new Integer(this.intValue);
            }
            case 1: {
                return new Byte(this.byteValue);
            }
            case 9: {
                return new Boolean(this.booleanValue);
            }
            case 3: {
                return new Short(this.shortValue);
            }
            case 5: {
                return new Long(this.longValue);
            }
            case 6: {
                return new Float(this.floatValue);
            }
            case 7: {
                return new Double(this.doubleValue);
            }
            case 101: {
                return this.sqlserverUniqueidentifierToString();
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.sqlserverDateTimeToTimestamp();
            }
            case 106: {
                return this.sybaseDatetoDate();
            }
            case 107: {
                return this.sybaseTimeToTimeStamp();
            }
            case 201: 
            case 204: {
                return Date.valueOf((String)this.data);
            }
            case 202: 
            case 205: {
                return Time.valueOf((String)this.data);
            }
            case 203: 
            case 206: {
                return BaseTimestamp.valueOf((String)this.data);
            }
            case 108: {
                return this.oracleDateToDate();
            }
            case 109: {
                return this.oracleTimestampToTimestamp(null);
            }
            case 110: {
                return this.oracleTimestampWithTimeZoneToTimestamp(null, this.oracleFetchTSWTZasTimestamp);
            }
            case 111: {
                return this.oracleTimestampWithLocalTimeZoneToTimestamp();
            }
        }
        return this.data;
    }

    public Object getObject(int n2, int n3, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        Object object = null;
        switch (n2) {
            case 1: {
                object = new Byte(this.getByte(baseExceptions));
                break;
            }
            case 9: {
                object = new Boolean(this.getBoolean(baseExceptions));
                break;
            }
            case 4: {
                object = new Integer(this.getInteger(baseExceptions));
                break;
            }
            case 3: {
                object = new Short(this.getShort(baseExceptions));
                break;
            }
            case 5: {
                object = new Long(this.getLong(baseExceptions));
                break;
            }
            case 6: {
                object = new Float(this.getFloat(baseExceptions));
                break;
            }
            case 7: {
                object = new Double(this.getDouble(baseExceptions));
                break;
            }
            case 10: {
                object = this.getString(n3, baseExceptions);
                break;
            }
            case 2: {
                object = this.getBytes(n3, baseExceptions);
                break;
            }
            case 19: {
                object = this.getBlob(baseConnection, baseExceptions);
                break;
            }
            case 20: {
                object = this.getClob(baseConnection, baseExceptions);
                break;
            }
            case 8: 
            case 21: {
                object = this.getBigDecimal(baseExceptions);
                break;
            }
            case 11: 
            case 201: 
            case 204: {
                object = this.getDate(baseExceptions);
                break;
            }
            case 12: 
            case 202: 
            case 205: {
                object = this.getTime(baseExceptions);
                break;
            }
            case 13: 
            case 203: 
            case 206: {
                object = this.getTimestamp(baseExceptions).getTimestamp();
                break;
            }
            case 101: {
                object = this.sqlserverUniqueidentifierToString();
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                object = this.sqlserverDateTimeToTimestamp().getTimestamp();
                break;
            }
            case 106: {
                object = this.sybaseDatetoDate();
                break;
            }
            case 107: {
                object = this.sybaseTimeToTimeStamp().getTimestamp();
                break;
            }
            case 108: {
                object = this.oracleDateToDate();
                break;
            }
            case 109: {
                object = this.oracleTimestampToTimestamp(null).getTimestamp();
                break;
            }
            case 110: {
                object = this.oracleTimestampWithTimeZoneToTimestamp(null, this.oracleFetchTSWTZasTimestamp);
            }
            case 111: {
                object = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                break;
            }
            default: {
                object = this.data;
            }
        }
        return object;
    }

    public InputStream getASCIIStreamNoConvert() {
        return (InputStream)this.data;
    }

    public InputStream getASCIIStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n3 = -1;
            switch (this.type) {
                case 15: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 14: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 2: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n3 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n3 = string.length();
                    break;
                }
                case 10: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n3 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n3 = string.length();
                    break;
                }
                case 18: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                case 20: {
                    inputStream = this.getClob(baseConnection, baseExceptions).getAsciiStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getASCIIStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl2) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n3 = -1;
            switch (this.type) {
                case 15: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 14: {
                    inputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    break;
                }
                case 2: {
                    inputStream = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])this.data));
                    n3 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n3 = string.length();
                    break;
                }
                case 10: {
                    inputStream = UtilDataConversions.stringToASCIIInputStream((String)this.data);
                    n3 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    inputStream = UtilDataConversions.stringToASCIIInputStream(string);
                    n3 = string.length();
                    break;
                }
                case 18: {
                    inputStream = new UtilCharacterReaderToASCIIInputStream((Reader)this.data);
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(baseConnection, baseExceptions);
                    if (clob instanceof BaseClob) {
                        inputStream = ((BaseClob)clob).getAsciiStream(bl2);
                        break;
                    }
                    inputStream = clob.getAsciiStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BigDecimal getBigDecimalNoConvert() {
        return (BigDecimal)this.data;
    }

    public BigDecimal getBigDecimal(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            BigDecimal bigDecimal = null;
            switch (this.type) {
                case 8: {
                    bigDecimal = (BigDecimal)this.data;
                    break;
                }
                case 21: {
                    BigInteger bigInteger = new BigInteger(((UtilSmallDecimal)this.data).toByteArray());
                    bigDecimal = new BigDecimal(bigInteger, ((UtilSmallDecimal)this.data).getScale());
                    break;
                }
                case 10: {
                    bigDecimal = new BigDecimal(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    bigDecimal = new BigDecimal(string.trim());
                    break;
                }
                case 7: {
                    if (UtilJDKVersionChecker.getJVMVersion() >= 1.3f) {
                        bigDecimal = new BigDecimal(Double.toString(this.doubleValue));
                        break;
                    }
                    bigDecimal = new BigDecimal(this.doubleValue);
                    break;
                }
                case 6: {
                    if (UtilJDKVersionChecker.getJVMVersion() >= 1.3f) {
                        bigDecimal = new BigDecimal(Float.toString(this.floatValue));
                        break;
                    }
                    bigDecimal = new BigDecimal(this.floatValue);
                    break;
                }
                case 1: {
                    bigDecimal = new BigDecimal((double)this.byteValue);
                    break;
                }
                case 3: {
                    bigDecimal = new BigDecimal((double)this.shortValue);
                    break;
                }
                case 5: {
                    byte[] byArray = new byte[]{(byte)(this.longValue >>> 56), (byte)(this.longValue >>> 48), (byte)(this.longValue >>> 40), (byte)(this.longValue >>> 32), (byte)(this.longValue >>> 24), (byte)(this.longValue >>> 16), (byte)(this.longValue >>> 8), (byte)this.longValue};
                    bigDecimal = new BigDecimal(new BigInteger(byArray));
                    break;
                }
                case 4: {
                    bigDecimal = new BigDecimal((double)this.intValue);
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        bigDecimal = new BigDecimal(1.0);
                        break;
                    }
                    bigDecimal = new BigDecimal(0.0);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BigDecimal getBigDecimal(int n2, BaseExceptions baseExceptions) throws SQLException {
        try {
            BigDecimal bigDecimal = this.getBigDecimal(baseExceptions);
            if (bigDecimal != null) {
                try {
                    bigDecimal = bigDecimal.setScale(n2, 7);
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.setScale(n2, 4);
                }
            }
            return bigDecimal;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Blob getBlobNoConvert() {
        return (Blob)this.data;
    }

    public Blob getBlob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 19) {
                return null;
            }
            this.getBytes(0, baseExceptions);
            return null;
        }
        try {
            Blob blob = null;
            switch (this.type) {
                case 19: {
                    if (this.data instanceof BaseImplBlob) {
                        this.data = new BaseBlob((BaseImplBlob)this.data, baseConnection, baseExceptions);
                    }
                    blob = (Blob)this.data;
                    break;
                }
                default: {
                    this.needWrapper = false;
                    InputStream inputStream = this.getBinaryStream(-1, baseConnection, baseExceptions);
                    this.needWrapper = true;
                    BaseImplBlobEmulated baseImplBlobEmulated = new BaseImplBlobEmulated(baseExceptions, inputStream);
                    blob = new BaseBlob(baseImplBlobEmulated, baseConnection, baseExceptions);
                }
            }
            return blob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public boolean getBooleanNoConvert() {
        return this.booleanValue;
    }

    public boolean getBoolean(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return false;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return false;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            boolean bl2 = false;
            switch (this.type) {
                case 9: {
                    bl2 = this.booleanValue;
                    break;
                }
                case 10: 
                case 15: 
                case 17: 
                case 18: {
                    String string;
                    if (this.type == 10) {
                        string = ((String)this.data).trim();
                    } else {
                        String string2 = this.getString(-1, baseExceptions);
                        string = string2.trim();
                    }
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
                        bl2 = true;
                        break;
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
                        bl2 = false;
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 1: {
                    bl2 = this.byteValue != 0;
                    break;
                }
                case 3: {
                    bl2 = this.shortValue != 0;
                    break;
                }
                case 4: {
                    bl2 = this.intValue != 0;
                    break;
                }
                case 5: {
                    bl2 = this.longValue != 0L;
                    break;
                }
                case 6: {
                    bl2 = (double)this.floatValue != 0.0;
                    break;
                }
                case 7: {
                    bl2 = this.doubleValue != 0.0;
                    break;
                }
                case 8: {
                    bl2 = ((BigDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                case 21: {
                    bl2 = ((UtilSmallDecimal)this.data).doubleValue() != 0.0;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public byte getByteNoConvert() {
        return this.byteValue;
    }

    public byte getByte(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            byte by2 = 0;
            switch (this.type) {
                case 1: {
                    by2 = this.byteValue;
                    break;
                }
                case 10: {
                    by2 = Byte.parseByte(((String)this.data).trim());
                    break;
                }
                case 3: {
                    if (this.shortValue > 127 || this.shortValue < -128) {
                        throw baseExceptions.getException(6104);
                    }
                    by2 = (byte)this.shortValue;
                    break;
                }
                case 4: {
                    if (this.intValue > 127 || this.intValue < -128) {
                        throw baseExceptions.getException(6104);
                    }
                    by2 = (byte)this.intValue;
                    break;
                }
                case 5: {
                    if (this.longValue > 127L || this.longValue < -128L) {
                        throw baseExceptions.getException(6104);
                    }
                    by2 = (byte)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 127.0f || this.floatValue < -128.0f) {
                        throw baseExceptions.getException(6104);
                    }
                    by2 = (byte)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 127.0 || this.doubleValue < -128.0) {
                        throw baseExceptions.getException(6104);
                    }
                    by2 = (byte)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxByte) > 0 || bigDecimal.compareTo(bdMinByte) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    by2 = (byte)bigDecimal.intValue();
                    break;
                }
                case 21: {
                    by2 = (byte)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        by2 = 1;
                        break;
                    }
                    by2 = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    by2 = Byte.parseByte(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return by2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public byte[] getBytesNoConvert() {
        switch (this.type) {
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                if (this.nativeDataLen == ((byte[])this.data).length) {
                    return (byte[])this.data;
                }
                byte[] byArray = new byte[this.nativeDataLen];
                System.arraycopy(this.data, 0, byArray, 0, this.nativeDataLen);
                return byArray;
            }
        }
        return (byte[])this.data;
    }

    public byte[] getBytes(int n2, BaseExceptions baseExceptions) throws SQLException {
        return this.getBytes(n2, null, baseExceptions);
    }

    public byte[] getBytes(int n2, UtilTransliterator utilTransliterator, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Object object;
            Object object2 = null;
            switch (this.type) {
                case 2: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    object2 = (byte[])this.data;
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    if (this.nativeDataLen == ((byte[])this.data).length) {
                        object2 = (byte[])this.data;
                        break;
                    }
                    object2 = new byte[this.nativeDataLen];
                    System.arraycopy(this.data, 0, object2, 0, this.nativeDataLen);
                    break;
                }
                case 201: 
                case 202: 
                case 203: {
                    object2 = ((String)this.data).getBytes("UTF-16BE");
                    break;
                }
                case 10: 
                case 204: 
                case 205: 
                case 206: {
                    object2 = BaseData.stringToBytes((String)this.data, utilTransliterator, baseExceptions);
                    break;
                }
                case 14: {
                    object = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    boolean bl2 = false;
                    while (!bl2) {
                        int n3;
                        try {
                            n3 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n3 == -1) {
                            bl2 = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        ((ByteArrayOutputStream)object).write(byArray, 0, n3);
                    }
                    object2 = ((ByteArrayOutputStream)object).toByteArray();
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    object = this.getString(-1, baseExceptions);
                    object2 = BaseData.stringToBytes((String)object, utilTransliterator, baseExceptions);
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n4 = (int)blob.length();
                    if (n2 >= 0 && n4 > n2) {
                        n4 = n2;
                    }
                    object2 = blob.getBytes(1L, n4);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (n2 != -1 && ((byte[])object2).length > n2) {
                object = new byte[n2];
                System.arraycopy(object2, 0, object, 0, n2);
                object2 = object;
            }
            return object2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Reader getCharacterStreamReaderNoConvert() {
        return (Reader)this.data;
    }

    public Reader getCharacterStreamReader(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Reader reader = null;
            int n3 = -1;
            switch (this.type) {
                case 18: {
                    reader = (Reader)this.data;
                    break;
                }
                case 10: {
                    reader = new StringReader((String)this.data);
                    n3 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    reader = new StringReader(string);
                    n3 = string.length();
                    break;
                }
                case 15: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 2: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n3 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    reader = new StringReader(string);
                    n3 = string.length();
                    break;
                }
                case 14: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 17: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 20: {
                    reader = this.getClob(baseConnection, baseExceptions).getCharacterStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (reader != null && this.needWrapper) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n2 / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Reader getCharacterStreamReader(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl2) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 10: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 20: 
                case 101: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Reader reader = null;
            int n3 = -1;
            switch (this.type) {
                case 18: {
                    reader = (Reader)this.data;
                    break;
                }
                case 10: {
                    reader = new StringReader((String)this.data);
                    n3 = ((String)this.data).length();
                    break;
                }
                case 110: {
                    String string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    reader = new StringReader(string);
                    n3 = string.length();
                    break;
                }
                case 15: {
                    reader = new UtilASCIIInputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 2: {
                    String string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    reader = new StringReader(string);
                    n3 = ((byte[])this.data).length * 2;
                    break;
                }
                case 101: {
                    String string = this.sqlserverUniqueidentifierToString();
                    reader = new StringReader(string);
                    n3 = string.length();
                    break;
                }
                case 14: {
                    UtilBinaryToASCIIInputStream utilBinaryToASCIIInputStream = new UtilBinaryToASCIIInputStream((InputStream)this.data);
                    if (this.data instanceof BaseInputStreamWrapper) {
                        n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    }
                    reader = new UtilASCIIInputStreamToCharacterReader(utilBinaryToASCIIInputStream);
                    break;
                }
                case 17: {
                    reader = new UtilUCS2InputStreamToCharacterReader((InputStream)this.data);
                    if (!(this.data instanceof BaseInputStreamWrapper)) break;
                    n3 = (int)((BaseInputStreamWrapper)this.data).length();
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(baseConnection, baseExceptions);
                    if (clob instanceof BaseClob) {
                        reader = ((BaseClob)clob).getCharacterStream(bl2);
                        break;
                    }
                    reader = clob.getCharacterStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (reader != null && this.needWrapper) {
                if (!(reader instanceof BaseCharacterStreamWrapper)) {
                    reader = new BaseCharacterStreamWrapper(reader, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseCharacterStreamWrapper)reader).maxCharsToReturn = n2 / 2;
                }
            }
            return reader;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public short getShortNoConvert() {
        return this.shortValue;
    }

    public short getShort(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            short s2 = 0;
            switch (this.type) {
                case 3: {
                    s2 = this.shortValue;
                    break;
                }
                case 10: {
                    s2 = Short.parseShort(((String)this.data).trim());
                    break;
                }
                case 1: {
                    s2 = this.byteValue;
                    break;
                }
                case 4: {
                    if (this.intValue > Short.MAX_VALUE || this.intValue < Short.MIN_VALUE) {
                        throw baseExceptions.getException(6104);
                    }
                    s2 = (short)this.intValue;
                    break;
                }
                case 5: {
                    if (this.longValue > 32767L || this.longValue < -32768L) {
                        throw baseExceptions.getException(6104);
                    }
                    s2 = (short)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 32767.0f || this.floatValue < -32768.0f) {
                        throw baseExceptions.getException(6104);
                    }
                    s2 = (short)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 32767.0 || this.doubleValue < -32768.0) {
                        throw baseExceptions.getException(6104);
                    }
                    s2 = (short)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxShort) > 0 || bigDecimal.compareTo(bdMinShort) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    s2 = (short)bigDecimal.intValue();
                    break;
                }
                case 21: {
                    s2 = (short)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        s2 = 1;
                        break;
                    }
                    s2 = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    s2 = Short.parseShort(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return s2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public int getIntegerNoConvert() {
        return this.intValue;
    }

    public int getInteger(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            int n2 = 0;
            switch (this.type) {
                case 4: {
                    n2 = this.intValue;
                    break;
                }
                case 1: {
                    n2 = this.byteValue;
                    break;
                }
                case 3: {
                    n2 = this.shortValue;
                    break;
                }
                case 5: {
                    if (this.longValue > Integer.MAX_VALUE || this.longValue < Integer.MIN_VALUE) {
                        throw baseExceptions.getException(6104);
                    }
                    n2 = (int)this.longValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 2.1474836E9f || this.floatValue < -2.1474836E9f) {
                        throw baseExceptions.getException(6104);
                    }
                    n2 = (int)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 2.147483647E9 || this.doubleValue < -2.147483648E9) {
                        throw baseExceptions.getException(6104);
                    }
                    n2 = (int)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxInt) > 0 || bigDecimal.compareTo(bdMinInt) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    n2 = bigDecimal.intValue();
                    break;
                }
                case 21: {
                    n2 = (int)((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        n2 = 1;
                        break;
                    }
                    n2 = 0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    n2 = Integer.parseInt(string.trim());
                    break;
                }
                case 10: {
                    n2 = Integer.parseInt(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return n2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public long getLongNoConvert() {
        return this.longValue;
    }

    public long getLong(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0L;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0L;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            long l2 = 0L;
            switch (this.type) {
                case 5: {
                    l2 = this.longValue;
                    break;
                }
                case 1: {
                    l2 = this.byteValue;
                    break;
                }
                case 3: {
                    l2 = this.shortValue;
                    break;
                }
                case 4: {
                    l2 = this.intValue;
                    break;
                }
                case 6: {
                    if (this.floatValue > 9.223372E18f || this.floatValue < -9.223372E18f) {
                        throw baseExceptions.getException(6104);
                    }
                    l2 = (long)this.floatValue;
                    break;
                }
                case 7: {
                    if (this.doubleValue > 9.223372036854776E18 || this.doubleValue < -9.223372036854776E18) {
                        throw baseExceptions.getException(6104);
                    }
                    l2 = (long)this.doubleValue;
                    break;
                }
                case 8: {
                    BigDecimal bigDecimal = (BigDecimal)this.data;
                    if (bigDecimal.compareTo(bdMaxLong) > 0 || bigDecimal.compareTo(bdMinLong) < 0) {
                        throw baseExceptions.getException(6104);
                    }
                    l2 = ((BigDecimal)this.data).longValue();
                    break;
                }
                case 21: {
                    l2 = ((UtilSmallDecimal)this.data).longValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        l2 = 1L;
                        break;
                    }
                    l2 = 0L;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    l2 = Long.parseLong(string.trim());
                    break;
                }
                case 10: {
                    l2 = BaseData.stringToLong(((String)this.data).trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return l2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public float getFloatNoConvert() {
        return this.floatValue;
    }

    public float getFloat(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0.0f;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0.0f;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            float f2 = 0.0f;
            switch (this.type) {
                case 6: {
                    f2 = this.floatValue;
                    break;
                }
                case 10: {
                    f2 = Float.valueOf(((String)this.data).trim()).floatValue();
                    break;
                }
                case 1: {
                    f2 = this.byteValue;
                    break;
                }
                case 3: {
                    f2 = this.shortValue;
                    break;
                }
                case 4: {
                    f2 = this.intValue;
                    break;
                }
                case 5: {
                    f2 = this.longValue;
                    break;
                }
                case 7: {
                    f2 = (float)this.doubleValue;
                    break;
                }
                case 8: {
                    float f3 = ((BigDecimal)this.data).floatValue();
                    if (f3 == Float.POSITIVE_INFINITY || f3 == Float.NEGATIVE_INFINITY) {
                        throw baseExceptions.getException(6104);
                    }
                    f2 = f3;
                    break;
                }
                case 21: {
                    f2 = (float)((UtilSmallDecimal)this.data).doubleValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        f2 = 1.0f;
                        break;
                    }
                    f2 = 0.0f;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    f2 = Float.valueOf(string.trim()).floatValue();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return f2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public double getDoubleNoConvert() {
        return this.doubleValue;
    }

    public double getDouble(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return 0.0;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 18: 
                case 21: {
                    return 0.0;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            double d2 = 0.0;
            switch (this.type) {
                case 7: {
                    d2 = this.doubleValue;
                    break;
                }
                case 10: {
                    d2 = BaseData.asciiToDouble(this.data.toString());
                    break;
                }
                case 1: {
                    d2 = this.byteValue;
                    break;
                }
                case 3: {
                    d2 = this.shortValue;
                    break;
                }
                case 4: {
                    d2 = this.intValue;
                    break;
                }
                case 5: {
                    d2 = this.longValue;
                    break;
                }
                case 6: {
                    d2 = this.floatValue;
                    break;
                }
                case 8: {
                    double d3 = BaseData.bigdecimalToDouble((BigDecimal)this.data);
                    if (d3 == Double.POSITIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
                        throw baseExceptions.getException(6104);
                    }
                    d2 = d3;
                    break;
                }
                case 21: {
                    d2 = ((UtilSmallDecimal)this.data).doubleValue();
                    break;
                }
                case 9: {
                    if (this.booleanValue) {
                        d2 = 1.0;
                        break;
                    }
                    d2 = 0.0;
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    d2 = Double.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return d2;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public String getStringNoConvert() {
        switch (this.type) {
            case 101: {
                return this.sqlserverUniqueidentifierToString();
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.sqlserverDateTimeToTimestamp().toString();
            }
            case 106: {
                return this.sybaseDatetoString();
            }
            case 107: {
                return this.sybaseTimeToTimeStamp().timeToString();
            }
            case 108: {
                return this.oracleDateToTimestamp(null).toString();
            }
            case 109: {
                return this.oracleTimestampToTimestamp(null).toString();
            }
            case 110: {
                return (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
            }
            case 111: {
                return this.oracleTimestampWithLocalTimeZoneToTimestamp().toString();
            }
        }
        return (String)this.data;
    }

    public String getString(int n2, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            if (this.type == 16) {
                this.unsupportedConversion(baseExceptions);
            }
            return null;
        }
        try {
            String string = null;
            switch (this.type) {
                case 10: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    string = (String)this.data;
                    break;
                }
                case 2: {
                    string = UtilDataConversions.bytesToString((byte[])this.data, ((byte[])this.data).length);
                    break;
                }
                case 101: {
                    string = this.sqlserverUniqueidentifierToString();
                    break;
                }
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    string = this.sqlserverDateTimeToTimestamp().toString();
                    break;
                }
                case 106: {
                    string = this.sybaseDatetoString();
                    break;
                }
                case 107: {
                    string = this.sybaseTimeToTimeStamp().timeToString();
                    break;
                }
                case 108: {
                    string = this.oracleDateToTimestamp(null).toString();
                    break;
                }
                case 109: {
                    string = this.oracleTimestampToTimestamp(null).toString();
                    break;
                }
                case 110: {
                    string = (String)this.oracleTimestampWithTimeZoneToTimestamp(null, false);
                    break;
                }
                case 111: {
                    string = this.oracleTimestampWithLocalTimeZoneToTimestamp().toString();
                    break;
                }
                case 14: {
                    byte[] byArray = this.getBytes(n2, baseExceptions);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 15: 
                case 17: {
                    long l2;
                    int n3 = -1;
                    if (this.data instanceof BaseInputStreamWrapper && (l2 = ((BaseInputStreamWrapper)this.data).numTotalBytesInStream) > 0L && l2 <= Integer.MAX_VALUE) {
                        n3 = new Long(l2).intValue();
                    }
                    if (n3 == -1) {
                        n3 = 10240;
                    }
                    StringBuffer stringBuffer = new StringBuffer(n3);
                    boolean bl2 = false;
                    byte[] byArray = new byte[n3];
                    boolean bl3 = false;
                    while (!bl3) {
                        int n4;
                        try {
                            n4 = ((InputStream)this.data).read(byArray, 0, byArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n4 == -1) {
                            bl3 = true;
                            try {
                                ((InputStream)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        if (this.type == 15) {
                            stringBuffer.append(UtilDataConversions.ASCIIBytesToString(byArray, n4));
                            continue;
                        }
                        stringBuffer.append(UtilDataConversions.UCS2BytesToString(byArray, n4));
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 18: {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl4 = false;
                    char[] cArray = new char[1024];
                    boolean bl5 = false;
                    while (!bl5) {
                        int n5;
                        try {
                            n5 = ((Reader)this.data).read(cArray, 0, cArray.length);
                        }
                        catch (IOException iOException) {
                            throw baseExceptions.getException(iOException);
                        }
                        if (n5 == -1) {
                            bl5 = true;
                            try {
                                ((Reader)this.data).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw baseExceptions.getException(iOException);
                            }
                        }
                        stringBuffer.append(cArray, 0, n5);
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 20: {
                    Clob clob = this.getClob(null, baseExceptions);
                    int n6 = new Long(clob.length()).intValue();
                    if (n2 >= 0 && n6 > n2) {
                        n6 = n2;
                    }
                    string = clob.getSubString(1L, n6);
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(null, baseExceptions);
                    int n7 = new Long(blob.length()).intValue();
                    if (n2 >= 0 && n7 > n2 / 2) {
                        n7 = n2 / 2;
                    }
                    byte[] byArray = blob.getBytes(1L, n7);
                    string = UtilDataConversions.bytesToString(byArray, byArray.length);
                    break;
                }
                case 1: {
                    string = String.valueOf(this.byteValue);
                    break;
                }
                case 9: {
                    string = String.valueOf(this.booleanValue);
                    break;
                }
                case 4: {
                    if (this.intValue >= 0 && this.intValue <= 7000) {
                        string = BaseIntegerStringConstants.positiveIntegers[this.intValue];
                        break;
                    }
                    if (this.intValue < 0 && this.intValue >= -1000) {
                        string = BaseIntegerStringConstants.negativeIntegers[-this.intValue];
                        break;
                    }
                    string = String.valueOf(this.intValue);
                    break;
                }
                case 3: {
                    if (this.shortValue >= 0 && this.shortValue <= 7000) {
                        string = BaseIntegerStringConstants.positiveIntegers[this.shortValue];
                        break;
                    }
                    if (this.shortValue < 0 && this.shortValue >= -1000) {
                        string = BaseIntegerStringConstants.negativeIntegers[-this.shortValue];
                        break;
                    }
                    string = String.valueOf(this.shortValue);
                    break;
                }
                case 5: {
                    if (this.longValue >= 0L && this.longValue <= 7000L) {
                        string = BaseIntegerStringConstants.positiveIntegers[(int)this.longValue];
                        break;
                    }
                    if (this.longValue < 0L && this.longValue >= -1000L) {
                        string = BaseIntegerStringConstants.negativeIntegers[-((int)this.longValue)];
                        break;
                    }
                    string = this.longToString(this.longValue);
                    break;
                }
                case 7: {
                    if (this.connection == null) {
                        throw baseExceptions.getException(6024);
                    }
                    if (this.connection.isJavaDoubleToString) {
                        string = String.valueOf(this.doubleValue);
                        break;
                    }
                    string = this.doubleToString(this.doubleValue);
                    break;
                }
                case 6: {
                    string = String.valueOf(this.floatValue);
                    break;
                }
                case 16: {
                    this.unsupportedConversion(baseExceptions);
                }
                default: {
                    string = this.data.toString();
                }
            }
            if (n2 != -1 && string.length() > n2) {
                string = string.substring(0, n2);
            }
            return string;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Date getDateNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
            case 108: {
                return this.oracleDateToDate();
            }
            case 109: {
                BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
            case 110: {
                BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
            case 111: {
                BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                return new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
            }
        }
        return (Date)this.data;
    }

    public Date getDate(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 10: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 203: 
                case 204: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Date date = null;
            switch (this.type) {
                case 11: {
                    date = (Date)this.data;
                    break;
                }
                case 10: 
                case 201: 
                case 204: {
                    date = Date.valueOf(((String)this.data).trim());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    date = Date.valueOf(this.getString(-1, baseExceptions).trim());
                    break;
                }
                case 203: 
                case 206: {
                    BaseTimestamp baseTimestamp = BaseTimestamp.valueOf((String)this.data);
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 106: {
                    date = this.sybaseDatetoDate();
                    break;
                }
                case 108: {
                    date = this.oracleDateToDate();
                    break;
                }
                case 109: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                        date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                case 13: {
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    date = new Date(baseTimestamp.getDateClassCompatiableYear(), baseTimestamp.getMonth(), baseTimestamp.getDate());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return date;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Date getDate(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 11: 
                case 13: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 203: 
                case 204: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    return this.applyCalendarToSqlServerDate(calendar);
                }
                case 11: {
                    return BaseData.applyCalender((Date)this.data, calendar, false);
                }
                case 13: 
                case 108: 
                case 109: 
                case 111: 
                case 203: 
                case 206: {
                    Date date = this.getDate(baseExceptions);
                    return BaseData.applyCalender(date, calendar, false);
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        Date date = this.getDate(baseExceptions);
                        return BaseData.applyCalender(date, calendar, false);
                    }
                    throw baseExceptions.getException(6024);
                }
                case 201: 
                case 204: {
                    return BaseData.applyCalender(Date.valueOf((String)this.data), calendar, false);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Time getTimeNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 107: {
                BaseTimestamp baseTimestamp = this.sybaseTimeToTimeStamp();
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 108: {
                BaseTimestamp baseTimestamp = this.oracleDateToTimestamp(null);
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 109: {
                BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 110: {
                BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
            case 111: {
                BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                return new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
            }
        }
        return (Time)this.data;
    }

    public Time getTime(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 202: 
                case 203: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            Time time = null;
            switch (this.type) {
                case 12: {
                    time = (Time)this.data;
                    break;
                }
                case 10: 
                case 202: 
                case 205: {
                    time = Time.valueOf(((String)this.data).trim());
                    break;
                }
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    BaseTimestamp baseTimestamp = this.sqlserverDateTimeToTimestamp();
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 107: {
                    BaseTimestamp baseTimestamp = this.sybaseTimeToTimeStamp();
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 203: 
                case 206: {
                    BaseTimestamp baseTimestamp = BaseTimestamp.valueOf((String)this.data);
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 108: {
                    BaseTimestamp baseTimestamp = this.oracleDateToTimestamp(null);
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 109: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampToTimestamp(null);
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        BaseTimestamp baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                        time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    BaseTimestamp baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 13: {
                    BaseTimestamp baseTimestamp = (BaseTimestamp)this.data;
                    time = new Time(baseTimestamp.getHours(), baseTimestamp.getMinutes(), baseTimestamp.getSeconds());
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    time = Time.valueOf(string.trim());
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return time;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Time getTime(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 12: 
                case 13: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 202: 
                case 203: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 107: {
                    return this.applyCalendarToSqlServerTime(calendar);
                }
                case 202: 
                case 205: {
                    return BaseData.applyCalender(Time.valueOf((String)this.data), calendar, false);
                }
                case 12: {
                    return BaseData.applyCalender((Time)this.data, calendar, false);
                }
                case 13: 
                case 108: 
                case 109: 
                case 111: 
                case 203: 
                case 206: {
                    Time time = this.getTime(baseExceptions);
                    return BaseData.applyCalender(time, calendar, false);
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        Time time = this.getTime(baseExceptions);
                        return BaseData.applyCalender(time, calendar, false);
                    }
                    throw baseExceptions.getException(6024);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BaseTimestamp getTimestampNoConvert() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.sqlserverDateTimeToTimestamp();
            }
            case 107: {
                return this.sybaseTimeToTimeStamp();
            }
            case 108: {
                return this.oracleDateToTimestamp(null);
            }
            case 109: {
                return this.oracleTimestampToTimestamp(null);
            }
            case 110: {
                return (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
            }
            case 111: {
                return this.oracleTimestampWithLocalTimeZoneToTimestamp();
            }
        }
        return (BaseTimestamp)this.data;
    }

    public BaseTimestamp getTimestamp(BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 18: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            BaseTimestamp baseTimestamp = null;
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: {
                    baseTimestamp = this.sqlserverDateTimeToTimestamp();
                    break;
                }
                case 107: {
                    baseTimestamp = this.sybaseTimeToTimeStamp();
                    break;
                }
                case 13: {
                    baseTimestamp = (BaseTimestamp)this.data;
                    break;
                }
                case 10: 
                case 203: 
                case 206: {
                    baseTimestamp = BaseTimestamp.valueOf(((String)this.data).trim());
                    break;
                }
                case 108: {
                    baseTimestamp = this.oracleDateToTimestamp(null);
                    break;
                }
                case 109: {
                    baseTimestamp = this.oracleTimestampToTimestamp(null);
                    break;
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        baseTimestamp = (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(null, true);
                        break;
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    baseTimestamp = this.oracleTimestampWithLocalTimeZoneToTimestamp();
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    String string = this.getString(-1, baseExceptions);
                    baseTimestamp = BaseTimestamp.valueOf(string.trim());
                    break;
                }
                case 201: 
                case 202: 
                case 204: 
                case 205: {
                    if (this.data == null) break;
                    Calendar calendar = Calendar.getInstance();
                    if (this.type == 202 || this.type == 205) {
                        calendar.setTime(Time.valueOf((String)this.data));
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    } else {
                        calendar.setTime(Date.valueOf((String)this.data));
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                    baseTimestamp = new BaseTimestamp(calendar, 0);
                    break;
                }
                case 11: 
                case 12: {
                    if (this.data == null) break;
                    Calendar calendar = Calendar.getInstance();
                    if (this.type == 12) {
                        calendar.setTime((Time)this.data);
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                    } else {
                        calendar.setTime((Date)this.data);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                    }
                    baseTimestamp = new BaseTimestamp(calendar, 0);
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            return baseTimestamp;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public BaseTimestamp getTimestamp(Calendar calendar, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (this.connection != null && this.connection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 11: 
                case 12: 
                case 13: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            switch (this.type) {
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return this.applyCalendarToSqlServerTimestamp(calendar);
                }
                case 201: 
                case 204: {
                    return new BaseData(11, BaseData.applyCalender(Date.valueOf(((String)this.data).trim()), calendar, false), this.connection).getTimestamp(baseExceptions);
                }
                case 202: 
                case 205: {
                    return new BaseData(12, BaseData.applyCalender(Time.valueOf(((String)this.data).trim()), calendar, false), this.connection).getTimestamp(baseExceptions);
                }
                case 203: 
                case 206: {
                    return BaseTimestamp.applyCalender(BaseTimestamp.valueOf(((String)this.data).trim()), calendar);
                }
                case 108: {
                    return this.oracleDateToTimestamp(calendar);
                }
                case 109: {
                    return this.oracleTimestampToTimestamp(calendar);
                }
                case 110: {
                    if (this.oracleFetchTSWTZasTimestamp) {
                        return (BaseTimestamp)this.oracleTimestampWithTimeZoneToTimestamp(calendar, true);
                    }
                    throw baseExceptions.getException(6024);
                }
                case 111: {
                    return this.oracleTimestampWithLocalTimeZoneToTimestamp();
                }
                case 13: {
                    return BaseTimestamp.applyCalender((BaseTimestamp)this.data, calendar);
                }
                case 12: {
                    return new BaseData(12, BaseData.applyCalender((Time)this.data, calendar, false), this.connection).getTimestamp(baseExceptions);
                }
                case 11: {
                    return new BaseData(11, BaseData.applyCalender((Date)this.data, calendar, false), this.connection).getTimestamp(baseExceptions);
                }
            }
            this.unsupportedConversion(baseExceptions);
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getBinaryStreamNoConvert() {
        return (InputStream)this.data;
    }

    public InputStream getBinaryStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 14: 
                case 19: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n3 = -1;
            switch (this.type) {
                case 14: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 201: 
                case 202: 
                case 203: {
                    byte[] byArray = ((String)this.data).getBytes("UTF-16BE");
                    inputStream = new ByteArrayInputStream(byArray);
                    n3 = byArray.length;
                    break;
                }
                case 204: 
                case 205: 
                case 206: {
                    byte[] byArray = ((String)this.data).getBytes();
                    inputStream = new ByteArrayInputStream(byArray);
                    n3 = byArray.length;
                    break;
                }
                case 2: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n3 = ((byte[])this.data).length;
                    break;
                }
                case 108: 
                case 109: 
                case 110: {
                    inputStream = new ByteArrayInputStream(this.getBytesNoConvert());
                    n3 = this.nativeDataLen;
                    break;
                }
                case 19: {
                    inputStream = this.getBlob(baseConnection, baseExceptions).getBinaryStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null && this.needWrapper) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getBinaryStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions, boolean bl2) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            switch (this.type) {
                case 2: 
                case 14: 
                case 19: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: {
                    return null;
                }
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            int n3 = -1;
            switch (this.type) {
                case 14: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                case 201: 
                case 202: 
                case 203: {
                    byte[] byArray = ((String)this.data).getBytes("UTF-16BE");
                    inputStream = new ByteArrayInputStream(byArray);
                    n3 = byArray.length;
                    break;
                }
                case 204: 
                case 205: 
                case 206: {
                    byte[] byArray = ((String)this.data).getBytes();
                    inputStream = new ByteArrayInputStream(byArray);
                    n3 = byArray.length;
                    break;
                }
                case 2: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    inputStream = new ByteArrayInputStream((byte[])this.data);
                    n3 = ((byte[])this.data).length;
                    break;
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    inputStream = new ByteArrayInputStream(this.getBytesNoConvert());
                    n3 = this.nativeDataLen;
                    break;
                }
                case 19: {
                    Blob blob = this.getBlob(baseConnection, baseExceptions);
                    if (blob instanceof BaseBlob) {
                        inputStream = ((BaseBlob)blob).getBinaryStream(bl2);
                        break;
                    }
                    inputStream = blob.getBinaryStream();
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null && this.needWrapper) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, n3, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getUTF8InputStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 16) {
                return null;
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 16: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    this.unsupportedConversion(baseExceptions);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public InputStream getUCS2InputStream(int n2, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 17) {
                return null;
            }
            this.unsupportedConversion(baseExceptions);
        }
        try {
            InputStream inputStream = null;
            switch (this.type) {
                case 17: {
                    inputStream = (InputStream)this.data;
                    break;
                }
                default: {
                    Reader reader = this.getCharacterStreamReader(n2, baseConnection, baseExceptions);
                    if (reader == null) break;
                    inputStream = new UtilCharacterReaderToUCS2InputStream(reader);
                }
            }
            if (inputStream != null) {
                if (!(inputStream instanceof BaseInputStreamWrapper)) {
                    inputStream = new BaseInputStreamWrapper(inputStream, -1L, baseConnection, baseExceptions);
                }
                if (n2 != -1) {
                    ((BaseInputStreamWrapper)inputStream).maxBytesToReturn = n2;
                }
            }
            return inputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    public Clob getClobNoConvert() {
        return (Clob)this.data;
    }

    public Clob getClob(BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        if (this.isNull) {
            if (baseConnection != null && baseConnection.convertNull == 0) {
                return null;
            }
            if (this.type == 20) {
                return null;
            }
            this.getString(0, baseExceptions);
            return null;
        }
        try {
            Clob clob = null;
            switch (this.type) {
                case 20: {
                    if (this.data == null) break;
                    if (this.data instanceof BaseImplClob) {
                        this.data = new BaseClob((BaseImplClob)this.data, baseConnection, baseExceptions);
                    }
                    clob = (Clob)this.data;
                    break;
                }
                default: {
                    this.needWrapper = false;
                    Reader reader = this.getCharacterStreamReader(-1, baseConnection, baseExceptions);
                    this.needWrapper = true;
                    BaseImplClobEmulated baseImplClobEmulated = new BaseImplClobEmulated(baseExceptions, reader);
                    clob = new BaseClob(baseImplClobEmulated, baseConnection, baseExceptions);
                }
            }
            return clob;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw baseExceptions.getException(6024);
        }
    }

    static Date applyCalender(Date date, Calendar calendar, boolean bl2) {
        calendar = (Calendar)calendar.clone();
        if (bl2) {
            calendar.setTime(date);
            int n2 = calendar.get(1) - 1900;
            int n3 = calendar.get(2);
            int n4 = calendar.get(5);
            return new Date(n2, n3, n4);
        }
        calendar.clear();
        calendar.set(date.getYear() + 1900, date.getMonth(), date.getDate(), 0, 0, 0);
        return new Date(calendar.getTime().getTime());
    }

    static Time applyCalender(Time time, Calendar calendar, boolean bl2) {
        calendar = (Calendar)calendar.clone();
        if (bl2) {
            calendar.setTime(time);
            int n2 = calendar.get(11);
            int n3 = calendar.get(12);
            int n4 = calendar.get(13);
            return new Time(n2, n3, n4);
        }
        calendar.clear();
        calendar.set(1970, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
        return new Time(calendar.getTime().getTime());
    }

    final void unsupportedConversion(BaseExceptions baseExceptions) throws SQLException {
        switch (this.type) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                try {
                    ((InputStream)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 18: {
                try {
                    ((Reader)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 19: {
                try {
                    ((BaseImplBlob)this.data).close();
                }
                catch (Exception exception) {}
                break;
            }
            case 20: {
                try {
                    ((BaseImplClob)this.data).close();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw baseExceptions.getException(6008);
    }

    static double exponentAdjust(long l2, int n2, int n3) {
        int n4;
        long l3;
        long l4;
        if (n2 == 0) {
            return l2;
        }
        if (n2 > 0) {
            if (n2 >= BaseDoubleConversionConstants.PowersOf10Mantissa.length) {
                return Double.longBitsToDouble(0x7FF0000000000000L);
            }
            l4 = BaseDoubleConversionConstants.PowersOf10Mantissa[n2];
            l3 = BaseDoubleConversionConstants.PowersOf10Exponent[n2];
        } else {
            int n5 = -n2;
            if (n5 >= BaseDoubleConversionConstants.DivisorsOf10Mantissa.length) {
                return 0.0;
            }
            l4 = BaseDoubleConversionConstants.DivisorsOf10Mantissa[n5];
            l3 = BaseDoubleConversionConstants.DivisorsOf10Exponent[n5] + (long)n3;
        }
        long l5 = (l2 & 0xFFFFFFFFL) * (l4 & 0xFFFFFFFFL);
        long l6 = (l2 >> 32 & 0xFFFFFFFFL) * (l4 >> 32 & 0xFFFFFFFFL);
        long l7 = (l2 >> 32 & 0xFFFFFFFFL) * (l4 & 0xFFFFFFFFL);
        l6 += l7 >> 32 & 0xFFFFFFFFL;
        long l8 = l7 << 32;
        if (l5 < 0L) {
            l5 += l8;
            if (l8 < 0L) {
                ++l6;
            } else if (l5 >= 0L) {
                ++l6;
            }
        } else if (l8 < 0L && (l5 += l8) >= 0L) {
            ++l6;
        }
        l7 = (l2 & 0xFFFFFFFFL) * (l4 >> 32 & 0xFFFFFFFFL);
        l6 += l7 >> 32 & 0xFFFFFFFFL;
        l8 = l7 << 32;
        if (l5 < 0L) {
            l5 += l8;
            if (l8 < 0L) {
                ++l6;
            } else if (l5 >= 0L) {
                ++l6;
            }
        } else if (l8 < 0L && (l5 += l8) >= 0L) {
            ++l6;
        }
        if (l6 == 0L) {
            if (l5 >= 0L) {
                l6 = l5;
            } else {
                l6 = l5 >> 1 & Long.MAX_VALUE;
                ++l3;
            }
            l5 = 0L;
            l3 -= 64L;
        }
        if (l6 < 0x10000000000000L || l6 >= 0x20000000000000L) {
            int n6 = 0;
            int n7 = BaseDoubleConversionConstants.HighestBit.length - 1;
            do {
                int n8;
                if (l6 < BaseDoubleConversionConstants.HighestBit[n8 = (n6 + n7) / 2]) {
                    n7 = n8 - 1;
                    continue;
                }
                n6 = n8 + 1;
            } while (n6 <= n7);
            if (n7 < 52) {
                n4 = 52 - n7;
                l6 = l5 >= 0L ? l6 << n4 | l5 >> 64 - n4 & Long.MAX_VALUE : l6 << n4 | (l5 >> 1 & Long.MAX_VALUE) >> 63 - n4;
                l5 <<= n4;
                l3 -= (long)n4;
            } else {
                n4 = n7 - 52;
                l5 = l6 << 64 - n4;
                l6 >>= n4;
                l3 += (long)n4;
            }
        }
        l7 = l6;
        if (l5 < 0L && ++l7 >= 0x20000000000000L) {
            l7 = 0x10000000000000L;
            ++l3;
        }
        if (n2 < 0) {
            l8 = (l7 |= 0x4330000000000000L) + (l3 + 2L << 52);
            if (l8 < 0L || (l8 & 0x7FF0000000000000L) == 0L) {
                l8 = l6;
                if ((l3 += 2L + ((l7 & 0x7FF0000000000000L) >> 52)) <= 0L) {
                    n4 = (int)(-l3);
                } else {
                    System.out.println("** Internal Error! ** : " + l3);
                    n4 = 0;
                }
                if (n4 > 52) {
                    return 0.0;
                }
                if (n4 > 0) {
                    l8 >>= n4;
                }
                l8 = (l8 & 1L) == 0L ? (l8 >>= 1) : (l8 >> 1) + 1L;
            }
        } else {
            l8 = l7 + (l3 + 1138L << 52);
            if (l8 < 0L || (l8 & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
                l8 = 0x7FF0000000000000L;
            }
        }
        double d2 = Double.longBitsToDouble(l8);
        return d2;
    }

    static double asciiToDouble(String string) {
        long l2;
        boolean bl2;
        int n2;
        int n3;
        for (n3 = string.length(); n3 >= 0 && string.charAt(n3 - 1) <= ' '; --n3) {
        }
        if (n3 == 0) {
            throw new NumberFormatException("empty string");
        }
        for (n2 = 0; n2 < n3 && string.charAt(n2) <= ' '; ++n2) {
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = 0;
        char c2 = string.charAt(n2);
        while (c2 <= ' ' && (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '\f') && ++n2 < n3) {
            c2 = string.charAt(n2);
        }
        if (n2 >= n3) {
            return 0.0;
        }
        if (c2 == '-') {
            bl2 = true;
            c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
        } else {
            bl2 = false;
            if (c2 == '+') {
                c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
            }
        }
        while (c2 == '0') {
            if (++n2 < n3) {
                c2 = string.charAt(n2);
                continue;
            }
            c2 = '\u0000';
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (c2 >= '0' && c2 <= '9') {
            n6 = n6 * 10 + (c2 - 48);
            c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
            if (++n5 != 9 || c2 != '.' && (c2 < '0' || c2 > '9')) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            if (c2 == '.') {
                c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                if (n6 == 0) {
                    while (c2 == '0') {
                        c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                        ++n4;
                    }
                }
                while (c2 >= '0' && c2 <= '9') {
                    n6 = n6 * 10 + (c2 - 48);
                    c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                    ++n4;
                    if (++n5 != 9 || c2 < '0' || c2 > '9') continue;
                    bl3 = true;
                    bl4 = true;
                    break;
                }
            }
            if (!bl3) {
                if (c2 == 'E' || c2 == 'e') {
                    boolean bl6;
                    if ((c2 = string.charAt(++n2)) == '-') {
                        bl6 = true;
                        c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                    } else {
                        bl6 = false;
                        if (c2 == '+') {
                            c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                        }
                    }
                    while (c2 == '0') {
                        if (++n2 < n3) {
                            c2 = string.charAt(n2);
                            continue;
                        }
                        c2 = '\u0000';
                    }
                    while (c2 >= '0' && c2 <= '9') {
                        n7 = n7 * 10 + (c2 - 48);
                        if (++n2 < n3) {
                            c2 = string.charAt(n2);
                            continue;
                        }
                        c2 = '\u0000';
                    }
                    if (bl6) {
                        n7 = -n7;
                    }
                }
                while (c2 <= ' ' && (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '\f')) {
                    if (++n2 < n3) {
                        c2 = string.charAt(n2);
                        continue;
                    }
                    c2 = '\u0000';
                }
                if (c2 != '\u0000') {
                    throw new NumberFormatException("Invalid value");
                }
                if (n6 == 0) {
                    if (bl2) {
                        return -0.0;
                    }
                    return 0.0;
                }
                double d2 = BaseData.exponentAdjust(n6, n7 -= n4, 0);
                if (bl2) {
                    d2 = -d2;
                }
                return d2;
            }
        }
        if (!bl4) {
            l2 = n6;
            while (c2 >= '0' && c2 <= '9') {
                l2 = l2 * 10L + (long)(c2 - 48);
                c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                if (++n5 != 19 && (n5 != 18 || l2 < 0xCCCCCCCCCCCCCCCL)) continue;
                if (c2 >= '5') {
                    ++l2;
                }
                while (c2 >= '0' && c2 <= '9') {
                    c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                    --n4;
                }
                if (c2 == '.') {
                    c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                }
                while (c2 >= '0' && c2 <= '9') {
                    if (++n2 < n3) {
                        c2 = string.charAt(n2);
                        continue;
                    }
                    c2 = '\u0000';
                }
                bl5 = true;
                break;
            }
            if (!bl5 && c2 == '.') {
                c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                bl4 = true;
            }
        } else {
            l2 = n6;
        }
        if (bl4) {
            while (c2 >= '0' && c2 <= '9') {
                l2 = l2 * 10L + (long)(c2 - 48);
                c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                ++n4;
                if (++n5 != 19 && (n5 != 18 || l2 < 0xCCCCCCCCCCCCCCCL)) continue;
                if (c2 >= '5') {
                    ++l2;
                }
                while (c2 >= '0' && c2 <= '9') {
                    if (++n2 < n3) {
                        c2 = string.charAt(n2);
                        continue;
                    }
                    c2 = '\u0000';
                }
                break block13;
            }
        }
        if (c2 == 'E' || c2 == 'e') {
            boolean bl7;
            if ((c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000') == '-') {
                bl7 = true;
                c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
            } else {
                bl7 = false;
                if (c2 == '+') {
                    c2 = ++n2 < n3 ? string.charAt(n2) : (char)'\u0000';
                }
            }
            while (c2 == '0') {
                if (++n2 < n3) {
                    c2 = string.charAt(n2);
                    continue;
                }
                c2 = '\u0000';
            }
            while (c2 >= '0' && c2 <= '9') {
                n7 = n7 * 10 + (c2 - 48);
                if (++n2 < n3) {
                    c2 = string.charAt(n2);
                    continue;
                }
                c2 = '\u0000';
            }
            if (bl7) {
                n7 = -n7;
            }
        }
        while (c2 <= ' ' && (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '\f')) {
            if (++n2 < n3) {
                c2 = string.charAt(n2);
                continue;
            }
            c2 = '\u0000';
        }
        if (c2 != '\u0000') {
            throw new NumberFormatException("Invalid Value");
        }
        double d3 = BaseData.exponentAdjust(l2, n7 -= n4, 0);
        if (bl2) {
            d3 = -d3;
        }
        return d3;
    }

    public String doubleToString(double d2) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (d2 == Double.NEGATIVE_INFINITY) {
            return new String(NEGATIVE_INFINITY);
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return new String(POSITIVE_INFINITY);
        }
        if (d2 != d2) {
            return new String(NaN);
        }
        if (d2 == 0.0) {
            return "0.0";
        }
        if (this.buf == null) {
            this.buf = new char[32];
        }
        int n6 = 0;
        boolean bl2 = false;
        long l2 = Double.doubleToLongBits(d2);
        int n7 = (int)((l2 & 0x7FF0000000000000L) >> 52);
        long l3 = n7 != 0 ? l2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L : l2 & 0xFFFFFFFFFFFFFL;
        if ((n7 -= 1023) >= 0 && n7 <= 52) {
            if (d2 < 0.0) {
                bl2 = true;
            }
            if ((BaseDoubleConversionConstants.CheckForInteger[n7] & l3) == 0L) {
                int n8;
                int n9;
                long l4 = l3 >> 52 - n7;
                n6 = 25;
                while (l4 > Integer.MAX_VALUE) {
                    long l5 = l4 / 1000L;
                    n9 = (int)(l4 - l5 * 1000L);
                    l4 = l5;
                    this.buf[n6] = DigitOnes[n9];
                    this.buf[n6 - 1] = DigitTens[n9];
                    this.buf[n6 - 2] = DigitHundreds[n9];
                    n6 -= 3;
                }
                int n10 = (int)l4;
                while (n10 >= 65536) {
                    n8 = n10 / 1000;
                    n9 = n10 - n8 * 1000;
                    n10 = n8;
                    this.buf[n6] = DigitOnes[n9];
                    this.buf[n6 - 1] = DigitTens[n9];
                    this.buf[n6 - 2] = DigitHundreds[n9];
                    n6 -= 3;
                }
                while (true) {
                    n8 = n10 * 52429 >>> 19;
                    this.buf[n6] = (char)(n10 - n8 * 10 + 48);
                    --n6;
                    if (n8 == 0) break;
                    n10 = n8;
                }
                if (n6 <= 17) {
                    n7 = 24 - n6;
                    this.buf[n6] = this.buf[n6 + 1];
                    this.buf[n6 + 1] = 46;
                    int n11 = 25;
                    while (this.buf[n11] == '0') {
                        --n11;
                    }
                    if (n11 == n6 + 1) {
                        n11 += 2;
                    }
                    int n12 = ++n11;
                    ++n11;
                    this.buf[n12] = 69;
                    if (n7 > 9) {
                        this.buf[n11++] = 49;
                        this.buf[n11++] = (char)(n7 + 38);
                    } else {
                        this.buf[n11++] = (char)(n7 + 48);
                    }
                    if (bl2) {
                        this.buf[--n6] = 45;
                    }
                    return new String(this.buf, n6, n11 - n6);
                }
                this.buf[26] = 46;
                this.buf[27] = 48;
                if (bl2) {
                    this.buf[n6] = 45;
                    --n6;
                }
                return new String(this.buf, n6 + 1, 27 - n6);
            }
        }
        long l6 = BaseDoubleConversionConstants.ScalingTable[n7 += 1050];
        long l7 = l6 & 0xFFFFFFFFL;
        long l8 = l3 & 0xFFFFFFFFL;
        long l9 = (l6 & 0xFFFFFFFFL) * (l3 & 0xFFFFFFFFL);
        long l10 = (l6 >> 32 & 0xFFFFFFFFL) * (l3 & 0xFFFFFFFFL);
        long l11 = l9;
        long l12 = l10 << 32;
        l9 += l12;
        boolean bl3 = false;
        if (l11 < 0L && l12 < 0L) {
            bl3 = true;
        } else if (l11 < 0L || l12 < 0L) {
            bl3 = l9 >= 0L;
        }
        long l13 = bl3 ? (l10 >> 32 & 0xFFFFFFFFL) + 1L : l10 >> 32 & 0xFFFFFFFFL;
        l10 = (l6 & 0xFFFFFFFFL) * (l3 >> 32 & 0xFFFFFFFFL);
        l11 = l9;
        l12 = l10 << 32;
        l9 += l12;
        bl3 = false;
        if (l11 < 0L && l12 < 0L) {
            bl3 = true;
        } else if (l11 < 0L || l12 < 0L) {
            boolean bl4 = bl3 = l9 >= 0L;
        }
        l13 = bl3 ? (l13 += (l10 >> 32 & 0xFFFFFFFFL) + 1L) : (l13 += l10 >> 32 & 0xFFFFFFFFL);
        l10 = (l6 >> 32 & 0xFFFFFFFFL) * (l3 >> 32 & 0xFFFFFFFFL);
        l13 += l10;
        int n13 = ((int)(l9 >> 48) & 0xFFFF) * 100;
        if (d2 < 0.0) {
            l13 = (n13 & 0x8000) != 0 ? -(l13 * 100L + (long)(n13 >> 16) + 1L) : -(l13 * 100L + (long)(n13 >> 16));
            bl2 = true;
        } else {
            l13 = (n13 & 0x8000) != 0 ? l13 * 100L + (long)(n13 >> 16) + 1L : l13 * 100L + (long)(n13 >> 16);
        }
        int n14 = BaseDoubleConversionConstants.ScalingTableExp[n7] + 3;
        if (bl2) {
            l13 = -l13;
        }
        if (l13 > 999999999999999L) {
            if (l13 > 9999999999999999L) {
                if (l13 > 99999999999999999L) {
                    if (l13 > 999999999999999999L) {
                        n14 -= 4;
                        l13 = (l13 + 5000L) / 10000L;
                    } else {
                        n14 -= 3;
                        l13 = (l13 + 500L) / 1000L;
                    }
                } else {
                    n14 -= 2;
                    l13 = (l13 + 50L) / 100L;
                }
            } else {
                --n14;
                l13 = (l13 + 5L) / 10L;
            }
        }
        n6 = 25;
        while (l13 > Integer.MAX_VALUE) {
            long l14 = l13 / 1000L;
            n5 = (int)(l13 - l14 * 1000L);
            l13 = l14;
            this.buf[n6] = DigitOnes[n5];
            this.buf[n6 - 1] = DigitTens[n5];
            this.buf[n6 - 2] = DigitHundreds[n5];
            n6 -= 3;
        }
        int n15 = (int)l13;
        while (n15 >= 65536) {
            n4 = n15 / 1000;
            n5 = n15 - n4 * 1000;
            n15 = n4;
            this.buf[n6] = DigitOnes[n5];
            this.buf[n6 - 1] = DigitTens[n5];
            this.buf[n6 - 2] = DigitHundreds[n5];
            n6 -= 3;
        }
        while (true) {
            n4 = n15 * 52429 >>> 19;
            this.buf[n6] = (char)(n15 - n4 * 10 + 48);
            --n6;
            if (n4 == 0) break;
            n15 = n4;
        }
        n14 = 25 - n6 - n14;
        if (n14 <= 6 && n14 > 0) {
            n3 = n6;
            for (n2 = 0; n2 <= n14; ++n2) {
                this.buf[n3] = this.buf[n3 + 1];
                ++n3;
            }
            this.buf[n3] = 46;
        } else if (n14 > -4 && n14 < 0) {
            switch (n14) {
                case -1: {
                    this.buf[n6--] = 46;
                    this.buf[n6] = 48;
                    break;
                }
                case -2: {
                    this.buf[n6--] = 48;
                    this.buf[n6--] = 46;
                    this.buf[n6] = 48;
                    break;
                }
                case -3: {
                    this.buf[n6--] = 48;
                    this.buf[n6--] = 48;
                    this.buf[n6--] = 46;
                    this.buf[n6] = 48;
                }
            }
        } else {
            this.buf[n6] = this.buf[n6 + 1];
            this.buf[n6 + 1] = 46;
        }
        n3 = 26;
        n2 = 25;
        while (this.buf[n2] == '0') {
            --n2;
        }
        int n16 = n3 = this.buf[n2] == '.' ? n2 + 2 : n2 + 1;
        if (bl2) {
            this.buf[--n6] = 45;
        }
        if (n14 > 6 || n14 < -3) {
            this.buf[n3] = 69;
            ++n3;
            if (n14 < 0) {
                this.buf[n3] = 45;
                ++n3;
                n14 = -n14;
            }
            if (n14 < 10) {
                this.buf[n3] = DigitOnes[n14];
                ++n3;
            } else if (n14 < 100) {
                this.buf[n3] = DigitTens[n14];
                this.buf[n3 + 1] = DigitOnes[n14];
                n3 += 2;
            } else if (n14 < 1000) {
                this.buf[n3] = DigitHundreds[n14];
                this.buf[n3 + 1] = DigitTens[n14];
                this.buf[n3 + 2] = DigitOnes[n14];
                n3 += 3;
            }
        }
        return new String(this.buf, n6, n3 - n6);
    }

    public static double bigdecimalToDouble(BigDecimal bigDecimal) {
        double d2;
        int n2;
        if (bigDecimal.signum() == 0) {
            return 0.0;
        }
        int n3 = bigDecimal.scale();
        if (n3 >= BaseDoubleConversionConstants.DivisorsOf10Mantissa.length) {
            return BaseData.asciiToDouble(bigDecimal.toString());
        }
        boolean bl2 = bigDecimal.signum() < 0;
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        int n4 = byArray.length - 1;
        if (n4 < 8) {
            n2 = 0;
        } else {
            n2 = (n4 - 7) * 8;
            n4 = 7;
        }
        long l2 = byArray[n4] & 0xFF;
        if (n4 > 0) {
            l2 |= (long)((byArray[n4 - 1] & 0xFF) << 8);
            if (n4 > 1) {
                l2 |= (long)((byArray[n4 - 2] & 0xFF) << 16);
                if (n4 > 2) {
                    l2 |= ((long)byArray[n4 - 3] & 0xFFL) << 24;
                    if (n4 > 3) {
                        l2 |= ((long)byArray[n4 - 4] & 0xFFL) << 32;
                        if (n4 > 4) {
                            l2 |= ((long)byArray[n4 - 5] & 0xFFL) << 40;
                            if (n4 > 5) {
                                l2 |= ((long)byArray[n4 - 6] & 0xFFL) << 48;
                                if (n4 > 6) {
                                    if (bl2 && (l2 |= ((long)byArray[n4 - 7] & 0xFFL) << 56) != Long.MIN_VALUE) {
                                        l2 = -l2;
                                    }
                                } else if (bl2) {
                                    l2 = 0x100000000000000L - l2;
                                }
                            } else if (bl2) {
                                l2 = 0x1000000000000L - l2;
                            }
                        } else if (bl2) {
                            l2 = 0x10000000000L - l2;
                        }
                    } else if (bl2) {
                        l2 = 0x100000000L - l2;
                    }
                } else if (bl2) {
                    l2 = 0x1000000L - l2;
                }
            } else if (bl2) {
                l2 = 65536L - l2;
            }
        } else if (bl2) {
            l2 = 256L - l2;
        }
        if (n3 == 0) {
            if (l2 < 0L) {
                if ((l2 >> 10 & 1L) != 0L) {
                    if ((l2 = (l2 >> 11 & 0x1FFFFFFFFFFFFFL) + 1L) >= 0x20000000000000L) {
                        l2 = 0x10000000000000L;
                        ++n2;
                    }
                } else {
                    l2 = l2 >> 11 & 0x1FFFFFFFFFFFFFL;
                }
                n2 += 11;
            } else if (l2 < 0x10000000000000L || l2 >= 0x20000000000000L) {
                int n5 = 0;
                int n6 = BaseDoubleConversionConstants.HighestBit.length - 1;
                do {
                    int n7;
                    if (l2 < BaseDoubleConversionConstants.HighestBit[n7 = (n5 + n6) / 2]) {
                        n6 = n7 - 1;
                        continue;
                    }
                    n5 = n7 + 1;
                } while (n5 <= n6);
                if (n6 < 52) {
                    int n8 = 52 - n6;
                    l2 <<= n8;
                    n2 -= n8;
                } else if (n6 != 52) {
                    int n9 = n6 - 52;
                    n2 += n9;
                    if (l2 << 116 - n6 < 0L) {
                        if ((l2 = (l2 >> n9) + 1L) >= 0x20000000000000L) {
                            l2 = 0x10000000000000L;
                            ++n2;
                        }
                    } else {
                        l2 >>= n9;
                    }
                }
            }
            l2 = (n2 += 1074) >= 2046 ? 0x7FF0000000000000L : (l2 += (long)n2 << 52);
            d2 = Double.longBitsToDouble(l2);
        } else {
            d2 = BaseData.exponentAdjust(l2, -n3, n2);
            if (byArray.length > 8) {
                byte by2 = byArray[8];
                if (l2 >= 0L) {
                    int n10;
                    if ((l2 & 0xF000000000000000L) == 0L) {
                        if ((l2 & 0xC00000000000000L) == 0L) {
                            if ((l2 & 0x200000000000000L) == 0L) {
                                if ((l2 & 0x100000000000000L) == 0L) {
                                    n10 = 8;
                                    l2 = l2 << 8 | (long)(by2 & 0xFF);
                                    by2 = byArray.length > 9 ? byArray[9] : (byte)0;
                                } else {
                                    n10 = 7;
                                }
                            } else {
                                n10 = 6;
                            }
                        } else {
                            n10 = (l2 & 0x800000000000000L) == 0L ? 5 : 4;
                        }
                    } else {
                        n10 = (l2 & 0xC000000000000000L) == 0L ? ((l2 & 0x2000000000000000L) == 0L ? 3 : 2) : 1;
                    }
                    if (n10 < 8) {
                        l2 = l2 << n10 | (long)((by2 & 0xFF) >> 8 - n10);
                        by2 = (byte)(by2 << n10);
                    }
                    n2 -= n10;
                }
                if (by2 < 0 && ++l2 == 0L) {
                    l2 = Long.MIN_VALUE;
                    ++n2;
                }
                d2 = BaseData.exponentAdjust(l2, -n3, n2);
            }
        }
        if (bl2) {
            d2 = -d2;
        }
        return d2;
    }

    public String longToString(long l2) {
        int n2;
        int n3;
        boolean bl2 = false;
        if (l2 < 0L) {
            if (l2 == Long.MIN_VALUE) {
                return "-9223372036854775808";
            }
            l2 = -l2;
            bl2 = true;
        }
        if (this.buf == null) {
            this.buf = new char[32];
        }
        int n4 = 19;
        while (l2 > Integer.MAX_VALUE) {
            long l3 = l2 / 1000L;
            n3 = (int)(l2 - l3 * 1000L);
            l2 = l3;
            this.buf[n4] = DigitOnes[n3];
            this.buf[n4 - 1] = DigitTens[n3];
            this.buf[n4 - 2] = DigitHundreds[n3];
            n4 -= 3;
        }
        int n5 = (int)l2;
        while (n5 >= 65536) {
            n2 = n5 / 1000;
            n3 = n5 - n2 * 1000;
            n5 = n2;
            this.buf[n4] = DigitOnes[n3];
            this.buf[n4 - 1] = DigitTens[n3];
            this.buf[n4 - 2] = DigitHundreds[n3];
            n4 -= 3;
        }
        while (true) {
            n2 = n5 * 52429 >>> 19;
            this.buf[n4] = (char)(n5 - n2 * 10 + 48);
            --n4;
            if (n2 == 0) break;
            n5 = n2;
        }
        if (bl2) {
            this.buf[n4--] = 45;
        }
        return new String(this.buf, ++n4, 20 - n4);
    }

    public static long stringToLong(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        long l2 = 0L;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 0) {
            int n4;
            long l3;
            if (string.charAt(0) == '-') {
                bl2 = true;
                l3 = Long.MIN_VALUE;
                ++n2;
            } else {
                l3 = -9223372036854775807L;
            }
            long l4 = l3 / 10L;
            if (n2 < n3) {
                if ((n4 = string.charAt(n2++) - 48) < 0) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                l2 = -n4;
            }
            while (n2 < n3) {
                n4 = string.charAt(n2++) - 48;
                if (n4 < 0) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                if (n4 > 9) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                if (l2 < l4) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                if ((l2 *= 10L) < l3 + (long)n4) {
                    throw new NumberFormatException("For input string: \"" + string + "\"");
                }
                l2 -= (long)n4;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + string + "\"");
        }
        if (bl2) {
            if (n2 > 1) {
                return l2;
            }
            throw new NumberFormatException("For input string: \"" + string + "\"");
        }
        return -l2;
    }

    private String sqlserverUniqueidentifierToString() {
        byte[] byArray = (byte[])this.data;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[byArray[3] >> 4 & 0xF], cArray[byArray[3] & 0xF], cArray[byArray[2] >> 4 & 0xF], cArray[byArray[2] & 0xF], cArray[byArray[1] >> 4 & 0xF], cArray[byArray[1] & 0xF], cArray[byArray[0] >> 4 & 0xF], cArray[byArray[0] & 0xF], '-', cArray[byArray[5] >> 4 & 0xF], cArray[byArray[5] & 0xF], cArray[byArray[4] >> 4 & 0xF], cArray[byArray[4] & 0xF], '-', cArray[byArray[7] >> 4 & 0xF], cArray[byArray[7] & 0xF], cArray[byArray[6] >> 4 & 0xF], cArray[byArray[6] & 0xF], '-', cArray[byArray[8] >> 4 & 0xF], cArray[byArray[8] & 0xF], cArray[byArray[9] >> 4 & 0xF], cArray[byArray[9] & 0xF], '-', cArray[byArray[10] >> 4 & 0xF], cArray[byArray[10] & 0xF], cArray[byArray[11] >> 4 & 0xF], cArray[byArray[11] & 0xF], cArray[byArray[12] >> 4 & 0xF], cArray[byArray[12] & 0xF], cArray[byArray[13] >> 4 & 0xF], cArray[byArray[13] & 0xF], cArray[byArray[14] >> 4 & 0xF], cArray[byArray[14] & 0xF], cArray[byArray[15] >> 4 & 0xF], cArray[byArray[15] & 0xF]};
        return new String(cArray2);
    }

    private Time applyCalendarToSqlServerTime(Calendar calendar) {
        int[] nArray = new int[3];
        if (this.type == 107) {
            this.sybaseTimeValues(nArray);
        } else {
            this.sqlserverDateTimeValues(nArray);
        }
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1970, 0, 1, 0, 0, nArray[1]);
        return new Time(calendar.getTime().getTime());
    }

    private Date applyCalendarToSqlServerDate(Calendar calendar) {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        if (this.type == 106) {
            calendar.set(1900, 0, nArray[0]);
        } else {
            calendar.set(1900, 0, nArray[0], 0, 0, nArray[1]);
        }
        return new Date(calendar.getTime().getTime());
    }

    private BaseTimestamp applyCalendarToSqlServerTimestamp(Calendar calendar) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        this.sqlserverDateTimeValues(nArray);
        if (this.type == 107) {
            this.sybaseTimeValues(nArray2);
            calendar = (Calendar)calendar.clone();
            calendar.clear();
            calendar.set(1900, 0, nArray[0], 0, 0, nArray2[1]);
            BaseTimestamp baseTimestamp = new BaseTimestamp(calendar, nArray2[2]);
            return baseTimestamp;
        }
        calendar = (Calendar)calendar.clone();
        calendar.clear();
        calendar.set(1900, 0, nArray[0], 0, 0, nArray[1]);
        BaseTimestamp baseTimestamp = new BaseTimestamp(calendar, nArray[2]);
        return baseTimestamp;
    }

    private Date sybaseDatetoDate() {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        ((GregorianCalendar)this.connection.cal).setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        this.connection.cal.set(1900, 0, nArray[0]);
        Calendar cfr_ignored_0 = this.connection.cal;
        Calendar cfr_ignored_1 = this.connection.cal;
        Calendar cfr_ignored_2 = this.connection.cal;
        return new Date(this.connection.cal.get(1) - 1900, this.connection.cal.get(2), this.connection.cal.get(5));
    }

    private String sybaseDatetoString() {
        int[] nArray = new int[3];
        Object var2_2 = null;
        this.sqlserverDateTimeValues(nArray);
        ((GregorianCalendar)this.connection.cal).setGregorianChange(new java.util.Date(Long.MIN_VALUE));
        this.connection.cal.set(1900, 0, nArray[0]);
        Calendar cfr_ignored_0 = this.connection.cal;
        this.datetoString(3, 4, this.connection.cal.get(1));
        Calendar cfr_ignored_1 = this.connection.cal;
        this.datetoString(6, 2, this.connection.cal.get(2) + 1);
        Calendar cfr_ignored_2 = this.connection.cal;
        this.datetoString(9, 2, this.connection.cal.get(5));
        return new String(this.connection.buff);
    }

    void datetoString(int n2, int n3, int n4) {
        while (n3 > 0) {
            this.connection.buff[n2--] = (char)(48 + n4 % 10);
            n4 /= 10;
            --n3;
        }
        this.connection.buff[4] = 45;
        this.connection.buff[7] = 45;
    }

    private BaseTimestamp sybaseTimeToTimeStamp() {
        int[] nArray = new int[3];
        this.sybaseTimeValues(nArray);
        return new BaseTimestamp(1970, 0, 1, 0, 0, nArray[1], nArray[2], null);
    }

    private void sybaseTimeValues(int[] nArray) {
        byte[] byArray = (byte[])this.data;
        int n2 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | byArray[0] << 24;
        int n3 = n2 / 300;
        int n4 = n2 - n3 * 300;
        int n5 = n4 * 10 / 3 * 1000000;
        nArray[1] = n3;
        nArray[2] = n5;
    }

    private BaseTimestamp sqlserverDateTimeToTimestamp() {
        int[] nArray = new int[3];
        this.sqlserverDateTimeValues(nArray);
        return new BaseTimestamp(1900, 0, nArray[0], 0, 0, nArray[1], nArray[2], null);
    }

    private void sqlserverDateTimeValues(int[] nArray) {
        int n2;
        int n3;
        byte[] byArray = (byte[])this.data;
        int n4 = 0;
        if (this.type == 102 || this.type == 104) {
            int n5;
            if (this.type == 102) {
                n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
                n5 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
            } else {
                n3 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | byArray[0] << 24;
                n5 = byArray[7] & 0xFF | (byArray[6] & 0xFF) << 8 | (byArray[5] & 0xFF) << 16 | byArray[4] << 24;
            }
            n2 = n5 / 300;
            int n6 = n5 - n2 * 300;
            n4 = this.type == 102 ? (n6 * 10 + 1) / 3 * 1000000 : n6 * 10 / 3 * 1000000;
            nArray[2] = n4;
        } else {
            if (this.type == 103) {
                n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                n2 = (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) * 60;
            } else {
                n3 = byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8;
                n2 = (byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8) * 60;
            }
            nArray[2] = 0;
        }
        if (this.type == 106) {
            n3 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | byArray[0] << 24;
            nArray[1] = 0;
        }
        nArray[0] = ++n3;
        nArray[1] = n2;
    }

    private BaseTimestamp oracleDateToTimestamp(Calendar calendar) {
        byte[] byArray = (byte[])this.data;
        int n2 = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n3 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n4 = (n2 - 100) * 100 + (n3 - 100);
        return new BaseTimestamp(n4, byArray[2] - 1, byArray[3], byArray[4] - 1, byArray[5] - 1, byArray[6] - 1, 0, calendar);
    }

    private Date oracleDateToDate() {
        byte[] byArray = (byte[])this.data;
        int n2 = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n3 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n4 = (n2 - 100) * 100 + (n3 - 100);
        return new Date(n4 - 1900, byArray[2] - 1, byArray[3]);
    }

    private BaseTimestamp oracleTimestampToTimestamp(Calendar calendar) {
        byte[] byArray = (byte[])this.data;
        int n2 = this.nativeDataLen;
        int n3 = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n4 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n5 = (n3 - 100) * 100 + (n4 - 100);
        int n6 = 0;
        if (n2 > 7) {
            n6 = ((byArray[7] >= 0 ? byArray[7] : 256 + byArray[7]) << 24) + ((byArray[8] >= 0 ? byArray[8] : 256 + byArray[8]) << 16) + ((byArray[9] >= 0 ? byArray[9] : 256 + byArray[9]) << 8) + (byArray[10] >= 0 ? byArray[10] : 256 + byArray[10]);
        }
        return new BaseTimestamp(n5, byArray[2] - 1, byArray[3], byArray[4] - 1, byArray[5] - 1, byArray[6] - 1, n6, calendar);
    }

    static int insertDateTimeComponent(char[] cArray, int n2, int n3, int n4) {
        for (int i2 = 1; i2 <= n4; ++i2) {
            int n5 = (int)Math.pow(10.0, n4 - i2);
            int n6 = n3 / n5;
            cArray[n2 + i2 - 1] = (char)(48 + n6);
            n3 -= n6 * n5;
        }
        return n4;
    }

    private BaseTimestamp oracleTimestampWithLocalTimeZoneToTimestamp() {
        boolean bl2 = false;
        byte[] byArray = (byte[])this.data;
        int n2 = this.nativeDataLen;
        int n3 = byArray[0] >= 0 ? byArray[0] : 256 + byArray[0];
        int n4 = byArray[1] >= 0 ? byArray[1] : 256 + byArray[1];
        int n5 = (n3 - 100) * 100 + (n4 - 100);
        byte by2 = byArray[2];
        byte by3 = byArray[3];
        int n6 = byArray[4] - 1;
        int n7 = byArray[5] - 1;
        int n8 = byArray[6] - 1;
        int n9 = 0;
        if (n2 > 7) {
            n9 = ((byArray[7] >= 0 ? byArray[7] : 256 + byArray[7]) << 24) + ((byArray[8] >= 0 ? byArray[8] : 256 + byArray[8]) << 16) + ((byArray[9] >= 0 ? byArray[9] : 256 + byArray[9]) << 8) + (byArray[10] >= 0 ? byArray[10] : 256 + byArray[10]);
        }
        if (this.s_calendar == null) {
            this.s_calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        this.s_calendar.clear();
        if (n5 < 0) {
            this.s_calendar.set(0, 0);
            this.s_calendar.set(-n5, by2 - 1, by3, n6, n7, n8);
        } else {
            this.s_calendar.set(n5, by2 - 1, by3, n6, n7, n8);
        }
        if (bl2) {
            System.out.println("Before");
            System.out.println(this.s_calendar.getTime().toString());
            System.out.println("Calendar.getYear=" + this.s_calendar.get(1));
            System.out.println("Calendar.getMonth=" + this.s_calendar.get(2));
            System.out.println("Calendar.getDay=" + this.s_calendar.get(5));
            System.out.println("Calendar.getHour=" + this.s_calendar.get(11));
            System.out.println("Calendar.getMinute=" + this.s_calendar.get(12));
            System.out.println("Calendar.getSecond=" + this.s_calendar.get(13));
            System.out.println("Applying TZ adjustment: tzHours=" + this.oracleLTZHours + ",tzMinutes=" + this.oracleLTZMinutes);
        }
        this.s_calendar.add(10, this.oracleLTZHours);
        this.s_calendar.add(12, this.oracleLTZMinutes);
        if (bl2) {
            System.out.println("After");
            System.out.println(this.s_calendar.getTime().toString());
            System.out.println("Calendar.getYear=" + this.s_calendar.get(1));
            System.out.println("Calendar.getMonth=" + this.s_calendar.get(2));
            System.out.println("Calendar.getDay=" + this.s_calendar.get(5));
            System.out.println("Calendar.getHour=" + this.s_calendar.get(11));
            System.out.println("Calendar.getMinute=" + this.s_calendar.get(12));
            System.out.println("Calendar.getSecond=" + this.s_calendar.get(13));
        }
        return new BaseTimestamp(this.s_calendar.get(1), this.s_calendar.get(2), this.s_calendar.get(5), this.s_calendar.get(11), this.s_calendar.get(12), this.s_calendar.get(13), n9, null);
    }

    private Object oracleTimestampWithTimeZoneToTimestamp(Calendar calendar, boolean bl2) {
        byte[] byArray = (byte[])this.data;
        int n2 = 0;
        int n3 = byArray[0 + n2] >= 0 ? byArray[0 + n2] : 256 + byArray[0 + n2];
        int n4 = byArray[1 + n2] >= 0 ? byArray[1 + n2] : 256 + byArray[1 + n2];
        int n5 = (n3 - 100) * 100 + (n4 - 100);
        byte by2 = byArray[2 + n2];
        byte by3 = byArray[3 + n2];
        int n6 = byArray[4 + n2] - 1;
        int n7 = byArray[5 + n2] - 1;
        int n8 = byArray[6 + n2] - 1;
        if (this.s_calendar == null) {
            this.s_calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        }
        this.s_calendar.clear();
        if (n5 < 0) {
            this.s_calendar.set(0, 0);
            this.s_calendar.set(-n5, by2 - 1, by3, n6, n7, n8);
        } else {
            this.s_calendar.set(n5, by2 - 1, by3, n6, n7, n8);
        }
        int n9 = byArray[11 + n2] - 20;
        int n10 = byArray[12 + n2] - 60;
        this.s_calendar.add(10, n9);
        this.s_calendar.add(12, n10);
        int n11 = 32;
        if (n9 < 0) {
            n11 = 45;
            n9 = Math.abs(n9);
        } else if (n9 > 0) {
            n11 = 43;
        }
        int n12 = ((byArray[7 + n2] >= 0 ? byArray[7 + n2] : 256 + byArray[7 + n2]) << 24) + ((byArray[8 + n2] >= 0 ? byArray[8 + n2] : 256 + byArray[8 + n2]) << 16) + ((byArray[9 + n2] >= 0 ? byArray[9 + n2] : 256 + byArray[9 + n2]) << 8) + (byArray[10 + n2] >= 0 ? byArray[10 + n2] : 256 + byArray[10 + n2]);
        if (bl2) {
            return new BaseTimestamp(this.s_calendar.get(1), this.s_calendar.get(2), this.s_calendar.get(5), this.s_calendar.get(11), this.s_calendar.get(12), this.s_calendar.get(13), n12, calendar);
        }
        int n13 = scalingFactors[this.oracleTZScale];
        if (n12 != 0) {
            n12 /= n13;
        }
        char[] cArray = new char[27 + this.oracleTZScale + (n5 < 0 ? 1 : 0)];
        int n14 = 0;
        if (n5 < 0) {
            cArray[n14++] = 45;
        }
        n14 += BaseData.insertDateTimeComponent(cArray, n14, this.s_calendar.get(1), 4);
        cArray[n14++] = 45;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, this.s_calendar.get(2) + 1, 2);
        cArray[n14++] = 45;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, this.s_calendar.get(5), 2);
        cArray[n14++] = 32;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, this.s_calendar.get(11), 2);
        cArray[n14++] = 58;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, this.s_calendar.get(12), 2);
        cArray[n14++] = 58;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, this.s_calendar.get(13), 2);
        cArray[n14++] = 46;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, n12, this.oracleTZScale);
        cArray[n14++] = 32;
        cArray[n14++] = n11;
        n14 += BaseData.insertDateTimeComponent(cArray, n14, n9, 2);
        cArray[n14++] = 58;
        BaseData.insertDateTimeComponent(cArray, n14, Math.abs(n10), 2);
        return new String(cArray);
    }
}

