/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.fpe;

import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.engines.AESEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.fpe.FPEEngine;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.fpe.SP80038G;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.FPEParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Properties;

public class FPEFF3_1Engine
extends FPEEngine {
    public FPEFF3_1Engine() {
        this(new AESEngine());
    }

    public FPEFF3_1Engine(BlockCipher blockCipher) {
        super(blockCipher);
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("base cipher needs to be 128 bits");
        }
        if (Properties.isOverrideSet("org.bouncycastle.fpe.disable")) {
            throw new UnsupportedOperationException("FPE disabled");
        }
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forEncryption = bl2;
        this.fpeParameters = (FPEParameters)cipherParameters;
        this.baseCipher.init(!this.fpeParameters.isUsingInverseFunction(), new KeyParameter(Arrays.reverse(this.fpeParameters.getKey().getKey())));
        if (this.fpeParameters.getTweak().length != 7) {
            throw new IllegalArgumentException("tweak should be 56 bits");
        }
    }

    @Override
    public String getAlgorithmName() {
        return "FF3-1";
    }

    @Override
    protected int encryptBlock(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = this.fpeParameters.getRadix() > 256 ? FPEFF3_1Engine.toByteArray(SP80038G.encryptFF3_1w(this.baseCipher, this.fpeParameters.getRadix(), this.fpeParameters.getTweak(), FPEFF3_1Engine.toShortArray(byArray), n2, n3 / 2)) : SP80038G.encryptFF3_1(this.baseCipher, this.fpeParameters.getRadix(), this.fpeParameters.getTweak(), byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, n3);
        return n3;
    }

    @Override
    protected int decryptBlock(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = this.fpeParameters.getRadix() > 256 ? FPEFF3_1Engine.toByteArray(SP80038G.decryptFF3_1w(this.baseCipher, this.fpeParameters.getRadix(), this.fpeParameters.getTweak(), FPEFF3_1Engine.toShortArray(byArray), n2, n3 / 2)) : SP80038G.decryptFF3_1(this.baseCipher, this.fpeParameters.getRadix(), this.fpeParameters.getTweak(), byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, n3);
        return n3;
    }
}

