/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DHUPrivateParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DHUPublicParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.BigIntegers;

public class DHUnifiedAgreement {
    private DHUPrivateParameters privParams;

    public void init(CipherParameters cipherParameters) {
        this.privParams = (DHUPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        DHUPublicParameters dHUPublicParameters = (DHUPublicParameters)cipherParameters;
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(this.privParams.getStaticPrivateKey());
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHUPublicParameters.getStaticPublicKey());
        dHBasicAgreement2.init(this.privParams.getEphemeralPrivateKey());
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHUPublicParameters.getEphemeralPublicKey());
        int n2 = this.getFieldSize();
        byte[] byArray = new byte[n2 * 2];
        BigIntegers.asUnsignedByteArray(bigInteger2, byArray, 0, n2);
        BigIntegers.asUnsignedByteArray(bigInteger, byArray, n2, n2);
        return byArray;
    }
}

