/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1;

import java.io.IOException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DLSequence;

public class DLTaggedObject
extends ASN1TaggedObject {
    public DLTaggedObject(int n2, ASN1Encodable aSN1Encodable) {
        super(true, n2, aSN1Encodable);
    }

    public DLTaggedObject(int n2, int n3, ASN1Encodable aSN1Encodable) {
        super(true, n2, n3, aSN1Encodable);
    }

    public DLTaggedObject(boolean bl2, int n2, ASN1Encodable aSN1Encodable) {
        super(bl2, n2, aSN1Encodable);
    }

    public DLTaggedObject(boolean bl2, int n2, int n3, ASN1Encodable aSN1Encodable) {
        super(bl2, n2, n3, aSN1Encodable);
    }

    DLTaggedObject(int n2, int n3, int n4, ASN1Encodable aSN1Encodable) {
        super(n2, n3, n4, aSN1Encodable);
    }

    @Override
    boolean encodeConstructed() {
        return this.isExplicit() || this.obj.toASN1Primitive().toDLObject().encodeConstructed();
    }

    @Override
    int encodedLength(boolean bl2) throws IOException {
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDLObject();
        boolean bl3 = this.isExplicit();
        int n2 = aSN1Primitive.encodedLength(bl3);
        if (bl3) {
            n2 += ASN1OutputStream.getLengthOfDL(n2);
        }
        return n2 += bl2 ? ASN1OutputStream.getLengthOfIdentifier(this.tagNo) : 0;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDLObject();
        boolean bl3 = this.isExplicit();
        if (bl2) {
            int n2 = this.tagClass;
            if (bl3 || aSN1Primitive.encodeConstructed()) {
                n2 |= 0x20;
            }
            aSN1OutputStream.writeIdentifier(true, n2, this.tagNo);
        }
        if (bl3) {
            aSN1OutputStream.writeDL(aSN1Primitive.encodedLength(true));
        }
        aSN1Primitive.encode(aSN1OutputStream.getDLSubStream(), bl3);
    }

    @Override
    String getASN1Encoding() {
        return "DL";
    }

    @Override
    ASN1Sequence rebuildConstructed(ASN1Primitive aSN1Primitive) {
        return new DLSequence(aSN1Primitive);
    }

    @Override
    ASN1TaggedObject replaceTag(int n2, int n3) {
        return new DLTaggedObject(this.explicitness, n2, n3, this.obj);
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }
}

