/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.module;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.Settings;
import coldfusion.monitor.Utils;
import coldfusion.monitor.active.ActiveRequestMonitor;
import coldfusion.monitor.beans.Cluster;
import coldfusion.monitor.beans.ESDetails;
import coldfusion.monitor.beans.InstanceHeartbeat;
import coldfusion.monitor.beans.NonRequestData;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.monitor.datastore.MonitoringDatastoreClient;
import coldfusion.monitor.datastore.QueryBuilder;
import coldfusion.monitor.discovery.CFMonitoringMulticastService;
import coldfusion.monitor.es.ElasticSearchClient;
import coldfusion.monitor.event.AbstractRequestMonitorEventHandler;
import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.module.MonitoringServiceUtilsImpl;
import coldfusion.monitor.scheduler.GCListener;
import coldfusion.monitor.scheduler.OperatingSystemMXBean;
import coldfusion.monitor.scheduler.TaskScheduler;
import coldfusion.monitor.sql.QueryMonitor;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.monitor.util.MonitoringServiceUtils;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Struct;
import coldfusion.server.ConfigMap;
import coldfusion.server.InMemoryMonitoringService;
import coldfusion.server.MonitoringService;
import coldfusion.server.SchedulerService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.util.PasswordUtils;
import coldfusion.util.SoftCache;
import coldfusion.vfs.VFSUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.Vector;
import org.apache.jasper.JasperException;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.xml.sax.InputSource;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSProcess;

public class MonitoringServiceImpl
extends ServiceBase
implements MonitoringService,
Observer {
    private static final Boolean FORCE_RESET_UUID = Boolean.valueOf(System.getProperty("coldfusion.monitoring.id.reset", "false"));
    private File configFile;
    private ConfigMap generalSettings;
    private Date serverStartedAt = new Date();
    Runnable heartbeatTask = null;
    private SchedulerService ss = ServiceFactory.getSchedulerService();
    private Map<Runnable, RunnableWrapper> scheduledTasks = new HashMap<Runnable, RunnableWrapper>();
    private String seed;
    private boolean heartbeatStarted;
    private Logger logger = CFLogs.MONITOR_LOG;
    private boolean isStandaloneCF = true;
    private boolean isPartOfCluster = false;
    private static volatile int currentCount = 0;
    private CFMonitoringMulticastService cfMonitoringMulticastService;
    protected TreeNode treeNode = null;
    private String instancesXmlFilePath = null;
    private String CONFIG_DIR = "config";
    private String INSTANCES_XML_FILE = "instances.xml";
    private static final long MEBI = 0x100000L;
    private Integer cfMonitoredPort;
    private long[] oldTicks;

    public boolean isPartOfCluster() {
        return this.isPartOfCluster;
    }

    public void setPartOfCluster(boolean isPartOfCluster) {
        this.isPartOfCluster = isPartOfCluster;
    }

    public boolean isStandaloneCF() {
        return this.isStandaloneCF;
    }

    public void setStandaloneCF(boolean isStandaloneCF) {
        this.isStandaloneCF = isStandaloneCF;
    }

    public MonitoringServiceImpl(File configFile) {
        this.configFile = configFile;
        this.setEnableWatch(true);
        this.setWatchFile(configFile);
        AbstractRequestMonitorEventHandler.setMonitoringService((MonitoringService)this);
    }

    public void start() throws ServiceException {
        InMemoryMonitoringService inMemoryMs;
        super.start();
        if (this.isFirstLoad()) {
            PasswordUtils.getInstance().addObserver((Observer)this);
        }
        if ((inMemoryMs = ServiceFactory.getInMemoryMonitoringService()) != null && inMemoryMs.isMonitoringEnabled()) {
            this.logger.info((Object)"Since the Performance Monitoring Toolset service is starting, the In-Memory Monitoring service is stopped.");
            inMemoryMs.stop();
        }
    }

    public int getMonitoredPort() {
        if (this.cfMonitoredPort == null) {
            Vector settings;
            Object settingsInfo;
            this.cfMonitoredPort = (Integer)this.generalSettings.get((Object)"cfport");
            if (this.cfMonitoredPort == null && (settingsInfo = (settings = (Vector)this.deserialize(this.configFile)).get(0)) != null && settingsInfo instanceof ConfigMap) {
                this.generalSettings = (ConfigMap)settingsInfo;
                this.cfMonitoredPort = Settings.toIntValue((Map)this.generalSettings, (String)"cfport", (int)8500);
            }
        }
        return this.cfMonitoredPort;
    }

    public Map getHeartBeat() {
        Struct quickSnapShot = new Struct();
        quickSnapShot.put("started_at", new Long(this.serverStartedAt.getTime()));
        quickSnapShot.put("time_stamp", new Long(new Date().getTime()));
        quickSnapShot.put("instance_id", Configuration.INSTANCE.getInstanceId());
        quickSnapShot.put("cluster_id", Configuration.INSTANCE.getClusterId());
        quickSnapShot.put("group_id", Configuration.INSTANCE.getGroupId());
        quickSnapShot.put("host", Configuration.INSTANCE.getServerHostName());
        quickSnapShot.put("name", Configuration.INSTANCE.getInstanceName());
        quickSnapShot.put("j2ee", !this.isStandaloneCF);
        quickSnapShot.put("monitoring_enabled", Configuration.INSTANCE.isMonitoringEnabled());
        quickSnapShot.put("port", Configuration.INSTANCE.isMonitoringEnabled() ? this.cfMonitoredPort : Configuration.INSTANCE.getInstancePort());
        quickSnapShot.put("traking_enabled", ElasticSearchClient.INSTANCE.isInitialized());
        quickSnapShot.put("display_name", Configuration.INSTANCE.getDisplayName());
        quickSnapShot.put("es_host", ElasticSearchClient.INSTANCE.getElasticSearchHost());
        quickSnapShot.put("es_port", ElasticSearchClient.INSTANCE.getElasticSearchPort());
        quickSnapShot.put("version", new Double("1.0"));
        quickSnapShot.put("uuid", Configuration.INSTANCE.getUuid());
        quickSnapShot.put("https_enabled", Configuration.INSTANCE.isHttpsEnabled());
        this.setGroupAndCluster((Map)quickSnapShot);
        if (System.getProperty("java.vendor").toLowerCase().contains("ibm")) {
            quickSnapShot.put("jdk", "ibm");
        } else {
            quickSnapShot.put("jdk", "oracle");
        }
        return quickSnapShot;
    }

    private void setGroupAndCluster(Map quickSnapShot) {
        Cluster cluster = Configuration.INSTANCE.getClusterObj();
        quickSnapShot.put("group_name", Configuration.INSTANCE.getGroupName());
        if (cluster != null) {
            quickSnapShot.put("cluster_name", cluster.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws ServiceException {
        if (!this.configFile.exists()) {
            this.logger.error((Object)"Monitoring Service initialization failed as configuration file does not exist");
            return;
        }
        Vector settings = (Vector)this.deserialize(this.configFile);
        Vector localsettings = (Vector)this.deserialize(this.configFile, true);
        Object settingsInfo = settings.get(0);
        Object l_settingsInfo = localsettings.get(0);
        if (settingsInfo != null && settingsInfo instanceof ConfigMap) {
            this.generalSettings = (ConfigMap)settingsInfo;
            String uuidValue = Settings.toStringValue((Map)this.generalSettings, (String)"uuid", (String)"");
            boolean uuidReset = Settings.toBooleanValue((Map)this.generalSettings, (String)"uuidreset", (boolean)true);
            this.cfMonitoredPort = Settings.toIntValue((Map)this.generalSettings, (String)"cfport", (int)8500);
            if (l_settingsInfo != null && l_settingsInfo instanceof ConfigMap) {
                uuidValue = Settings.toStringValue((Map)((ConfigMap)l_settingsInfo), (String)"uuid", (String)"");
            }
            if (FORCE_RESET_UUID.booleanValue() || uuidReset) {
                uuidValue = null;
                uuidReset = false;
            }
            if (uuidValue == null || uuidValue.isEmpty()) {
                uuidValue = UUID.randomUUID().toString();
                this.setUUIDSetting(uuidValue, uuidReset);
            }
            if (this.isStandaloneCF) {
                String instanceSecretKey = this.getSecretKeyFromInstancesXML();
                if (instanceSecretKey == null || instanceSecretKey.equals("")) {
                    instanceSecretKey = UUID.randomUUID().toString();
                    this.writeSecretKeyInInstancesXML(instanceSecretKey);
                }
                Configuration.INSTANCE.setConnectorSecret(instanceSecretKey);
            }
            Configuration.INSTANCE.setUuid(uuidValue);
            Configuration.INSTANCE.setHostName(Settings.toStringValue((Map)this.generalSettings, (String)"hostname", (String)""));
            Configuration.INSTANCE.setDisplayName(Settings.toStringValue((Map)this.generalSettings, (String)"displayname", (String)""));
            Configuration.INSTANCE.setPMTDashboardUrl(Settings.toStringValue((Map)this.generalSettings, (String)"pmtdashboardurl", (String)""));
            if (!this.isStandaloneCF) {
                Configuration.INSTANCE.setInstancePort(String.valueOf(Settings.toIntValue((Map)this.generalSettings, (String)"j2eeport", (int)0)));
                Configuration.INSTANCE.setInstanceName(Settings.toStringValue((Map)this.generalSettings, (String)"j2eecontext", (String)""));
                Configuration.INSTANCE.setDisplayName(Settings.toStringValue((Map)this.generalSettings, (String)"displayname", (String)Configuration.INSTANCE.getInstanceName()));
                Configuration.INSTANCE.setHttpsEnabled(Settings.toBooleanValue((Map)this.generalSettings, (String)"j2eehttpsenabled", (boolean)Configuration.INSTANCE.isHttpsEnabled()));
            }
            this.getCFInfo();
            ElasticSearchClient.INSTANCE.initializeDBParameters(this.generalSettings);
            ElasticSearchClient.INSTANCE.initialize(this.generalSettings);
            boolean trackingEnabled = this.isTrackingEnabled(this.isStandaloneCF);
            boolean multicastenabled = Settings.toBooleanValue((Map)this.generalSettings, (String)"multicastenabled", (boolean)true);
            if (multicastenabled) {
                ElasticSearchClient.INSTANCE.setIntialized(trackingEnabled);
                int multiCastPort = Settings.toIntValue((Map)this.generalSettings, (String)"multicastport", (int)46864);
                String multiCastGroupIp = Settings.toStringValue((Map)this.generalSettings, (String)"multicastgroupip", (String)"229.0.0.3");
                this.cfMonitoringMulticastService = new CFMonitoringMulticastService(multiCastGroupIp, multiCastPort, (MonitoringService)this);
                this.cfMonitoringMulticastService.startMulticastService();
            }
            if (!trackingEnabled) {
                return;
            }
        }
        if (!ElasticSearchClient.INSTANCE.isInitialized()) {
            return;
        }
        try {
            this.initialize();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Monitoring Service initialization failed: ", (Throwable)ex);
        }
        finally {
            if (!Configuration.INSTANCE.isSettingsLoaded()) {
                RequestMonitorData.teardown();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTrackingEnabled(boolean isStandalone) {
        if (!ElasticSearchClient.INSTANCE.isInitialized()) return false;
        String response = null;
        InstanceHeartbeat instanceHeartbeat = null;
        if (isStandalone) {
            List<InstanceHeartbeat> instanceHeartbeatList = this.getMatchingHeartbeat();
            if (instanceHeartbeatList != null && instanceHeartbeatList.size() > 1) {
                this.logger.info((Object)"Search template not updated. Monitoring Service was not initialized. Please update and restart PMT and then restart the Coldfusion server");
                return false;
            }
            if (instanceHeartbeatList == null || instanceHeartbeatList.isEmpty()) return false;
            instanceHeartbeat = instanceHeartbeatList.get(0);
            return instanceHeartbeat == null || instanceHeartbeat.isTrakingEnabled();
        } else {
            response = ElasticSearchClient.INSTANCE.getDocument("/instance-heartbeat/" + Configuration.INSTANCE.getInstanceId());
            instanceHeartbeat = (InstanceHeartbeat)JSONConverter.INSTANCE.getNode(response, InstanceHeartbeat.class);
        }
        return instanceHeartbeat == null || instanceHeartbeat.isTrakingEnabled();
    }

    private List<InstanceHeartbeat> getMatchingHeartbeat() {
        String query = QueryBuilder.getQuery((String)"generic-list", Arrays.asList("instance_host", "instance_port"), Arrays.asList(Configuration.INSTANCE.getServerHostName(), Configuration.INSTANCE.getInstancePort()));
        String response = QueryBuilder._makeQuery((String)"instance-heartbeat", (String)query, null);
        if (response != null) {
            List heartbeatList = JSONConverter.INSTANCE.toInstanceHeartBeatList(response, Arrays.asList("hits", "hits"), "_source");
            return heartbeatList;
        }
        return null;
    }

    private String getSecretKeyFromInstancesXML() {
        Class<?> cls = null;
        Method getInstanceSecretKeyMethod = null;
        String instanceDirectory = ServiceFactory.getRuntimeService().getRootDir();
        String instanceName = instanceDirectory.substring(instanceDirectory.lastIndexOf(File.separator) + 1);
        String serverDir = instanceDirectory.substring(0, instanceDirectory.lastIndexOf(File.separator));
        this.instancesXmlFilePath = serverDir + File.separator + this.CONFIG_DIR + File.separator + this.INSTANCES_XML_FILE;
        try {
            cls = Class.forName("com.adobe.coldfusion.connector.connectorinstaller.ConfigParser");
            if (cls != null) {
                Constructor<?> constructor = cls.getConstructor(String.class);
                Object o = constructor.newInstance(this.instancesXmlFilePath);
                getInstanceSecretKeyMethod = cls.getMethod("getInstanceSecretKey", String.class);
                if (getInstanceSecretKeyMethod != null) {
                    return (String)getInstanceSecretKeyMethod.invoke(o, instanceName);
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error((Object)("The class 'com.adobe.coldfusion.connector.connectorinstaller.ConfigParser' is not found. [" + e.getMessage() + "]"));
        }
        return null;
    }

    private void writeSecretKeyInInstancesXML(String instanceSecretKey) {
        Class<?> cls = null;
        Method setInstanceSecretKey = null;
        Method store = null;
        String instanceDirectory = ServiceFactory.getRuntimeService().getRootDir();
        String instanceName = instanceDirectory.substring(instanceDirectory.lastIndexOf(File.separator) + 1);
        try {
            cls = Class.forName("com.adobe.coldfusion.connector.connectorinstaller.ConfigParser");
            if (cls != null) {
                Constructor<?> constructor = cls.getConstructor(String.class);
                Object o = constructor.newInstance(this.instancesXmlFilePath);
                setInstanceSecretKey = cls.getMethod("setInstanceSecretKey", String.class, String.class);
                store = cls.getMethod("store", new Class[0]);
                if (setInstanceSecretKey != null) {
                    setInstanceSecretKey.invoke(o, instanceName, instanceSecretKey);
                }
                store.invoke(o, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error((Object)("The class 'com.adobe.coldfusion.connector.connectorinstaller.ConfigParser' is not found. [" + e.getMessage() + "]"));
        }
    }

    private TreeNode getRootNode() {
        if (this.treeNode != null) {
            return this.treeNode;
        }
        ParserUtils utils = new ParserUtils(false);
        if (this.instancesXmlFilePath != null) {
            URI uri = new File(this.instancesXmlFilePath).toURI();
            InputSource is = new InputSource(uri.toString());
            try {
                this.treeNode = utils.parseXMLDocument(uri.toString(), is);
            }
            catch (Throwable t) {
                this.logger.error((Object)("Error parsing config file: " + this.instancesXmlFilePath), t);
            }
        }
        return this.treeNode;
    }

    private void deleteConfig(String serverName) throws IOException, JasperException {
        Iterator nodes = this.getRootNode().findChildren("server");
        boolean found = false;
        TreeNode tempNode = null;
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (!node.findChild("name").getBody().equalsIgnoreCase(serverName)) continue;
            tempNode = node;
            this.getRootNode().removeNode(node);
            found = true;
            break;
        }
        if (found) {
            FileWriter writer = new FileWriter(new File(this.instancesXmlFilePath));
            writer.write(this.getRootNode().toString());
            writer.close();
        }
    }

    public void getCFInfo() {
        Configuration.INSTANCE.setHostName(Settings.toStringValue((Map)this.generalSettings, (String)"hostname", (String)""));
        if (this.isStandaloneCF) {
            Configuration.INSTANCE.persistClusterData("coldfusion.monitor.TomCatCluster");
            Configuration.INSTANCE.setDisplayName(Settings.toStringValue((Map)this.generalSettings, (String)"displayname", (String)Configuration.INSTANCE.getInstanceName()));
        } else {
            Configuration.INSTANCE.setInstancePort(String.valueOf(Settings.toIntValue((Map)this.generalSettings, (String)"j2eeport", (int)0)));
            Configuration.INSTANCE.setInstanceName(Settings.toStringValue((Map)this.generalSettings, (String)"j2eecontext", (String)""));
            Configuration.INSTANCE.setDisplayName(Settings.toStringValue((Map)this.generalSettings, (String)"displayname", (String)Configuration.INSTANCE.getInstanceName()));
            Configuration.INSTANCE.setInstanceId(Utils.getInstanceId((String)Configuration.INSTANCE.getServerHostName(), (String)Configuration.INSTANCE.getInstanceName(), (String)Configuration.INSTANCE.getInstancePort()));
        }
    }

    public boolean intializeNodeWithEs(ESDetails esDetails, int cfPort) {
        if (!this.configFile.exists()) {
            this.logger.warn((Object)"neo-monitoring file does not exists");
            return false;
        }
        this.cfMonitoredPort = cfPort;
        this.generalSettings.put((Object)"elasticsearchhost", (Object)esDetails.getElasticSearchHost());
        this.generalSettings.put((Object)"elasticsearchport", (Object)esDetails.getElsaticSearchPort());
        this.generalSettings.put((Object)"pmtdashboardurl", (Object)esDetails.getPMTDashboardUrl());
        this.generalSettings.put((Object)"elasticSearchProtocol", (Object)esDetails.getElasticSearchProtocol());
        this.generalSettings.put((Object)"elasticSearchUsername", (Object)esDetails.getUsername());
        this.generalSettings.put((Object)"elasticSearchPassword", (Object)esDetails.getEncryptedPassword());
        this.generalSettings.put((Object)"cfport", (Object)cfPort);
        try {
            this.store();
            if (this.cfMonitoringMulticastService != null) {
                this.cfMonitoringMulticastService.broadcastNodeUpMessage();
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("Exception while storing monitoring settings " + (Object)((Object)e)));
        }
        return true;
    }

    public boolean setBlankEsSetting(String host, int port) {
        if (!this.configFile.exists()) {
            this.logger.warn((Object)"neo-monitoring file does not exists");
            return false;
        }
        this.generalSettings.put((Object)"elasticsearchhost", (Object)host);
        this.generalSettings.put((Object)"elasticsearchport", (Object)port);
        this.generalSettings.put((Object)"pmtdashboardurl", (Object)"");
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.add(this.generalSettings);
        this.serialize(v, this.configFile);
        return true;
    }

    private boolean setUUIDSetting(String uuid, boolean uuidReset) {
        if (!this.configFile.exists()) {
            this.logger.warn((Object)"neo-monitoring file does not exists");
            return false;
        }
        this.generalSettings.put((Object)"uuid", (Object)uuid);
        this.generalSettings.put((Object)"uuidreset", (Object)uuidReset);
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.add(this.generalSettings);
        this.serialize(v, this.configFile, false);
        return true;
    }

    public void updateJ2eeHostPort(String hostname, int port, String j2eeContext, boolean httpsEnabled) {
        this.generalSettings.put((Object)"hostname", (Object)hostname);
        Configuration.INSTANCE.setHostName(hostname);
        this.generalSettings.put((Object)"j2eeport", (Object)port);
        Configuration.INSTANCE.setInstancePort(String.valueOf(port));
        Configuration.INSTANCE.setInstanceName(j2eeContext);
        this.generalSettings.put((Object)"j2eecontext", (Object)j2eeContext);
        this.generalSettings.put((Object)"displayname", (Object)j2eeContext);
        Configuration.INSTANCE.setDisplayName(j2eeContext);
        this.generalSettings.put((Object)"j2eehttpsenabled", (Object)httpsEnabled);
        Configuration.INSTANCE.setHttpsEnabled(httpsEnabled);
    }

    public boolean reload(String hostName, int j2eeePort, String displayName, String pmtDashBoardUrl, boolean httpsenabled) {
        Struct oldStruct = new Struct();
        oldStruct.putAll((Map)this.generalSettings);
        if (!this.configFile.exists()) {
            this.logger.warn((Object)"neo-monitoring file does not exists");
            return false;
        }
        this.generalSettings.put((Object)"hostname", (Object)hostName);
        if (displayName != null && !displayName.isEmpty()) {
            this.generalSettings.put((Object)"displayname", (Object)displayName);
        } else {
            this.generalSettings.put((Object)"displayname", (Object)hostName);
            displayName = hostName;
        }
        Configuration.INSTANCE.setDisplayName(displayName);
        if (pmtDashBoardUrl != null && !pmtDashBoardUrl.isEmpty()) {
            this.generalSettings.put((Object)"pmtdashboardurl", (Object)pmtDashBoardUrl);
            Configuration.INSTANCE.setPMTDashboardUrl(pmtDashBoardUrl);
        }
        if (!this.isStandaloneCF) {
            this.generalSettings.put((Object)"j2eeport", (Object)j2eeePort);
            this.generalSettings.put((Object)"j2eehttpsenabled", (Object)httpsenabled);
            Configuration.INSTANCE.setInstancePort(String.valueOf(j2eeePort));
            Configuration.INSTANCE.setHttpsEnabled(httpsenabled);
            String contextRoot = this.getContextRoot();
            if (contextRoot != null) {
                Configuration.INSTANCE.setInstanceName(contextRoot);
                this.generalSettings.put((Object)"j2eecontext", (Object)contextRoot);
            } else {
                if (this.cfMonitoredPort == null) {
                    this.cfMonitoredPort = this.getMonitoredPort();
                }
                Configuration.INSTANCE.setInstancePort(String.valueOf(this.cfMonitoredPort));
            }
        }
        Configuration.INSTANCE.setHostName(hostName);
        this.getCFInfo();
        if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled()) {
            TaskScheduler.INSTANCE.updateStaticMetrics();
        }
        try {
            this.saveChangesToFile("PMTSettings", this.generalSettings, oldStruct);
            boolean multicastenabled = Settings.toBooleanValue((Map)this.generalSettings, (String)"multicastenabled", (boolean)true);
            if (multicastenabled) {
                this.cfMonitoringMulticastService.broadcastNodeUpMessage();
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("Exception while storing monitoring settings " + (Object)((Object)e)));
        }
        return true;
    }

    private String getContextRoot() {
        try {
            String contextRoot;
            if (FusionContext.getCurrent() != null && (contextRoot = FusionContext.getCurrent().getRequest().getContextPath()) != null) {
                String[] splitArray = contextRoot.split("/");
                if (splitArray.length > 1) {
                    return splitArray[1];
                }
                return "";
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception while finding context root", (Throwable)ex);
        }
        return null;
    }

    private void initialize() {
        this.logger.debug((Object)"MonitoringServiceImpl: start initialize ");
        InMemoryMonitoringService inMemoryMs = ServiceFactory.getInMemoryMonitoringService();
        if (inMemoryMs != null && inMemoryMs.isMonitoringEnabled()) {
            this.logger.info((Object)"Since the Performance Monitoring Toolset service is starting, the In-Memory Monitoring service is stopped.");
            try {
                inMemoryMs.stop();
            }
            catch (ServiceException e) {
                this.logger.info((Object)"Exception while stopping In-Memory Service");
            }
        }
        Configuration.INSTANCE.updateClusterData(this.isStandaloneCF);
        if (ElasticSearchClient.INSTANCE.isInitialized()) {
            Configuration.INSTANCE.initializeSettings();
        }
        this.startMonitoringTasks();
        this.logger.debug((Object)"MonitoringServiceImpl: initialization done ");
    }

    private void startMonitoringTasks() {
        if (!Configuration.INSTANCE.isSettingsLoaded()) {
            this.logger.fatal((Object)"Monitoring Service initialization failed.");
            return;
        }
        this.loadMonitors(false);
        this.startNonRequestTasks();
        this.logger.info((Object)"Monitoring Service is up and running");
    }

    private void startNonRequestTasks() {
        this.logger.debug((Object)"Start MonitoringServiceImpl: startNonRequestTasks ");
        TaskScheduler.INSTANCE.start();
        try {
            GCListener.registerGCListener();
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Garbage Collection Listener Registration Failed. This Feature will not be available");
            this.logger.error((Throwable)ex);
        }
        this.heartbeatStarted = false;
        this.updateHeartbeat();
        this.logger.debug((Object)"End MonitoringServiceImpl: startNonRequestTasks ");
    }

    private void loadMonitors(boolean changed) {
        RequestMonitorData.setup((boolean)true).setDoMonitor(true);
        MemoryMonitor.getInstance().load(changed);
        QueryMonitor.getInstance().load(changed);
        QueryStat.setQueryMonitor((QueryMonitor)QueryMonitor.getInstance());
        SoftCache.setStatsEnabled((boolean)true);
    }

    private void saveChangesToFile(Object key, Object value, Object oldValue) throws ServiceException {
        this.logger.trace((Object)"started store method");
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.add(this.generalSettings);
        this.serialize(v, this.configFile, true, key, value, oldValue);
        this.logger.trace((Object)"finished store method");
    }

    public void store() throws ServiceException {
        this.logger.trace((Object)"started store method");
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.add(this.generalSettings);
        this.serialize(v, this.configFile);
        this.stopMonitoring();
        Configuration.INSTANCE.setEsHealthy(true);
        ElasticSearchClient.INSTANCE.initialize(this.generalSettings);
        this.initialize();
        this.logger.trace((Object)"finished store method");
    }

    public void disableMonitoring() {
        if (Configuration.INSTANCE.isSettingsLoaded()) {
            Configuration.INSTANCE.getMonitorSettings().setMonitoringEnabled(false);
        }
    }

    public void stopMonitoring() {
        if (Configuration.INSTANCE.isSettingsLoaded()) {
            this.logger.debug((Object)"stopMonitoring called in MonitoringService");
            this.cancelTask(this.heartbeatTask);
            TaskScheduler.INSTANCE.stop();
            Configuration.INSTANCE.reset();
            ElasticSearchClient.INSTANCE.closeConnection();
            SoftCache.setStatsEnabled((boolean)false);
            this.heartbeatStarted = false;
            if (this.cfMonitoringMulticastService != null) {
                this.cfMonitoringMulticastService.broadcastNodeUpMessage();
            }
            this.logger.debug((Object)"stopMonitoring finished in MonitoringService");
        }
    }

    public void stop() throws ServiceException {
        if (Configuration.INSTANCE.isSettingsLoaded() || ElasticSearchClient.INSTANCE.isInitialized()) {
            this.cancelTask(this.heartbeatTask);
            TaskScheduler.INSTANCE.stop();
            Configuration.INSTANCE.reset();
            ElasticSearchClient.INSTANCE.closeConnection();
            this.heartbeatStarted = false;
        }
        if (this.cfMonitoringMulticastService != null) {
            this.cfMonitoringMulticastService.stopMulticastService();
        }
        this.logger.info((Object)"Monitoring Service stopped.");
    }

    private void updateHeartbeat() {
        this.heartbeatTask = () -> this.indexHeartBeat();
        this.scheduleTask(this.heartbeatTask, 1000L);
    }

    private void indexHeartBeat() {
        if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled() || ElasticSearchClient.INSTANCE.isInitialized() && !this.heartbeatStarted) {
            if (Configuration.INSTANCE.getClusterId() == null && currentCount >= 30) {
                Configuration.INSTANCE.updateClusterIdForRemoteInstance(this.isStandaloneCF);
                currentCount = 0;
            } else {
                ++currentCount;
            }
            Map hBeat = this.getHeartBeat();
            Struct heartBeat = new Struct();
            heartBeat.put((Object)"doc", (Object)hBeat);
            heartBeat.put((Object)"doc_as_upsert", (Object)true);
            String heartBeatJson = JSONConverter.toJson((Object)heartBeat);
            if (!Configuration.INSTANCE.isEsHealthy() && !this.elasticSearchSchemaExists()) {
                return;
            }
            ElasticSearchClient.INSTANCE.indexDocument(heartBeatJson, "instance-heartbeat/_update/" + hBeat.get("instance_id").toString() + "?retry_on_conflict=5");
            this.heartbeatStarted = true;
            this.logger.debug((Object)("Sending ColdFusion Hearbeat to PMS " + heartBeatJson));
        }
    }

    private boolean elasticSearchSchemaExists() {
        return ElasticSearchClient.INSTANCE.indexExists("/misc_data");
    }

    public void updateHeartBeatStartedFlag(boolean flag) {
        this.heartbeatStarted = flag;
    }

    public void callGC() {
        this.logger.debug((Object)"invoking System.gc ");
        try {
            System.gc();
        }
        catch (Throwable th) {
            this.logger.error((Object)"Exception while calliing System.gc");
            this.logger.debug((Object)th.getStackTrace());
        }
    }

    public int getLoggedInUserCount() {
        return ActiveRequestMonitor.getInstance().getLoggedInUserCount();
    }

    private String getRootDirName(String rootDir) {
        int index = rootDir.lastIndexOf(File.separator);
        String fileName = rootDir.substring(index + 1);
        return fileName;
    }

    public Map getGlobalVFSMemoryStats() {
        return VFSUtils.getGlobalVFSMetaData();
    }

    public void scheduleTask(Runnable task, long interval) {
        this.logger.debug((Object)("scheduling task with interval " + interval));
        this.cancelTask(task);
        RunnableWrapper r = new RunnableWrapper(task, interval);
        this.scheduledTasks.put(task, r);
        r.schedule();
        this.logger.debug((Object)("Scheduled task with interval " + interval));
    }

    public void cancelTask(Runnable task) {
        RunnableWrapper r = this.scheduledTasks.get(task);
        if (r != null) {
            r.cancel();
            this.scheduledTasks.remove(task);
            this.logger.debug((Object)"Cancelled Monitoring Scheduled Task ");
        }
    }

    public String getMailPassword() {
        return "";
    }

    public void setCacheProperties(Map prop) {
        CacheTagHelper.setCacheProperties((Map)prop, null);
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    private void reEncryptPassword(String oldSeed) {
        if (oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        String oldPassword = this.getMailPassword();
        if (oldPassword != null && oldPassword.length() > 0) {
            try {
                String string = PasswordUtils.reEncryptWithNewSeed((String)oldPassword, (String)oldSeed, (String)this.seed);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    private void setMailPassword(String seed) {
        String password = this.getMailPassword();
        if (password != null && password.length() > 0) {
            String newPassword = PasswordUtils.encryptPassword((String)password, (String)seed);
            this.setEncryptedMailPassword(newPassword);
        }
    }

    private void setEncryptedMailPassword(String password) {
    }

    public void reEncryptPasswordForMigration(String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (!PasswordUtils.isAESS((int)majorVersion, (int)minorVersion)) {
            this.setMailPassword(this.seed);
            return;
        }
        if (oldSeed == null || oldSeed != null && oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        String oldPassword = this.getMailPassword();
        if (oldPassword != null && oldPassword.length() > 0) {
            try {
                String newPassword = PasswordUtils.reEncryptWithNewSeed((String)oldPassword, (String)oldSeed, (String)this.seed, (String)oldAlgoValue, (int)majorVersion, (int)minorVersion);
                this.setEncryptedMailPassword(newPassword);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    public boolean isMonitoringEnabled() {
        return Configuration.INSTANCE.isMonitoringEnabled();
    }

    public boolean isRejectNewRequestsEnabled() {
        return ActiveRequestMonitor.getInstance().isRejectNewRequestsEnabled();
    }

    public boolean isInstanceOfMonitoringService(Object obj) {
        return obj != null && obj instanceof MonitoringServiceImpl;
    }

    public Object getSystemInfo() {
        SystemInfo sinf = new SystemInfo();
        return sinf;
    }

    public void updateSystemInfo(Struct system, Object sisInfo) {
        if (!(sisInfo instanceof SystemInfo)) {
            sisInfo = this.getSystemInfo();
            TaskScheduler.INSTANCE.reinitialise(sisInfo);
        }
        SystemInfo sinf = (SystemInfo)sisInfo;
        CentralProcessor centralProcessor = sinf.getHardware().getProcessor();
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        GlobalMemory globalMemory = sinf.getHardware().getMemory();
        system.put((Object)"processors", (Object)centralProcessor.getPhysicalProcessorCount());
        system.put((Object)"name", (Object)processorIdentifier.getName());
        system.put((Object)"version", (Object)processorIdentifier.getFamily());
        system.put((Object)"vendor", (Object)processorIdentifier.getVendor());
        system.put((Object)"family", (Object)processorIdentifier.getFamily());
        system.put((Object)"identifier", (Object)processorIdentifier.getIdentifier());
        system.put((Object)"model", (Object)processorIdentifier.getModel());
        system.put((Object)"total_swap_space", (Object)globalMemory.getVirtualMemory().getSwapTotal());
        system.put((Object)"total_system_memory", (Object)globalMemory.getTotal());
    }

    public void updateNetworkMetrics(NonRequestData rqd, Object sinf) {
        if (!(sinf instanceof SystemInfo)) {
            sinf = this.getSystemInfo();
            TaskScheduler.INSTANCE.reinitialise(sinf);
        }
        NetworkIF[] nif = ((SystemInfo)sinf).getHardware().getNetworkIFs().toArray(new NetworkIF[0]);
        long byteRec = 0L;
        long byteSent = 0L;
        long maxSpeed = 0L;
        for (NetworkIF nf : nif) {
            byteRec += nf.getBytesRecv() / 0x100000L;
            byteSent += nf.getBytesSent() / 0x100000L;
            if (nf.getSpeed() <= maxSpeed) continue;
            maxSpeed = nf.getSpeed();
        }
        Struct nfStr = new Struct();
        nfStr.put((Object)"byte_received", (Object)byteRec);
        nfStr.put((Object)"byte_sent", (Object)byteSent);
        nfStr.put((Object)"speed", (Object)maxSpeed);
        rqd.setNetworkMetrics(nfStr);
    }

    public void updateOtherSystemMetrics(NonRequestData rqd, Object sysInfo) {
        if (sysInfo == null || !(sysInfo instanceof SystemInfo)) {
            sysInfo = this.getSystemInfo();
            TaskScheduler.INSTANCE.reinitialise(sysInfo);
        }
        SystemInfo sinf = (SystemInfo)sysInfo;
        Struct system = new Struct();
        OSProcess jvmProcess = sinf.getOperatingSystem().getProcess(sinf.getOperatingSystem().getProcessId());
        if (jvmProcess != null) {
            system.put((Object)"jvm_cpu_load", (Object)this.getJVMCPUUsage(jvmProcess));
        }
        system.put((Object)"system_cpu_load", (Object)this.getSystemCPUUsage(sinf));
        system.put((Object)"free_system_memory", (Object)(sinf.getHardware().getMemory().getTotal() - sinf.getHardware().getMemory().getAvailable()));
        if (jvmProcess != null) {
            system.put((Object)"committed_virtual_memory", (Object)jvmProcess.getVirtualSize());
            system.put((Object)"disk_read", (Object)jvmProcess.getBytesRead());
            system.put((Object)"disk_write", (Object)jvmProcess.getBytesWritten());
        }
        system.put((Object)"free_swap_space", (Object)(sinf.getHardware().getMemory().getVirtualMemory().getSwapTotal() - sinf.getHardware().getMemory().getVirtualMemory().getSwapUsed()));
        rqd.setSystemData(system);
    }

    private double getJVMCPUUsage(OSProcess jvmProcess) {
        double jvmCpu = OperatingSystemMXBean.INSTANCE.getJVMCPUUsage();
        if (jvmCpu != -1.0) {
            return jvmCpu * 100000.0;
        }
        if (jvmProcess != null) {
            jvmCpu = 100.0 * (double)(jvmProcess.getUserTime() + jvmProcess.getKernelTime()) / (double)jvmProcess.getUpTime();
        } else {
            this.logger.error((Object)"failed to collect jvm cpu usage");
        }
        return jvmCpu < 0.0 ? 0.0 : jvmCpu * 1000.0;
    }

    private double getSystemCPUUsage(SystemInfo sinf) {
        double systemCpu = OperatingSystemMXBean.INSTANCE.getSystemCPUUsage();
        if (systemCpu != -1.0) {
            return systemCpu * 100000.0;
        }
        systemCpu = MonitoringServiceUtilsImpl.getInstance().getSystemCPUUsage(this.oldTicks);
        this.oldTicks = MonitoringServiceUtilsImpl.getInstance().getCurrentCPULoadTicks();
        return systemCpu < 0.0 ? 0.0 : systemCpu * 100000.0;
    }

    public MonitoringDatastoreClient getDatastoreClient() {
        return ElasticSearchClient.INSTANCE;
    }

    public void updateMemoryStat(NonRequestData rqd, Object sinf) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getBasicMonitoring().isMemoryPoolMetrics()) {
                return;
            }
            this.logger.debug((Object)"Started collecting Memory metrics");
            MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage hpUsg = memBean.getHeapMemoryUsage();
            MemoryUsage nonHpUsg = memBean.getNonHeapMemoryUsage();
            Struct memoryUsed = new Struct();
            memoryUsed.put((Object)"heap_used", (Object)hpUsg.getUsed());
            memoryUsed.put((Object)"nonheap_used", (Object)nonHpUsg.getUsed());
            long codecache = 0L;
            List<MemoryPoolMXBean> memPoolBns = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memPoolBn : memPoolBns) {
                if (TaskScheduler.INSTANCE.getJvm().equals("ibm")) {
                    this.updateMemoryPoolsForIBMJDK(memPoolBn, memoryUsed);
                    continue;
                }
                codecache = this.updateMemoryPoolsForOracleJDK(memoryUsed, codecache, memPoolBn);
            }
            if (TaskScheduler.INSTANCE.getJvm().equals("oracle")) {
                memoryUsed.put((Object)"codecache_used", (Object)codecache);
            }
            memoryUsed.put((Object)"process_memory_used", (Object)this.getProcessMemoryUsed(rqd, sinf));
            rqd.setMemoryMetrics(memoryUsed);
            this.logger.debug((Object)"Finished collecting Memory metrics");
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception occurred while collecting JVM Memory Metrics", (Throwable)ex);
        }
    }

    private void updateMemoryPoolsForIBMJDK(MemoryPoolMXBean memPoolBn, Struct memoryUsed) {
        if (TaskScheduler.INSTANCE.getJvm().equals("ibm")) {
            String poolName = memPoolBn.getName().trim().replaceAll("\\s", "").toLowerCase();
            if (poolName.equals("classstorage")) {
                memoryUsed.put((Object)"metaspace_used", (Object)memPoolBn.getUsage().getUsed());
            } else if (poolName.equals("jitdatacache")) {
                memoryUsed.put((Object)"codecache_used", (Object)memPoolBn.getUsage().getUsed());
            } else if (poolName.equals("miscellaneousnon-heapstorage")) {
                memoryUsed.put((Object)"psoldgen_used", (Object)memPoolBn.getUsage().getUsed());
            }
        }
    }

    private long updateMemoryPoolsForOracleJDK(Struct memoryUsed, long codecache, MemoryPoolMXBean memPoolBn) {
        if (memPoolBn.getName().trim().replaceAll("\\s", "").toLowerCase().startsWith("codeheap")) {
            codecache += memPoolBn.getUsage().getUsed();
        } else {
            memoryUsed.put((Object)(memPoolBn.getName().trim().replaceAll("\\s", "").toLowerCase() + "_used"), (Object)memPoolBn.getUsage().getUsed());
        }
        return codecache;
    }

    private long getProcessMemoryUsed(NonRequestData rqd, Object sinf) {
        int pid = 0;
        long processMemory = 0L;
        if (!(sinf instanceof SystemInfo)) {
            sinf = this.getSystemInfo();
            TaskScheduler.INSTANCE.reinitialise(sinf);
        }
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        try {
            pid = Integer.parseInt(jvmName.substring(0, index));
            OSProcess osProcess = ((SystemInfo)sinf).getOperatingSystem().getProcess(pid);
            if (osProcess != null) {
                processMemory = osProcess.getResidentSetSize();
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"Exception occurred while getting process id", (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)"Exception occurred while getting process memory", (Throwable)e1);
        }
        return processMemory;
    }

    public MonitoringServiceUtils getMonitoringServiceUtils() {
        return MonitoringServiceUtilsImpl.getInstance();
    }

    private class RunnableWrapper
    implements Runnable {
        private Runnable runnable;
        private long interval;
        private boolean cancelled = false;

        public RunnableWrapper(Runnable runnable, long interval) {
            this.runnable = runnable;
            this.interval = interval;
        }

        public void schedule() {
            if (this.cancelled) {
                return;
            }
            MonitoringServiceImpl.this.ss.schedule((Runnable)this, System.currentTimeMillis() + this.interval);
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            this.runnable.run();
            this.schedule();
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

