/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.RangeVal;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.common.util.StrUtils;

class ReplicaVariable
extends VariableBase {
    public static final String REPLICASCOUNT = "relevantReplicas";

    public ReplicaVariable(Variable.Type type) {
        super(type);
    }

    static int getRelevantReplicasCount(Policy.Session session, Condition cv, String collection, String shard) {
        int totalReplicasOfInterest = 0;
        Clause clause = cv.getClause();
        for (Row row : session.matrix) {
            Integer perShardCount = row.computeCacheIfAbsent(collection, shard, REPLICASCOUNT, cv.clause, o -> {
                int[] result = new int[1];
                row.forEachReplica(collection, replicaInfo -> {
                    if (clause.isMatch((ReplicaInfo)replicaInfo, collection, shard)) {
                        nArray[0] = result[0] + 1;
                    }
                });
                return result[0];
            });
            if (perShardCount == null) continue;
            totalReplicasOfInterest += perShardCount.intValue();
        }
        return totalReplicasOfInterest;
    }

    @Override
    public Object validate(String name, Object val, boolean isRuleVal) {
        return ReplicaVariable.getOperandAdjustedValue(super.validate(name, val, isRuleVal), val);
    }

    @Override
    public Operand getOperand(Operand expected, Object strVal, ComputedType computedType) {
        if (computedType == ComputedType.ALL) {
            return expected;
        }
        return ReplicaVariable.checkForRangeOperand(expected, strVal, computedType);
    }

    static Operand checkForRangeOperand(Operand expected, Object strVal, ComputedType computedType) {
        String s;
        int hyphenIdx;
        if (strVal instanceof String && (hyphenIdx = (s = ((String)strVal).trim()).indexOf(45)) > 0) {
            if (hyphenIdx == s.length() - 1) {
                throw new IllegalArgumentException("bad range input :" + (Object)((Object)expected));
            }
            if (expected == Operand.EQUAL) {
                return Operand.RANGE_EQUAL;
            }
            if (expected == Operand.NOT_EQUAL) {
                return Operand.RANGE_NOT_EQUAL;
            }
        }
        if (!(expected != Operand.EQUAL || computedType == null && ReplicaVariable.isIntegerEquivalent(strVal))) {
            return Operand.RANGE_EQUAL;
        }
        if (!(expected != Operand.NOT_EQUAL || computedType == null && ReplicaVariable.isIntegerEquivalent(strVal))) {
            return Operand.RANGE_NOT_EQUAL;
        }
        return expected;
    }

    @Override
    public String postValidate(Condition condition) {
        boolean isNodesetObjectList;
        Object val = condition.clause.getThirdTag().val;
        boolean bl = isNodesetObjectList = condition.clause.nodeSetPresent && val instanceof List && ((List)val).get(0) instanceof Condition;
        if (condition.clause.nodeSetPresent) {
            if (condition.computedType == ComputedType.EQUAL) {
                if (!isNodesetObjectList) {
                    return " 'nodeset' must have an array value when 'replica': '#EQUAL` is used";
                }
            } else if (isNodesetObjectList) {
                return "cannot use array value for nodeset if replica : '#EQUAL' is not used";
            }
        }
        if (condition.computedType == ComputedType.EQUAL) {
            if (condition.getClause().tag != null && (condition.getClause().tag.op == Operand.WILDCARD || condition.getClause().tag.op == Operand.IN)) {
                return null;
            }
            return "'replica': '#EQUAL` must be used with 'node':'#ANY'";
        }
        if (condition.computedType == ComputedType.ALL) {
            if (isNodesetObjectList) {
                return "replica: '#ALL' cannot be used with a list of values in nodeset";
            }
            if (condition.getClause().tag != null && (condition.getClause().getTag().op == Operand.IN || condition.getClause().getTag().op == Operand.WILDCARD)) {
                return StrUtils.formatString("array value or wild card cannot be used for tag {0} with replica : '#ALL'", condition.getClause().tag.getName());
            }
        } else {
            return ReplicaVariable.checkNonEqualOp(condition);
        }
        return null;
    }

    static String checkNonEqualOp(Condition condition) {
        if (condition.computedType == null && condition.val instanceof RangeVal && condition.op != Operand.RANGE_EQUAL) {
            return "non-integer values cannot have any other operators";
        }
        if (condition.computedType == ComputedType.PERCENT && condition.op != Operand.RANGE_EQUAL) {
            return "percentage values cannot have any other operators";
        }
        return null;
    }

    @Override
    public Object computeValue(Policy.Session session, Condition cv, String collection, String shard, String node) {
        if (cv.computedType == ComputedType.ALL) {
            return (double)ReplicaVariable.getRelevantReplicasCount(session, cv, collection, shard);
        }
        if (cv.computedType == ComputedType.EQUAL) {
            int relevantReplicasCount = ReplicaVariable.getRelevantReplicasCount(session, cv, collection, shard);
            double bucketsCount = this.getNumBuckets(session, cv.getClause());
            if (relevantReplicasCount == 0 || bucketsCount == 0.0) {
                return 0;
            }
            return (double)relevantReplicasCount / bucketsCount;
        }
        if (cv.computedType == ComputedType.PERCENT) {
            return ComputedType.PERCENT.compute(ReplicaVariable.getRelevantReplicasCount(session, cv, collection, shard), cv);
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)cv.computedType));
    }

    private int getNumBuckets(Policy.Session session, Clause clause) {
        if (clause.getTag().getOperand() == Operand.IN) {
            return ((Collection)clause.getTag().val).size();
        }
        if (clause.getTag().getOperand() == Operand.WILDCARD) {
            if (clause.getTag().varType == Variable.Type.NODE) {
                return session.matrix.size();
            }
            HashSet<Object> uniqueVals = new HashSet<Object>();
            for (Row matrix : session.matrix) {
                Object val = matrix.getVal(clause.getTag().name);
                if (val == null) continue;
                uniqueVals.add(val);
            }
            return uniqueVals.size();
        }
        throw new IllegalArgumentException("Invalid operand for the tag in  " + clause);
    }
}

