/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaVariable;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.params.CollectionParams;

public class CoresVariable
extends VariableBase {
    static final String TOTALCORES = CoresVariable.class.getSimpleName() + ".totalcores";

    public CoresVariable(Variable.Type type) {
        super(type);
    }

    @Override
    public Object validate(String name, Object val, boolean isRuleVal) {
        return VariableBase.getOperandAdjustedValue(super.validate(name, val, isRuleVal), val);
    }

    @Override
    public boolean addViolatingReplicas(Violation.Ctx ctx) {
        for (Row row : ctx.allRows) {
            if (!row.node.equals(ctx.currentViolation.node)) continue;
            row.forEachReplica(replicaInfo -> ctx.currentViolation.addReplica(new Violation.ReplicaInfoAndErr((ReplicaInfo)replicaInfo).withDelta(ctx.currentViolation.replicaCountDelta)));
        }
        return true;
    }

    @Override
    public void getSuggestions(Suggestion.Ctx ctx) {
        if (ctx.violation == null || ctx.violation.replicaCountDelta == 0.0) {
            return;
        }
        if (ctx.violation.replicaCountDelta > 0.0) {
            int i = 0;
            while ((double)i < Math.abs(ctx.violation.replicaCountDelta)) {
                if (!ctx.needMore()) {
                    return;
                }
                Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.SRC_NODE, ctx.violation.node);
                if (ctx.addSuggestion(suggester) == null) break;
                ++i;
            }
        }
    }

    @Override
    public void projectAddReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> ops, boolean strictMode) {
        cell.val = cell.val == null ? 0.0 : ((Number)cell.val).doubleValue() + 1.0;
    }

    @Override
    public void projectRemoveReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector) {
        cell.val = cell.val == null ? 0.0 : ((Number)cell.val).doubleValue() - 1.0;
    }

    @Override
    public Object computeValue(Policy.Session session, Condition condition, String collection, String shard, String node) {
        if (condition.computedType == ComputedType.EQUAL) {
            AtomicInteger liveNodes = new AtomicInteger(0);
            int coresCount = this.getTotalCores(session, liveNodes);
            int numBuckets = condition.clause.tag.op == Operand.IN ? ((Collection)condition.clause.tag.val).size() : liveNodes.get();
            return numBuckets == 0 || coresCount == 0 ? 0.0 : (double)coresCount / (double)numBuckets;
        }
        if (condition.computedType == ComputedType.PERCENT) {
            return ComputedType.PERCENT.compute(this.getTotalCores(session, new AtomicInteger()), condition);
        }
        throw new IllegalArgumentException("Invalid computed type in " + condition);
    }

    private int getTotalCores(Policy.Session session, AtomicInteger liveNodes) {
        int coresCount = 0;
        for (Row row : session.matrix) {
            if (!row.isLive) continue;
            liveNodes.incrementAndGet();
            Integer res = row.computeCacheIfAbsent(TOTALCORES, o -> {
                int[] result = new int[1];
                row.forEachReplica(replicaInfo -> {
                    nArray[0] = result[0] + 1;
                });
                return result[0];
            });
            if (res == null) continue;
            coresCount += res.intValue();
        }
        return coresCount;
    }

    @Override
    public String postValidate(Condition condition) {
        Condition nodeTag = condition.getClause().getTag();
        if (nodeTag.varType != Variable.Type.NODE) {
            return "'cores' attribute can only be used with 'node' attribute";
        }
        if (condition.computedType == ComputedType.EQUAL) {
            if (nodeTag.name.equals("node") && (nodeTag.op == Operand.WILDCARD || nodeTag.op == Operand.IN)) {
                return null;
            }
            return "cores: '#EQUAL' can be used only with node: '#ANY', node :[....]";
        }
        return ReplicaVariable.checkNonEqualOp(condition);
    }

    @Override
    public Operand getOperand(Operand expected, Object strVal, ComputedType computedType) {
        return ReplicaVariable.checkForRangeOperand(expected, strVal, computedType);
    }
}

