/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.spi;

import coldfusion.document.CFDocument;
import coldfusion.document.DocumentMargin;
import coldfusion.document.DocumentPageLayout;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.DocumentWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import ice.storm.print.StormPageFormat;
import ice.util.unit.InchUnit;
import ice.util.unit.Unit;
import java.awt.Image;

public abstract class DocumentProperties {
    protected boolean printAllFrames;
    protected DocumentPageLayout pageLayout;
    protected StormPageFormat pageFormat;
    protected double scale;
    protected CFDocument document;
    protected boolean bookmarkEnabled;
    protected Image waterMarkImage;
    protected boolean bgVisible = true;
    protected boolean externalLinksOn = true;
    private boolean scaleToFit;

    public DocumentProperties(DocumentPageLayout pageLayout) {
        this.pageLayout = pageLayout;
        this.setupPageFormat();
        Rectangle rect = new Rectangle((float)this.pageFormat.getPageWidth(), (float)this.pageFormat.getPageHeight());
        this.document = new CFDocument(rect, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected void setupPageFormat() {
        if (this.pageLayout.getPagetype().equalsIgnoreCase("CUSTOM") && (this.pageLayout.getPagewidth() == 0.0 || this.pageLayout.getPageheight() == 0.0)) {
            throw new DocumentPageLayout.MissingPageSizeException();
        }
        this.pageFormat = new StormPageFormat();
        if (this.pageLayout.getPagetype().equals("LETTER")) {
            this.pageFormat.setPageSize(0);
        } else if (this.pageLayout.getPagetype().equals("LEGAL")) {
            this.pageFormat.setPageSize(3);
        } else {
            this.pageFormat.setPageSize((Unit)new InchUnit(this.pageLayout.getPagewidth()), (Unit)new InchUnit(this.pageLayout.getPageheight()));
        }
        if (this.pageLayout.getOrientation().equals("landscape")) {
            this.pageFormat.setOrientation(0);
        } else {
            this.pageFormat.setOrientation(1);
        }
        this.setupMargins(this.pageFormat, this.pageLayout.getMargin());
    }

    public CFDocument getDocument() {
        return this.document;
    }

    public abstract DocumentWriter getWriter() throws DocumentException;

    public abstract String getFormat();

    public DocumentPageLayout getPageLayout() {
        return this.pageLayout;
    }

    public StormPageFormat getStormPageFormat() {
        return this.pageFormat;
    }

    public boolean isPrintAllFrames() {
        return false;
    }

    public void setPrintAllFrames(boolean printAllFrames) {
        this.printAllFrames = printAllFrames;
    }

    public void setWatermarkImage(Image image) {
        this.waterMarkImage = image;
    }

    public Image getWaterMarkImage() {
        return this.waterMarkImage;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void setBackgroundVisible(boolean visible) {
        this.bgVisible = visible;
    }

    public boolean isBackGroundVisible() {
        return this.bgVisible;
    }

    public boolean isBookmarkEnabled() {
        return this.bookmarkEnabled;
    }

    public void setBookmarkEnabled(boolean bookmarkEnabled) {
        this.bookmarkEnabled = bookmarkEnabled;
    }

    public DocumentSectionProperties createDocumentSection(DocumentMargin margin, String sectionName, int pageShift) {
        StormPageFormat sectionPageFormat = (StormPageFormat)this.pageFormat.clone();
        this.setupMargins(sectionPageFormat, margin);
        DocumentSectionProperties docSection = new DocumentSectionProperties(sectionPageFormat);
        docSection.setSectionName(sectionName);
        docSection.setShiftPageCount(pageShift);
        return docSection;
    }

    private void setupMargins(StormPageFormat pageFormat, DocumentMargin margin) {
        this.validateMargins(pageFormat, margin);
        if (margin.getTop() != -1.0) {
            pageFormat.setMargin((Unit)new InchUnit(margin.getTop()), 1);
        }
        if (margin.getBottom() != -1.0) {
            pageFormat.setMargin((Unit)new InchUnit(margin.getBottom()), 3);
        }
        if (margin.getLeft() != -1.0) {
            pageFormat.setMargin((Unit)new InchUnit(margin.getLeft()), 2);
        }
        if (margin.getRight() != -1.0) {
            pageFormat.setMargin((Unit)new InchUnit(margin.getRight()), 4);
        }
    }

    private void validateMargins(StormPageFormat pageFormat, DocumentMargin margin) {
        double dRight;
        double height = this.pageLayout.getPageheight();
        double width = this.pageLayout.getPagewidth();
        double dTop = margin.getTop() == -1.0 ? pageFormat.getMargin(1) * 0.014 : margin.getTop();
        double dBottom = margin.getBottom() == -1.0 ? pageFormat.getMargin(3) * 0.014 : margin.getBottom();
        double dLeft = margin.getLeft() == -1.0 ? pageFormat.getMargin(2) * 0.014 : margin.getLeft();
        double d = dRight = margin.getRight() == -1.0 ? pageFormat.getMargin(4) * 0.014 : margin.getRight();
        if (dTop + dBottom > height) {
            throw new DocumentMargin.InvalidMarginException("margintop=" + dTop + ", marginbottom=" + dBottom, "pageheight=" + height);
        }
        if (dLeft + dRight > width) {
            throw new DocumentMargin.InvalidMarginException("marginleft=" + dLeft + ", marginright=" + dRight, "pagewidth=" + width);
        }
    }

    public void setExternalLinksOn(boolean isOn) {
        this.externalLinksOn = isOn;
    }

    public boolean isExternalLinksOn() {
        return this.externalLinksOn;
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    static {
        System.setProperty("ice.browser.verbose", "false");
        System.setProperty("ice.pilots.html4.encodeImageURL", "true");
        System.setProperty("ice.pilots.html4.traceFonts", "false");
        System.setProperty("ice.pilots.html4.print.resizeTables", "true");
        System.setProperty("ice.pilots.html4.GraphicExtension", "ice.pilots.html4.MacromediaCSSExtension");
        System.setProperty("macromedia.fractionalMetrics", "true");
        System.setProperty("ice.pilots.html4.fractionalMetrics", "VALUE_FRACTIONALMETRICS_ON");
        System.setProperty("ice.storm.use14", "true");
        boolean isMac = System.getProperty("os.name").equals("Mac OS X");
        if (isMac) {
            System.setProperty("ice.pilots.html4.addonFontProviders", "coldfusion.document.font.BrowserFontProvider,ice.pilots.html4.FractionalDeviceFontProvider,ice.pilots.html4.HeadlessJavaFontProvider");
            System.setProperty("ice.pilots.html4.printerFontProviders", "coldfusion.document.font.BrowserFontProvider,ice.pilots.html4.FractionalDeviceFontProvider,ice.pilots.html4.HeadlessJavaFontProvider");
        } else {
            System.setProperty("ice.pilots.html4.addonFontProviders", "ice.pilots.html4.FractionalDeviceFontProvider,ice.pilots.html4.HeadlessJavaFontProvider,coldfusion.document.font.BrowserFontProvider");
            System.setProperty("ice.pilots.html4.printerFontProviders", "ice.pilots.html4.FractionalDeviceFontProvider,ice.pilots.html4.HeadlessJavaFontProvider,coldfusion.document.font.BrowserFontProvider");
        }
    }
}

