/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.DocumentSection;
import coldfusion.document.spi.DocumentExportException;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.PageNoCallbackHandler;
import com.icesoft.util.PageDecorator.HeaderFooterDecoration;
import com.icesoft.util.PageDecorator.WatermarkDecoration;
import ice.pilots.notsupported.ThePilot;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.PageDecoration;
import ice.storm.print.StormPageFormat;
import java.awt.Image;
import java.net.URL;
import java.util.List;

public class DocumentExporter
implements Exporter {
    public void export(Viewport[] viewports, DocumentProperties docProps) throws DocumentExportException {
        this.export(viewports, docProps, null, null, null, null, null, null);
    }

    @Override
    public void export(Viewport[] viewports, DocumentProperties docProps, HeaderFooterContentProvider headerContentProvider, HeaderFooterContentProvider footerContentProvider, PageNoCallbackHandler pageCbh, URL baseURL) throws DocumentExportException {
        this.export(viewports, docProps, null, headerContentProvider, footerContentProvider, pageCbh, baseURL, null);
    }

    @Override
    public void export(Viewport[] viewports, DocumentProperties docProps, DocumentSectionProperties docSecProps, HeaderFooterContentProvider headerContentProvider, HeaderFooterContentProvider footerContentProvider, PageNoCallbackHandler pageCbh, URL baseUrl, List sectionList) throws DocumentExportException {
        StormPageFormat stormPageFormat = docSecProps == null ? docProps.getStormPageFormat() : docSecProps.getStormPageFormat();
        try {
            for (int i = 0; i < viewports.length; ++i) {
                DocumentSection job;
                double scale;
                Image image;
                Pilot pilot = viewports[i].getPilot();
                if (pilot instanceof ThePilot) continue;
                stormPageFormat.removeAllDecorations();
                if (headerContentProvider != null) {
                    HeaderFooterDecoration headerDecoration = new HeaderFooterDecoration(pilot.getStorm(), headerContentProvider, baseUrl, docProps, 0);
                    headerDecoration.setPageNoCallbackHandler(pageCbh);
                    stormPageFormat.addDecoration((PageDecoration)headerDecoration);
                }
                if (footerContentProvider != null) {
                    HeaderFooterDecoration footerDecoration = new HeaderFooterDecoration(pilot.getStorm(), footerContentProvider, baseUrl, docProps, 1);
                    footerDecoration.setPageNoCallbackHandler(pageCbh);
                    stormPageFormat.addDecoration((PageDecoration)footerDecoration);
                }
                if ((image = docProps.getWaterMarkImage()) != null) {
                    WatermarkDecoration wm = new WatermarkDecoration(image);
                    stormPageFormat.addDecoration((PageDecoration)wm);
                }
                stormPageFormat.setBackgroundVisible(docProps.isBackGroundVisible());
                stormPageFormat.setTextWrapping(true);
                stormPageFormat.setHtmlSmartPaging(true);
                StormPrinter _stormPrinter = pilot.createPrinter();
                _stormPrinter.setStormPageFormat(stormPageFormat);
                double htmlzoomscale = docProps.getScale();
                double d = scale = htmlzoomscale == 0.0 ? 1.0 : htmlzoomscale / 100.0;
                if (scale * (double)_stormPrinter.getDimension().width > stormPageFormat.getImageableWidth()) {
                    scale = scale / (double)_stormPrinter.getDimension().width * stormPageFormat.getImageableWidth();
                }
                boolean scaleToFit = docSecProps == null ? docProps.isScaleToFit() : docSecProps.isScaleToFit();
                stormPageFormat.setScaleToFitEnabled(scaleToFit);
                stormPageFormat.setScale(scale);
                _stormPrinter.setStormPageFormat(stormPageFormat);
                if (sectionList != null) {
                    job = new DocumentSection(pilot.getStorm(), viewports[i], _stormPrinter, stormPageFormat, docProps);
                    if (docSecProps != null) {
                        job.shiftPageCount(docSecProps.getShiftPageCount());
                        job.setBookmarksEnabled(docProps.isBookmarkEnabled());
                        job.setDocumentSectionName(docSecProps.getSectionName());
                    }
                    job.setPageNoCallbackHandler(pageCbh);
                    job.setSectiontotalpagecount(_stormPrinter.getPageCount());
                    sectionList.add(job);
                    continue;
                }
                docProps.getDocument().setTotalPageCount(_stormPrinter.getPageCount());
                job = new DocumentSection(_stormPrinter, stormPageFormat, docProps);
                job.print();
            }
            if (sectionList == null) {
                docProps.getDocument().close();
            }
        }
        catch (Exception e) {
            throw new DocumentExportException(e);
        }
    }
}

