/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sharepoint;

import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.server.XmlRpcService;
import coldfusion.sharepoint.SharepointConfigManager;
import coldfusion.sharepoint.SharepointObject;
import coldfusion.sharepoint.SharepointUtils;
import coldfusion.tagext.net.sharepoint.SharepointExceptions;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.XmlProcessor;
import coldfusion.xml.rpc.BadWsdlXMLException;
import coldfusion.xml.rpc.ServiceProxy;
import coldfusion.xml.rpc.ServiceProxyContext;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SharepointManager {
    private SharepointObject sp;
    private PageContext pc;

    public SharepointManager(SharepointObject spObj, PageContext pc) {
        this.sp = spObj;
        this.pc = pc;
    }

    public void executeAction(String name) {
        this.populateMappedWSDL();
        ServiceProxy proxy = this.getProxy();
        String action = this.sp.getAction();
        SharepointConfigManager config = SharepointConfigManager.getInstance();
        Map<String, String> spsActionMap = config.getCustomActionMap();
        if (spsActionMap.containsKey(action)) {
            action = spsActionMap.get(action);
        }
        SharepointUtils utils = new SharepointUtils();
        utils.verifyParams(proxy.getService(), action, this.sp.getParams());
        Map<String, Object> params = utils.modifyParamValues(action, proxy, this.sp.getParams());
        Object response = proxy.invoke(action, params, this.pc);
        if (name != null) {
            this.populateResults(name, response);
        }
    }

    private ServiceProxy getProxy() {
        boolean refresh;
        ServiceProxy proxy = null;
        HashMap<String, String> props = new HashMap<String, String>();
        XmlRpcService xmlrpcService = ServiceFactory.getXmlRpcService();
        String username = this.sp.getUsername();
        String password = this.sp.getPassword();
        String authtype = this.sp.getAuthtype();
        String ntlmdomain = this.sp.getNtlmdomain();
        String workstation = this.sp.getWorkstation();
        if (username != null) {
            props.put("username", username);
        }
        if (password != null) {
            props.put("password", password);
        }
        if (authtype != null) {
            props.put("authtype", authtype);
        }
        if (ntlmdomain != null) {
            props.put("ntlmdomain", ntlmdomain);
        }
        if (workstation != null) {
            props.put("workstation", workstation);
        }
        if (refresh = xmlrpcService.isRefreshWS(this.sp.getWsdl(), username, password)) {
            props.put("refreshwsdl", "true");
        }
        try {
            ServiceProxyContext context = ServiceProxyContext.getInstance();
            context.setVersion("1");
            proxy = xmlrpcService.getWebServiceProxy(this.sp.getWsdl(), props);
            context.clear();
        }
        catch (BadWsdlXMLException bwe) {
            if (this.isMappedWS(this.sp.getAction(), "search") && !this.sp.getWsdl().contains("spsearch")) {
                String wsdl = this.sp.getWsdl().replace("search", "spsearch");
                this.sp.setWsdl(wsdl);
                return this.getProxy();
            }
            SharepointExceptions.throwUnimplementedActionException();
        }
        return proxy;
    }

    private void populateMappedWSDL() {
        String wsdl = this.sp.getWsdl();
        if (wsdl == null) {
            SharepointConfigManager configManager = SharepointConfigManager.getInstance();
            String action = this.sp.getAction().toLowerCase();
            String wsName = configManager.getBaseMetaData().get(action);
            if (wsName != null || (wsName = configManager.getSPSMetaData().get(action)) != null) {
                wsdl = this.sp.getDomain() + "/_vti_bin/" + wsName + "?wsdl";
                if (!wsdl.toLowerCase().startsWith("http:") && !wsdl.toLowerCase().startsWith("https:")) {
                    wsdl = "http://" + wsdl;
                }
            } else {
                SharepointExceptions.throwUnsupportedActionException(action);
            }
            this.sp.setWsdl(wsdl);
        }
    }

    private boolean isMappedWS(String action, String wsName) {
        SharepointConfigManager configManager = SharepointConfigManager.getInstance();
        String name = configManager.getSPSMetaData().get(action.toLowerCase());
        if (name != null) {
            wsName = wsName + ".asmx";
            return name.equals(wsName);
        }
        return false;
    }

    private void populateResults(String name, Object response) {
        Struct rs = null;
        if (response == null) {
            rs = this.populateStatusResultSet();
        } else if (response instanceof String) {
            rs = this.parseString(response);
        } else if (response instanceof AnyContentType) {
            rs = this.parseAnyContentType(response);
        } else {
            SharepointExceptions.throwUnsupportedRespFormatException();
        }
        SharepointUtils utils = new SharepointUtils();
        utils.cleanUpStruct(rs);
        if (rs != null) {
            this.pc.setAttribute(name, (Object)rs);
        }
    }

    private Struct populateStatusResultSet() {
        Struct rs = new Struct();
        rs.put((Object)"ResultFlag", (Object)"SUCCESS");
        return rs;
    }

    private Struct parseString(Object response) {
        String nodeName;
        Struct rs = new Struct();
        if (XmlProcessor.IsXML((String)((String)response))) {
            XmlNodeList nodeList = XmlProcessor.parse((String)((String)response), (boolean)true);
            Node node = nodeList.getFirstNode();
            Node childNode = null;
            if (node != null) {
                childNode = node.getFirstChild();
            } else {
                SharepointExceptions.throwUnsupportedRespFormatException();
            }
            if (childNode == null) {
                SharepointExceptions.throwUnsupportedRespFormatException();
            }
            SharepointUtils utils = new SharepointUtils(childNode);
            rs = utils.constructResultStruct();
            nodeName = ((String)rs.get((Object)"_CF_STRUCT_NAME")).toUpperCase();
        } else {
            nodeName = "SUCCESS";
            rs.put((Object)"Result", response);
        }
        if (nodeName.equals("ERROR")) {
            rs.put((Object)"ResultFlag", (Object)"ERROR");
        } else {
            rs.put((Object)"ResultFlag", (Object)"SUCCESS");
        }
        return rs;
    }

    private Struct parseAnyContentType(Object response) {
        AnyContentType result = (AnyContentType)response;
        MessageElement[] elements = result.get_any();
        Struct rs = null;
        for (MessageElement element : elements) {
            Document doc = null;
            try {
                doc = element.getAsDocument();
            }
            catch (Exception e) {
                SharepointExceptions.throwCorruptDocumentException(e.getMessage());
            }
            doc.normalize();
            Element rootNode = doc.getDocumentElement();
            SharepointUtils utils = new SharepointUtils(rootNode);
            rs = utils.constructResultStruct();
            rs.put((Object)"ResultFlag", (Object)"SUCCESS");
        }
        return rs;
    }
}

