/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.websocket.server.cluster;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.net.websocket.WebSocketUtil;
import coldfusion.tagext.net.websocket.server.cluster.MethodInvocationData;
import coldfusion.tagext.net.websocket.server.cluster.PeerInfo;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketClusterManager;
import coldfusion.tagext.net.websocket.server.cluster.WebSocketRemoteService;
import coldfusion.util.RB;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import org.apache.log4j.Logger;

public class WebSocketRemoteServiceImpl
implements WebSocketRemoteService {
    private transient WebSocketClusterManager clusterManager = WebSocketClusterManager.getInstance();
    private WebSocketRemoteService localStub;
    private static Logger logger = Logger.getLogger(WebSocketRemoteServiceImpl.class);

    @Override
    public void addPeer(PeerInfo peer) {
        this.clusterManager.onAddPeer(peer);
    }

    @Override
    public int numPeers() throws RemoteException {
        return this.clusterManager.getPeers().size();
    }

    @Override
    public void removePeer(PeerInfo peer) {
        this.clusterManager.onRemovePeer(peer);
    }

    @Override
    public WebSocketRemoteService toStub() {
        if (this.localStub == null) {
            try {
                this.localStub = (WebSocketRemoteService)((Object)UnicastRemoteObject.exportObject(this));
            }
            catch (NoSuchObjectException nse) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"StubExportFailedError", (Object)nse.getMessage()), (Throwable)nse);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(WebSocketClusterManager.class, (String)"StubExportFailedError", (Object)e.getMessage()), (Throwable)e);
            }
        }
        return this.localStub;
    }

    @Override
    public String getRemoteServerName() throws RemoteException {
        return this.clusterManager.getLocalPeerInfo().getNodeName();
    }

    @Override
    public Object invoke(MethodInvocationData methodData) throws RemoteException {
        if (methodData == null) {
            throw new RemoteException("Method arguments passed are null");
        }
        switch (methodData.getMethodType()) {
            case 1: {
                try {
                    WebSocketUtil.publishMessage_Remote(methodData.getAppName(), methodData.getChannelName(), methodData.getMessageToPublish(), methodData.getFilterCriteria(), false);
                }
                catch (ApplicationException e) {
                    throw new RemoteException("Error publishing message on remote node", e);
                }
            }
            case 2: {
                try {
                    return WebSocketUtil.getAllClients(methodData.getAppName(), methodData.getChannelName(), false);
                }
                catch (ApplicationException e) {
                    throw new RemoteException("Error invoking getAllChannels on remote node", e);
                }
            }
            case 3: {
                try {
                    return WebSocketUtil.getAllChannels(methodData.getAppName(), methodData.getChannelName(), false);
                }
                catch (ApplicationException e) {
                    throw new RemoteException("Error invoking getAllClients on remote node", e);
                }
            }
            case 4: {
                try {
                    return WebSocketUtil.getSubscriberCount(methodData.getAppName(), methodData.getChannelName(), false);
                }
                catch (ApplicationException e) {
                    throw new RemoteException("Error invoking getSubscriberCount on remote node", e);
                }
            }
        }
        System.out.println("Method name passed is invalid.");
        return null;
    }

    @Override
    public List getPeers() throws RemoteException {
        return this.clusterManager.getPeers();
    }
}

