/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.js;

import coldfusion.compiler.JSAssembler;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.js.JSDebugUtils;
import coldfusion.util.FastHashtable;
import coldfusion.util.HTMLTools;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSDebuggingServlet
extends HttpServlet {
    private String TEMPLATE_QUERY_STRING = "template";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = req;
            response = res;
        }
        catch (ClassCastException e) {
            throw new ServletException("Not a HTTP Request");
        }
        try {
            this.processCmd(request, response);
        }
        catch (Throwable th) {
            CFDebuggerLogger.log(th);
            response.sendError(500);
        }
    }

    private void processCmd(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        String queryString = request.getQueryString();
        FastHashtable queryParams = HTMLTools.parseQueryString((String)queryString);
        String[] templatePaths = (String[])queryParams.get(this.TEMPLATE_QUERY_STRING);
        if (templatePaths == null || templatePaths[0] == null) {
            JSAssembler.throwException((String)"Debug File for the template does not exist!");
        }
        String templatePath = templatePaths[0];
        String debugContent = JSDebugUtils.getDebugFileContent(URLDecoder.decode(templatePath));
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setContentType("text/html");
        try {
            ServletOutputStream out = response.getOutputStream();
            byte[] debugBytes = debugContent.getBytes();
            response.setContentLength(debugBytes.length);
            out.write(debugBytes);
            out.close();
        }
        catch (IOException ioe) {
            JSAssembler.throwException((Throwable)ioe);
        }
    }
}

