/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sns;

import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.AWSUtils;
import coldfusion.cloud.aws.sns.SNSServiceConfig;
import coldfusion.runtime.Struct;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

public class SNSUtils
extends AWSUtils {
    public static void configureSNSClientBuilder(SnsClientBuilder snsClientBuilder, Struct serviceConfig) {
        SNSServiceConfig config = (SNSServiceConfig)SNSUtils.getAWSserviceConfig((Struct)serviceConfig);
        if (config != null) {
            if (config.getHttpClientBuilder() != null) {
                snsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)config.getHttpClientBuilder());
            }
            if (config.getClientOverrideConfiguration() != null) {
                snsClientBuilder.overrideConfiguration(config.getClientOverrideConfiguration());
            }
        }
    }

    public static void configureSNSClientBuilder(SnsClientBuilder snsClientBuilder, SNSServiceConfig config) {
        if (config != null) {
            if (config.getHttpClientBuilder() != null) {
                snsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)config.getHttpClientBuilder());
            } else {
                snsClientBuilder.httpClient(SNSUtils.getDefaultHTTPClient());
            }
            if (config.getClientOverrideConfiguration() != null) {
                snsClientBuilder.overrideConfiguration(config.getClientOverrideConfiguration());
            }
        } else {
            snsClientBuilder.httpClient(SNSUtils.getDefaultHTTPClient());
        }
    }

    private static SdkHttpClient getDefaultHTTPClient() {
        return ApacheHttpClient.builder().build();
    }

    public static AwsCredentialsProvider getAWSCredential(final AWSCredential awsCred) {
        return new AwsCredentialsProvider(){

            public AwsCredentials resolveCredentials() {
                if (awsCred.sessionToken() == null) {
                    return new AwsCredentials(){

                        public String secretAccessKey() {
                            return awsCred.secretAccessKey();
                        }

                        public String accessKeyId() {
                            return awsCred.accessKeyId();
                        }
                    };
                }
                return AwsSessionCredentials.create((String)awsCred.accessKeyId(), (String)awsCred.secretAccessKey(), (String)awsCred.sessionToken());
            }
        };
    }
}

