/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.smpp.ServerPDUEvent;
import org.smpp.ServerPDUEventListener;
import org.smpp.Session;
import org.smpp.SmppObject;
import org.smpp.TCPIPConnection;
import org.smpp.debug.Debug;
import org.smpp.debug.Event;
import org.smpp.debug.FileDebug;
import org.smpp.debug.FileEvent;
import org.smpp.pdu.Address;
import org.smpp.pdu.AddressRange;
import org.smpp.pdu.BindResponse;
import org.smpp.pdu.BindTransciever;
import org.smpp.pdu.EnquireLink;
import org.smpp.pdu.PDU;
import org.smpp.pdu.SubmitSM;
import org.smpp.pdu.UnbindResp;
import org.smpp.pdu.WrongLengthOfStringException;
import org.smpp.util.Queue;

public class SimpleSMPPClient {
    static final String copyright = "Macromedia ColdFusion QA\n";
    static final String version = "Simple SMPP Protocol Test Client\n";
    static final String dbgDir = "./";
    static Debug debug;
    static Event event;
    static String propsFilePath;
    static BufferedReader keyboard;
    static Session session;
    Properties properties = new Properties();
    boolean bound = false;
    private boolean keepRunning = true;
    String ipAddress = null;
    int port = 0;
    String systemId = null;
    String password = null;
    String bindOption = "t";
    boolean asynchronous = false;
    SimpleSMPPClientPDUEventListener pduListener = null;
    AddressRange addressRange = new AddressRange();
    String systemType = "";
    String serviceType = "";
    Address sourceAddress = new Address();
    Address destAddress = new Address();
    String scheduleDeliveryTime = "";
    String validityPeriod = "";
    String shortMessage = "";
    String phoneNum = "";
    byte ton = 1;
    byte npi = 1;
    int numberOfDestination = 1;
    String messageId = "";
    byte esmClass = 0;
    byte protocolId = 0;
    byte priorityFlag = 0;
    byte registeredDelivery = 0;
    byte replaceIfPresentFlag = 0;
    byte dataCoding = 0;
    byte smDefaultMsgId = 0;
    String lastIncomingMessageSourceAddress = "";
    String replyToAddress = "";
    byte isReply = 0;
    long receiveTimeout = -1L;

    public SimpleSMPPClient(String propsFile) throws IOException {
        this.loadProperties(propsFile);
    }

    public static void main(String[] args) {
        System.out.println("initializing...");
        debug.activate();
        event.activate();
        SmppObject.setDebug(debug);
        SmppObject.setEvent(event);
        SimpleSMPPClient client = null;
        try {
            client = args.length > 0 ? new SimpleSMPPClient(args[0]) : new SimpleSMPPClient(propsFilePath);
        }
        catch (IOException e) {
            event.write(e, "");
            debug.write("exception initializing SimpleSMPPClient " + e);
            System.out.println("Exception initializing SimpleSMPPClient " + e);
        }
        if (client != null) {
            client.menu();
        }
    }

    public void menu() {
        this.keepRunning = true;
        String option = "1";
        block12: while (this.keepRunning) {
            System.out.println();
            System.out.println("-  1 connect to server");
            System.out.println("-  2 send message");
            System.out.println("-  3 check connection to server");
            if (this.lastIncomingMessageSourceAddress != "") {
                System.out.println("-  R respond to last incoming msg");
            }
            System.out.println("-  8 reset connection");
            System.out.println("-  9 disconnect from server");
            System.out.println("-  0 exit");
            System.out.print("> ");
            int optionInt = -1;
            try {
                option = keyboard.readLine();
                optionInt = option.startsWith("R") || option.startsWith("r") ? 5 : Integer.parseInt(option);
            }
            catch (Exception e) {
                debug.write("exception reading keyboard " + e);
                optionInt = -1;
            }
            switch (optionInt) {
                case 1: {
                    this.bind();
                    continue block12;
                }
                case 2: {
                    this.submit();
                    continue block12;
                }
                case 3: {
                    this.enquireLink();
                    continue block12;
                }
                case 8: {
                    this.unbind();
                    this.bind();
                    continue block12;
                }
                case 9: {
                    this.unbind();
                    continue block12;
                }
                case 5: {
                    if (this.lastIncomingMessageSourceAddress != "") {
                        this.isReply = 1;
                        this.replyToAddress = this.lastIncomingMessageSourceAddress;
                    } else {
                        this.isReply = 0;
                    }
                    this.submit();
                    continue block12;
                }
                case 0: {
                    this.exit();
                    continue block12;
                }
                case -1: {
                    continue block12;
                }
            }
            System.out.println("Invalid option. Choose 1, 2, 3, 4 or 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        debug.enter(this, "SimpleSMPPClient.bind()");
        try {
            if (this.bound) {
                System.out.println("Already bound, unbind first.");
                return;
            }
            BindTransciever request = null;
            BindResponse response = null;
            request = new BindTransciever();
            if (this.ipAddress == null || this.ipAddress == "") {
                this.ipAddress = this.getParam("IP address of SMSC", this.ipAddress);
            }
            if (this.port == 0) {
                this.port = this.getParam("Port number", this.port);
            }
            TCPIPConnection connection = new TCPIPConnection(this.ipAddress, this.port);
            connection.setReceiveTimeout(20000L);
            session = new Session(connection);
            if (this.systemId == null || this.systemId == "") {
                this.systemId = this.getParam("Your system ID", this.systemId);
            }
            if (this.password == null || this.password == "") {
                this.password = this.getParam("Your password", this.password);
            }
            if (this.phoneNum == null || this.phoneNum == "") {
                this.phoneNum = this.getParam("Your phone number", this.phoneNum);
            }
            request.setSystemId(this.systemId);
            request.setPassword(this.password);
            request.setSystemType(this.systemType);
            request.setInterfaceVersion((byte)52);
            this.addressRange.setTon(this.ton);
            this.addressRange.setNpi(this.npi);
            this.addressRange.setAddressRange(this.phoneNum);
            request.setAddressRange(this.addressRange);
            this.pduListener = new SimpleSMPPClientPDUEventListener(session);
            response = session.bind(request, this.pduListener);
            System.out.println("[CONNECTED to " + this.systemId + ":" + this.password + "@" + this.ipAddress + ":" + this.port + " as " + this.phoneNum + "]");
            if (response.getCommandStatus() == 0) {
                this.bound = true;
            }
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Bind operation failed. " + e);
            System.out.println("Bind operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        debug.enter(this, "SimpleSMPPClient.unbind()");
        try {
            if (!this.bound) {
                System.out.println("Not bound, cannot unbind.");
                return;
            }
            System.out.println("Going to unbind.");
            if (session.getReceiver().isReceiver()) {
                System.out.println("It can take a while to stop the receiver.");
            }
            UnbindResp response = session.unbind();
            System.out.println("[DISCONNECTED from " + this.systemId + ":" + this.password + "@" + this.ipAddress + ":" + this.port + " as " + this.phoneNum + "]");
            this.bound = false;
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Unbind operation failed. " + e);
            System.out.println("Unbind operation failed. Resetting..." + e);
            session = null;
            this.pduListener = null;
            this.bound = false;
        }
        finally {
            debug.exit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit() {
        debug.enter(this, "SimpleSMPPClient.submit()");
        try {
            SubmitSM request = new SubmitSM();
            if (this.serviceType == null || this.serviceType == "") {
                this.serviceType = this.getParam("Service type", this.serviceType);
            }
            if (this.sourceAddress == null || this.sourceAddress.getAddress() == "") {
                this.sourceAddress = this.getAddress("Source", this.sourceAddress);
            }
            if (this.isReply != 1) {
                this.destAddress = this.getAddress("Destination", this.destAddress);
            } else {
                this.destAddress.setAddress(this.replyToAddress);
                this.destAddress.setNpi((byte)1);
                this.destAddress.setTon((byte)1);
            }
            this.shortMessage = this.getParam("Message", this.shortMessage);
            request.setServiceType(this.serviceType);
            request.setSourceAddr(this.sourceAddress);
            request.setDestAddr(this.destAddress);
            request.setReplaceIfPresentFlag(this.replaceIfPresentFlag);
            request.setShortMessage(this.shortMessage);
            request.setScheduleDeliveryTime(this.scheduleDeliveryTime);
            request.setValidityPeriod(this.validityPeriod);
            request.setEsmClass(this.esmClass);
            request.setProtocolId(this.protocolId);
            request.setPriorityFlag(this.priorityFlag);
            request.setRegisteredDelivery(this.registeredDelivery);
            request.setDataCoding(this.dataCoding);
            request.setSmDefaultMsgId(this.smDefaultMsgId);
            request.assignSequenceNumber(true);
            System.out.println();
            System.out.println("[MESSAGE SENT to " + this.destAddress.getAddress() + " via " + this.systemId + ":" + this.password + "@" + this.ipAddress + ":" + this.port + " as " + this.phoneNum + "]");
            session.submit(request);
            System.out.println();
            this.isReply = 0;
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Submit operation failed. " + e);
            System.out.println("Submit operation failed. " + e);
        }
        finally {
            debug.exit(this);
        }
    }

    private void exit() {
        debug.enter(this, "SimpleSMPPClient.exit()");
        if (this.bound) {
            this.unbind();
        }
        this.keepRunning = false;
        debug.exit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enquireLink() {
        debug.enter(this, "SMPPTest.enquireLink()");
        try {
            EnquireLink request = new EnquireLink();
            System.out.println("[REQUESTING CONNECTION STATUS from " + this.systemId + ":" + this.password + "@" + this.ipAddress + ":" + this.port + "]");
            session.enquireLink(request);
        }
        catch (Exception e) {
            event.write(e, "");
            debug.write("Enquire Link operation failed. " + e);
            System.out.println("[NOT CONNECTED]\n(type 8 to reconnect)");
        }
        finally {
            debug.exit(this);
        }
    }

    private String getParam(String prompt, String defaultValue) {
        String value = "";
        String promptFull = prompt;
        promptFull = promptFull + (defaultValue == null ? "" : " [" + defaultValue + "] ");
        System.out.print(promptFull);
        try {
            value = keyboard.readLine();
        }
        catch (IOException e) {
            event.write(e, "");
            debug.write("Got exception getting a param. " + e);
        }
        if (value.compareTo("") == 0) {
            return defaultValue;
        }
        return value;
    }

    private byte getParam(String prompt, byte defaultValue) {
        return Byte.parseByte(this.getParam(prompt, Byte.toString(defaultValue)));
    }

    private int getParam(String prompt, int defaultValue) {
        return Integer.parseInt(this.getParam(prompt, Integer.toString(defaultValue)));
    }

    private Address getAddress(String type, Address address, int maxAddressLength) throws WrongLengthOfStringException {
        byte ton = 1;
        byte npi = 1;
        String addr = this.getParam(type + " address", address.getAddress());
        address.setTon(ton);
        address.setNpi(npi);
        address.setAddress(addr, maxAddressLength);
        return address;
    }

    private Address getAddress(String type, Address address) throws WrongLengthOfStringException {
        return this.getAddress(type, address, 21);
    }

    private void loadProperties(String fileName) throws IOException {
        System.out.println("Reading configuration file " + fileName + "...");
        FileInputStream propsFile = new FileInputStream(fileName);
        this.properties.load(propsFile);
        propsFile.close();
        System.out.println("Setting default parameters...");
        this.ipAddress = this.properties.getProperty("ip-address");
        this.port = this.getIntProperty("port", this.port);
        this.systemId = this.properties.getProperty("system-id");
        this.password = this.properties.getProperty("password");
        byte ton = this.getByteProperty("addr-ton", this.addressRange.getTon());
        byte npi = this.getByteProperty("addr-npi", this.addressRange.getNpi());
        String addr = this.properties.getProperty("address-range", this.addressRange.getAddressRange());
        this.addressRange.setTon(ton);
        this.addressRange.setNpi(npi);
        try {
            this.addressRange.setAddressRange(addr);
        }
        catch (WrongLengthOfStringException e) {
            System.out.println("The length of address-range parameter is wrong.");
        }
        ton = this.getByteProperty("source-ton", this.sourceAddress.getTon());
        npi = this.getByteProperty("source-npi", this.sourceAddress.getNpi());
        addr = this.properties.getProperty("source-address", this.sourceAddress.getAddress());
        this.phoneNum = this.properties.getProperty("phone-number", this.phoneNum);
        this.setAddressParameter("source-address", this.sourceAddress, ton, npi, addr);
        ton = this.getByteProperty("destination-ton", this.destAddress.getTon());
        npi = this.getByteProperty("destination-npi", this.destAddress.getNpi());
        addr = this.properties.getProperty("destination-address", this.destAddress.getAddress());
        this.setAddressParameter("destination-address", this.destAddress, ton, npi, addr);
        this.serviceType = this.properties.getProperty("service-type", this.serviceType);
        this.systemType = this.properties.getProperty("system-type", this.systemType);
        String bindMode = this.properties.getProperty("bind-mode", this.bindOption);
        if (bindMode.equalsIgnoreCase("transmitter")) {
            bindMode = "t";
        } else if (bindMode.equalsIgnoreCase("receiver")) {
            bindMode = "r";
        } else if (bindMode.equalsIgnoreCase("transciever")) {
            bindMode = "tr";
        } else if (!(bindMode.equalsIgnoreCase("t") || bindMode.equalsIgnoreCase("r") || bindMode.equalsIgnoreCase("tr"))) {
            System.out.println("The value of bind-mode parameter in the configuration file " + fileName + " is wrong. " + "Setting the default");
            bindMode = "t";
        }
        this.bindOption = bindMode;
        int rcvTimeout = this.receiveTimeout == -1L ? -1 : (int)this.receiveTimeout / 1000;
        rcvTimeout = this.getIntProperty("receive-timeout", rcvTimeout);
        this.receiveTimeout = rcvTimeout == -1 ? -1L : (long)(rcvTimeout * 1000);
        String syncMode = this.properties.getProperty("sync-mode", this.asynchronous ? "async" : "sync");
        this.asynchronous = syncMode.equalsIgnoreCase("sync") ? false : syncMode.equalsIgnoreCase("async");
    }

    private byte getByteProperty(String propName, byte defaultValue) {
        return Byte.parseByte(this.properties.getProperty(propName, Byte.toString(defaultValue)));
    }

    private int getIntProperty(String propName, int defaultValue) {
        return Integer.parseInt(this.properties.getProperty(propName, Integer.toString(defaultValue)));
    }

    private void setAddressParameter(String descr, Address address, byte ton, byte npi, String addr) {
        address.setTon(ton);
        address.setNpi(npi);
        try {
            address.setAddress(addr);
        }
        catch (WrongLengthOfStringException e) {
            System.out.println("The length of " + descr + " parameter is wrong.");
        }
    }

    static {
        System.out.println(copyright);
        System.out.println(version);
        debug = new FileDebug(dbgDir, "SimpleSMPPClient.dbg");
        event = new FileEvent(dbgDir, "SimpleSMPPClient.evt");
        propsFilePath = "./etc/SimpleSMPPClient.cfg";
        keyboard = new BufferedReader(new InputStreamReader(System.in));
        session = null;
    }

    private class SimpleSMPPClientPDUEventListener
    extends SmppObject
    implements ServerPDUEventListener {
        Session session;
        Queue requestEvents = new Queue();

        public SimpleSMPPClientPDUEventListener(Session session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ServerPDUEvent event) {
            PDU pdu = event.getPDU();
            if (pdu.isRequest()) {
                SimpleSMPPClient.this.lastIncomingMessageSourceAddress = pdu.getSource();
                System.out.println(pdu.msgOutput());
                Queue queue = this.requestEvents;
                synchronized (queue) {
                    this.requestEvents.enqueue(event);
                    this.requestEvents.notify();
                }
            } else if (pdu.isResponse()) {
                if (pdu.getClass().getName() == "org.smpp.pdu.EnquireLinkResp") {
                    System.out.println("[CONNECTION is good]");
                } else {
                    System.out.println("[MESSAGE RECEIPT received]");
                }
            } else {
                System.out.println("pdu of unknown class (not request nor response) received, discarding " + pdu.debugString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerPDUEvent getRequestEvent(long timeout) {
            ServerPDUEvent pduEvent = null;
            Queue queue = this.requestEvents;
            synchronized (queue) {
                if (this.requestEvents.isEmpty()) {
                    try {
                        this.requestEvents.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!this.requestEvents.isEmpty()) {
                    pduEvent = (ServerPDUEvent)this.requestEvents.dequeue();
                }
            }
            return pduEvent;
        }
    }
}

