/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.smscsim.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.smpp.smscsim.util.Attribute;
import org.smpp.smscsim.util.BasicTableParser;
import org.smpp.smscsim.util.Record;
import org.smpp.smscsim.util.TableParser;

public class Table {
    private List records;
    private String fileName;

    public Table() {
        this.fileName = null;
        this.records = new LinkedList();
    }

    public Table(String fileName) throws FileNotFoundException, IOException {
        this.fileName = fileName;
        this.read(fileName);
    }

    public synchronized void add(Record record) {
        this.records.add(record);
    }

    public synchronized void add(Record record, Attribute key) {
        this.replace(record, key);
    }

    public synchronized void replace(Record record, Attribute oldKey) {
        Record old = this.find(oldKey);
        if (old != null) {
            this.remove(oldKey);
        }
        this.add(record);
    }

    public synchronized Record find(Attribute key) {
        if (key != null) {
            return this.find(key.getName(), key.getValue());
        }
        return null;
    }

    public synchronized Record find(String name, String value) {
        ListIterator iter = this.records.listIterator(0);
        while (iter.hasNext()) {
            Record current = (Record)iter.next();
            String currKeyValue = current.getValue(name);
            if (currKeyValue == null || !currKeyValue.equals(value)) continue;
            return current;
        }
        return null;
    }

    public synchronized void remove(Attribute key) {
        this.remove(key.getName(), key.getValue());
    }

    public synchronized void remove(String key, String value) {
        Record toRemove = this.find(key, value);
        if (toRemove != null) {
            this.records.remove(toRemove);
        }
    }

    public int count() {
        return this.records.size();
    }

    public Record get(int i) {
        return (Record)this.records.get(i);
    }

    public synchronized void read(String fileName) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(fileName);
        this.records = new LinkedList();
        this.read(is);
        is.close();
    }

    public synchronized void read(InputStream is) throws IOException {
        TableParser parser = this.getParser();
        parser.parse(is);
    }

    public synchronized void reload() throws IOException {
        this.read(this.fileName);
    }

    public synchronized void write(String fileName) throws FileNotFoundException, IOException {
        FileOutputStream os = new FileOutputStream(fileName);
        this.write(os);
        os.close();
    }

    public synchronized void write(OutputStream os) throws IOException {
        TableParser parser = this.getParser();
        parser.compose(os);
    }

    public TableParser getParser() {
        return new BasicTableParser(this);
    }
}

