/*
 * Decompiled with CFR 0.152.
 */
package org.smpp.pdu.tlv;

import org.smpp.pdu.ByteData;
import org.smpp.pdu.ValueNotSetException;
import org.smpp.pdu.tlv.TLVException;
import org.smpp.pdu.tlv.WrongLengthException;
import org.smpp.util.ByteBuffer;
import org.smpp.util.NotEnoughDataInByteBufferException;

public abstract class TLV
extends ByteData {
    private short tag = 0;
    private boolean valueIsSet = false;
    private static int DONT_CHECK_LIMIT = -1;
    private int minLength = DONT_CHECK_LIMIT;
    private int maxLength = DONT_CHECK_LIMIT;

    public TLV() {
    }

    public TLV(short tag) {
        this.tag = tag;
    }

    public TLV(int min, int max) {
        this.minLength = min;
        this.maxLength = max;
    }

    public TLV(short tag, int min, int max) {
        this.tag = tag;
        this.minLength = min;
        this.maxLength = max;
    }

    protected abstract void setValueData(ByteBuffer var1) throws TLVException;

    protected abstract ByteBuffer getValueData() throws ValueNotSetException;

    public void setTag(short tag) {
        this.tag = tag;
    }

    public short getTag() {
        return this.tag;
    }

    public int getLength() throws ValueNotSetException {
        if (this.hasValue()) {
            ByteBuffer valueBuf = this.getValueData();
            if (valueBuf != null) {
                return valueBuf.length();
            }
            return 0;
        }
        return 0;
    }

    public void setData(ByteBuffer buffer) throws NotEnoughDataInByteBufferException, TLVException {
        short newTag = buffer.removeShort();
        short length = buffer.removeShort();
        ByteBuffer valueBuf = buffer.removeBuffer(length);
        this.setValueData(valueBuf);
        this.setTag(newTag);
    }

    public ByteBuffer getData() throws ValueNotSetException {
        if (this.hasValue()) {
            ByteBuffer tlvBuf = new ByteBuffer();
            tlvBuf.appendShort(this.getTag());
            tlvBuf.appendShort(TLV.encodeUnsigned(this.getLength()));
            tlvBuf.appendBuffer(this.getValueData());
            return tlvBuf;
        }
        return null;
    }

    protected void markValueSet() {
        this.valueIsSet = true;
    }

    public boolean hasValue() {
        return this.valueIsSet;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TLV) {
            return this.getTag() == ((TLV)obj).getTag();
        }
        return false;
    }

    protected static void checkLength(int min, int max, int length) throws WrongLengthException {
        if (length < min || length > max) {
            throw new WrongLengthException(min, max, length);
        }
    }

    protected void checkLength(int length) throws WrongLengthException {
        int min = 0;
        int max = 0;
        min = this.minLength != DONT_CHECK_LIMIT ? this.minLength : 0;
        max = this.maxLength != DONT_CHECK_LIMIT ? this.maxLength : Integer.MAX_VALUE;
        TLV.checkLength(min, max, length);
    }

    protected static void checkLength(int min, int max, ByteBuffer buffer) throws WrongLengthException {
        int length = buffer != null ? buffer.length() : 0;
        TLV.checkLength(min, max, length);
    }

    protected void checkLength(ByteBuffer buffer) throws WrongLengthException {
        int length = buffer != null ? buffer.length() : 0;
        this.checkLength(length);
    }

    public String debugString() {
        String dbgs = "(tlv: ";
        dbgs = dbgs + this.tag;
        dbgs = dbgs + ") ";
        return dbgs;
    }
}

