/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.aws.lambda.producer;

import coldfusion.aws.lambda.client.CFLambdaClient;
import coldfusion.aws.lambda.client.CFLambdaClientImpl;
import coldfusion.aws.lambda.client.CFLambdaServiceConfig;
import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.VendorCredentialService;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.config.AWSServiceConfig;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.util.RB;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.utils.StringUtils;

public class LambdaProducer
implements CloudServiceProducer<AWSCredential, AWSServiceConfig> {
    private static Map<String, CFLambdaClient> aliasTolambdaClient = new HashMap<String, CFLambdaClient>();

    public CloudService getServiceHandle(AWSCredential credential, AWSServiceConfig serviceConfig) {
        if (StringUtils.isBlank((CharSequence)credential.getRegion())) {
            throw new ValidationException(RB.getString(VendorCredentialService.class, (String)"AWSRegionNotFound"));
        }
        CFLambdaServiceConfig config = (CFLambdaServiceConfig)serviceConfig;
        String id = credential.hashCode() + "-" + config.hashCode();
        CFLambdaClient lambdaClient = aliasTolambdaClient.get(id);
        if (lambdaClient == null) {
            lambdaClient = new CFLambdaClientImpl(credential, config);
            aliasTolambdaClient.put(id, lambdaClient);
        }
        return lambdaClient;
    }
}

