/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.wsdl;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.wsdl.WSDLBindingOperation;
import com.adobe.xfa.wsdl.WSDLExten;
import com.adobe.xfa.wsdl.WSDLMessage;
import com.adobe.xfa.wsdl.WSDLNode;
import com.adobe.xfa.wsdl.WSDLOperation;
import com.adobe.xfa.wsdl.WSDLPart;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WSDLDocument
extends WSDLNode {
    private WSDLNode moDefinitions;
    private String mTargetNS;
    private String mOpenFileName;
    private final List<String> mImportFileNameStack = new ArrayList<String>();
    private final List<ImportedDocInfo> mImportedDomDocuments = new ArrayList<ImportedDocInfo>();
    private final List<String> mTargetNSStack = new ArrayList<String>();

    public WSDLDocument() {
        super(null, null, 1);
    }

    public static WSDLDocument loadFromFile(String sFilename, String sLoadOptions) {
        InputStream oStreamFile = WSDLDocument.openFile(sFilename);
        WSDLDocument poWSDLDoc = null;
        try {
            poWSDLDoc = WSDLDocument.loadFromStream(oStreamFile, sFilename, sLoadOptions);
        }
        catch (ExFull oEx) {
            if (sLoadOptions.contains("mode='test'")) {
                throw oEx;
            }
            return null;
        }
        return poWSDLDoc;
    }

    public static WSDLDocument loadFromStream(InputStream oStream, String sFilename, String sLoadOptions) {
        WSDLDocument poDoc = new WSDLDocument();
        Document oDomDoc = WSDLDocument.loadDocument(oStream, sFilename, sLoadOptions);
        poDoc.mOpenFileName = sFilename;
        poDoc.loadChildren(oDomDoc);
        if (poDoc.moDefinitions == null) {
            return null;
        }
        poDoc.consolidateBindings();
        return poDoc;
    }

    public WSDLNode getDefinitionsNode() {
        return this.moDefinitions;
    }

    public String getTargetNS() {
        return this.mTargetNS;
    }

    public String getOpenFileName() {
        return this.mOpenFileName;
    }

    PrefixParseInfo checkAndParsePrefix(String inFullName, WSDLNode inReferencingNode) {
        String outLocalName = null;
        String outTargetNS = null;
        int nPos = inFullName.indexOf(58);
        if (nPos >= 0) {
            int i;
            String localName;
            String prefix = inFullName.substring(0, nPos);
            outLocalName = localName = inFullName.substring(nPos + 1, inFullName.length());
            String docTargetNS = this.getTargetNS();
            String prefixExpanded = null;
            String referencingTargetNS = null;
            if (inReferencingNode != null) {
                referencingTargetNS = inReferencingNode.getTargetNamespace();
            }
            int importCount = this.mImportedDomDocuments.size();
            for (i = 0; i < importCount; ++i) {
                ImportedDocInfo importedDoc = this.mImportedDomDocuments.get(i);
                if (!StringUtils.equalsWithNull(referencingTargetNS, importedDoc.importNS)) continue;
                WSDLNode oDefinitions = importedDoc.oDefinitions;
                if (oDefinitions == null) break;
                prefixExpanded = oDefinitions.getNSURI(prefix);
                break;
            }
            if (StringUtils.isEmpty(prefixExpanded) && this.moDefinitions != null) {
                prefixExpanded = this.moDefinitions.getNSURI(prefix);
            }
            outTargetNS = prefixExpanded;
            if (StringUtils.equalsWithNull(prefixExpanded, docTargetNS)) {
                return new PrefixParseInfo(outLocalName, outTargetNS);
            }
            for (i = 0; i < importCount; ++i) {
                if (!StringUtils.equalsWithNull(prefixExpanded, this.mImportedDomDocuments.get((int)i).importNS)) continue;
                return new PrefixParseInfo(outLocalName, outTargetNS);
            }
            return null;
        }
        return new PrefixParseInfo(inFullName, this.getTargetNS());
    }

    public String getCurrentFileName() {
        String sFileName = this.mOpenFileName;
        int stacksize = this.mImportFileNameStack.size();
        if (stacksize > 0) {
            sFileName = this.mImportFileNameStack.get(stacksize - 1);
        }
        return sFileName;
    }

    private void loadChildren(Node oStartNode) {
        for (Node oDomChild = oStartNode.getFirstXMLChild(); oDomChild != null; oDomChild = oDomChild.getNextXMLSibling()) {
            Element e;
            String aLocalName;
            if (!(oDomChild instanceof Element) || (aLocalName = (e = (Element)oDomChild).getLocalName()) != "definitions") continue;
            WSDLNode oDefinitions = this.createStandardNode(e, 2);
            Element definitionsDomNode = oDefinitions.getDomNode();
            if (definitionsDomNode != null) {
                int attrCount = definitionsDomNode.getNumAttrs();
                for (int i = 0; i < attrCount; ++i) {
                    Attribute oDomAttr = definitionsDomNode.getAttr(i);
                    String aNodeName = oDomAttr.getLocalName();
                    if (aNodeName != "targetNamespace") continue;
                    this.mTargetNS = oDomAttr.getAttrValue();
                    this.mTargetNSStack.add(this.mTargetNS);
                    oDefinitions.setTargetNamespace(this.mTargetNS);
                    break;
                }
            }
            CreateDefinitionsEnumerator enumerator = new CreateDefinitionsEnumerator(e, oDefinitions);
            enumerator.enumerate();
            this.moDefinitions = oDefinitions;
            this.appendWSDLChild(oDefinitions);
            int targetNSSize = this.mTargetNSStack.size();
            if (targetNSSize <= 0) continue;
            this.mTargetNSStack.remove(targetNSSize - 1);
        }
    }

    private void consolidateBindings() {
        WSDLNode current = this.getDefinitionsNode().getFirstWSDLNode(8);
        while (current != null) {
            WSDLNode oBinding = current;
            current = current.getNextWSDLNode(8);
            String bindingPortType = oBinding.getWSDLAttribute(6);
            WSDLNode portType = null;
            if (!StringUtils.isEmpty(bindingPortType)) {
                PrefixParseInfo prefixParseInfo = this.checkAndParsePrefix(bindingPortType, oBinding);
                if (prefixParseInfo == null) continue;
                portType = this.getDefinitionsNode().getWSDLChildNode(7, prefixParseInfo.mLocalName, prefixParseInfo.mTargetNS);
            }
            if (portType == null) continue;
            WSDLNode operationSource = oBinding.getFirstWSDLNode(9);
            while (operationSource != null) {
                WSDLNode next = operationSource.getNextWSDLNode(9);
                WSDLNode childOp = portType.getWSDLChildNode(6, operationSource.getWSDLName());
                if (childOp instanceof WSDLOperation) {
                    WSDLOperation operationNode = (WSDLOperation)childOp;
                    if (operationSource instanceof WSDLBindingOperation) {
                        WSDLBindingOperation bindingOperation = (WSDLBindingOperation)operationSource;
                        operationNode.addBindingOperation(operationSource);
                        bindingOperation.setOperation(operationNode);
                    }
                }
                operationSource = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDocument(InputStream stream, String fileName, String loadOptions) {
        AppModel appModel = new AppModel(null);
        Document result = appModel.getDocument();
        Element bogusRoot = null;
        try {
            bogusRoot = result.loadIntoDocument(stream);
        }
        catch (ExFull oEx) {
            int resId = oEx.firstResId();
            if (resId != ResId.EXPAT_ERROR) {
                throw oEx;
            }
            Document document = null;
            return document;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        result.appendChild(bogusRoot.getFirstXMLChildElement());
        return result;
    }

    private static InputStream openFile(String fileName) {
        InputStream inputStream = ProtocolUtils.openUrl(fileName);
        if (inputStream == null) {
            ExFull ex = new ExFull(ResId.FILE_ERR_MUST_EXIST, fileName);
            throw ex;
        }
        return inputStream;
    }

    private String resolveLocation(String sLocation) {
        String directory;
        int position = 0;
        if (sLocation.startsWith("/") && (position = (directory = this.getCurrentFileName()).indexOf("://")) >= 0) {
            URL url = null;
            try {
                url = new URL(directory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (url != null) {
                String sServer = url.getHost();
                String sPath = url.getPath();
                position = -1;
                if (sServer.length() > 0) {
                    position = sPath.indexOf(47);
                }
                if (position >= 0) {
                    String sAuthority = sPath.substring(0, position);
                    return sServer + sAuthority + sLocation;
                }
            }
        }
        if ((position = sLocation.indexOf("://")) < 0) {
            directory = this.getCurrentFileName();
            int cDirSep = 47;
            if (directory.indexOf(47) < 0 && directory.indexOf(92) >= 0) {
                cDirSep = 92;
            }
            int offset = 0;
            while ((position = directory.indexOf(cDirSep, offset + 1)) >= 0) {
                offset = position;
            }
            directory = directory.substring(0, offset + 1);
            return directory + sLocation;
        }
        return sLocation;
    }

    private WSDLNode createTypesNode(Element oStartNode) {
        return this.createStandardNode(oStartNode, 3);
    }

    private WSDLNode createMessageNode(Element oDomNode) {
        WSDLMessage poMessage = new WSDLMessage(this, oDomNode);
        this.setStandardNodeProps(oDomNode, poMessage);
        CreatePartEnumerator enumerator = new CreatePartEnumerator(oDomNode, poMessage);
        enumerator.enumerate();
        return poMessage;
    }

    private WSDLNode createPortTypeNode(Element oStartNode) {
        WSDLNode portTypeNode = this.createStandardNode(oStartNode, 7);
        CreateOperationEnumerator enumerator = new CreateOperationEnumerator(oStartNode, portTypeNode);
        enumerator.enumerate();
        return portTypeNode;
    }

    private WSDLNode createBindingNode(Element oStartNode) {
        WSDLNode bindingNode = this.createStandardNode(oStartNode, 8);
        CreateOperationEnumerator enumerator = new CreateOperationEnumerator(oStartNode, bindingNode);
        enumerator.enumerate();
        return bindingNode;
    }

    private WSDLNode createServiceNode(Element oStartNode) {
        WSDLNode serviceNode = this.createStandardNode(oStartNode, 10);
        CreatePortEnumerator enumerator = new CreatePortEnumerator(oStartNode, serviceNode);
        enumerator.enumerate();
        return serviceNode;
    }

    private WSDLNode createDocumentationNode(Element oDomNode) {
        return null;
    }

    private void createImportNode(Element oImportNode, WSDLNode oParentWSDLNode) {
        if (oParentWSDLNode.getNodeType() == 2) {
            String sLocation = null;
            String sNamespace = null;
            int attrIndex = oImportNode.findAttr(null, "location");
            if (attrIndex >= 0) {
                sLocation = oImportNode.getAttrVal(attrIndex);
            }
            if ((attrIndex = oImportNode.findAttr(null, "namespace")) >= 0) {
                sNamespace = oImportNode.getAttrVal(attrIndex);
            }
            if (!StringUtils.isEmpty(sLocation)) {
                sLocation = this.resolveLocation(sLocation);
                int importCount = this.mImportedDomDocuments.size();
                for (int i = 0; i < importCount; ++i) {
                    ImportedDocInfo oDocInfo = this.mImportedDomDocuments.get(i);
                    if (!StringUtils.equalsWithNull(oDocInfo.docName, sLocation) || !StringUtils.equalsWithNull(oDocInfo.importNS, sNamespace)) continue;
                    return;
                }
                InputStream oStreamFile = WSDLDocument.openFile(sLocation);
                Document oDomDoc = WSDLDocument.loadDocument(oStreamFile, sLocation, "");
                if (oDomDoc != null) {
                    ImportedDocInfo oDocInfo = new ImportedDocInfo();
                    oDocInfo.docName = sLocation;
                    oDocInfo.importNS = sNamespace;
                    oDocInfo.oDoc = oDomDoc;
                    this.mImportedDomDocuments.add(oDocInfo);
                    this.mTargetNSStack.add(sNamespace);
                    this.mImportFileNameStack.add(sLocation);
                    Node oDomChild = oDomDoc.getFirstXMLChild();
                    if (oDomChild instanceof AppModel) {
                        oDomChild = oDomChild.getFirstXMLChild();
                    }
                    while (oDomChild != null) {
                        Element e;
                        if (oDomChild instanceof Element && (e = (Element)oDomChild).getLocalName() == "definitions") {
                            WSDLNode oImportDefinitions;
                            this.mImportedDomDocuments.get((int)(this.mImportedDomDocuments.size() - 1)).oDefinitions = oImportDefinitions = this.createStandardNode(e, 2);
                            CreateDefinitionsEnumerator enumerator = new CreateDefinitionsEnumerator(e, oParentWSDLNode);
                            enumerator.enumerate();
                        }
                        oDomChild = oDomChild.getNextXMLSibling();
                    }
                    this.mTargetNSStack.remove(this.mTargetNSStack.size() - 1);
                    this.mImportFileNameStack.remove(this.mImportFileNameStack.size() - 1);
                }
            }
        }
    }

    private WSDLNode createStandardNode(Element oDomNode, int eType) {
        WSDLNode node = new WSDLNode(this, oDomNode, eType);
        this.setStandardNodeProps(oDomNode, node);
        return node;
    }

    private void setStandardNodeProps(Element oDomNode, WSDLNode poNodeImp) {
        String nodeName = null;
        int attrIndex = oDomNode.findAttr(null, "name");
        if (attrIndex >= 0) {
            nodeName = oDomNode.getAttrVal(attrIndex);
        }
        poNodeImp.setLocalName(oDomNode.getLocalName());
        poNodeImp.setNamespaceURI(oDomNode.getNS());
        poNodeImp.setWSDLPrefix(oDomNode.getPrefix());
        poNodeImp.setWSDLName(nodeName);
        if (this.mTargetNSStack.size() > 0) {
            poNodeImp.setTargetNamespace(this.mTargetNSStack.get(this.mTargetNSStack.size() - 1));
        }
    }

    private WSDLNode createExtenNode(Element oDomNode, int eType) {
        WSDLExten oExten = new WSDLExten(this, oDomNode);
        this.setStandardNodeProps(oDomNode, oExten);
        oExten.setExtenType(eType);
        return oExten;
    }

    private class CreateInputOutputSubEnumerator
    extends NodeEnumerator {
        CreateInputOutputSubEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element oDomNode) {
            String aLocalName = oDomNode.getLocalName();
            WSDLNode oWSDLNode = null;
            if (oDomNode.getNS() == "http://schemas.xmlsoap.org/wsdl/soap/") {
                if (aLocalName == "body") {
                    oWSDLNode = WSDLDocument.this.createExtenNode(oDomNode, 4);
                } else if (aLocalName == "header") {
                    oWSDLNode = WSDLDocument.this.createExtenNode(oDomNode, 6);
                } else if (aLocalName == "headerfefault") {
                    oWSDLNode = WSDLDocument.this.createExtenNode(oDomNode, 7);
                } else if (aLocalName == "fault" && this.getParentWSDLNode().getNodeType() == 13) {
                    oWSDLNode = WSDLDocument.this.createExtenNode(oDomNode, 5);
                }
            }
            return oWSDLNode;
        }
    }

    private class CreateInputOutputEnumerator
    extends NodeEnumerator {
        CreateInputOutputEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element oDomNode) {
            String aLocalName = oDomNode.getLocalName();
            WSDLNode oParentWSDLNode = this.getParentWSDLNode();
            WSDLNode oWSDLNode = null;
            boolean bEnumerateSubChildren = false;
            if (aLocalName == "input") {
                oWSDLNode = WSDLDocument.this.createStandardNode(oDomNode, 11);
                bEnumerateSubChildren = true;
            } else if (aLocalName == "output") {
                oWSDLNode = WSDLDocument.this.createStandardNode(oDomNode, 12);
                bEnumerateSubChildren = true;
            } else if (aLocalName == "fault") {
                oWSDLNode = WSDLDocument.this.createStandardNode(oDomNode, 13);
                bEnumerateSubChildren = true;
            } else if (oDomNode.getNS() == "http://schemas.xmlsoap.org/wsdl/soap/" && aLocalName == "operation" && oParentWSDLNode.getNodeType() == 9) {
                oWSDLNode = WSDLDocument.this.createExtenNode(oDomNode, 3);
            }
            if (oParentWSDLNode.getNodeType() == 9 && bEnumerateSubChildren) {
                CreateInputOutputSubEnumerator enumerator = new CreateInputOutputSubEnumerator(oDomNode, oWSDLNode);
                enumerator.enumerate();
            }
            return oWSDLNode;
        }
    }

    private class CreatePortSubEnumerator
    extends NodeEnumerator {
        CreatePortSubEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element domChild) {
            String aLocalName = domChild.getLocalName();
            WSDLNode oWSDLNode = null;
            if (domChild.getNS() == "http://schemas.xmlsoap.org/wsdl/soap/" && aLocalName == "address") {
                oWSDLNode = WSDLDocument.this.createExtenNode(domChild, 8);
            }
            return oWSDLNode;
        }
    }

    private class CreatePortEnumerator
    extends NodeEnumerator {
        CreatePortEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element domChild) {
            String aLocalName = domChild.getLocalName();
            WSDLNode oWSDLNode = null;
            if (aLocalName == "port") {
                oWSDLNode = WSDLDocument.this.createStandardNode(domChild, 14);
            }
            CreatePortSubEnumerator enumerator = new CreatePortSubEnumerator(domChild, oWSDLNode);
            enumerator.enumerate();
            return oWSDLNode;
        }
    }

    private class CreateOperationEnumerator
    extends NodeEnumerator {
        CreateOperationEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element oDomNode) {
            String aLocalName = oDomNode.getLocalName();
            WSDLNode oParentWSDLNode = this.getParentWSDLNode();
            WSDLNode oNode = null;
            if (aLocalName == "operation") {
                if (oParentWSDLNode.getNodeType() == 7) {
                    WSDLOperation oOperation = new WSDLOperation(WSDLDocument.this, oDomNode);
                    WSDLDocument.this.setStandardNodeProps(oDomNode, oOperation);
                    int eOpType = 1;
                    for (Node oChild = oDomNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
                        if (!(oChild instanceof Element)) continue;
                        Element oElementChild = (Element)oChild;
                        String aChildLocalName = oElementChild.getLocalName();
                        if (aChildLocalName == "input") {
                            if (eOpType == 5) {
                                eOpType = 4;
                                break;
                            }
                            eOpType = 2;
                            continue;
                        }
                        if (aChildLocalName != "output") continue;
                        if (eOpType == 2) {
                            eOpType = 3;
                            break;
                        }
                        eOpType = 5;
                    }
                    oOperation.setOperationType(eOpType);
                    oNode = oOperation;
                } else if (oParentWSDLNode.getNodeType() == 8) {
                    WSDLBindingOperation poBindingOperation = new WSDLBindingOperation(WSDLDocument.this, oDomNode);
                    WSDLDocument.this.setStandardNodeProps(oDomNode, poBindingOperation);
                    oNode = poBindingOperation;
                }
                CreateInputOutputEnumerator enumerator = new CreateInputOutputEnumerator(oDomNode, oNode);
                enumerator.enumerate();
                if (oParentWSDLNode.getNodeType() == 7 && oNode instanceof WSDLOperation) {
                    WSDLNode oOutput;
                    WSDLOperation oOperation = (WSDLOperation)oNode;
                    WSDLNode oInput = oOperation.getWSDLChildNode(11, "");
                    if (oInput != null && StringUtils.isEmpty(oInput.getWSDLName())) {
                        oInput.setWSDLName(oOperation.getInputName());
                    }
                    if ((oOutput = oOperation.getWSDLChildNode(12, "")) != null && StringUtils.isEmpty(oOutput.getWSDLName())) {
                        oOutput.setWSDLName(oOperation.getOutputName());
                    }
                }
            } else if (oDomNode.getNS() == "http://schemas.xmlsoap.org/wsdl/soap/" && aLocalName == "binding" && oParentWSDLNode.getNodeType() == 8) {
                oNode = WSDLDocument.this.createExtenNode(oDomNode, 2);
            }
            return oNode;
        }
    }

    private class CreatePartEnumerator
    extends NodeEnumerator {
        CreatePartEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element domChild) {
            String aLocalName = domChild.getLocalName();
            WSDLPart oWSDLNode = null;
            if (aLocalName == "part") {
                oWSDLNode = new WSDLPart(WSDLDocument.this, domChild);
                WSDLDocument.this.setStandardNodeProps(domChild, oWSDLNode);
            }
            return oWSDLNode;
        }
    }

    private class CreateDefinitionsEnumerator
    extends NodeEnumerator {
        CreateDefinitionsEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            super(domNode, parentWSDLNode);
        }

        @Override
        WSDLNode processNode(Element domChild) {
            String aLocalName = domChild.getLocalName();
            WSDLNode oWSDLNode = null;
            if (aLocalName == "types") {
                oWSDLNode = WSDLDocument.this.createTypesNode(domChild);
            } else if (aLocalName == "message") {
                oWSDLNode = WSDLDocument.this.createMessageNode(domChild);
            } else if (aLocalName == "portType") {
                oWSDLNode = WSDLDocument.this.createPortTypeNode(domChild);
            } else if (aLocalName == "binding") {
                oWSDLNode = WSDLDocument.this.createBindingNode(domChild);
            } else if (aLocalName == "service") {
                oWSDLNode = WSDLDocument.this.createServiceNode(domChild);
            } else if (aLocalName == "documentation") {
                oWSDLNode = WSDLDocument.this.createDocumentationNode(domChild);
            } else if (aLocalName == "import") {
                WSDLDocument.this.createImportNode(domChild, this.getParentWSDLNode());
            }
            return oWSDLNode;
        }
    }

    private abstract class NodeEnumerator {
        private Element mDOMNode;
        private WSDLNode mParentWSDLNode;

        NodeEnumerator(Element domNode, WSDLNode parentWSDLNode) {
            this.mDOMNode = domNode;
            this.mParentWSDLNode = parentWSDLNode;
        }

        void enumerate() {
            for (Node oDomChild = this.mDOMNode.getFirstXMLChild(); oDomChild != null; oDomChild = oDomChild.getNextXMLSibling()) {
                if (!(oDomChild instanceof Element)) continue;
                WSDLNode oWSDLNode = null;
                oWSDLNode = this.processNode((Element)oDomChild);
                if (oWSDLNode == null) continue;
                this.mParentWSDLNode.appendWSDLChild(oWSDLNode);
            }
        }

        Element getDomNode() {
            return this.mDOMNode;
        }

        WSDLNode getParentWSDLNode() {
            return this.mParentWSDLNode;
        }

        abstract WSDLNode processNode(Element var1);
    }

    static final class PrefixParseInfo {
        final String mLocalName;
        final String mTargetNS;

        PrefixParseInfo(String localName, String targetNS) {
            this.mLocalName = localName;
            this.mTargetNS = targetNS;
        }
    }

    private static class ImportedDocInfo {
        public String docName;
        public String importNS;
        public Document oDoc;
        public WSDLNode oDefinitions;

        private ImportedDocInfo() {
        }
    }
}

