/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.template.InstanceManager;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.SubformScript;
import com.adobe.xfa.template.containers.SubformSet;

public class Subform
extends Container {
    private static final ScriptDynamicPropObj getInstanceManagerScriptObj = new ScriptDynamicPropObj(21, 63){

        @Override
        public boolean invokeGetProp(Obj scriptThis, Arg retValue, String sPropertyName) {
            return Subform.getInstanceManagerFunc(scriptThis, retValue, sPropertyName);
        }
    };

    public Subform(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "subform", "subform", null, XFA.SUBFORMTAG, "subform");
    }

    public Obj getInstanceManager() {
        return new InstanceManager(this);
    }

    public DataNode getDataNode() {
        return null;
    }

    public void execEvent(String sActivity) {
    }

    public boolean execValidate() {
        return true;
    }

    @Override
    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        Attribute oProperty = super.getAttribute(eTag, bPeek, bValidate);
        if (eTag == XFA.LOCALETAG && !bPeek) {
            if (oProperty != null && !oProperty.isEmpty()) {
                return oProperty;
            }
            String sLocale = this.getInstalledLocale();
            return this.newAttribute(eTag, sLocale);
        }
        return oProperty;
    }

    String getBackColor() {
        Element pColorNode;
        Element pFillNode;
        String sRet = "";
        Element pBorderNode = this.getElement(XFA.BORDERTAG, true, 0, true, false);
        if (pBorderNode != null && (pFillNode = pBorderNode.getElement(XFA.FILLTAG, true, 0, true, false)) != null && (pColorNode = pFillNode.getElement(XFA.COLORTAG, true, 0, true, false)) != null) {
            sRet = pColorNode.getAttribute(XFA.VALUETAG).toString();
        }
        return sRet;
    }

    String getBorderColor() {
        Element pColorNode;
        Element pEdgeNode;
        String sRet = "";
        Element pBorderNode = this.getElement(XFA.BORDERTAG, true, 0, true, false);
        if (pBorderNode != null && (pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, true, 0, true, false)) != null && (pColorNode = pEdgeNode.getElement(XFA.COLORTAG, true, 0, true, false)) != null) {
            sRet = pColorNode.getAttribute(XFA.VALUETAG).toString();
        }
        return sRet;
    }

    String getBorderWidth() {
        Element pEdgeNode;
        String sRet = "";
        Element pBorderNode = this.getElement(XFA.BORDERTAG, true, 0, true, false);
        if (pBorderNode != null && (pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, true, 0, true, false)) != null) {
            sRet = pEdgeNode.getAttribute(XFA.THICKNESSTAG).toString();
        }
        return sRet;
    }

    protected int getInstanceIndex(DependencyTracker pDepTrack) {
        return 0;
    }

    String getMessage() {
        String sRet = "";
        Element pValidateNode = this.getElement(XFA.VALIDATETAG, true, 0, false, false);
        if (pValidateNode != null) {
            sRet = TemplateModel.getValidationMessage(pValidateNode, "scriptTest");
        }
        return sRet;
    }

    @Override
    public boolean isConnectSupported() {
        return true;
    }

    @Override
    public boolean isHeightGrowSupported() {
        return true;
    }

    @Override
    public boolean isWidthGrowSupported() {
        return true;
    }

    public void reset() {
    }

    void setBackColor(String sString) {
        Element pBorderNode = this.getElement(XFA.BORDERTAG, 0);
        Element pFillNode = pBorderNode.getElement(XFA.FILLTAG, 0);
        Element pColorNode = pFillNode.getElement(XFA.COLORTAG, 0);
        pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
    }

    void setBorderColor(String sString) {
        Element pColorNode;
        int i;
        Element pBorderNode = this.getElement(XFA.BORDERTAG, 0);
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.EDGETAG, true, i); ++i) {
            Element pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, false, i, false, false);
            pColorNode = pEdgeNode.getElement(XFA.COLORTAG, 0);
            pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
        }
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.CORNERTAG, true, i); ++i) {
            Element pCornerNode = pBorderNode.getElement(XFA.CORNERTAG, false, i, false, false);
            pColorNode = pCornerNode.getElement(XFA.COLORTAG, 0);
            pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
        }
    }

    void setBorderWidth(String sString) {
        int i;
        Element pBorderNode = this.getElement(XFA.BORDERTAG, 0);
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.EDGETAG, true, i); ++i) {
            Element pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, false, i, false, false);
            pEdgeNode.setAttribute(new StringAttr("thickness", sString), XFA.THICKNESSTAG);
        }
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.CORNERTAG, true, i); ++i) {
            Element pCornerNode = pBorderNode.getElement(XFA.CORNERTAG, false, i, false, false);
            pCornerNode.setAttribute(new StringAttr("thickness", sString), XFA.THICKNESSTAG);
        }
    }

    public void setInstanceIndex(int nIndex) {
    }

    void setMessage(String sString) {
        Element pValidateNode = this.getElement(XFA.VALIDATETAG, 0);
        TemplateModel.setValidationMessage(pValidateNode, sString, "scriptTest");
    }

    @Override
    public ScriptTable getScriptTable() {
        return SubformScript.getScriptTable();
    }

    @Override
    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        Node oChild;
        String sNewName;
        if (sPropertyName.length() > 0 && sPropertyName.charAt(0) == '_' && (sNewName = sPropertyName.substring(1)).length() > 0 && (oChild = this.locateChildByName(sNewName, 0)) != null && (oChild instanceof Subform || oChild instanceof SubformSet)) {
            return getInstanceManagerScriptObj;
        }
        return super.getDynamicScriptProp(sPropertyName, bPropertyOverride, bPeek);
    }

    private static boolean getInstanceManagerFunc(Obj oObj, Arg oRetVal, String sProp) {
        Subform oSubform = (Subform)oObj;
        oRetVal.setObject(oSubform.getInstanceManager());
        return true;
    }
}

