/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Element;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.ManifestScript;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;

public class Manifest
extends ProtoableNode {
    public Manifest(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "manifest", "manifest", null, XFA.MANIFESTTAG, "manifest");
    }

    public NodeList doEvaluate() {
        ArrayNodeList ret = new ArrayNodeList();
        Node child = this.getFirstXFAChild();
        int i = 0;
        while (child != null) {
            NodeList items = this.getItems(i);
            int nItems = items.length();
            for (int j = 0; j < nItems; ++j) {
                Node oItem = (Node)items.item(j);
                assert (oItem instanceof Element);
                if (!(oItem instanceof Element)) continue;
                Element oElement = (Element)oItem;
                ((ListBase)ret).append(oElement);
            }
            child = child.getNextXFASibling();
            ++i;
        }
        return ret;
    }

    NodeList getItems(int nIndex) {
        Node oChild = this.getXFAChild(nIndex);
        if (oChild.getClassTag() != XFA.REFTAG) {
            return new ArrayNodeList();
        }
        TextNode oRef = (TextNode)oChild.getProperty(XFA.TEXTNODETAG, 0);
        String sRef = oRef.getValue();
        return this.getXFAParent().resolveNodes(sRef, true, false, false);
    }

    @Override
    public ScriptTable getScriptTable() {
        return ManifestScript.getScriptTable();
    }

    public boolean doExecValidate() {
        return false;
    }

    public void doExecCalculate() {
    }

    public void doExecInitialize() {
    }
}

