/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.xfa.Node;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import java.util.List;

class CChkBxBasedField
extends CPDField {
    public static final ASName k_Off = ASName.create("Off");

    public CChkBxBasedField(CPDFields pCPDFlds, PDFFieldNode coFld, String esFldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pCPDFlds, coFld, esFldName);
    }

    public PDFFieldButton getPDFFieldButton() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFFieldButton)this.getPDFFieldNode();
    }

    @Override
    public boolean setValue(CosObject coValue, ASName asaKey) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        return this.setValueFromEStr(coValue.textValue());
    }

    @Override
    public boolean setValueFromEStr(String esVal) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        boolean bIsXFA;
        Node oNode = this.getXFAField(true);
        boolean bl = bIsXFA = oNode != null;
        if (!bIsXFA && (AFUtils.EStrIsNull(esVal) || k_Off.asString().equals(esVal))) {
            return super.setValue(this.getCosDoc().createCosNull(), ASName.k_V);
        }
        ASName asaVal = this.getOption(esVal);
        CosScalar coVal = null;
        coVal = asaVal == null ? (AFUtils.EStrIsNull(esVal) ? this.getCosDoc().createCosNull() : this.getCosDoc().createCosName(ASName.create(esVal))) : this.getCosDoc().createCosName(asaVal);
        if (this.AFCosObjEquivalent(coVal, super.getValue(ASName.k_V))) {
            return false;
        }
        if (bIsXFA) {
            String cesOff;
            FormField oField;
            String sOff;
            PDFFieldNode coFld = this.getPDFFieldNode();
            if (AFUtils.EStrIsNull(esVal)) {
                CosObject coPreviousValue = coFld.getDictionaryCosObjectValue(ASName.k_V);
                coFld.removeValue(ASName.k_V);
                return coPreviousValue != null && (coPreviousValue.getType() != 3 || ((CosName)coPreviousValue).nameValue() != k_Off);
            }
            if (oNode instanceof FormField && (sOff = (oField = (FormField)oNode).getOffValue()) != null && (cesOff = sOff).equals(esVal)) {
                CosObject coPreviousValue = coFld.getDictionaryCosObjectValue(ASName.k_V);
                coFld.removeValue(ASName.k_V);
                return coPreviousValue != null && (coPreviousValue.getType() != 3 || ((CosName)coPreviousValue).nameValue() != k_Off);
            }
            coFld.getCosDictionary().put(ASName.k_V, coVal);
            return true;
        }
        return super.setValue(coVal, ASName.k_V);
    }

    private CosObject getOption(ASName asaOpt) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String cOpt = asaOpt.asString();
        char ch = cOpt.charAt(0);
        try {
            if (Character.isDigit(ch)) {
                return this.getOption(Integer.parseInt(cOpt));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getCosDoc().createCosNull();
    }

    private CosObject getOption(int iOpt) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject coOpt;
        CosObject coOpts = this.getPDFFieldButton().getOptionValue();
        if (coOpts != null && coOpts.getType() == 5 && iOpt < ((CosArray)coOpts).size() && (coOpt = ((CosArray)coOpts).get(iOpt)).getType() == 4) {
            return coOpt;
        }
        return this.getCosDoc().createCosNull();
    }

    private ASName getOption(String esVal) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int valueIndex = -1;
        List optionList = this.getPDFFieldButton().getOptionList();
        if (optionList != null && !optionList.isEmpty() && (valueIndex = optionList.indexOf(esVal)) != -1) {
            return ASName.create(Integer.toString(valueIndex));
        }
        return null;
    }

    @Override
    protected String getValueAsEStr() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        return this.TranslateValueToEStr(this.getValue(ASName.k_V));
    }

    @Override
    protected CosObject getValue(ASName asaKey) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        Node oNode;
        CosObject coValue = this.TranslateValueFromPDF(super.getValue(ASName.k_V));
        if (coValue.getType() == 3 && ((CosName)coValue).nameValue() == k_Off && (oNode = this.getXFAField(true)) != null) {
            if (oNode instanceof ExclGroup) {
                return this.getCosDoc().createCosNull();
            }
            Field oField = (Field)oNode;
            String sOff = oField.getOffValue();
            if (sOff != null) {
                coValue = this.getCosDoc().createCosString(sOff);
            }
        }
        return coValue;
    }

    private CosObject TranslateValueFromPDF(CosObject coValue) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (coValue.getType() == 0) {
            return this.getCosDoc().createCosName(k_Off);
        }
        CosObject coOpt = this.getOption(((CosName)coValue).nameValue());
        if (coOpt.getType() == 0) {
            return coValue;
        }
        return coOpt;
    }

    private String TranslateValueToEStr(CosObject coValue) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String esVal = AFUtils.EStrNewFromCosObj(coValue);
        return esVal;
    }

    @Override
    public CosObject getDefaultValue() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Node oNode;
        CosObject coValue = this.TranslateValueFromPDF(super.getDefaultValue());
        if (coValue.getType() == 3 && ((CosName)coValue).nameValue() == k_Off && (oNode = this.getXFAField(true)) != null) {
            if (oNode instanceof ExclGroup) {
                return this.getCosDoc().createCosNull();
            }
            FormField oField = (FormField)oNode;
            String sOff = oField.getOffValue();
            if (sOff != null) {
                coValue = this.getCosDoc().createCosString(sOff);
            }
        }
        return coValue;
    }
}

