/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.swf;

import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GlyphAbsoluteOutlineGenerator;

class SWFGlyphOutlineGenerator
extends GlyphAbsoluteOutlineGenerator {
    private StringBuilder outlinePath = new StringBuilder("");
    private static final ASMatrix inverseMatrix = new ASMatrix(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);

    public SWFGlyphOutlineGenerator(ASMatrix textMatrix) {
        super(textMatrix);
    }

    private double[] getOutlineCoordinates(double x, double y) {
        ASCoordinate finalC1 = new ASCoordinate(x, y).transform(inverseMatrix);
        return new double[]{finalC1.x(), finalC1.y()};
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3) {
        double[] p1 = this.getOutlineCoordinates(x2, y2);
        double[] p2 = this.getOutlineCoordinates(x3, y3);
        this.outlinePath.append(" Q ").append(p1[0]).append(" ").append(p1[1]).append(" ").append(p2[0]).append(" ").append(p2[1]);
        super.curveto(x2, y2, x3, y3);
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        double[] p1 = this.getOutlineCoordinates(x2, y2);
        double[] p2 = this.getOutlineCoordinates(x3, y3);
        double[] p3 = this.getOutlineCoordinates(x4, y4);
        this.outlinePath.append(" C ").append(p1[0]).append(" ").append(p1[1]).append(" ").append(p2[0]).append(" ").append(p2[1]).append(" ").append(p3[0]).append(" ").append(p3[1]);
        super.curveto(x2, y2, x3, y3, x4, y4);
    }

    @Override
    public void lineto(double x, double y) {
        double[] p1 = this.getOutlineCoordinates(x, y);
        this.outlinePath.append(" L ").append(p1[0]).append(" ").append(p1[1]);
        super.lineto(x, y);
    }

    @Override
    public void moveto(double x, double y) {
        double[] p1 = this.getOutlineCoordinates(x, y);
        this.outlinePath.append(" M ").append(p1[0]).append(" ").append(p1[1]);
        super.moveto(x, y);
    }

    public String getOutlineString() {
        return this.outlinePath.toString();
    }
}

