/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.shading.CoonsPatchMeshesShading;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTextState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class RasterCoonsPatchMeshesShading
extends CoonsPatchMeshesShading<RasterGraphicsState, RasterTextState, RasterContentItem> {
    private static final int NEW_PATCH = 0;
    private static final int OLDEST_EDGE = 1;
    private static final int SECOND_OLDEST_EDGE = 2;
    private static final int YOUNGEST_EDGE = 3;
    private int startIndex = 0;
    private boolean isEndOfStream = false;
    private int nVertices = 12;
    private int nPatchColorValues = 16;
    private static final List<Integer> legalBitsPerCoordinate = new ArrayList<Integer>(Arrays.asList(1, 2, 4, 8, 12, 16, 24, 32, 0));
    private static final List<Integer> legalBitsPerComponent = new ArrayList<Integer>(Arrays.asList(1, 2, 4, 8, 12, 16, 0));
    private static final List<Integer> legalBitsPerFlag = new ArrayList<Integer>(Arrays.asList(2, 4, 8, 0));
    private byte[] coonsShadingStream;
    private int bitsPerCoordinate;
    private int bitsPerComponent;
    private int bitsPerFlag;
    private int nCompLocal;
    private Point2D[] coordDecode;
    private Point2D[] colorDecode;
    private ASMatrix ctm;
    private boolean isDirect = false;

    public RasterCoonsPatchMeshesShading(RasterGraphicsState graphicsState, int id) {
        super(graphicsState, id);
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        if (!this.init()) {
            return;
        }
        Rectangle bounds = new Rectangle((int)this.ctm.getx(), (int)((double)rasterDocumentContext.getPageHeight() - this.ctm.gety()), (int)(this.coordDecode[0].getY() - this.coordDecode[0].getX()), (int)(Math.abs(this.coordDecode[1].getY()) - Math.abs(this.coordDecode[1].getX())));
        this.isDirect = true;
        rasterDocumentContext.setGraphics2d(this.applyCoonsPatchMeshes(rasterDocumentContext.getGraphics2d(), bounds, ((RasterGraphicsState)this.getGState()).getFillShadingPatternName() != null));
    }

    private boolean init() {
        this.bitsPerComponent = this.getBitsPerComponent();
        if (!legalBitsPerComponent.contains(this.bitsPerComponent)) {
            return false;
        }
        this.bitsPerCoordinate = this.getBitsPerCoordinate();
        if (!legalBitsPerCoordinate.contains(this.bitsPerCoordinate)) {
            return false;
        }
        this.bitsPerFlag = this.getBitsPerFlag();
        if (!legalBitsPerFlag.contains(this.bitsPerFlag)) {
            return false;
        }
        this.colorDecode = this.getColorDecode();
        this.coordDecode = this.getCoordDecode();
        this.coonsShadingStream = this.getCoonsShadingStream();
        this.nCompLocal = this.getNCompLocal();
        this.startIndex = 0;
        this.isEndOfStream = false;
        return true;
    }

    Graphics2D applyCoonsPatchMeshes(Graphics2D graphics2d, Rectangle bounds, boolean fill) {
        if (!this.isDirect && !this.init()) {
            return graphics2d;
        }
        Point2D[] transformedaCtrlPts = new Point2D.Double[this.nPatchColorValues];
        Point2D[] aCtrlPts = new Point2D.Double[this.nPatchColorValues];
        Point2D[] prevCtrlPt = new Point2D.Double[this.nPatchColorValues];
        for (int i = 0; i < this.nPatchColorValues; ++i) {
            aCtrlPts[i] = new Point2D.Double();
            prevCtrlPt[i] = new Point2D.Double();
            transformedaCtrlPts[i] = new Point2D.Double();
        }
        this.getCoordBounds(graphics2d, aCtrlPts, prevCtrlPt, bounds, transformedaCtrlPts);
        return graphics2d;
    }

    private void getCoordBounds(Graphics2D graphics2d, Point2D[] aCtrlPts, Point2D[] prevCtrlPt, Rectangle shadingBounds, Point2D[] transformedaCtrlPts) {
        int nPatchColorValues = 4;
        float[] color = new float[this.nCompLocal];
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        int sharedEdge = 0;
        double[][] patchCornerColors = new double[4][3];
        while (!this.isEndOfStream) {
            sharedEdge = this.getFlag();
            switch (sharedEdge) {
                case 0: {
                    this.getCoords(null, aCtrlPts, 0, nPatchColorValues);
                    break;
                }
                case 1: {
                    aCtrlPts[0] = prevCtrlPt[3];
                    aCtrlPts[1] = prevCtrlPt[4];
                    aCtrlPts[2] = prevCtrlPt[5];
                    aCtrlPts[3] = prevCtrlPt[6];
                    patchCornerColors[0] = patchCornerColors[1];
                    patchCornerColors[1] = patchCornerColors[2];
                    break;
                }
                case 2: {
                    aCtrlPts[0] = prevCtrlPt[6];
                    aCtrlPts[1] = prevCtrlPt[7];
                    aCtrlPts[2] = prevCtrlPt[8];
                    aCtrlPts[3] = prevCtrlPt[9];
                    patchCornerColors[0] = patchCornerColors[2];
                    patchCornerColors[1] = patchCornerColors[3];
                    break;
                }
                case 3: {
                    aCtrlPts[0] = prevCtrlPt[9];
                    aCtrlPts[1] = prevCtrlPt[10];
                    aCtrlPts[2] = prevCtrlPt[11];
                    aCtrlPts[3] = prevCtrlPt[0];
                    double[] tempColor = patchCornerColors[0];
                    patchCornerColors[0] = patchCornerColors[3];
                    patchCornerColors[1] = tempColor;
                    break;
                }
            }
            this.getCoords(null, aCtrlPts, nPatchColorValues, 8);
            this.cpSurface(1, 1, aCtrlPts, 12);
            this.cpSurface(1, 2, aCtrlPts, 13);
            this.cpSurface(2, 2, aCtrlPts, 14);
            this.cpSurface(2, 1, aCtrlPts, 15);
            for (int i = 0; i < 16; ++i) {
                double xMin = bounds.getMinX();
                double xMax = bounds.getMaxX();
                double yMin = bounds.getMinY();
                double yMax = bounds.getMaxY();
                if (aCtrlPts[i].getX() < xMin) {
                    xMin = aCtrlPts[i].getX();
                }
                if (aCtrlPts[i].getX() > xMax) {
                    xMax = aCtrlPts[i].getX();
                }
                if (aCtrlPts[i].getY() < yMin) {
                    yMin = aCtrlPts[i].getY();
                }
                if (aCtrlPts[i].getY() > yMax) {
                    yMax = aCtrlPts[i].getY();
                }
                xMin = xMin == 0.0 ? aCtrlPts[i].getX() : xMin;
                yMin = yMin == 0.0 ? aCtrlPts[i].getY() : yMin;
                bounds.setFrame(xMin, yMin, xMax - xMin, yMax - yMin);
                if (i >= this.nVertices) continue;
                prevCtrlPt[i] = aCtrlPts[i];
            }
            switch (sharedEdge) {
                case 0: {
                    patchCornerColors[0] = this.getColorVal(color);
                    patchCornerColors[1] = this.getColorVal(color);
                }
                case 1: 
                case 2: 
                case 3: {
                    patchCornerColors[2] = this.getColorVal(color);
                    patchCornerColors[3] = this.getColorVal(color);
                    break;
                }
            }
            this.drawCurrentPatch(graphics2d, aCtrlPts, prevCtrlPt, patchCornerColors, bounds, shadingBounds, transformedaCtrlPts);
            if (this.startIndex <= this.coonsShadingStream.length - 1) continue;
            this.isEndOfStream = true;
        }
    }

    private int getFlag() {
        return (int)this.getValue(this.bitsPerFlag, 0.0);
    }

    private void getCoords(Point2D decode, Point2D[] coords, int start, int end) {
        for (int i = 0; i < end; ++i) {
            coords[start + i] = this.getCoord(null, coords[start + i]);
        }
    }

    private Point2D getCoord(AffineTransform mtx, Point2D coords) {
        double x = this.getFloatVal(this.bitsPerCoordinate, coords.getX(), this.coordDecode[0], false);
        double y = this.getFloatVal(this.bitsPerCoordinate, coords.getY(), this.coordDecode[1], false);
        return new Point2D.Double(x, y);
    }

    private double getFloatVal(int bitsPerCoordinate, double x, Point2D decode, boolean b) {
        double val = this.getValue(bitsPerCoordinate, x);
        return this.decode(val, decode.getX(), decode.getY(), bitsPerCoordinate);
    }

    private double getValue(int bits, double val) {
        int tmp = 0;
        int offset = 8;
        int currentByte = 0;
        if ((offset & 7) == 0 && (bits & 7) == 0) {
            int bytes = bits / 8;
            for (int i = 0; i < bytes; ++i) {
                currentByte = (currentByte = this.coonsShadingStream[this.startIndex++]) < 0 ? currentByte & 0xFF : currentByte;
                tmp <<= 8;
                tmp |= currentByte;
                offset += 8;
            }
            val = tmp;
        }
        return val;
    }

    private double decode(double val, double d0, double d1, double bps) {
        return d0 + val * (d1 - d0) / this.scale(bps);
    }

    private double scale(double bps) {
        int y = 1 << (byte)bps;
        return bps == 32.0 ? 4.294967295E9 : (double)(y - 1);
    }

    private void cpSurface(int u, int v, Point2D[] ctrlPts, int i) {
        Point2D.Double[] c2 = new Point2D.Double[4];
        Point2D.Double[] c1 = new Point2D.Double[4];
        Point2D.Double[] d2 = new Point2D.Double[4];
        double U = (float)((double)u / 3.0);
        double V = (float)((double)v / 3.0);
        Point2D[] d1 = ctrlPts;
        c2[0] = ctrlPts[3];
        c2[1] = ctrlPts[4];
        c2[2] = ctrlPts[5];
        c2[3] = ctrlPts[6];
        d2[0] = ctrlPts[9];
        d2[1] = ctrlPts[8];
        d2[2] = ctrlPts[7];
        d2[3] = ctrlPts[6];
        c1[0] = ctrlPts[0];
        c1[1] = ctrlPts[11];
        c1[2] = ctrlPts[10];
        c1[3] = ctrlPts[9];
        double rC = (1.0 - V) * ((Point2D)c1[u]).getX() + V * ((Point2D)c2[u]).getX();
        double rD = (1.0 - U) * d1[v].getX() + U * ((Point2D)d2[v]).getX();
        double b = (1.0 - V) * ((1.0 - U) * ((Point2D)c1[0]).getX() + U * ((Point2D)c1[3]).getX()) + V * ((1.0 - U) * ((Point2D)c2[0]).getX() + U * ((Point2D)c2[3]).getX());
        double x = rC + rD - b;
        rC = (1.0 - V) * ((Point2D)c1[u]).getY() + V * ((Point2D)c2[u]).getY();
        rD = (1.0 - U) * d1[v].getY() + U * ((Point2D)d2[v]).getY();
        b = (1.0 - V) * ((1.0 - U) * ((Point2D)c1[0]).getY() + U * ((Point2D)c1[3]).getY()) + V * ((1.0 - U) * ((Point2D)c2[0]).getY() + U * ((Point2D)c2[3]).getY());
        double y = rC + rD - b;
        ctrlPts[i].setLocation(x, y);
    }

    private double[] getColorVal(float[] color) {
        double[] values = new double[this.nCompLocal];
        for (int i = 0; i < this.nCompLocal; ++i) {
            if (this.colorDecode[i] == null) continue;
            values[i] = (float)this.getFloatVal(this.bitsPerComponent, color[i], this.colorDecode[i], false);
            values[i] = values[i] > 1.0 ? 1.0 : values[i];
            values[i] = values[i] < 0.0 ? 0.0 : values[i];
        }
        double[] rgb = this.getColorSpace().toRGB(values);
        return new double[]{rgb[0], rgb[1], rgb[2]};
    }

    private void drawCurrentPatch(Graphics2D graphics2d, Point2D[] aCtrlPts, Point2D[] prevCtrlPt, double[][] colors, Rectangle2D.Double bounds, Rectangle shadingBounds, Point2D[] transformCtrlPts) {
        Point2D[] colorDistance = new Point2D[4];
        transformCtrlPts = this.transfromToRasterCoordinateSpace(aCtrlPts, shadingBounds, transformCtrlPts, bounds);
        if (this.isDirect) {
            for (int i = 0; i < 4; ++i) {
                colorDistance[i] = new Point2D.Double(transformCtrlPts[i].getX(), transformCtrlPts[i].getY());
            }
            this.fillDirectPatch(graphics2d, colorDistance, transformCtrlPts, colors, shadingBounds);
        } else {
            int i = 0;
            int j = 0;
            while (i < 4) {
                colorDistance[i] = new Point2D.Double(transformCtrlPts[j].getX(), transformCtrlPts[j].getY());
                ++i;
                j += 3;
            }
            Path2D path = this.getPatch(transformCtrlPts);
            this.fillSinglePatch(graphics2d, path, colors, colorDistance, 4);
        }
    }

    private Path2D getPatch(Point2D[] transformCtrlPts) {
        Path2D.Double curve = new Path2D.Double();
        int length = transformCtrlPts.length;
        if (!this.isDirect) {
            length = this.nVertices;
        }
        ((Path2D)curve).moveTo(transformCtrlPts[length - 1].getX(), transformCtrlPts[length - 1].getY());
        int j = length - 1;
        for (int i = 0; i < length; ++i) {
            ((Path2D)curve).curveTo(transformCtrlPts[j % length].getX(), transformCtrlPts[j++ % length].getY(), transformCtrlPts[j % length].getX(), transformCtrlPts[j++ % length].getY(), transformCtrlPts[j % length].getX(), transformCtrlPts[j++ % length].getY());
        }
        return curve;
    }

    private void fillPoint(Graphics2D graphics2d, double[][] colors, Point2D[] colorDistance, Point2D point2d, int length) {
        double[] distanceToPoint = new double[length];
        for (int i = 0; i < length; ++i) {
            distanceToPoint[i] = colorDistance[i].distance(point2d);
        }
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        double totalDistance = 0.0;
        for (int i = 0; i < length; ++i) {
            red += colors[i][0] * (1.0 / distanceToPoint[i]);
            green += colors[i][1] * (1.0 / distanceToPoint[i]);
            blue += colors[i][2] * (1.0 / distanceToPoint[i]);
            totalDistance += 1.0 / distanceToPoint[i];
        }
        graphics2d.setColor(new Color(GraphicsUtils.toARGB(new double[]{red /= totalDistance, green /= totalDistance, blue /= totalDistance}, 1.0), true));
        graphics2d.fillRect((int)point2d.getX(), (int)point2d.getY(), 1, 1);
    }

    private Point2D[] transfromToRasterCoordinateSpace(Point2D[] aCtrlPts, Rectangle shadingBounds, Point2D[] transformCtrlPts, Rectangle2D.Double bounds) {
        if (this.isDirect) {
            double x = shadingBounds.getMinX();
            double y = shadingBounds.getMinY();
            for (int i = 0; i < this.nVertices; ++i) {
                transformCtrlPts[i].setLocation(x + aCtrlPts[i].getX(), y - aCtrlPts[i].getY());
            }
        } else {
            double x = shadingBounds.getMinX();
            double y = shadingBounds.getMaxY();
            for (int i = 0; i < this.nVertices; ++i) {
                transformCtrlPts[i].setLocation(x + aCtrlPts[i].getX(), y - aCtrlPts[i].getY());
            }
        }
        return transformCtrlPts;
    }

    void setCTM(ASMatrix ctm) {
        this.ctm = ctm;
    }

    private void fillDirectPatch(Graphics2D graphics2d, Point2D[] colorDistance, Point2D[] transformCtrlPts, double[][] colors, Rectangle shadingBounds) {
        double[][] newColors = new double[4][3];
        Point2D[] newColorDistance = new Point2D[4];
        Point2D[] trianglePoints = new Point2D[4];
        double[][] triangleColors = new double[4][3];
        int k = 0;
        double x = shadingBounds.getMinX();
        double y = shadingBounds.getMinY();
        int i = 6;
        int j = 2;
        while (i >= 0) {
            Point2D.Double p4;
            Point2D p1 = transformCtrlPts[i];
            Point2D p2 = transformCtrlPts[i + 2];
            double xDiff = Math.abs(p1.getX() - p2.getX());
            double yDiff = Math.abs(p1.getY() - p2.getY());
            double a = transformCtrlPts[i + 4].getX();
            double value = Math.min(Math.abs(Math.abs(a) - Math.abs(p1.getX())), Math.abs(Math.abs(a) - Math.abs(p2.getX())));
            double variation = Math.abs(Math.abs(transformCtrlPts[i + 4].getY() - shadingBounds.getMinY()) - Math.abs(transformCtrlPts[i + 5].getY() - shadingBounds.getMinY()));
            int sign = 1;
            for (int l = 0; l < 4; l += 2) {
                newColors[l] = colors[j];
                newColors[l + 1] = colors[j + 1];
            }
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(p1.getX(), p1.getY());
            ((Path2D)path).lineTo(p2.getX(), p2.getY());
            if (transformCtrlPts[i + 4].getY() < shadingBounds.getMinY()) {
                p4 = new Point2D.Double(x + value, y - variation);
                triangleColors[k] = newColors[k];
                triangleColors[k + 1] = newColors[k + 1];
                trianglePoints[k++] = p2;
            } else {
                sign = -1;
                p4 = new Point2D.Double(shadingBounds.getMinX() + variation, y - value);
                triangleColors[k] = newColors[k];
                triangleColors[k + 1] = newColors[k + 1];
                trianglePoints[k++] = p4;
            }
            Point2D.Double p3 = new Point2D.Double(((Point2D)p4).getX() + xDiff * (double)sign, ((Point2D)p4).getY() + yDiff * (double)sign);
            trianglePoints[k++] = p3;
            ((Path2D)path).lineTo(((Point2D)p3).getX(), ((Point2D)p3).getY());
            ((Path2D)path).lineTo(((Point2D)p4).getX(), ((Point2D)p4).getY());
            newColorDistance[0] = p1;
            newColorDistance[1] = p2;
            newColorDistance[2] = p4;
            newColorDistance[3] = p3;
            this.fillSinglePatch(graphics2d, path, newColors, newColorDistance, 4);
            i -= 6;
            j -= 2;
        }
        Line2D.Double line1 = new Line2D.Double(trianglePoints[0], trianglePoints[1]);
        Line2D.Double line2 = new Line2D.Double(trianglePoints[2], trianglePoints[3]);
        Point2D intersectionPoint = this.getIntersection(line1, line2);
        double d1 = intersectionPoint.distance(trianglePoints[0]);
        double d2 = intersectionPoint.distance(trianglePoints[1]);
        double[] intersectionColor = this.getMixedColor(triangleColors[0], (float)(d1 / (d1 + d2)), triangleColors[1], (float)(d2 / (d1 + d2)));
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(trianglePoints[0].getX(), trianglePoints[0].getY());
        ((Path2D)path).lineTo(trianglePoints[3].getX(), trianglePoints[3].getY());
        ((Path2D)path).lineTo(intersectionPoint.getX(), intersectionPoint.getY());
        trianglePoints[1] = trianglePoints[3];
        triangleColors[1] = triangleColors[3];
        trianglePoints[2] = intersectionPoint;
        triangleColors[2] = intersectionColor;
        this.fillSinglePatch(graphics2d, path, triangleColors, trianglePoints, 3);
    }

    private double[] getMixedColor(double[] color1, float fraction1, double[] color2, float fraction2) {
        float red = (float)((color1[0] * (double)fraction1 + color2[0] * (double)fraction2) / 255.0);
        float green = (float)((color1[1] * (double)fraction1 + color2[1] * (double)fraction2) / 255.0);
        float blue = (float)((color1[2] * (double)fraction1 + color2[2] * (double)fraction2) / 255.0);
        float f = red > 1.0f ? 1.0f : (red = red < 0.0f ? 0.0f : red);
        float f2 = green > 1.0f ? 1.0f : (green = green < 0.0f ? 0.0f : green);
        blue = blue > 1.0f ? 1.0f : (blue < 0.0f ? 0.0f : blue);
        return new double[]{red, green, blue};
    }

    private Point2D getIntersection(Line2D.Double line1, Line2D.Double line2) {
        double x1 = line1.x1;
        double y1 = line1.y1;
        double x2 = line1.x2;
        double y2 = line1.y2;
        double x3 = line2.x1;
        double y3 = line2.y1;
        double x4 = line2.x2;
        double y4 = line2.y2;
        double x = ((x2 - x1) * (x3 * y4 - x4 * y3) - (x4 - x3) * (x1 * y2 - x2 * y1)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        double y = ((y3 - y4) * (x1 * y2 - x2 * y1) - (y1 - y2) * (x3 * y4 - x4 * y3)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        return new Point2D.Double(x, y);
    }

    private void fillSinglePatch(Graphics2D graphics2d, Path2D path, double[][] colors, Point2D[] colorDistance, int length) {
        Rectangle2D rectangle2d = path.getBounds2D();
        rectangle2d = rectangle2d.getBounds();
        Rectangle2D.intersect(rectangle2d, graphics2d.getDeviceConfiguration().getBounds(), rectangle2d);
        int xMin = (int)rectangle2d.getMinX();
        int xMax = (int)rectangle2d.getMaxX();
        int yMin = (int)rectangle2d.getMinY();
        int yMax = (int)rectangle2d.getMaxY();
        for (int i = xMin; i < xMax; ++i) {
            for (int j = yMin; j < yMax; ++j) {
                Point2D.Double point2d = new Point2D.Double(i, j);
                if (!path.contains(point2d)) continue;
                this.fillPoint(graphics2d, colors, colorDistance, point2d, length);
            }
        }
    }
}

