/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingComposite;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingMixture;
import java.awt.CompositeContext;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class RasterBlendingContext
implements CompositeContext {
    private RasterBlendingMixture mixture;
    private RasterBlendingComposite composite;

    RasterBlendingContext(RasterBlendingComposite composite) {
        this.composite = composite;
        this.mixture = RasterBlendingMixture.getMixture(composite);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster source, Raster currnet, WritableRaster output) {
        int width = Math.min(source.getWidth(), currnet.getWidth());
        int height = Math.min(source.getHeight(), currnet.getHeight());
        float alpha = this.composite.getAlpha();
        int[] result = new int[4];
        int[] srcPixel = new int[4];
        int[] dstPixel = new int[4];
        int[] srcPixels = new int[width];
        int[] dstPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            source.getDataElements(0, y, width, 1, srcPixels);
            currnet.getDataElements(0, y, width, 1, dstPixels);
            for (int x = 0; x < width; ++x) {
                int pixel = srcPixels[x];
                srcPixel[0] = pixel >> 16 & 0xFF;
                srcPixel[1] = pixel >> 8 & 0xFF;
                srcPixel[2] = pixel >> 0 & 0xFF;
                srcPixel[3] = pixel >> 24 & 0xFF;
                pixel = dstPixels[x];
                dstPixel[0] = pixel >> 16 & 0xFF;
                dstPixel[1] = pixel >> 8 & 0xFF;
                dstPixel[2] = pixel >> 0 & 0xFF;
                dstPixel[3] = pixel >> 24 & 0xFF;
                this.mixture.blend(srcPixel, dstPixel, result);
                float alpha1 = 1.0f - (float)srcPixel[3] / 255.0f;
                float alpha2 = 1.0f - (float)dstPixel[3] / 255.0f;
                int[] firstPart = this.mix(alpha1, dstPixel);
                int[] second1 = this.mix(alpha2, srcPixel);
                int[] second2 = this.mix((float)dstPixel[3] / 255.0f, result);
                int[] secondPart = this.mix((float)srcPixel[3] / 255.0f, this.sum(second1, second2));
                result = this.sum(firstPart, secondPart);
                dstPixels[x] = ((int)((float)dstPixel[3] + (float)(result[3] - dstPixel[3]) * alpha) & 0xFF) << 24 | ((int)((float)dstPixel[0] + (float)(result[0] - dstPixel[0]) * alpha) & 0xFF) << 16 | ((int)((float)dstPixel[1] + (float)(result[1] - dstPixel[1]) * alpha) & 0xFF) << 8 | (int)((float)dstPixel[2] + (float)(result[2] - dstPixel[2]) * alpha) & 0xFF;
            }
            output.setDataElements(0, y, width, 1, dstPixels);
        }
    }

    private int[] mix(float f, int[] pixel) {
        int[] temp = new int[]{(int)((float)pixel[0] * f), (int)((float)pixel[1] * f), (int)((float)pixel[2] * f), pixel[3]};
        return temp;
    }

    private int[] sum(int[] s1, int[] s2) {
        int[] temp = new int[]{s1[0] + s2[0], s1[1] + s2[1], s1[2] + s2[2], s1[3] + s2[3]};
        temp[0] = temp[0] > 255 ? 255 : temp[0];
        temp[1] = temp[1] > 255 ? 255 : temp[1];
        temp[2] = temp[2] > 255 ? 255 : temp[2];
        temp[3] = temp[3] > 255 ? 255 : temp[3];
        return temp;
    }
}

