/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfigList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsage;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageApp;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageAppList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCVExpression;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.optionalcontent.OCUsageAppHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class OCManager {
    private PDFOCProperties properties;
    private PDFOCGroupArray allOCGs;
    private PDFOCConfig currentConfig;
    private HashMap<PDFOCGroup, Boolean> visibilityMap;
    private HashMap<PDFOCGroup, Boolean> explicitOffMap;

    private OCManager(PDFOCProperties properties) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (properties.getOCGs() == null) {
            throw new PDFInvalidDocumentException("OCGs is a required entry in optional content properties dictionary.");
        }
        if (properties.getDefaultOCConfigDict() == null) {
            throw new PDFInvalidDocumentException("D is a required entry in optional content properties dictionary.");
        }
        this.properties = properties;
        this.visibilityMap = new HashMap();
        this.explicitOffMap = new HashMap();
    }

    public static OCManager newInstance(PDFOCProperties properties) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (properties == null) {
            return null;
        }
        OCManager mgr = new OCManager(properties);
        mgr.allOCGs = properties.getOCGs();
        mgr.setCurrentConfig(properties.getDefaultOCConfigDict());
        return mgr;
    }

    public static OCManager newInstance(PDFOCProperties properties, OCUsageAppHandler usageAppHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (properties == null) {
            return null;
        }
        OCManager mgr = new OCManager(properties);
        mgr.allOCGs = properties.getOCGs();
        mgr.setCurrentConfig(properties.getDefaultOCConfigDict(), usageAppHandler);
        return mgr;
    }

    public PDFOCConfig getDefaultConfig() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.properties.getDefaultOCConfigDict();
    }

    public void setDefaultConfig(PDFOCConfig config) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.properties.setDefaultOCConfigDict(config);
    }

    public boolean hasAlternateConfigs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.properties.dictionaryContains(ASName.k_Configs);
    }

    public PDFOCConfigList getAlternateConfigs() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.properties.getOCConfigsArray();
    }

    public void setAlternateConfigs(PDFOCConfigList configs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.properties.setOCConfigsArray(configs);
    }

    public PDFOCConfig getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(PDFOCConfig config) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentConfig = config;
        this.initVisibilityMap(null);
    }

    public void setCurrentConfig(PDFOCConfig config, OCUsageAppHandler usageAppHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currentConfig = config;
        this.initVisibilityMap(usageAppHandler);
    }

    public boolean isVisible(PDFOCObject oc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (oc == null) {
            return true;
        }
        if (oc instanceof PDFOCGroup) {
            if (!this.allOCGs.contains(oc)) {
                throw new PDFInvalidDocumentException("All OC instances MUST be included in the master OCG list in the catalog.");
            }
            return this.isVisible((PDFOCGroup)oc);
        }
        return this.isVisible((PDFOCMembership)oc);
    }

    public boolean isVisible(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.visibilityMap.get(ocg);
    }

    public boolean isVisible(PDFOCMembership ocmd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean result;
        PDFOCVExpression ve = ocmd.getVisibilityExpression();
        if (ve != null) {
            VisibilitExpressionValue veResult = new VisibilitExpressionValue(false);
            return !this.evalutateVisibilityExpression(ve, veResult) || veResult.isVisible();
        }
        PDFOCGroupList ocgs = ocmd.getOCGs();
        if (ocgs == null) {
            return true;
        }
        int numOCGs = ocgs.size();
        if (numOCGs == 0) {
            return true;
        }
        ASName visibilityPolicy = ocmd.getVisibilityPolicy();
        Iterator iter = ocgs.iterator();
        if (visibilityPolicy == ASName.k_AllOn) {
            result = true;
            while (iter.hasNext() && result) {
                PDFOCGroup ocg = (PDFOCGroup)iter.next();
                boolean isVisible = this.visibilityMap.get(ocg);
                if (isVisible) continue;
                result = false;
            }
        } else if (visibilityPolicy == ASName.k_AnyOn) {
            result = false;
            while (iter.hasNext() && !result) {
                PDFOCGroup ocg = (PDFOCGroup)iter.next();
                boolean isVisible = this.visibilityMap.get(ocg);
                if (!isVisible) continue;
                result = true;
            }
        } else if (visibilityPolicy == ASName.k_AnyOff) {
            result = false;
            while (iter.hasNext() && !result) {
                PDFOCGroup ocg = (PDFOCGroup)iter.next();
                boolean isVisible = this.visibilityMap.get(ocg);
                if (isVisible) continue;
                result = true;
            }
        } else if (visibilityPolicy == ASName.k_AllOff) {
            result = true;
            while (iter.hasNext() && result) {
                PDFOCGroup ocg = (PDFOCGroup)iter.next();
                boolean isVisible = this.visibilityMap.get(ocg);
                if (!isVisible) continue;
                result = false;
            }
        } else {
            throw new PDFInvalidDocumentException("Invalid OCMD Visibility Policy");
        }
        return result;
    }

    private boolean evalutateVisibilityExpression(PDFOCVExpression ve, VisibilitExpressionValue veResult) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (ve.getCosObject() instanceof CosDictionary) {
            PDFOCGroup ocg = PDFOCGroup.getInstance(ve.getCosObject());
            if (ocg == null) {
                return false;
            }
            veResult.setVisibility(this.visibilityMap.get(ocg));
            return true;
        }
        if (!(ve.getCosObject() instanceof CosArray)) {
            return false;
        }
        if (ve.getCosArray().size() <= 1) {
            return false;
        }
        ASName operator = ve.getOperator();
        if (operator == null) {
            return false;
        }
        boolean validOperands = false;
        if (operator == ASName.k_Not) {
            VisibilitExpressionValue operandResult;
            if (ve.getCosArray().size() != 2) {
                return false;
            }
            PDFOCVExpression operand = PDFOCVExpression.getInstance(ve.getCosArray().get(1));
            validOperands = this.evalutateVisibilityExpression(operand, operandResult = new VisibilitExpressionValue(false));
            if (validOperands) {
                veResult.setVisibility(!operandResult.isVisible());
            }
            return validOperands;
        }
        if (operator == ASName.k_And) {
            int numOperands = ve.getCosArray().size();
            boolean tempResult = true;
            VisibilitExpressionValue operandResult = new VisibilitExpressionValue(false);
            for (int i = 1; i < numOperands && tempResult; ++i) {
                PDFOCVExpression operand = PDFOCVExpression.getInstance(ve.getCosArray().get(i));
                if (!this.evalutateVisibilityExpression(operand, operandResult)) continue;
                validOperands = true;
                tempResult &= operandResult.isVisible();
            }
            if (validOperands) {
                veResult.setVisibility(tempResult);
            }
            return validOperands;
        }
        if (operator == ASName.k_Or) {
            int numOperands = ve.getCosArray().size();
            boolean tempResult = false;
            VisibilitExpressionValue operandResult = new VisibilitExpressionValue(false);
            for (int i = 1; i < numOperands && !tempResult; ++i) {
                PDFOCVExpression operand = PDFOCVExpression.getInstance(ve.getCosArray().get(i));
                if (!this.evalutateVisibilityExpression(operand, operandResult)) continue;
                validOperands = true;
                tempResult |= operandResult.isVisible();
            }
            if (validOperands) {
                veResult.setVisibility(tempResult);
            }
            return validOperands;
        }
        return false;
    }

    public void setVisibility(PDFOCGroup ocg, boolean visible) {
        if (!this.visibilityMap.containsKey(ocg)) {
            this.allOCGs.add(ocg);
        }
        this.visibilityMap.put(ocg, visible);
    }

    public void remove(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.allOCGs != null) {
            this.allOCGs.remove(ocg);
        }
        PDFOCConfig config2 = this.getDefaultConfig();
        config2.remove(ocg);
        if (this.hasAlternateConfigs()) {
            for (PDFOCConfig config2 : this.getAlternateConfigs()) {
                config2.remove(ocg);
            }
        }
        this.visibilityMap.remove(ocg);
    }

    private void initVisibilityMap(OCUsageAppHandler usageAppHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray offOCGs;
        PDFOCGroupArray onOCGs;
        PDFOCBaseState baseState;
        this.visibilityMap = new HashMap();
        this.explicitOffMap = new HashMap();
        PDFOCBaseState pDFOCBaseState = baseState = this.currentConfig != null ? this.currentConfig.getBaseState() : null;
        if (baseState == null) {
            PDFOCConfig defaultConfig = this.properties.getDefaultOCConfigDict();
            baseState = PDFUtil.isPDFCosObjectRefEqual(this.currentConfig, defaultConfig) ? PDFOCBaseState.ON : PDFOCBaseState.Unchanged;
        }
        if (baseState != PDFOCBaseState.Unchanged && this.allOCGs != null) {
            for (PDFOCGroup ocg : this.allOCGs) {
                if (ocg == null) continue;
                this.visibilityMap.put(ocg, baseState == PDFOCBaseState.ON);
            }
        }
        if (baseState != PDFOCBaseState.ON && this.currentConfig != null && (onOCGs = this.currentConfig.getONList()) != null) {
            for (PDFOCGroup ocg : onOCGs) {
                if (ocg == null) continue;
                this.visibilityMap.put(ocg, Boolean.TRUE);
            }
        }
        if (baseState != PDFOCBaseState.OFF && this.currentConfig != null && (offOCGs = this.currentConfig.getOFFList()) != null) {
            for (PDFOCGroup ocg : offOCGs) {
                if (ocg == null) continue;
                this.visibilityMap.put(ocg, Boolean.FALSE);
            }
        }
        if (this.currentConfig != null) {
            ASName usageApplicationEvent = usageAppHandler != null ? usageAppHandler.getAppEvent() : null;
            PDFOCUsageAppList asList = this.currentConfig.getASList();
            if (asList != null && usageApplicationEvent != null) {
                for (PDFOCUsageApp usageApp : asList) {
                    if (usageApp.getEvent() != usageApplicationEvent) continue;
                    ArrayList<ASName> categories = usageApp.getCategoryList();
                    PDFOCGroupArray ocgs = usageApp.getOCGs();
                    if (categories == null || ocgs == null || ocgs.isEmpty()) continue;
                    for (PDFOCGroup ocg : ocgs) {
                        PDFOCUsage usage;
                        if (ocg == null || (usage = ocg.getUsage()) == null) continue;
                        for (ASName category : categories) {
                            Boolean explicitlyOff;
                            ASName state = null;
                            if (category == ASName.k_View) {
                                state = usage.getView();
                            } else if (category == ASName.k_Print) {
                                state = usage.getPrintState();
                            } else if (category == ASName.k_Export) {
                                state = usage.getExport();
                            } else if (category == ASName.k_Language && usageAppHandler != null) {
                                Locale userLocale = usageAppHandler.getLocale();
                                ASString usageLang = usage.getLanguageSpec();
                                if (userLocale != null && usageLang != null) {
                                    String usageLangStr;
                                    String appLang = userLocale.toString();
                                    state = appLang.equals(usageLangStr = usageLang.toString()) || appLang.replace('_', '-').equals(usageLangStr) || userLocale.getLanguage().equals(usageLangStr) ? ASName.k_ON : ASName.k_OFF;
                                }
                            }
                            if (state == null || (explicitlyOff = this.explicitOffMap.get(ocg)) != null && explicitlyOff.booleanValue()) continue;
                            if (state == ASName.k_ON) {
                                this.visibilityMap.put(ocg, Boolean.TRUE);
                                continue;
                            }
                            this.visibilityMap.put(ocg, Boolean.FALSE);
                            this.explicitOffMap.put(ocg, Boolean.TRUE);
                        }
                    }
                }
            }
        }
    }

    public List<PDFOCObject> getVisibleOCObjects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFOCObject> list = new ArrayList<PDFOCObject>();
        if (this.allOCGs != null) {
            for (PDFOCObject oc : this.allOCGs) {
                if (!this.isVisible(oc)) continue;
                list.add(oc);
            }
        }
        PDFPageTree pageTree = this.properties.getPDFDocument().requirePages();
        Iterator<PDFPage> pageIter = pageTree.iterator();
        while (pageIter.hasNext()) {
            PDFMCPropertyMap map;
            PDFPage page = pageIter.next();
            PDFResources resources = page.getResources();
            if (resources == null || (map = resources.getMCPropertyMap()) == null) continue;
            for (ASName key : map.keySet()) {
                PDFOCMembership ocmd;
                PDFMCProperty property;
                Object value = map.get((Object)key);
                if (!(value instanceof PDFMCProperty) || (property = (PDFMCProperty)value).getDictionaryNameValue(ASName.k_Type) != ASName.k_OCMD || !this.isVisible(ocmd = PDFOCMembership.getInstance(property.getCosObject()))) continue;
                list.add(ocmd);
            }
        }
        return list;
    }

    public void setInitialState(PDFOCGroup pdfocGroup, Boolean state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCConfig pdfocConfig;
        PDFOCProperties pdfocProperties = pdfocGroup.getPDFDocument().requireCatalog().getOCProperties();
        this.setVisibility(pdfocGroup, state);
        if (pdfocProperties != null && (pdfocConfig = pdfocProperties.getDefaultOCConfigDict()) != null) {
            PDFOCBaseState pBaseState = pdfocConfig.getBaseState();
            PDFOCGroupArray onList = pdfocConfig.getONList();
            PDFOCGroupArray offList = pdfocConfig.getOFFList();
            if (onList == null) {
                onList = PDFOCGroupArray.newInstance(pdfocGroup.getPDFDocument());
            }
            if (offList == null) {
                offList = PDFOCGroupArray.newInstance(pdfocGroup.getPDFDocument());
            }
            if (pBaseState != null) {
                PDFOCGroupArray pdfocGroupList = pdfocProperties.getOCGs();
                if (pBaseState.isEqual(PDFOCBaseState.ON) && !state.booleanValue()) {
                    pdfocConfig.removeValue(ASName.k_BaseState);
                    pdfocConfig.setDictionaryValue(ASName.k_OFF, pdfocGroup.getCosObject());
                    if (pdfocGroupList != null) {
                        onList.addList(pdfocGroupList);
                        onList.remove(pdfocGroup);
                    }
                    offList.add(pdfocGroup);
                }
                if (pBaseState.isEqual(PDFOCBaseState.OFF) && state.booleanValue()) {
                    pdfocConfig.removeValue(ASName.k_BaseState);
                    pdfocConfig.setDictionaryValue(ASName.k_ON, pdfocGroup.getCosObject());
                    if (pdfocGroupList != null) {
                        offList.addList(pdfocGroupList);
                        offList.remove(pdfocGroup);
                    }
                    onList.add(pdfocGroup);
                }
            } else if (state.booleanValue() && !onList.contains(pdfocGroup)) {
                onList.add(pdfocGroup);
                if (offList != null && offList.contains(pdfocGroup)) {
                    offList.remove(pdfocGroup);
                }
            } else if (!state.booleanValue() && !offList.contains(pdfocGroup)) {
                offList.add(pdfocGroup);
                if (onList != null && onList.contains(pdfocGroup)) {
                    onList.remove(pdfocGroup);
                }
            }
        }
    }

    public PDFOCGroupArray getOCGs(int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMCPropertyMap propertyMap;
        PDFPage page;
        PDFDocument pdfDocument;
        PDFCatalog catalog;
        if (this.currentConfig != null && (catalog = (pdfDocument = this.currentConfig.getPDFDocument()).requireCatalog()) != null && (page = catalog.requirePages().getPage(pageNum)) != null && (propertyMap = page.getResources().getMCPropertyMap()) != null) {
            Collection pdfMCProperties = propertyMap.values();
            PDFOCGroupArray groupArray = PDFOCGroupArray.newInstance(pdfDocument);
            if (pdfMCProperties != null) {
                for (PDFMCProperty property : pdfMCProperties) {
                    if (property == null || ASName.k_OCG != property.getDictionaryNameValue(ASName.k_Type)) continue;
                    PDFOCGroup group = PDFOCGroup.getInstance(property.getCosObject());
                    groupArray.add(group);
                }
            }
            return groupArray;
        }
        return null;
    }

    private static class VisibilitExpressionValue {
        private boolean visibility;

        private VisibilitExpressionValue(boolean visibil) {
            this.visibility = visibil;
        }

        private boolean isVisible() {
            return this.visibility;
        }

        private void setVisibility(boolean visibil) {
            this.visibility = visibil;
        }
    }
}

